/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.merchandise.IService.IInterestFreeService;
import com.thebeastshop.pegasus.merchandise.enums.InterestFreeEnum;
import com.thebeastshop.pegasus.merchandise.exception.PublicException;
import com.thebeastshop.pegasus.merchandise.service.McOpProductService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuCategoryService;
import com.thebeastshop.pegasus.merchandise.vo.OpProductVO;
import com.thebeastshop.pegasus.merchandise.vo.OpSpvVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCombinationVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.scm.cond.InterestFreeCond;
import com.thebeastshop.scm.dao.InterestFreeDao;
import com.thebeastshop.scm.dao.InterestFreeProductDao;
import com.thebeastshop.scm.dao.InterestFreeProvideDao;
import com.thebeastshop.scm.dao.MemberDao;
import com.thebeastshop.scm.po.InterestFree;
import com.thebeastshop.scm.po.InterestFreeProduct;
import com.thebeastshop.scm.po.InterestFreeProvide;
import com.thebeastshop.scm.po.Member;
import com.thebeastshop.scm.vo.interest.InterestFreeProductExcelVO;
import com.thebeastshop.scm.vo.interest.InterestFreeProvideVO;
import com.thebeastshop.scm.vo.interest.InterestFreeUseVO;
import com.thebeastshop.scm.vo.interest.InterestFreeVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pers.richard.ormybatis.domain.po.IdPo;

@Service
public class InterestFreeService
implements IInterestFreeService {
    private static final Logger logger = LoggerFactory.getLogger(InterestFreeService.class);
    private static final Integer ALL_MEMBER_ID = -1;
    @Resource
    private InterestFreeDao interestFreeDao;
    @Resource
    private InterestFreeProductDao interestFreeProductDao;
    @Resource
    private InterestFreeProvideDao interestFreeProvideDao;
    @Resource
    private MemberDao memberDao;
    @Resource(name="mcOpProductService")
    private McOpProductService mcOpProductService;
    @Resource(name="mcPcsSkuCategoryService")
    private McPcsSkuCategoryService mcPcsSkuCategoryService;

    @Transactional(value="scmDataSourceTx")
    public void save(InterestFreeVO interestFreeVO) {
        logger.info("[\u514d\u90ae\u6743\u76ca] \u6743\u76ca\u4fdd\u5b58  \u53c2\u6570:{}", (Object)interestFreeVO);
        this.checkInterestFreeNum(interestFreeVO);
        InterestFree interestFree = InterestFreeVO.toInterstFree((InterestFreeVO)interestFreeVO);
        int rs = this.interestFreeDao.insertOrUpdate((IdPo)interestFree);
        if (rs != 1) {
            throw new PublicException("PB0003", "\u4fdd\u5b58\u6743\u76ca\u9519\u8bef");
        }
        this.interestFreeReletion(interestFreeVO, interestFree.getId());
        logger.info("[\u514d\u90ae\u6743\u76ca] \u4fdd\u5b58\u6210\u529f");
    }

    public List<InterestFreeVO> queryList(InterestFreeCond cond) {
        return this.interestFreeDao.queryList(cond);
    }

    public InterestFreeVO queryByInterestFreeId(Integer interestFreeId) {
        InterestFree interestFree = (InterestFree)this.interestFreeDao.selectOne((Number)interestFreeId);
        if (interestFree == null) {
            throw new PublicException("PB0005");
        }
        List categorys = this.interestFreeProductDao.selectProductCategory(interestFreeId);
        InterestFreeVO interestFreeVO = new InterestFreeVO(interestFree);
        interestFreeVO.setCategories(categorys);
        return interestFreeVO;
    }

    public List<InterestFreeProvideVO> selectProvideRecord(InterestFreeCond cond) {
        return this.interestFreeProvideDao.selectProvideRecord(cond);
    }

    public List<InterestFreeProductExcelVO> selectProducts(Integer interestFreeId) {
        List productList = this.interestFreeProductDao.selectProduct(interestFreeId);
        OpProductVO opProductVO = null;
        ArrayList excelList = Lists.newArrayList();
        for (InterestFreeProduct product : productList) {
            opProductVO = this.mcOpProductService.findById(product.getBingdingId());
            excelList.add(new InterestFreeProductExcelVO(opProductVO.getCode(), opProductVO.getNameCn()));
        }
        return excelList;
    }

    @Transactional(value="scmDataSourceTx")
    public InterestFreeProvide interestFreeProvide(Integer memberId, Integer interestFreeId, String provideChannel) {
        logger.info("[\u514d\u90ae\u6743\u76ca] \u6743\u76ca\u53d1\u653e  memberId:{},interestFreeId:{},provideChannel:{}", new Object[]{memberId, interestFreeId, provideChannel});
        if (memberId == null || interestFreeId == null || StringUtils.isBlank((String)provideChannel)) {
            throw new PublicException("", "\u53c2\u6570\u7f3a\u5931");
        }
        InterestFree interestFree = (InterestFree)this.interestFreeDao.selectOne((Number)interestFreeId);
        if (interestFree == null) {
            throw new PublicException("", "\u672a\u627e\u5230ID\u4e3a[" + interestFreeId + "]\u7684\u514d\u90ae\u6743\u76ca\u4fe1\u606f");
        }
        Member member = (Member)this.memberDao.selectOne((Number)memberId);
        if (member == null) {
            throw new PublicException("", "\u672a\u627e\u5230ID\u4e3a[" + memberId + "]\u7684\u7528\u6237\u4fe1\u606f");
        }
        this.checkProvide(memberId, interestFree, 3);
        InterestFreeProvide provide = this.buildingProvide(interestFreeId, memberId, provideChannel);
        int res = this.interestFreeProvideDao.insert((IdPo)provide);
        if (res == 0) {
            throw new PublicException("PB0003", "\u4fdd\u5b58\u514d\u90ae\u6743\u76ca\u53d1\u653e\u4fe1\u606f\u5931\u8d25");
        }
        logger.info("[\u514d\u90ae\u6743\u76ca] \u6743\u76ca\u53d1\u653e\u6210\u529f provideId\uff1a{}", (Object)provide.getId());
        return provide;
    }

    public InterestFreeVO getCanUseInterestFree(InterestFreeUseVO interestFreeUseVO) {
        logger.info("[\u514d\u90ae\u6743\u76ca] \u83b7\u53d6\u7528\u6237\u53ef\u7528\u514d\u90ae\u6743\u76ca  \u53c2\u6570:{}", (Object)interestFreeUseVO);
        if (interestFreeUseVO == null || interestFreeUseVO.getMemberId() == null || StringUtils.isBlank((String)interestFreeUseVO.getAccessWay()) || CollectionUtils.isEmpty((Collection)interestFreeUseVO.getProductCodes())) {
            throw new PublicException("", "\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        String accessWay = "" + InterestFreeEnum.getCode((String)interestFreeUseVO.getAccessWay().toUpperCase());
        if (StringUtils.isBlank((String)accessWay)) {
            logger.info("[\u514d\u90ae\u6743\u76ca] \u672a\u80fd\u89e3\u6790\u5230\u9002\u7528\u5e73\u53f0");
            return null;
        }
        Member member = (Member)this.memberDao.selectOne((Number)interestFreeUseVO.getMemberId());
        if (member == null) {
            logger.info("[\u514d\u90ae\u6743\u76ca] memberId\u4e3a\uff1a" + interestFreeUseVO.getMemberId() + "\u7528\u6237\u4e0d\u5b58\u5728!");
            return null;
        }
        List productCodes = interestFreeUseVO.getProductCodes();
        boolean existsCrossBorder = this.existsCrossBorder(productCodes);
        int excluBorderFlag = existsCrossBorder ? InterestFreeEnum.CROSS_BORDER_INLAND.getCode() : InterestFreeEnum.CROSS_BORDER_OVERSEAS.getCode();
        Integer memberId = interestFreeUseVO.getMemberId();
        List allInterestFree = this.interestFreeDao.selectByMemberId(memberId, accessWay, Integer.valueOf(excluBorderFlag));
        this.queryCrossBorderFree(member.getMemberLevel(), existsCrossBorder, allInterestFree);
        if (CollectionUtils.isEmpty((Collection)allInterestFree)) {
            logger.info("[\u514d\u90ae\u6743\u76ca] \u4f1a\u5458[" + memberId + "]\u672a\u627e\u5230\u53ef\u7528\u7684\u514d\u90ae\u6743\u76ca");
            return null;
        }
        List<InterestFreeVO> canUseInterestFree = this.matchInterestFree(productCodes, allInterestFree);
        if (CollectionUtils.isEmpty(canUseInterestFree)) {
            logger.info("[\u514d\u90ae\u6743\u76ca] \u672a\u80fd\u5339\u914d\u5230\u53ef\u7528\u6743\u76ca");
            return null;
        }
        InterestFreeVO interestFreeVO = this.sortInterestFree(canUseInterestFree);
        logger.info("[\u514d\u90ae\u6743\u76ca] \u83b7\u53d6\u7528\u6237\u53ef\u7528\u514d\u90ae\u6743\u76ca :{}", (Object)interestFreeVO);
        return interestFreeVO;
    }

    public InterestFreeVO queryInterestFreeInfo(Integer provideId) {
        logger.info("[\u514d\u90ae\u6743\u76ca] \u6743\u76ca\u8be6\u60c5  provideId:{}", (Object)provideId);
        if (provideId == null) {
            throw new PublicException("", "\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        InterestFreeVO vo = this.interestFreeDao.selectByProvideId(provideId);
        if (vo == null) {
            throw new PublicException("", "\u672a\u627e\u5230provideID\u4e3a[" + provideId + "]\u7684\u514d\u90ae\u6743\u76ca\u4fe1\u606f");
        }
        vo.setProductScopeName(InterestFreeEnum.getDesc((String)"productScope", (Integer)vo.getProductScope()));
        if (InterestFreeEnum.USE_TIME_FIXED.getCode().equals(vo.getUseTimeType())) {
            vo.setValidateDateStr(String.valueOf(DateUtil.format((Date)vo.getUseBeginDate(), (String)"yyyy-MM-dd")) + "\u81f3" + DateUtil.format((Date)vo.getUseEndDate(), (String)"yyyy-MM-dd"));
        } else {
            vo.setValidateDateStr("\u9886\u53d6\u5373\u65e5\u8d77" + vo.getProvideAfterDay() + "\u5929\u4ee5\u5185");
            vo.setUseBeginDate(DateUtil.dayStart((Date)vo.getProvideTime()));
            vo.setUseEndDate(DateUtil.addDay((Date)vo.getProvideTime(), (int)vo.getProvideAfterDay()));
        }
        vo.setFreeStatus(InterestFreeEnum.FREE_STATUS_VALID.getCode());
        if (vo.getUseEndDate().before(DateUtil.dayStart((Date)DateUtil.getNow()))) {
            vo.setFreeStatus(InterestFreeEnum.FREE_STATUS_EXPIRED.getCode());
        }
        if (vo.getFreePostNum() != 0 && vo.getUseTotal() >= vo.getFreePostNum()) {
            vo.setFreeStatus(InterestFreeEnum.FREE_STATUS_USEUP.getCode());
        }
        logger.info("[\u514d\u90ae\u6743\u76ca] \u6743\u76ca\u8be6\u60c5 end InterestFreeVO:{}", (Object)vo);
        return vo;
    }

    public void interestFreeCash(InterestFreeUseVO vo) {
        logger.info("[\u514d\u90ae\u6743\u76ca] \u6743\u76ca\u5151\u6362 \u53c2\u6570:{}", (Object)vo);
        if (vo == null || vo.getProvideId() == null || vo.getMemberId() == null || StringUtils.isBlank((String)vo.getAccessWay())) {
            throw new PublicException("", "\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        InterestFreeVO interestFree = this.checkInterestFreeUse(vo);
        this.usedInterestFree(interestFree, 3);
        logger.info("[\u514d\u90ae\u6743\u76ca] \u6743\u76ca\u5151\u6362\u6210\u529f");
    }

    public void interestFreeBack(InterestFreeUseVO useVO) {
        logger.info("[\u514d\u90ae\u6743\u76ca] \u6743\u76ca\u8fd4\u8fd8 \u53c2\u6570:{}", (Object)useVO.toString());
        if (useVO == null || useVO.getProvideId() == null) {
            throw new PublicException("", "\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        InterestFreeProvide provide = (InterestFreeProvide)this.interestFreeProvideDao.selectOne((Number)useVO.getProvideId());
        if (provide == null) {
            throw new PublicException("", "\u672a\u80fd\u627e\u5230\u514d\u90ae\u6743\u76ca\u4f7f\u7528\u8bb0\u5f55");
        }
        int res = this.interestFreeProvideDao.backInterestFree(useVO.getProvideId());
        if (res != 1) {
            throw new PublicException("PB0002", "\u8fd4\u8fd8\u514d\u90ae\u6743\u76ca\u4f7f\u7528\u6570\u91cf\u5931\u8d25");
        }
        logger.info("[\u514d\u90ae\u6743\u76ca] \u6743\u76ca\u8fd4\u56de\u6210\u529f");
    }

    public List<InterestFreeVO> getPreExpiration(Integer day) {
        logger.info("[\u514d\u90ae\u6743\u76ca] \u67e5\u8be2[" + day + "]\u5929\u540e\u5230\u671f\u7684\u514d\u90ae\u6743\u76ca");
        if (day == null) {
            throw new PublicException("", "\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        List interestFreeVOList = this.interestFreeDao.selectAllMemberInterestFree();
        if (CollectionUtils.isEmpty((Collection)interestFreeVOList)) {
            logger.info("[\u514d\u90ae\u6743\u76ca] \u672a\u80fd\u67e5\u8be2\u5230\u5df2\u53d1\u653e\u672a\u4f7f\u7528\u7684\u514d\u90ae\u6743\u76ca");
            return interestFreeVOList;
        }
        ArrayList remindFreeList = Lists.newArrayList();
        for (InterestFreeVO vo : interestFreeVOList) {
            Date remindDate;
            if (InterestFreeEnum.USE_TIME_AFTER.getCode().equals(vo.getUseTimeType())) {
                vo.setUseEndDate(DateUtil.addDay((Date)vo.getProvideTime(), (int)vo.getProvideAfterDay()));
            }
            if (!(remindDate = DateUtil.addDay((Date)DateUtil.getNow(), (int)day)).after(vo.getUseEndDate())) continue;
            remindFreeList.add(vo);
            logger.info("[\u514d\u90ae\u6743\u76ca] \u7528\u6237:[" + vo.getMemberId() + "]\u53d1\u653e\u7684[" + vo.getProvideId() + "]\u7684\u514d\u90ae\u6743\u76ca\u5c06\u4e8e[" + DateUtil.format((Date)vo.getUseEndDate(), (String)"yyyy-MM-dd HH:mm:ss") + "]\u5230\u671f");
        }
        return remindFreeList;
    }

    private void queryCrossBorderFree(Integer memberLevel, boolean existsCrossBorder, List<InterestFreeVO> allInterestFree) {
        if (existsCrossBorder && (Integer.valueOf(2).equals(memberLevel) || Integer.valueOf(3).equals(memberLevel))) {
            List crossBorderFree = this.interestFreeDao.selectCrossBorderInterestFree(ALL_MEMBER_ID);
            allInterestFree.addAll(crossBorderFree);
        }
    }

    private List<InterestFreeVO> matchInterestFree(List<String> productCodes, List<InterestFreeVO> allInterestFree) {
        List<Integer> bingdingIds;
        logger.info("[\u514d\u90ae\u6743\u76ca] \u5f00\u59cb\u5339\u914d\u53ef\u7528\u514d\u90ae\u6743\u76ca " + JSON.toJSONString(allInterestFree));
        ArrayList canUseInterestFree = Lists.newArrayList();
        ArrayList allScopeInterestFree = Lists.newArrayList();
        ArrayList fixedScopeInterestFree = Lists.newArrayList();
        this.interestFreeWash(fixedScopeInterestFree, allScopeInterestFree, allInterestFree);
        if (CollectionUtils.isNotEmpty((Collection)allScopeInterestFree)) {
            bingdingIds = this.getBingdingIds(productCodes, false);
            for (InterestFreeVO vo : allScopeInterestFree) {
                boolean exclude = this.interestFreeDao.selectRelation(vo.getId(), bingdingIds, InterestFreeEnum.IS_EXCLUDE_TRUE.getCode());
                if (exclude) continue;
                canUseInterestFree.add(vo);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fixedScopeInterestFree)) {
            bingdingIds = this.getBingdingIds(productCodes, true);
            for (InterestFreeVO vo : fixedScopeInterestFree) {
                boolean isExsts = this.interestFreeDao.selectRelation(vo.getId(), bingdingIds, InterestFreeEnum.IS_EXCLUDE_FALSE.getCode());
                if (!isExsts) continue;
                canUseInterestFree.add(vo);
            }
        }
        logger.info("[\u514d\u90ae\u6743\u76ca] \u5339\u914d\u53ef\u7528\u514d\u90ae\u6743\u76ca\u7ed3\u679c :" + JSON.toJSONString((Object)canUseInterestFree));
        return canUseInterestFree;
    }

    private boolean existsCrossBorder(List<String> productCodes) {
        boolean isCrossBorder = false;
        for (String productCode : productCodes) {
            isCrossBorder = this.mcOpProductService.getCrossBorderFlagListByCode(productCode, Integer.valueOf(0));
            if (!isCrossBorder) continue;
            isCrossBorder = true;
            break;
        }
        return isCrossBorder;
    }

    private void interestFreeWash(List<InterestFreeVO> fixedScopeInterestFree, List<InterestFreeVO> allScopeInterestFree, List<InterestFreeVO> allInterestFree) {
        for (InterestFreeVO interestFree : allInterestFree) {
            if (InterestFreeEnum.USE_TIME_FIXED.getCode().equals(interestFree.getUseTimeType())) {
                Date toDay = DateUtil.dayStart((Date)DateUtil.getNow());
                if (interestFree.getUseBeginDate().after(toDay) || interestFree.getUseEndDate().before(toDay)) {
                    continue;
                }
            } else {
                Date currDay;
                Date provideDay = DateUtil.dayStart((Date)interestFree.getProvideTime());
                Date useEndDay = DateUtil.addDay((Date)provideDay, (int)interestFree.getProvideAfterDay());
                if (useEndDay.before(currDay = DateUtil.dayStart((Date)DateUtil.getNow()))) continue;
            }
            if (InterestFreeEnum.PRODUCT_SCOPE_ALL.getCode().equals(interestFree.getProductScope())) {
                allScopeInterestFree.add(interestFree);
                continue;
            }
            fixedScopeInterestFree.add(interestFree);
        }
    }

    private InterestFreeVO sortInterestFree(List<InterestFreeVO> list) {
        logger.info("[\u514d\u90ae\u6743\u76ca] \u53ef\u7528\u514d\u90ae\u6743\u76ca\u6392\u5e8f:" + JSON.toJSONString(list));
        InterestFreeVO vo = list.get(0);
        for (InterestFreeVO interestFree : list) {
            Date secondDate;
            Date firstDate = InterestFreeEnum.USE_TIME_FIXED.getCode().equals(vo.getUseTimeType()) ? vo.getUseEndDate() : DateUtil.addDay((Date)DateUtil.dayStart((Date)vo.getProvideTime()), (int)vo.getProvideAfterDay());
            Date date = secondDate = InterestFreeEnum.USE_TIME_FIXED.getCode().equals(interestFree.getUseTimeType()) ? interestFree.getUseEndDate() : DateUtil.addDay((Date)DateUtil.dayStart((Date)interestFree.getProvideTime()), (int)interestFree.getProvideAfterDay());
            if (firstDate.after(secondDate)) {
                vo = interestFree;
                continue;
            }
            if (InterestFreeEnum.PRODUCT_SCOPE_ALL.getCode().equals(vo.getProductScope()) && InterestFreeEnum.PRODUCT_SCOPE_FIXED.getCode().equals(interestFree.getProductScope())) {
                vo = interestFree;
                continue;
            }
            if (InterestFreeEnum.CROSS_BORDER_NOLIMIT.getCode().equals(vo.getCrossBorderFlag()) && !InterestFreeEnum.CROSS_BORDER_NOLIMIT.getCode().equals(interestFree.getCrossBorderFlag())) {
                vo = interestFree;
                continue;
            }
            if (interestFree.getUseTotal() < vo.getUseTotal()) {
                vo = interestFree;
                continue;
            }
            if (!interestFree.getProvideTime().before(vo.getProvideTime())) continue;
            vo = interestFree;
        }
        return vo;
    }

    private void checkInterestFreeNum(InterestFreeVO vo) {
        logger.info("[\u514d\u90ae\u6743\u76ca] \u4fdd\u5b58 \u6743\u76ca\u76f8\u5173\u6570\u91cf\u9a8c\u8bc1 ");
        Integer interestFreeId = vo.getId();
        if (vo.getFreePostNum() != null) {
            int maxUsedNum = this.interestFreeProvideDao.selectMaxUsedNum(interestFreeId);
            if (vo.getFreePostNum() < maxUsedNum) {
                throw new PublicException("", "\u514d\u90ae\u6b21\u6570\u4e0d\u5c0f\u5df2\u4f7f\u7528\u6700\u5927\u6b21\u6570\uff1a" + maxUsedNum);
            }
        }
        if (vo.getReceiveNum() != null) {
            int receiveTotal = this.interestFreeProvideDao.countReceive(interestFreeId);
            if (vo.getReceiveNum() < receiveTotal) {
                throw new PublicException("", "\u9650\u9886\u6570\u91cf\u4e0d\u5f97\u5c0f\u4e8e\u5df2\u9886\u53d6\u6570\u91cf:" + receiveTotal);
            }
        }
        if (vo.getSignReceiveNum() != null) {
            int signReceiveNum = this.interestFreeProvideDao.selectSignMaxReceiveNum(interestFreeId);
            if (vo.getSignReceiveNum() < signReceiveNum) {
                throw new PublicException("", "\u5355\u4e2a\u7528\u6237\u9650\u9886\u6570\u4e0d\u5f97\u5c0f\u4e8e\u76ee\u524d\u5df2\u9886\u53d6\u6570" + signReceiveNum);
            }
        }
        logger.info("[\u514d\u90ae\u6743\u76ca] \u4fdd\u5b58 \u6743\u76ca\u76f8\u5173\u6570\u91cf\u9a8c\u8bc1\u901a\u8fc7 ");
    }

    private void interestFreeReletion(InterestFreeVO vo, Integer interestFreeId) {
        int rs;
        if (vo.getId() != null) {
            Integer bingdingType = null;
            if (CollectionUtils.isNotEmpty((Collection)vo.getCategories())) {
                bingdingType = InterestFreeEnum.BINGDING_TYPE_CATEGORY.getCode();
                this.interestFreeProductDao.batchDelete(vo.getId(), bingdingType);
            }
            if (CollectionUtils.isNotEmpty((Collection)vo.getInterestFreeProduct())) {
                bingdingType = InterestFreeEnum.BINGDING_TYPE_PRODUCT.getCode();
                this.interestFreeProductDao.batchDelete(vo.getId(), bingdingType);
            }
        }
        vo.setId(interestFreeId);
        if (CollectionUtils.isNotEmpty((Collection)vo.getInterestFreeProduct())) {
            this.buildingProduct(vo);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getCategories())) {
            this.buildingCategory(vo);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getInterestFreeProduct()) && (rs = this.interestFreeProductDao.batchInsert(vo.getInterestFreeProduct())) != vo.getInterestFreeProduct().size()) {
            throw new PublicException("PB0003", "\u4fdd\u5b58\u9002\u7528\u5546\u54c1\u51fa\u9519");
        }
    }

    private List<Integer> getBingdingIds(List<String> productCodes, boolean needCategory) {
        logger.info("[\u514d\u90ae\u6743\u76ca] \u83b7\u53d6\u9002\u7528\u5546\u54c1\u7ed1\u5b9aID productCodes:{}", (Object)JSON.toJSONString(productCodes));
        ArrayList bingdingIds = Lists.newArrayList();
        for (String productCode : productCodes) {
            OpProductVO productVO = this.mcOpProductService.findProductByCode(productCode);
            if (productVO == null || productVO.getId() == null) {
                throw new PublicException("PB0005", "\u672a\u627e\u5230CODE\uff1a[" + productCode + "]\u7684\u5546\u54c1\u4fe1\u606f");
            }
            bingdingIds.add(Integer.parseInt("" + productVO.getId()));
            if (!needCategory) continue;
            List<String> skuCodes = this.getProductSkuCodes(productVO, productCode);
            for (String skuCode : skuCodes) {
                List skuCategoryList = this.mcPcsSkuCategoryService.findBackCategoriesBySkuCode(skuCode);
                if (CollectionUtils.isEmpty((Collection)skuCategoryList)) {
                    throw new PublicException("PB0005", "\u672a\u627e\u5230CODE\uff1a[" + productCode + "]\u7684\u5546\u54c1\u7c7b\u76ee\u4fe1\u606f");
                }
                for (PcsSkuCategoryVO skuCategory : skuCategoryList) {
                    bingdingIds.add(Integer.parseInt("" + skuCategory.getId()));
                }
            }
        }
        logger.info("[\u514d\u90ae\u6743\u76ca] \u83b7\u53d6\u9002\u7528\u5546\u54c1\u7ed1\u5b9aID:{}", (Object)JSON.toJSONString((Object)bingdingIds));
        return bingdingIds;
    }

    private List<String> getProductSkuCodes(OpProductVO productVO, String productCode) {
        ArrayList skuCodes = Lists.newArrayList();
        if (productVO.getCombined().booleanValue()) {
            OpSpvVO spvVO;
            List list;
            OpProductVO product = this.mcOpProductService.findCombinedProdbyProdId(productVO.getId());
            if (product != null && CollectionUtils.isNotEmpty((Collection)product.getSpvList()) && CollectionUtils.isNotEmpty((Collection)(list = (spvVO = (OpSpvVO)product.getSpvList().get(0)).getSkuCombinationList()))) {
                PcsSkuCombinationVO combinationVO = (PcsSkuCombinationVO)list.get(0);
                skuCodes.add(combinationVO.getSubSkuCode());
            }
        } else {
            List productList = this.mcOpProductService.findProdWithSpvByNameOrCode(productCode);
            if (CollectionUtils.isNotEmpty((Collection)productList)) {
                for (OpProductVO opProductVO : productList) {
                    skuCodes.addAll(opProductVO.getSkuCodes());
                }
            }
        }
        logger.info("[\u514d\u90ae\u6743\u76ca] \u83b7\u53d6product\u4e0b\u6240\u5bf9\u5e94\u7684SKUCode:{}", (Object)JSON.toJSONString((Object)skuCodes));
        return skuCodes;
    }

    private void checkProvide(Integer memberId, InterestFree interestFree, Integer retryTotal) {
        logger.info("[\u514d\u90ae\u6743\u76ca] \u6743\u76ca\u53d1\u653e\u5f00\u59cb\u6821\u9a8c");
        Integer interestFreeId = interestFree.getId();
        int signReceiveNum = this.interestFreeProvideDao.countReceiveByMember(interestFreeId, memberId);
        if (interestFree.getSignReceiveNum() != 0 && interestFree.getSignReceiveNum() <= signReceiveNum) {
            throw new PublicException("PB0005", "ID\u4e3a[" + interestFreeId + "]\u7684\u514d\u90ae\u6743\u76ca\u6bcf\u4e2a\u7528\u6237\u9650\u9886[" + interestFree.getSignReceiveNum() + "]\u6b21");
        }
        int receivedNum = this.interestFreeProvideDao.countReceive(interestFreeId);
        if (interestFree.getReceiveNum() != 0 && interestFree.getReceiveNum() <= receivedNum) {
            throw new PublicException("PB0005", "ID\u4e3a[" + interestFreeId + "]\u7684\u514d\u90ae\u6743\u76ca\u5df2\u88ab\u9886\u53d6\u5b8c");
        }
        int res = this.interestFreeDao.updateReceived(interestFree.getId(), interestFree.getReceivedTotal());
        if (res == 0) {
            logger.info("[\u514d\u90ae\u6743\u76ca] \u6743\u76ca\u53d1\u653e\u6821\u9a8c \u6570\u636e\u9501\u5931\u8d25,\u5c06\u91cd\u8bd5{}" + retryTotal);
            if (retryTotal != 0) {
                retryTotal = retryTotal - 1;
                this.checkProvide(memberId, interestFree, retryTotal);
            } else {
                logger.error("[\u514d\u90ae\u6743\u76ca] \u6743\u76ca\u53d1\u653e\u6821\u9a8c \u83b7\u53d6\u6570\u636e\u5e93\u9501\u91cd\u8bd53\u6b21\u5931\u8d25");
                throw new PublicException("", "\u514d\u90ae\u6743\u76ca\u9886\u53d6\u5931\u8d25");
            }
        }
        logger.info("[\u514d\u90ae\u6743\u76ca] \u6743\u76ca\u53d1\u653e\u6821\u9a8c\u901a\u8fc7");
    }

    private InterestFreeVO checkInterestFreeUse(InterestFreeUseVO vo) {
        logger.info("[\u514d\u90ae\u6743\u76ca] \u6743\u76ca\u5151\u6362\u5f00\u59cb\u6821\u9a8c");
        InterestFreeVO interestFree = this.interestFreeDao.selectByProvideId(vo.getProvideId());
        if (interestFree == null) {
            throw new PublicException("", "\u672a\u627e\u5230provideId\u4e3a[" + vo.getProvideId() + "]\u7684\u514d\u90ae\u6743\u76ca\u53d1\u653e\u8bb0\u5f55");
        }
        String accessWay = "" + InterestFreeEnum.getCode((String)vo.getAccessWay().toUpperCase());
        if (!interestFree.getAccessWay().contains(accessWay)) {
            throw new PublicException("", "ID\u4e3a[" + interestFree.getId() + "]\u7684\u514d\u90ae\u6743\u76ca\u9002\u7528\u5e73\u53f0\u4e0d\u7b26\u5408");
        }
        if (InterestFreeEnum.USE_TIME_FIXED.getCode().equals(interestFree.getUseTimeType())) {
            Date currDay = DateUtil.dayStart((Date)DateUtil.getNow());
            if (interestFree.getUseBeginDate().after(currDay) || interestFree.getUseEndDate().before(currDay)) {
                throw new PublicException("", "ID\u4e3a[" + interestFree.getId() + "]\u7684\u514d\u90ae\u6743\u76ca\u4e0d\u5728\u4f7f\u7528\u65f6\u95f4\u8303\u56f4\u5185");
            }
        } else {
            Date provideDay = DateUtil.dayStart((Date)interestFree.getProvideTime());
            Date useEndDay = DateUtil.addDay((Date)provideDay, (int)interestFree.getProvideAfterDay());
            Date currDay = DateUtil.dayStart((Date)DateUtil.getNow());
            if (currDay.after(useEndDay)) {
                throw new PublicException("", "ID\u4e3a[" + interestFree.getId() + "]\u7684\u514d\u90ae\u6743\u76ca\u5df2\u8fc7\u671f");
            }
        }
        logger.info("[\u514d\u90ae\u6743\u76ca] \u6743\u76ca\u5151\u6362\u6821\u9a8c\u901a\u8fc7");
        return interestFree;
    }

    private void usedInterestFree(InterestFreeVO vo, Integer retry) {
        InterestFreeProvide provide = (InterestFreeProvide)this.interestFreeProvideDao.selectOne((Number)vo.getProvideId());
        if (vo.getFreePostNum() != 0 && provide.getUsedNum() >= vo.getFreePostNum()) {
            throw new PublicException("", "\u514d\u90ae\u6743\u76ca\u4f7f\u7528\u8d85\u9650");
        }
        int res = this.interestFreeProvideDao.updateUsedNum(vo.getProvideId(), provide.getUsedNum());
        if (res == 0) {
            if (retry != 0) {
                retry = retry - 1;
                this.usedInterestFree(vo, retry);
            } else {
                logger.error("[\u514d\u90ae\u6743\u76ca] \u6743\u76ca\u4f7f\u7528\u5931\u8d25 \u83b7\u53d6\u6570\u636e\u5e93\u9501\u91cd\u8bd53\u6b21\u5931\u8d25");
                throw new PublicException("", "\u514d\u90ae\u6743\u76ca\u5151\u6362\u5931\u8d25");
            }
        }
    }

    private void buildingProduct(InterestFreeVO vo) {
        logger.info("[\u514d\u90ae\u6743\u76ca] \u4fdd\u5b58 \u6784\u5efa\u5546\u54c1\u96c6\u5408");
        ArrayList productList = Lists.newArrayList();
        List productIds = vo.getInterestFreeProduct();
        for (InterestFreeProduct product : productIds) {
            InterestFreeProduct interestFreeProduct = new InterestFreeProduct();
            interestFreeProduct.setInterestFreeId(vo.getId());
            interestFreeProduct.setIsExclusion(vo.getProductScope());
            Integer bingdingType = InterestFreeEnum.BINGDING_TYPE_PRODUCT.getCode();
            interestFreeProduct.setBingdingType(bingdingType);
            interestFreeProduct.setBingdingId(product.getBingdingId());
            interestFreeProduct.setCreateUser(vo.getCreateUser());
            interestFreeProduct.setCreateTime(DateUtil.getNow());
            productList.add(interestFreeProduct);
        }
        vo.setInterestFreeProduct((List)productList);
        logger.info("[\u514d\u90ae\u6743\u76ca] \u4fdd\u5b58 \u6784\u5efa\u5546\u54c1\u96c6\u5408:" + vo.toString());
    }

    private void buildingCategory(InterestFreeVO vo) {
        logger.info("[\u514d\u90ae\u6743\u76ca] \u4fdd\u5b58 \u6784\u5efa\u7c7b\u76ee\u96c6\u5408");
        List categories = vo.getCategories();
        InterestFreeProduct interestFreeProduct = null;
        ArrayList productList = Lists.newArrayList();
        for (Long categorie : categories) {
            interestFreeProduct = new InterestFreeProduct();
            interestFreeProduct.setInterestFreeId(vo.getId());
            interestFreeProduct.setIsExclusion(vo.getProductScope());
            Integer bingdingType = InterestFreeEnum.BINGDING_TYPE_CATEGORY.getCode();
            interestFreeProduct.setBingdingType(bingdingType);
            interestFreeProduct.setBingdingId(categorie);
            interestFreeProduct.setCreateUser(vo.getCreateUser());
            interestFreeProduct.setCreateTime(DateUtil.getNow());
            productList.add(interestFreeProduct);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getInterestFreeProduct())) {
            vo.getInterestFreeProduct().addAll(productList);
        } else {
            vo.setInterestFreeProduct((List)productList);
        }
        logger.info("[\u514d\u90ae\u6743\u76ca] \u4fdd\u5b58 \u6784\u5efa\u7c7b\u76ee\u96c6\u5408:" + vo.toString());
    }

    private InterestFreeProvide buildingProvide(Integer interestFreeId, Integer memberId, String channel) {
        InterestFreeProvide provide = new InterestFreeProvide();
        provide.setInterestFreeId(interestFreeId);
        provide.setMemberId(memberId);
        provide.setUsedNum(Integer.valueOf(0));
        provide.setProvideChannel(channel);
        provide.setCreateTime(DateUtil.getNow());
        return provide;
    }
}

