/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.price;

import com.thebeastshop.pegasus.merchandise.enums.PriceCalTypeEnum;
import com.thebeastshop.pegasus.merchandise.price.AbstractPriceCalculator;
import com.thebeastshop.pegasus.merchandise.price.PriceCalculator;
import com.thebeastshop.pegasus.merchandise.vo.PriceCalResultVO;
import java.math.BigDecimal;
import java.util.List;

public class BDDiscountPriceCalculator
extends AbstractPriceCalculator
implements PriceCalculator {
    private BigDecimal bdDiscountAmount;
    private boolean hasRush = false;
    private boolean allowBdDiscount = false;

    public BDDiscountPriceCalculator(PriceCalculator sourcePriceCalculator, BigDecimal bdDiscountAmount, boolean hasRush, boolean allowBdDiscount) {
        super(sourcePriceCalculator);
        this.bdDiscountAmount = bdDiscountAmount;
        this.hasRush = hasRush;
        this.allowBdDiscount = allowBdDiscount;
    }

    @Override
    public BigDecimal calculate(List<PriceCalResultVO> results) {
        BigDecimal targetPrice = this.getPrevPrice(results);
        PriceCalResultVO result = new PriceCalResultVO();
        result.setType(PriceCalTypeEnum.BIRTHDAY);
        result.setOriginalPrice(targetPrice);
        if (this.allowBdDiscount && !this.hasRush) {
            targetPrice = targetPrice.multiply(this.bdDiscountAmount);
        }
        if (results != null) {
            result.setFinalPrice(targetPrice);
            results.add(result);
        }
        return targetPrice;
    }
}

