/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsSupplierCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsSupplierBusinessCategoryMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsSupplierManufacturerMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsSupplierMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsSupplierPurchaseCategoryMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsSupplierDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplier;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplierBusinessCategory;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplierExample;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplierManufacturer;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplierPurchaseCategory;
import com.thebeastshop.pegasus.merchandise.service.McPcsBuyerInfoService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSupplierManufacturerVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSupplierVO;
import com.thebeastshop.pegasus.merchandise.vo.SupplierBrandRelation;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pcsSupplierDomain")
public class PcsSupplierDomainImpl
extends AbstractBaseDomain<PcsSupplierVO, PcsSupplier>
implements PcsSupplierDomain,
CheckAble {
    @Autowired
    private PcsSupplierMapper pcsSupplierMapper;
    @Autowired
    private McPcsBuyerInfoService mcPcsBuyerInfoService;
    @Autowired
    private PcsSupplierBusinessCategoryMapper pcsSupplierBusinessCategoryMapper;
    @Autowired
    private PcsSupplierPurchaseCategoryMapper pcsSupplierPurchaseCategoryMapper;
    @Autowired
    private PcsSupplierManufacturerMapper pcsSupplierManufacturerMapper;

    @Override
    @Transactional
    public Long create(PcsSupplier record, boolean saveDraft) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            if (!saveDraft) {
                record.setLastSubmitTime(new Date());
            }
            record.setCreateTime(new Date());
            this.pcsSupplierMapper.insertSelective(record);
            return record.getId();
        }
        return null;
    }

    @Override
    @Transactional
    public Boolean update(PcsSupplier record, boolean saveDraft) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            if (!saveDraft) {
                record.setLastSubmitTime(new Date());
            }
            if (this.pcsSupplierMapper.updateByPrimaryKeySelective(record) != 0) {
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public PcsSupplier findById(Long id) {
        if (EmptyUtil.isEmpty((Object)id)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return this.pcsSupplierMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsSupplierVO> findByCond(PcsSupplierCond cond) {
        List<PcsSupplierVO> recordList = this.pcsSupplierMapper.findByCond(cond);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSupplier> findByCriteria(PcsSupplierCond cond) {
        PcsSupplierExample example = new PcsSupplierExample();
        List<PcsSupplier> recordList = this.pcsSupplierMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSupplier> findByName(String name) {
        PcsSupplierExample example = new PcsSupplierExample();
        example.createCriteria().andNameCnLike(SQLUtils.allLike((String)name));
        example.or().andNameLike(SQLUtils.allLike((String)name));
        example.setOrderByClause("ID LIMIT 20 ");
        List<PcsSupplier> recordList = this.pcsSupplierMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSupplier> findByIds(List<Long> ids) {
        ArrayList<PcsSupplier> recordList = new ArrayList<PcsSupplier>();
        for (long id : ids) {
            PcsSupplier record = this.findById(id);
            if (!EmptyUtil.isNotEmpty((Object)record) || !EmptyUtil.isNotEmpty((Object)record.getId())) continue;
            recordList.add(record);
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    public Boolean check(Object obj) {
        PcsSupplier record = (PcsSupplier)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        Boolean currencyFlag = true;
        record.setPurchaseCurrencyDesc(record.getPurchaseCurrencyCode());
        if (!currencyFlag.booleanValue()) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(PcsSupplier record, Boolean isCreate) {
        PcsSupplier oldRecord;
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PcsSupplierExample example1 = new PcsSupplierExample();
        PcsSupplierExample example2 = new PcsSupplierExample();
        example1.createCriteria().andNameEqualTo(record.getName());
        example2.createCriteria().andNameCnEqualTo(record.getNameCn());
        List<PcsSupplier> oldList = null;
        oldList = this.pcsSupplierMapper.selectByExample(example1);
        if (oldList.size() > 0 && isCreate.booleanValue()) {
            throw new PurchaseException("PC0005", "\u4f9b\u5e94\u5546\u540d\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        if (oldList.size() > 0 && !isCreate.booleanValue() && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException("PC0005", "\u4f9b\u5e94\u5546\u540d\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        oldList = this.pcsSupplierMapper.selectByExample(example2);
        if (oldList.size() > 0 && isCreate.booleanValue()) {
            throw new PurchaseException("PC0005", "\u4f9b\u5e94\u5546\u4e2d\u6587\u540d\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        if (oldList.size() > 0 && !isCreate.booleanValue() && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException("PC0005", "\u4f9b\u5e94\u5546\u4e2d\u6587\u540d\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        if (!isCreate.booleanValue() && NullUtil.isNotNull((Object)(oldRecord = this.pcsSupplierMapper.selectByPrimaryKey(record.getId()))) && EmptyUtil.isNotEmpty((Object)oldRecord.getFileId()) && EmptyUtil.isNotEmpty((Object)record.getFileId()) && !oldRecord.getFileId().equals(record.getFileId())) {
            PegasusUtilFacade.getInstance().deleteFileById((long)oldRecord.getFileId().intValue());
        }
        return true;
    }

    @Override
    public Boolean audiSupplier(Long userId, long id, Boolean isPass, Integer type) {
        PcsSupplier record = this.pcsSupplierMapper.selectByPrimaryKey(id);
        record.setLastModifier(userId);
        record.setLastAuditTime(new Date());
        record.setLastApprover(userId.intValue());
        if (isPass.booleanValue()) {
            if (type == 1) {
                record.setSupplierOrderStatus(3);
            } else {
                record.setSupplierOrderStatus(2);
                String string = record.getName();
            }
        } else {
            record.setSupplierOrderStatus(-1);
        }
        if (this.pcsSupplierMapper.updateByPrimaryKeySelective(record) != 0) {
            return true;
        }
        return false;
    }

    @Override
    public long countByCond(PcsSupplierCond cond) {
        return this.pcsSupplierMapper.countByCond(cond);
    }

    @Override
    public List<SupplierBrandRelation> findSupplierBrandRelation() {
        return null;
    }

    @Override
    public Integer addSupplierBusinessCategory(PcsSupplierBusinessCategory supplierBusinessCategory) {
        return this.pcsSupplierBusinessCategoryMapper.insertSelective(supplierBusinessCategory);
    }

    @Override
    public Integer addSupplierPurchaseCategory(PcsSupplierPurchaseCategory supplierPurchaseCategory) {
        return this.pcsSupplierPurchaseCategoryMapper.insertSelective(supplierPurchaseCategory);
    }

    @Override
    public int deleteBusinessCategoryBySupplierId(Integer supplierId) {
        return this.pcsSupplierBusinessCategoryMapper.deleteBySupplierId(supplierId);
    }

    @Override
    public int deletePurchaseCategoryBySupplierId(Integer supplierId) {
        return this.pcsSupplierPurchaseCategoryMapper.deleteBySupplierId(supplierId);
    }

    @Override
    public List<String> findBusinessCategoryBySupplierId(Integer supplierId) {
        return this.pcsSupplierBusinessCategoryMapper.selectBySupplierId(supplierId);
    }

    @Override
    public List<String> findPurchaseCategoryBySupplierId(Integer supplierId) {
        return this.pcsSupplierPurchaseCategoryMapper.selectBySupplierId(supplierId);
    }

    @Override
    public Boolean update(PcsSupplier record) {
        return this.pcsSupplierMapper.updateByPrimaryKeySelective(record) == 1;
    }

    @Override
    public Integer addFactory(PcsSupplierManufacturer pcsSupplierManufacturer) {
        return this.pcsSupplierManufacturerMapper.insertSelective(pcsSupplierManufacturer);
    }

    @Override
    public int deleteFactoryBySupplierId(Integer supplierId) {
        return this.pcsSupplierManufacturerMapper.deleteBySupplierId(supplierId);
    }

    @Override
    public List<PcsSupplierManufacturerVO> findManufacturersBySupplierId(Integer supplierId) {
        return this.pcsSupplierManufacturerMapper.findBySupplierId(supplierId);
    }
}

