/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsReceiveRuleCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsMaterialCategoryMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsReceiveRuleMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsMaterialCategoryDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.model.PcsMaterialCategory;
import com.thebeastshop.pegasus.merchandise.vo.PcsMaterialCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsReceiveRuleVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pcsMaterialCategoryDomain")
public class PcsMaterialCategoryDomainImpl
extends AbstractBaseDomain<PcsMaterialCategoryVO, PcsMaterialCategory>
implements PcsMaterialCategoryDomain {
    @Autowired
    private PcsMaterialCategoryMapper pcsMaterialCategoryMapper;
    @Autowired
    private PcsReceiveRuleMapper pcsReceiveRuleMapper;

    @Override
    @Transactional
    public boolean add(PcsMaterialCategoryVO vo) {
        if (NullUtil.isNotNull((Object)vo.getParentId())) {
            List<PcsMaterialCategoryVO> children;
            PcsMaterialCategoryVO parent = this.findById(vo.getParentId());
            if (NullUtil.isNull((Object)parent)) {
                throw new PurchaseException("PC0002", "\u7236\u7c7b\u76ee\u4e0d\u5b58\u5728\uff01");
            }
            if ((NullUtil.isNull((Object)vo.isFocus()) || !vo.isFocus().booleanValue()) && EmptyUtil.isEmpty(children = this.findByParentId(vo.getParentId()))) {
                PcsReceiveRuleCond ruleCond = new PcsReceiveRuleCond();
                ArrayList<Long> categoryIds = new ArrayList<Long>();
                categoryIds.add(vo.getParentId());
                ruleCond.setMaterialCategoryIds(categoryIds);
                List<PcsReceiveRuleVO> ruleList = this.pcsReceiveRuleMapper.findByCond(ruleCond);
                if (EmptyUtil.isNotEmpty(ruleList)) {
                    throw new PurchaseException("PC0012", "\u8be5\u8282\u70b9\u6536\u8d27\u89c4\u5219\u8bb2\u8f6c\u79fb\u81f3\u65b0\u589e\u7684\u5b50\u7c7b\uff01");
                }
            }
        }
        PcsMaterialCategory record = (PcsMaterialCategory)this.buildFromVO(vo);
        this.pcsMaterialCategoryMapper.insert(record);
        vo.setId(record.getId());
        this.pcsReceiveRuleMapper.changeMaterialCategoryQcItemId(record.getId(), record.getParentId());
        this.pcsReceiveRuleMapper.changeReceiveRuleQcItemId(record.getId(), record.getParentId());
        return true;
    }

    @Override
    @Transactional
    public boolean update(PcsMaterialCategoryVO vo) {
        PcsMaterialCategoryVO tmp = this.findById(vo.getId());
        if (NullUtil.isNull((Object)tmp)) {
            throw new PurchaseException("PC0002", "\u7c7b\u76ee\u4e0d\u5b58\u5728\uff01");
        }
        this.pcsMaterialCategoryMapper.updateByPrimaryKeySelective((PcsMaterialCategory)this.buildFromVO(vo));
        return true;
    }

    @Override
    @Transactional
    public PcsMaterialCategoryVO save(PcsMaterialCategoryVO vo) {
        if (NullUtil.isNull((Object)vo.getId())) {
            this.add(vo);
        } else {
            this.update(vo);
        }
        return vo;
    }

    @Override
    @Transactional
    public boolean del(Long id) {
        List<PcsMaterialCategoryVO> subItems = this.findByParentId(id);
        if (EmptyUtil.isNotEmpty(subItems)) {
            throw new PurchaseException("PC0002", "\u5b58\u5728\u5b50\u7c7b\u7684\u6750\u8d28\u65e0\u6cd5\u5220\u9664\uff01");
        }
        this.pcsMaterialCategoryMapper.deleteByPrimaryKey(id);
        return true;
    }

    @Override
    public List<PcsMaterialCategoryVO> findAll() {
        List<PcsMaterialCategoryVO> list = this.pcsMaterialCategoryMapper.findAll();
        return list;
    }

    @Override
    public PcsMaterialCategoryVO findById(Long id) {
        return this.pcsMaterialCategoryMapper.findById(id);
    }

    @Override
    public List<PcsMaterialCategoryVO> findByParentId(Long parentId) {
        return this.pcsMaterialCategoryMapper.findByParentId(parentId);
    }

    @Override
    public List<PcsMaterialCategoryVO> findLeafById(List<Long> ids) {
        return this.pcsMaterialCategoryMapper.findLeafById(ids);
    }
}

