/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsBrandCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsBrandMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsBrandDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsBuyerDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCategoryDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.model.PcsBrand;
import com.thebeastshop.pegasus.merchandise.model.PcsBrandExample;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuCategoryService;
import com.thebeastshop.pegasus.merchandise.vo.PcsBrandVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pcsBrandDomain")
public class PcsBrandDomainImpl
extends AbstractBaseDomain<PcsBrandVO, PcsBrand>
implements PcsBrandDomain,
CheckAble {
    @Autowired
    private PcsBrandMapper pcsBrandMapper;
    @Autowired
    private PcsBuyerDomain pcsBuyerDomain;
    @Autowired
    private PcsSkuCategoryDomain pcsSkuCategoryDomain;
    @Autowired
    private McPcsSkuCategoryService mcPcsSkuCategoryService;

    @Override
    @Transactional
    public Long create(PcsBrand record, boolean saveDraft) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            record.setCreateTime(new Date());
            if (!saveDraft) {
                record.setLastSubmitTime(new Date());
            }
            this.pcsBrandMapper.insertSelective(record);
            return record.getId();
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsBrand record, boolean saveDraft) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            if (!saveDraft) {
                record.setLastSubmitTime(new Date());
            }
            return this.pcsBrandMapper.updateByPrimaryKeySelective(record) != 0;
        }
        return false;
    }

    @Override
    public PcsBrand findById(long id) {
        if (EmptyUtil.isEmpty((Object)id)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return this.pcsBrandMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsBrandVO> findByCond(PcsBrandCond cond) {
        List<PcsBrandVO> recordList = this.pcsBrandMapper.findByCond(cond);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsBrand> findByName(String name) {
        PcsBrandExample example = new PcsBrandExample();
        example.createCriteria().andNameCnLike(SQLUtils.allLike((String)name));
        example.or().andNameLike(SQLUtils.allLike((String)name));
        example.setOrderByClause("ID LIMIT 20 ");
        List<PcsBrand> recordList = this.pcsBrandMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsBrand> findByIds(List<Long> ids) {
        ArrayList<PcsBrand> recordList = new ArrayList<PcsBrand>();
        for (long id : ids) {
            PcsBrand record = this.findById(id);
            if (!EmptyUtil.isNotEmpty((Object)record) || !EmptyUtil.isNotEmpty((Object)record.getId())) continue;
            recordList.add(record);
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    public Boolean check(Object obj) {
        PcsBrand record = (PcsBrand)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(PcsBrand record, Boolean isCreate) {
        PcsBrand oldRecord;
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PcsBrandExample example1 = new PcsBrandExample();
        PcsBrandExample example2 = new PcsBrandExample();
        example1.createCriteria().andNameEqualTo(record.getName());
        example2.createCriteria().andNameCnEqualTo(record.getNameCn());
        List<PcsBrand> oldList = null;
        oldList = this.pcsBrandMapper.selectByExample(example1);
        if (oldList.size() > 0 && isCreate.booleanValue()) {
            throw new PurchaseException("PC0005", "name\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        if (oldList.size() > 0 && !isCreate.booleanValue() && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException("PC0005", "name\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        oldList = this.pcsBrandMapper.selectByExample(example2);
        if (oldList.size() > 0 && isCreate.booleanValue()) {
            throw new PurchaseException("PC0005", "nameCn\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        if (oldList.size() > 0 && !isCreate.booleanValue() && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException("PC0005", "nameCn\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u540d");
        }
        if (!isCreate.booleanValue() && NullUtil.isNotNull((Object)(oldRecord = this.pcsBrandMapper.selectByPrimaryKey(record.getId()))) && EmptyUtil.isNotEmpty((Object)oldRecord.getFileId()) && EmptyUtil.isNotEmpty((Object)record.getFileId()) && !oldRecord.getFileId().equals(record.getFileId())) {
            PegasusUtilFacade.getInstance().deleteFileById((long)oldRecord.getFileId().intValue());
        }
        return true;
    }

    @Override
    public Boolean auditBrand(Long userId, long id, Boolean isPass, Integer type) {
        PcsBrand record = this.pcsBrandMapper.selectByPrimaryKey(id);
        record.setLastModifier(userId);
        record.setLastAuditTime(new Date());
        record.setLastApprover(userId.intValue());
        if (isPass.booleanValue()) {
            if (type == 1) {
                record.setBrandStatus(3);
            } else {
                record.setBrandStatus(2);
            }
        } else {
            record.setBrandStatus(-1);
        }
        if (this.pcsBrandMapper.updateByPrimaryKeySelective(record) != 0) {
            return true;
        }
        return false;
    }

    @Override
    public long countByCond(PcsBrandCond cond) {
        return this.pcsBrandMapper.countByCond(cond);
    }

    @Override
    public List<PcsBrandVO> findByCondCategory(PcsBrandCond cond) {
        String code = cond.getCategoryCode();
        List<Long> ids = new ArrayList();
        if (code != null) {
            List list = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(code);
            for (PcsSkuCategoryVO obj : list) {
                ids.add(obj.getId());
            }
        } else {
            ids = cond.getCategoryIds();
        }
        cond.setCategoryIds(ids);
        return this.pcsBrandMapper.findByCondCategory(cond);
    }

    @Override
    public List<PcsBrandVO> findByCondIds(PcsBrandCond cond) {
        return this.pcsBrandMapper.findByCondIds(cond);
    }
}

