/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.OpChnCanSaleProdCond;
import com.thebeastshop.pegasus.merchandise.dao.OpChnCanSaleProdMapper;
import com.thebeastshop.pegasus.merchandise.dao.OpProductMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpChnCanSaleProdDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpProdSkuDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpProductDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.model.OpChnCanSaleProd;
import com.thebeastshop.pegasus.merchandise.model.OpChnCanSaleProdExample;
import com.thebeastshop.pegasus.merchandise.model.OpProdSku;
import com.thebeastshop.pegasus.merchandise.model.OpProduct;
import com.thebeastshop.pegasus.merchandise.vo.OpChnCanSaleProdVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProductVO;
import com.thebeastshop.pegasus.merchandise.vo.OpSpvVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCombinationVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="opChnCanSaleProdDomain")
public class OpChnCanSaleProdDomainImpl
extends AbstractBaseDomain<OpChnCanSaleProdVO, OpChnCanSaleProd>
implements OpChnCanSaleProdDomain {
    @Autowired
    private OpChnCanSaleProdMapper opChannelCanSaleSkuMapper;
    @Autowired
    private OpProdSkuDomain opProdSkuDomain;
    @Autowired
    OpProductMapper opProductMapper;
    @Autowired
    OpProductDomain opProductDomain;

    @Override
    public List<OpChnCanSaleProd> findByChannelCode(String channelCode) {
        OpChnCanSaleProdExample example = new OpChnCanSaleProdExample();
        OpChnCanSaleProdExample.Criteria criteria = example.createCriteria();
        criteria.andChannelCodeEqualTo(channelCode);
        return this.opChannelCanSaleSkuMapper.selectByExample(example);
    }

    @Override
    public boolean deleteById(Long id) {
        return this.opChannelCanSaleSkuMapper.deleteByPrimaryKey(id) != 0;
    }

    @Override
    public void deleteByChannelCode(String channelCode) {
        OpChnCanSaleProdExample example = new OpChnCanSaleProdExample();
        example.createCriteria().andChannelCodeEqualTo(channelCode);
        this.opChannelCanSaleSkuMapper.deleteByExample(example);
    }

    @Override
    public List<OpChnCanSaleProd> findByChannelCodeProdId(String channelCode, Long prodId) {
        OpChnCanSaleProdExample example = new OpChnCanSaleProdExample();
        OpChnCanSaleProdExample.Criteria criteria = example.createCriteria();
        criteria.andChannelCodeEqualTo(channelCode);
        criteria.andProductIdEqualTo(prodId);
        return this.opChannelCanSaleSkuMapper.selectByExample(example);
    }

    @Override
    public boolean create(OpChnCanSaleProd prod) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(this.findByChannelCodeProdId(prod.getChannelCode(), prod.getProductId()))) {
            return false;
        }
        Long productId = prod.getProductId();
        OpProduct opProduct = this.opProductMapper.selectByPrimaryKey(productId);
        ArrayList<String> list = new ArrayList<String>();
        if (opProduct.getCombined().booleanValue()) {
            OpProductVO productVO = this.opProductDomain.findCombinedProductByProdId(productId);
            List opSpvs = productVO.getSpvList();
            if (CollectionUtils.isNotEmpty((Collection)opSpvs)) {
                for (OpSpvVO spvVO : opSpvs) {
                    List scList = spvVO.getSkuCombinationList();
                    if (CollectionUtils.isNotEmpty((Collection)scList)) {
                        for (PcsSkuCombinationVO vo : scList) {
                            String skuCode = vo.getSubSkuCode();
                            list.add(skuCode);
                        }
                    }
                    list = new ArrayList(new LinkedHashSet(list));
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
                StringBuilder skuCodes = new StringBuilder();
                for (String sku : list) {
                    skuCodes.append(",").append(sku);
                }
                prod.setCanSaleSku(skuCodes.substring(1).toString());
                prod.setCanSeeSku(prod.getCanSaleSku());
            }
        } else {
            List<OpProdSku> skus = this.opProdSkuDomain.findByProdId(prod.getProductId());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(skus)) {
                StringBuilder skuCodes = new StringBuilder();
                for (OpProdSku sku : skus) {
                    skuCodes.append(",").append(sku.getSkuCode());
                }
                prod.setCanSaleSku(skuCodes.substring(1).toString());
                prod.setCanSeeSku(skuCodes.substring(1).toString());
            }
        }
        return this.opChannelCanSaleSkuMapper.insert(prod) != 0;
    }

    @Override
    public boolean update(OpChnCanSaleProd prod) {
        return this.opChannelCanSaleSkuMapper.updateByPrimaryKeySelective(prod) != 0;
    }

    @Override
    public List<OpChnCanSaleProdVO> findByCond(OpChnCanSaleProdCond cond) {
        return this.opChannelCanSaleSkuMapper.findVOByCond(cond);
    }

    @Override
    public List<OpChnCanSaleProdVO> findByProdIds(List<Long> prodIds) {
        OpChnCanSaleProdExample example = new OpChnCanSaleProdExample();
        OpChnCanSaleProdExample.Criteria criteria = example.createCriteria();
        criteria.andProductIdIn((List)prodIds);
        example.setOrderByClause("PRODUCT_ID");
        return BeanUtil.buildListFrom(this.opChannelCanSaleSkuMapper.selectByExample(example), OpChnCanSaleProdVO.class);
    }

    @Override
    public OpChnCanSaleProdVO findById(Long id) {
        return (OpChnCanSaleProdVO)BeanUtil.buildFrom((Object)this.opChannelCanSaleSkuMapper.selectByPrimaryKey(id), OpChnCanSaleProdVO.class);
    }

    @Override
    public void deleteByProdId(Long prodId) {
        OpChnCanSaleProdExample example = new OpChnCanSaleProdExample();
        example.createCriteria().andProductIdEqualTo(prodId);
        this.opChannelCanSaleSkuMapper.deleteByExample(example);
    }
}

