/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.merchandise.client.CampaignESClient;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.constants.SearchType;
import com.thebeastshop.pegasus.merchandise.domain.CampaignDomain;
import com.thebeastshop.pegasus.merchandise.vo.PsAdvanceCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="campaignDomain")
public class CampaignDomainImpl
implements CampaignDomain {
    @Autowired
    private CampaignESClient campaignClient;

    @Override
    public List<PsCampaignVO> getGlobalCampaignList(PsMatchCampaignCond cond) {
        cond.setProductScopeIds((List)Lists.newArrayList((Object[])new Integer[]{3}));
        cond.setStates((List)Lists.newArrayList((Object[])new Integer[]{1}));
        return this.getMatchedCampaignList(cond);
    }

    @Override
    public List<PsCampaignVO> getMatchedCampaignList(PsMatchCampaignCond cond) {
        Integer memberLevel = cond.getMemberLevel();
        Integer accessWay = cond.getAccessWay();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pagenum", 999);
        if (CollectionUtils.isNotEmpty((Collection)cond.getCampaignIds())) {
            params.put("id", cond.getCampaignIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)cond.getStates())) {
            params.put("state", QueryBuilders.termsQuery((String)"state", (Collection)cond.getStates()));
        }
        if (CollectionUtils.isNotEmpty((Collection)cond.getDiscountTypeIds())) {
            params.put("campaignList.discountTypeId", QueryBuilders.termsQuery((String)"campaignList.discountTypeId", (Collection)cond.getDiscountTypeIds()));
        }
        if (CollectionUtils.isNotEmpty((Collection)cond.getProductScopeIds())) {
            params.put("productScopeId", QueryBuilders.termsQuery((String)"productScopeId", (Collection)cond.getProductScopeIds()));
        }
        params.put("accessWayIds", QueryBuilders.termsQuery((String)"accessWayIds", (Collection)Lists.newArrayList((Object[])new Integer[]{accessWay})));
        params.put("memberLevels", QueryBuilders.termsQuery((String)"memberLevels", (Collection)Lists.newArrayList((Object[])new Integer[]{memberLevel})));
        Date now = new Date();
        params.put("startTime", QueryBuilders.rangeQuery((String)"startTime").lte((Object)now));
        params.put("expireTime", QueryBuilders.rangeQuery((String)"expireTime").gt((Object)now));
        params.put("active", QueryBuilders.termQuery((String)"active", (int)1));
        List<PsCampaignVO> campaigns = this.campaignClient.findByFields(params, SearchType.ANDLIKE);
        return campaigns;
    }

    private void matchCampaignList(List<PsCampaignVO> campaignList, Integer accessWayId, Integer memberLevelId, Boolean crossBorderFlag, List<PsCampaignVO> matchedAdvanceCampaignList, List<PsCampaignVO> matchedCampaignList) {
        for (PsCampaignVO campaignVO : campaignList) {
            if (campaignVO.match(accessWayId, memberLevelId, crossBorderFlag).booleanValue()) {
                matchedCampaignList.add(campaignVO);
                continue;
            }
            if (!campaignVO.isMatchAdvance(accessWayId, memberLevelId, crossBorderFlag).booleanValue()) continue;
            matchedAdvanceCampaignList.add(campaignVO);
        }
    }

    @Override
    public void matchListPageCampaigns(List<PsProductVO> productVOList, PsMatchCampaignCond cond) {
        if (CollectionUtils.isNotEmpty(productVOList)) {
            List<PsCampaignVO> globalCampaignList = this.getGlobalCampaignList(cond);
            for (PsProductVO psProductVO : productVOList) {
                this.matchCampaigns(psProductVO, cond, globalCampaignList);
            }
        }
    }

    @Override
    public void matchCampaigns(PsProductVO psProductVO, PsMatchCampaignCond cond) {
        List<PsCampaignVO> globalCampaignList = this.getGlobalCampaignList(cond);
        this.matchCampaigns(psProductVO, cond, globalCampaignList);
    }

    private void matchCampaigns(PsProductVO psProductVO, PsMatchCampaignCond cond, List<PsCampaignVO> globalCampaigns) {
        List spvList;
        List campaignList = psProductVO.getCampaignList();
        Boolean matchGlobalCampaigns = cond.getMatchGlobalCampaigns();
        if (CollectionUtils.isNotEmpty(globalCampaigns)) {
            campaignList.addAll(globalCampaigns);
        }
        Integer memberLevel = cond.getMemberLevel();
        Integer accessWay = cond.getAccessWay();
        Integer accessWayId = accessWay == null ? -1 : accessWay;
        Integer memberLevelId = memberLevel == null ? -1 : memberLevel;
        Integer crossBorderFlagValue = psProductVO.getCrossBorderFlag();
        Boolean crossBorderFlag = crossBorderFlagValue != null && crossBorderFlagValue.equals(1);
        if (CollectionUtils.isNotEmpty((Collection)campaignList)) {
            ArrayList matchedAdvanceCampaignList = Lists.newArrayList();
            ArrayList matchedProductCampaignList = Lists.newArrayList();
            this.matchCampaignList(campaignList, accessWayId, memberLevelId, crossBorderFlag, matchedAdvanceCampaignList, matchedProductCampaignList);
            psProductVO.setCampaignList((List)matchedProductCampaignList);
            if (CollectionUtils.isNotEmpty((Collection)matchedAdvanceCampaignList)) {
                PsAdvanceCampaignVO psAdvanceCampaignVO = new PsAdvanceCampaignVO();
                psAdvanceCampaignVO.setAdvanceCampaignList((List)matchedAdvanceCampaignList);
                psProductVO.setPsAdvanceCampaignVO(psAdvanceCampaignVO);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(spvList = psProductVO.getSpvList()))) {
            for (PsSpvVO spvVO : spvList) {
                this.matchCampaigns(spvVO, cond, crossBorderFlagValue);
            }
        }
    }

    @Override
    public void matchCampaigns(PsSpvVO spvVO, PsMatchCampaignCond cond, Integer crossBorderFlagValue) {
        Integer memberLevel = cond.getMemberLevel();
        Integer accessWay = cond.getAccessWay();
        Integer accessWayId = accessWay == null ? -1 : accessWay;
        Integer memberLevelId = memberLevel == null ? -1 : memberLevel;
        Boolean crossBorderFlag = crossBorderFlagValue != null && crossBorderFlagValue.equals(1);
        List campaignList = spvVO.getCampaignList();
        if (CollectionUtils.isNotEmpty((Collection)campaignList)) {
            ArrayList matchedAdvanceSpvCampaignList = Lists.newArrayList();
            ArrayList matchedSpvCampaignList = Lists.newArrayList();
            this.matchCampaignList(campaignList, accessWayId, memberLevelId, crossBorderFlag, matchedAdvanceSpvCampaignList, matchedSpvCampaignList);
            spvVO.setCampaignList((List)matchedSpvCampaignList);
            spvVO.setAdvanceCampaignList((List)matchedAdvanceSpvCampaignList);
        }
    }
}

