/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.client;

import com.thebeastshop.pegasus.merchandise.client.AbstractESClient;
import com.thebeastshop.pegasus.merchandise.client.ElasticsearchClientFactory;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CampaignESClient
extends AbstractESClient<PsCampaignVO> {
    private static final Logger logger = LoggerFactory.getLogger(CampaignESClient.class);

    public CampaignESClient(String index, String type, ElasticsearchClientFactory elasticsearchClientFactory) {
        super(index, type, elasticsearchClientFactory);
    }

    @Override
    public PsCampaignVO build(SearchHit hit, String chnCode) {
        Map params = hit.getSource();
        PsCampaignVO campaignVO = new PsCampaignVO();
        this.buildCampaign(params, campaignVO);
        return campaignVO;
    }

    @Override
    public PsCampaignVO build(SearchHit hit, String chnCode, Long total) {
        return this.build(hit, chnCode);
    }

    public void buildCampaign(Map params, PsCampaignVO psCampaignVO) {
        Date expireTime;
        Date advanceEndTime;
        psCampaignVO.setId(Long.valueOf(String.valueOf(params.get("id"))));
        psCampaignVO.setCode(String.valueOf(params.get("code")));
        psCampaignVO.setState(MapUtils.getInteger((Map)params, (Object)"state"));
        psCampaignVO.setName((String)params.get("name"));
        psCampaignVO.setTitle((String)params.get("title"));
        psCampaignVO.setDiscountTypeId((Integer)params.get("discountTypeId"));
        psCampaignVO.setDiscountTypeName((String)params.get("discountTypeName"));
        psCampaignVO.setProductScopeId((Integer)params.get("productScopeId"));
        psCampaignVO.setCrossBorderFlag(MapUtils.getInteger((Map)params, (Object)"crossBorderFlag"));
        psCampaignVO.setCumulative(MapUtils.getInteger((Map)params, (Object)"cumulative"));
        psCampaignVO.setAdvance((Integer)params.get("advance"));
        psCampaignVO.setAdvanceName((String)params.get("advanceName"));
        psCampaignVO.setAdvanceTitle((String)params.get("advanceTitle"));
        Date advanceStartTime = this.buildDateTime(params, "advanceStartTime");
        if (advanceStartTime != null) {
            psCampaignVO.setAdvanceStartTime(DateUtils.addHours((Date)advanceStartTime, (int)8));
        }
        if ((advanceEndTime = this.buildDateTime(params, "advanceEndTime")) != null) {
            psCampaignVO.setAdvanceEndTime(DateUtils.addHours((Date)advanceEndTime, (int)8));
        }
        psCampaignVO.setAdvancePriceTitle((String)params.get("advancePriceTitle"));
        ArrayList memberLevelIds = (ArrayList)params.get("memberLevels");
        if (memberLevelIds == null) {
            memberLevelIds = new ArrayList();
        }
        psCampaignVO.setMemberLevels((List)memberLevelIds);
        ArrayList accessWayIds = (ArrayList)params.get("accessWayIds");
        if (accessWayIds == null) {
            accessWayIds = new ArrayList();
        }
        psCampaignVO.setAccessWayIds((List)accessWayIds);
        Date startTime = this.buildDateTime(params, "startTime");
        if (startTime != null) {
            psCampaignVO.setStartTime(DateUtils.addHours((Date)startTime, (int)8));
        }
        if ((expireTime = this.buildDateTime(params, "expireTime")) != null) {
            psCampaignVO.setExpireTime(DateUtils.addHours((Date)expireTime, (int)8));
        }
        Integer limitAmount = (Integer)params.get("limitAmount");
        psCampaignVO.setLimitAmount(limitAmount);
        psCampaignVO.setOptionFlag((Integer)params.get("optionFlag"));
        psCampaignVO.setLadderRule((Integer)params.get("ladderRule"));
        List campaignSectionList = (List)params.get("campaignSections");
        if (EmptyUtil.isNotEmpty((List)campaignSectionList)) {
            ArrayList<PsCampaignSectionVO> campaignSections = new ArrayList<PsCampaignSectionVO>();
            psCampaignVO.setCampaignSectionList(campaignSections);
            for (Map campaignSection : campaignSectionList) {
                PsCampaignSectionVO psCampaignSectionVO = new PsCampaignSectionVO();
                psCampaignSectionVO.setId(Long.valueOf(String.valueOf(campaignSection.get("id"))));
                psCampaignSectionVO.setCampaignId(Long.valueOf(String.valueOf(campaignSection.get("campaignId"))));
                psCampaignSectionVO.setConditionType(MapUtils.getInteger((Map)campaignSection, (Object)"conditionType"));
                if (campaignSection.containsKey("line")) {
                    psCampaignSectionVO.setLine(new BigDecimal(MapUtils.getString((Map)campaignSection, (Object)"line")));
                }
                if (campaignSection.containsKey("factor")) {
                    psCampaignSectionVO.setFactor(new BigDecimal(MapUtils.getString((Map)campaignSection, (Object)"factor")));
                }
                if (campaignSection.containsKey("factorType")) {
                    psCampaignSectionVO.setFactorType(MapUtils.getInteger((Map)campaignSection, (Object)"factorType"));
                }
                if (campaignSection.containsKey("ranking")) {
                    psCampaignSectionVO.setRanking(MapUtils.getDouble((Map)campaignSection, (Object)"ranking"));
                }
                campaignSections.add(psCampaignSectionVO);
                List campaignSectionProductList = (List)campaignSection.get("sectionProducts");
                if (!EmptyUtil.isNotEmpty((List)campaignSectionProductList)) continue;
                ArrayList<PsCampaignSectionProductVO> campaignSectionProducts = new ArrayList<PsCampaignSectionProductVO>();
                psCampaignSectionVO.setCampaignSectionProducts(campaignSectionProducts);
                for (Map campaignSectionProduct : campaignSectionProductList) {
                    PsCampaignSectionProductVO psCampaignSectionProductVO = new PsCampaignSectionProductVO();
                    psCampaignSectionProductVO.setId(Long.valueOf(String.valueOf(campaignSectionProduct.get("id"))));
                    psCampaignSectionProductVO.setCampaignId(psCampaignVO.getId());
                    psCampaignSectionProductVO.setCampaignSectionId(psCampaignSectionVO.getId());
                    psCampaignSectionProductVO.setProductId(Long.valueOf(String.valueOf(campaignSectionProduct.get("productId"))));
                    psCampaignSectionProductVO.setPricePrice(new BigDecimal(String.valueOf(campaignSectionProduct.get("productPrice"))));
                    psCampaignSectionProductVO.setPriceCount((Integer)campaignSectionProduct.get("productCount"));
                    psCampaignSectionProductVO.setLimitCount((Integer)campaignSectionProduct.get("limitCount"));
                    campaignSectionProducts.add(psCampaignSectionProductVO);
                }
            }
        }
    }

    private Date buildDateTime(Map params, String key) {
        String dateStr;
        block3: {
            try {
                dateStr = MapUtils.getString((Map)params, (Object)key);
                if (dateStr != null) break block3;
                return null;
            }
            catch (Exception ex) {
                logger.error("\u6784\u5efa\u4eceES\u62ff\u5230\u7684\u6d3b\u52a8\u5b9e\u4f53\u4e2d\u7684" + key + "\u5b57\u6bb5\u8f6c\u5316\u65f6\u51fa\u9519");
                return null;
            }
        }
        dateStr = StringUtils.replace((String)dateStr, (String)"T", (String)" ");
        Date date = DateUtil.parse((String)dateStr, (String)"yyyy-MM-dd HH:mm:ss");
        return date;
    }

    @Override
    public XContentBuilder getXContentBuilder(PsCampaignVO vo) {
        return null;
    }

    @Override
    public String getPrimaryKeyName() {
        return "id";
    }
}

