/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.client;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.google.common.base.Strings;
import com.thebeastshop.pegasus.merchandise.client.ElasticsearchClientFactory;
import com.thebeastshop.pegasus.merchandise.client.ProductClient;
import com.thebeastshop.pegasus.merchandise.cond.DateRange;
import com.thebeastshop.pegasus.merchandise.domain.SearchKeyword;
import com.thebeastshop.pegasus.merchandise.exception.PublicException;
import com.thebeastshop.pegasus.merchandise.util.McReflectionUtil;
import com.thebeastshop.pegasus.merchandise.vo.PsBaseVO;
import com.thebeastshop.pegasus.merchandise.vo.PsUpdateVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.lang3.StringUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BaseFilterBuilder;
import org.elasticsearch.index.query.BoolFilterBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryFilterBuilder;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeFilterBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractESClient<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractESClient.class);
    protected String index;
    protected String type;
    private static final String DEFAULT_HOME = "127.0.0.1";
    private static final int DEFAULT_PORT = 9300;
    private static final int DEFAULT_FROM = 0;
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final int DEFAULT_PAGE_MAX_SIZE = Integer.MAX_VALUE;
    protected TransportClient client;
    protected final ElasticsearchClientFactory elasticsearchClientFactory;

    public AbstractESClient(String index, String type, ElasticsearchClientFactory elasticsearchClientFactory) {
        this.index = index;
        this.type = type;
        this.elasticsearchClientFactory = elasticsearchClientFactory;
        this.client = elasticsearchClientFactory.createClient();
    }

    public ElasticsearchClientFactory getElasticsearchClientFactory() {
        return this.elasticsearchClientFactory;
    }

    public List<T> findAllByField(String name, String value) {
        StackTraceElement stackTraceElement = this.getStrackElement();
        return this.findAllByField(stackTraceElement, name, value);
    }

    public List<T> findAllByField(StackTraceElement stackTraceElement, String name, String value) {
        return this.findByField(stackTraceElement, name, value, Integer.MAX_VALUE);
    }

    private void createMapping() {
        PutMappingRequest mappingRequest = Requests.putMappingRequest((String[])new String[]{this.index}).type(this.type);
        PutMappingResponse response = (PutMappingResponse)this.client.admin().indices().putMapping(mappingRequest).actionGet();
    }

    private StackTraceElement getStrackElement() {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[3];
        return stackTraceElement;
    }

    public List<T> findByField(String name, Object value, int count) {
        StackTraceElement stackTraceElement = this.getStrackElement();
        return this.findByField(stackTraceElement, name, value, count);
    }

    public List<T> findByField(String name, Object value) {
        StackTraceElement stackTraceElement = this.getStrackElement();
        return this.findByField(stackTraceElement, name, value, 0);
    }

    private List<T> findByField(StackTraceElement stackTraceElement, String name, Object value, int count) {
        if (count < 1) {
            count = 20;
        }
        MatchAllQueryBuilder builder = null;
        if (StringUtils.isBlank((CharSequence)name)) {
            builder = QueryBuilders.matchAllQuery();
        } else {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            builder = boolQueryBuilder;
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)value, (String[])new String[]{name}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
        }
        List<T> result = this.searchByQryBuilderWithSortList((QueryBuilder)builder, stackTraceElement, null, 0, count, null);
        return result;
    }

    private List<T> findByField(StackTraceElement stackTraceElement, String name, Object value) {
        return this.findByField(stackTraceElement, name, value, 0);
    }

    private void setOrder(SortBuilder sortBuilder, String order) {
        if ("asc".equals(order.toLowerCase())) {
            sortBuilder.order(SortOrder.ASC);
        } else if ("desc".equals(order.toLowerCase())) {
            sortBuilder.order(SortOrder.DESC);
        }
    }

    private void setFilterMap(SortBuilder sortBuilder, Map map) {
        Map nestedFilterMap;
        String mode;
        String order = (String)map.get("order");
        if (StringUtils.isNotEmpty((CharSequence)order)) {
            this.setOrder(sortBuilder, order);
        }
        if (StringUtils.isNotEmpty((CharSequence)(mode = (String)map.get("mode")))) {
            if (sortBuilder instanceof FieldSortBuilder) {
                ((FieldSortBuilder)sortBuilder).sortMode(mode);
            } else if (sortBuilder instanceof ScriptSortBuilder) {
                ((ScriptSortBuilder)sortBuilder).sortMode(mode);
            }
        }
        if (EmptyUtil.isNotEmpty((Map)(nestedFilterMap = (Map)map.get("nested_filter")))) {
            if (EmptyUtil.isNotEmpty(nestedFilterMap.get("range"))) {
                Map rangeMap = (Map)nestedFilterMap.get("range");
                for (String key : rangeMap.keySet()) {
                    RangeFilterBuilder filterBuilder = FilterBuilders.rangeFilter((String)key);
                    Map value = (Map)rangeMap.get(key);
                    filterBuilder.from(value.get("from"));
                    filterBuilder.to(value.get("to"));
                    this.setNestedFilterByCond(sortBuilder, (BaseFilterBuilder)filterBuilder);
                }
            } else {
                BoolFilterBuilder filterBuilder = FilterBuilders.boolFilter();
                for (String key : nestedFilterMap.keySet()) {
                    Object value = nestedFilterMap.get(key);
                    filterBuilder.must((FilterBuilder)FilterBuilders.termFilter((String)key, value));
                }
                this.setNestedFilterByCond(sortBuilder, (BaseFilterBuilder)filterBuilder);
            }
        }
    }

    private void setNestedFilterByCond(SortBuilder sortBuilder, BaseFilterBuilder filterBuilder) {
        if (sortBuilder instanceof FieldSortBuilder) {
            ((FieldSortBuilder)sortBuilder).setNestedFilter((FilterBuilder)filterBuilder);
        } else if (sortBuilder instanceof ScriptSortBuilder) {
            ((ScriptSortBuilder)sortBuilder).setNestedFilter((FilterBuilder)filterBuilder);
        }
    }

    public List<T> searchByQryBuilderWithSortMap(QueryBuilder queryBuilder, StackTraceElement stackTraceElement, String chnCode, int from, int size, Map sort) {
        ArrayList<T> list = new ArrayList<T>();
        String class_method = String.valueOf(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
        Transaction t = Cat.newTransaction((String)"ES", (String)class_method);
        try {
            try {
                SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(new String[]{this.index}).setTypes(new String[]{this.type}).setQuery(queryBuilder).setFrom(from).setSize(size).setQueryCache(Boolean.valueOf(false));
                if (sort != null && sort.size() > 0) {
                    for (String key : sort.keySet()) {
                        Object value = sort.get(key);
                        if (key.equals("_script") && value instanceof Map) {
                            Map scriptMap = (Map)value;
                            String script = (String)scriptMap.get("script");
                            ScriptSortBuilder scriptSortBuilder = SortBuilders.scriptSort((String)script, (String)"number");
                            if (scriptMap.containsKey("params")) {
                                Map params = (Map)scriptMap.get("params");
                                scriptSortBuilder.setParams(params);
                            }
                            this.setFilterMap((SortBuilder)scriptSortBuilder, (Map)value);
                            searchRequestBuilder.addSort((SortBuilder)scriptSortBuilder);
                            continue;
                        }
                        FieldSortBuilder sortBuilder = SortBuilders.fieldSort((String)key);
                        if (value instanceof String) {
                            this.setOrder((SortBuilder)sortBuilder, (String)value);
                        } else if (value instanceof Map) {
                            this.setFilterMap((SortBuilder)sortBuilder, (Map)value);
                        }
                        if ("channelProdInfo.createTime".equals(key)) {
                            if (chnCode == null || StringUtils.isBlank((CharSequence)chnCode)) {
                                log.error("chnCode is null");
                            } else {
                                BoolQueryBuilder queryBuilder2 = QueryBuilders.boolQuery();
                                queryBuilder2.must((QueryBuilder)QueryBuilders.queryStringQuery((String)chnCode).field("channelProdInfo.channelCode"));
                                QueryFilterBuilder termFilter = FilterBuilders.queryFilter((QueryBuilder)queryBuilder2);
                                sortBuilder.setNestedFilter((FilterBuilder)termFilter);
                            }
                        }
                        searchRequestBuilder.addSort((SortBuilder)sortBuilder);
                    }
                }
                if (sort == null || EmptyUtil.isEmpty((Map)sort)) {
                    searchRequestBuilder.addSort((SortBuilder)SortBuilders.fieldSort((String)"_id").order(SortOrder.ASC).ignoreUnmapped(true));
                }
                String esQueryString = searchRequestBuilder.toString();
                esQueryString = esQueryString.replaceAll("\\n", "");
                log.info("GET " + this.index + "/" + this.type + "/_search \n" + esQueryString);
                Cat.logEvent((String)"ES.Query", (String)("GET " + this.index + "/" + this.type + "/_search"), (String)"0", (String)esQueryString);
                SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
                SearchHits hits = searchResponse.getHits();
                long total = hits.getTotalHits();
                SearchHit[] searchHists = hits.getHits();
                if (searchHists.length > 0) {
                    SearchHit[] searchHitArray = searchHists;
                    int n = searchHists.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SearchHit hit = searchHitArray[n2];
                        if (this instanceof ProductClient) {
                            list.add(this.build(hit, chnCode, total));
                        } else {
                            list.add(this.build(hit, chnCode));
                        }
                        ++n2;
                    }
                }
                t.setStatus("0");
            }
            catch (RuntimeException e) {
                log.error("Search ES Error: " + e);
                Cat.logError((Throwable)e);
                e.printStackTrace();
                throw new PublicException("PB0005", "\u67e5\u8be2\u51fa\u9519\uff01");
            }
        }
        finally {
            t.complete();
        }
        return list;
    }

    public List<T> searchByQryBuilderWithSortList(QueryBuilder queryBuilder, StackTraceElement stackTraceElement, String chnCode, int from, int size, List<List<String>> sort) {
        ArrayList<T> list = new ArrayList<T>();
        String esQueryString = "";
        String class_method = String.valueOf(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
        Transaction t = Cat.newTransaction((String)"ES", (String)class_method);
        try {
            try {
                esQueryString = esQueryString.replaceAll("\\n", "");
                log.info("GET " + this.index + "/" + this.type + "/_search \n" + esQueryString);
                SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(new String[]{this.index}).setTypes(new String[]{this.type}).setQuery(queryBuilder).setFrom(from).setSize(size).setQueryCache(Boolean.valueOf(false));
                if (sort != null && sort.size() > 0) {
                    for (List<String> mySort : sort) {
                        if (mySort.size() != 2) continue;
                        searchRequestBuilder.addSort((SortBuilder)SortBuilders.fieldSort((String)mySort.get(0)).order(mySort.get(1).equals(SortOrder.ASC.toString()) ? SortOrder.ASC : SortOrder.DESC));
                    }
                }
                if (CollectionUtils.isEmpty(sort)) {
                    searchRequestBuilder.addSort((SortBuilder)SortBuilders.fieldSort((String)"_id").order(SortOrder.ASC));
                }
                esQueryString = searchRequestBuilder.toString();
                Cat.logEvent((String)"ES.Query", (String)("GET " + this.index + "/" + this.type + "/_search"), (String)"0", (String)esQueryString);
                SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
                SearchHits hits = searchResponse.getHits();
                SearchHit[] searchHists = hits.getHits();
                if (searchHists.length > 0) {
                    SearchHit[] searchHitArray = searchHists;
                    int n = searchHists.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SearchHit hit = searchHitArray[n2];
                        list.add(this.build(hit, chnCode));
                        ++n2;
                    }
                }
                t.setStatus("0");
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                Cat.logError((Throwable)e);
                throw new PublicException("PB0005", "\u67e5\u8be2\u51fa\u9519\uff01[ES\u67e5\u8be2]Query: " + esQueryString + "\n" + e);
            }
        }
        finally {
            t.complete();
        }
        return list;
    }

    private List<T> searchByQryBuilderJoin(QueryBuilder queryBuilder, StackTraceElement stackTraceElement, String chnCode, int from, int size) {
        ArrayList<T> list = new ArrayList<T>();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        QueryBuilders.disMaxQuery();
        QueryBuilders.prefixQuery((String)"", (String)"110");
        String class_method = String.valueOf(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
        Transaction t = Cat.newTransaction((String)"ES", (String)class_method);
        String esQueryString = queryBuilder.toString();
        try {
            try {
                esQueryString = esQueryString.replaceAll("\\n", "");
                log.info("GET " + this.index + "/" + this.type + "/_search \n" + esQueryString);
                Cat.logEvent((String)"ES.Query", (String)("GET " + this.index + "/" + this.type + "/_search"), (String)"0", (String)esQueryString);
                SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.index}).setTypes(new String[]{this.type, "pubsku"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery(queryBuilder).setFrom(from).setSize(size).setQueryCache(Boolean.valueOf(false)).addSort((SortBuilder)SortBuilders.fieldSort((String)"_id").order(SortOrder.ASC)).execute().actionGet();
                SearchHits hits = searchResponse.getHits();
                SearchHit[] searchHists = hits.getHits();
                if (searchHists.length > 0) {
                    SearchHit[] searchHitArray = searchHists;
                    int n = searchHists.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SearchHit hit = searchHitArray[n2];
                        list.add(this.build(hit, chnCode));
                        ++n2;
                    }
                }
                t.setStatus("0");
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                Cat.logError((Throwable)e);
                throw new PublicException("PB0005", "\u67e5\u8be2\u51fa\u9519\uff01[ES\u67e5\u8be2]Query: " + esQueryString + "\n" + e);
            }
        }
        finally {
            t.complete();
        }
        return list;
    }

    public List<T> findByFields(Map<String, Object> params, com.thebeastshop.pegasus.merchandise.constants.SearchType type) {
        StackTraceElement stackTraceElement = this.getStrackElement();
        return this.findByFields(stackTraceElement, params, type);
    }

    private List<T> findByFields(StackTraceElement stackTraceElement, Map<String, Object> params, com.thebeastshop.pegasus.merchandise.constants.SearchType type) {
        String queryString = params.values().toString();
        QueryStringQueryBuilder queryStringQueryBuilder = QueryBuilders.queryStringQuery((String)queryString);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        String chnCode = MapUtils.getString(params, (Object)"chnCode");
        if (chnCode != null) {
            params.remove("chnCode");
        }
        Integer currage = (Integer)params.remove("currpage");
        Integer pagenum = (Integer)params.remove("pagenum");
        Integer start = (Integer)params.remove("from");
        Integer size = (Integer)params.remove("size");
        List sortList = null;
        Map sortMap = null;
        if (params.get("sort") != null) {
            Object sortObj = params.remove("sort");
            if (sortObj instanceof List) {
                sortList = (List)sortObj;
            } else if (sortObj instanceof Map) {
                sortMap = (Map)sortObj;
            }
        }
        this.queryCondPrepare(boolQueryBuilder, params, type);
        for (String key : params.keySet()) {
            Object val = params.get(key);
            if (val instanceof QueryBuilder) {
                if (val instanceof QueryStringQueryBuilder) {
                    ((QueryStringQueryBuilder)val).field(key);
                }
                boolQueryBuilder.must((QueryBuilder)val);
                continue;
            }
            if (key.endsWith("List")) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)val.toString()).field(key));
                continue;
            }
            if (val instanceof List) {
                BoolQueryBuilder orBuilder = QueryBuilders.boolQuery();
                for (Object obj : (List)val) {
                    orBuilder.should((QueryBuilder)QueryBuilders.queryStringQuery((String)obj.toString()).field(key));
                }
                if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                    boolQueryBuilder.should((QueryBuilder)orBuilder);
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)orBuilder);
                continue;
            }
            if (val instanceof Map && "chanelProdTime".equals(key)) {
                BoolQueryBuilder nestedBoolQuery = QueryBuilders.boolQuery();
                nestedBoolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"channelProdInfo.channelCode", ((Map)val).get("channelCode"))).must((QueryBuilder)QueryBuilders.rangeQuery((String)"channelProdInfo.createTime").gt(((Map)val).get("createTimeStart")).lte(((Map)val).get("createTimeEnd")));
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.nestedQuery((String)"channelProdInfo", (QueryBuilder)nestedBoolQuery));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.OR.equals((Object)type)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.AND.equals((Object)type)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.ORLIKE.equals((Object)type)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
                continue;
            }
            if (!com.thebeastshop.pegasus.merchandise.constants.SearchType.ANDLIKE.equals((Object)type)) continue;
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
        }
        if (size == null) {
            size = pagenum != null && pagenum > 0 ? pagenum : 20;
        }
        if (start == null) {
            start = currage != null && currage > 0 ? (currage - 1) * pagenum : 0;
        }
        List<T> result = null;
        result = sortList != null ? this.searchByQryBuilderWithSortList((QueryBuilder)boolQueryBuilder, stackTraceElement, chnCode, start, size, sortList) : this.searchByQryBuilderWithSortMap((QueryBuilder)boolQueryBuilder, stackTraceElement, chnCode, start, size, sortMap);
        return result;
    }

    public boolean create(T vo, StackTraceElement stackTraceElement) {
        String primaryKeyName = this.getPrimaryKeyName();
        String class_method = String.valueOf(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
        Transaction t = Cat.newTransaction((String)"ES", (String)class_method);
        this.updateTime(vo);
        Object primaryKeyValue = McReflectionUtil.getFieldValue(vo, (String)primaryKeyName);
        try {
            XContentBuilder sourceBuilder = this.getXContentBuilder(vo);
            String esQueryString = sourceBuilder.toString();
            esQueryString = esQueryString.replaceAll("\\n", "");
            log.info("GET " + this.index + "/" + this.type + "/_search \n" + esQueryString);
            Cat.logEvent((String)"ES.Query", (String)("POST " + this.index + "/" + this.type), (String)"0", (String)esQueryString);
            IndexResponse response = (IndexResponse)this.client.prepareIndex(this.index, this.type).setRefresh(true).setSource(sourceBuilder).setId(primaryKeyValue.toString()).execute().actionGet();
            t.setStatus("0");
            boolean bl = response.isCreated();
            return bl;
        }
        catch (Exception ex) {
            Cat.logError((Throwable)ex);
            throw new PublicException("PB0002", "\u66f4\u65b0\u51fa\u9519\uff01");
        }
        finally {
            t.complete();
        }
    }

    public boolean create(List<T> vos, StackTraceElement stackTraceElement) {
        if (CollectionUtils.isEmpty(vos)) {
            return false;
        }
        String class_method = String.valueOf(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
        Transaction t = Cat.newTransaction((String)"ES", (String)class_method);
        BulkRequestBuilder bulkBuilder = this.client.prepareBulk().setRefresh(true);
        String primaryKeyName = this.getPrimaryKeyName();
        try {
            for (T vo : vos) {
                this.updateTime(vo);
                Object primaryKeyValue = this.getPrimaryKeyValue(vo);
                bulkBuilder.add(this.client.prepareIndex(this.index, this.type).setRefresh(true).setSource(this.getXContentBuilder(vo)).setId(primaryKeyValue.toString()));
            }
            BulkResponse responses = (BulkResponse)bulkBuilder.execute().actionGet();
            boolean bl = !responses.hasFailures();
            return bl;
        }
        catch (Exception ex) {
            Cat.logError((Throwable)ex);
            throw new PublicException("PB0002", "\u66f4\u65b0\u51fa\u9519\uff01");
        }
        finally {
            t.complete();
        }
    }

    public boolean deleteByPrimaryKey(Object id) {
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk().setRefresh(true);
        bulkRequestBuilder.add(new DeleteRequest(this.index, this.type, id.toString()));
        return !((BulkResponse)bulkRequestBuilder.execute().actionGet()).hasFailures();
    }

    public boolean deleteByPrimaryKey(List<String> ids) {
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk().setRefresh(true);
        for (String id : ids) {
            bulkRequestBuilder.add(new DeleteRequest(this.index, this.type, id.toString()));
        }
        return !((BulkResponse)bulkRequestBuilder.execute().actionGet()).hasFailures();
    }

    public boolean deleteAll() {
        DeleteMappingRequest deleteMappingRequest = new DeleteMappingRequest(new String[]{this.index}).types(new String[]{this.type});
        DeleteMappingResponse deleteMappingResponse = (DeleteMappingResponse)this.client.admin().indices().deleteMapping(deleteMappingRequest).actionGet();
        return deleteMappingResponse.isAcknowledged();
    }

    public boolean createOrUpdate(StackTraceElement stackTraceElement, T vo) {
        Object primaryKeyValue;
        String primaryKeyName = this.getPrimaryKeyName();
        List<T> exists = this.findByField(stackTraceElement, primaryKeyName, primaryKeyValue = McReflectionUtil.getFieldValue(vo, (String)primaryKeyName));
        if (CollectionUtils.isEmpty(exists)) {
            return this.create(vo, stackTraceElement);
        }
        T exist = exists.get(0);
        return this.update(exist);
    }

    public boolean createOrUpdate(StackTraceElement stackTraceElement, List<T> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return Boolean.TRUE;
        }
        for (T vo : vos) {
            this.createOrUpdate(stackTraceElement, vo);
        }
        return Boolean.TRUE;
    }

    public boolean update(List<T> vos) {
        BulkRequestBuilder bulkBuilder = this.client.prepareBulk().setRefresh(true);
        for (T vo : vos) {
            UpdateRequest request = this.buildUpdateRequest(vo);
            bulkBuilder.add(request);
        }
        return !((BulkResponse)bulkBuilder.execute().actionGet()).hasFailures();
    }

    public boolean update(T vo) {
        String primaryKeyName = this.getPrimaryKeyName();
        Object primaryKeyValue = this.getPrimaryKeyValue(vo);
        if (primaryKeyValue == null || StringUtils.isBlank((CharSequence)primaryKeyValue.toString())) {
            throw new PublicException("PB0001", "\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Map params = McReflectionUtil.getFieldNameValue(vo);
        if (MapUtils.isEmpty((Map)params)) {
            return true;
        }
        try {
            UpdateResponse response = (UpdateResponse)this.client.update(this.buildUpdateRequest(vo)).actionGet();
            return response.getVersion() > 0L;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new PublicException("PB0002", "\u66f4\u65b0\u51fa\u9519\uff01");
        }
    }

    private UpdateRequest buildUpdateRequest(T vo) {
        Object primaryKeyValue = this.getPrimaryKeyValue(vo);
        if (primaryKeyValue == null) {
            throw new PublicException("PB0001", "\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.updateTime(vo);
        Map params = McReflectionUtil.getFieldNameValue(vo);
        UpdateRequest updateRequest = new UpdateRequest();
        updateRequest.index(this.index);
        updateRequest.type(this.type);
        updateRequest.id(primaryKeyValue.toString());
        updateRequest.refresh(true);
        UpdateRequestBuilder updateRequestBuilder = this.client.prepareUpdate(this.index, this.type, (String)primaryKeyValue).setRefresh(true);
        params.remove(this.getPrimaryKeyName());
        XContentBuilder builder = null;
        try {
            builder = XContentFactory.jsonBuilder();
            String updateTime = (String)params.get("updateTime");
            if (StringUtils.isNotBlank((CharSequence)updateTime)) {
                params.put("updateLong", DateUtil.parse((String)updateTime, (String)"yyyy-MM-dd HH:mm:ss").getTime());
            }
            this.buildUpdateParams(builder, params);
            updateRequest.doc(builder);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new PublicException("PB0002", "\u6279\u91cf\u66f4\u65b0\u51fa\u9519\uff01");
        }
        return updateRequest;
    }

    private void buildUpdateParams(XContentBuilder builder, Map<String, Object> params) {
        try {
            builder.startObject();
            for (String key : params.keySet()) {
                List vos;
                Object val = params.get(key);
                if (val instanceof List && CollectionUtils.isNotEmpty((Collection)(vos = (List)val)) && vos.get(0) instanceof PsBaseVO) {
                    builder.startArray(key);
                    for (Object obj : vos) {
                        this.updateTime(obj);
                        this.buildUpdateParams(builder, McReflectionUtil.getFieldNameValue(obj));
                    }
                    builder.endArray();
                    continue;
                }
                builder.field(key, val);
            }
            builder.endObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Object getPrimaryKeyValue(T vo) {
        return McReflectionUtil.getFieldValue(vo, (String)this.getPrimaryKeyName());
    }

    private void updateTime(Object obj) {
        if (obj instanceof PsUpdateVO) {
            ((PsUpdateVO)obj).setUpdateTime(this.getNow());
        }
    }

    String getNow() {
        return DateUtil.format((Date)DateUtil.getNow(), (String)"yyyy-MM-dd HH:mm:ss");
    }

    public abstract T build(SearchHit var1, String var2);

    public abstract T build(SearchHit var1, String var2, Long var3);

    public abstract XContentBuilder getXContentBuilder(T var1);

    public abstract String getPrimaryKeyName();

    public void queryCondPrepare(BoolQueryBuilder queryBuilder, Map<String, Object> params, com.thebeastshop.pegasus.merchandise.constants.SearchType type) {
        String updateTime = (String)params.get("updateTime");
        String updateTimeEnd = this.getNow();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{updateTime})) {
            RangeQueryBuilder rangeBuilder = QueryBuilders.rangeQuery((String)"updateLong");
            rangeBuilder.gte(DateUtil.parse((String)updateTime, (String)"yyyy-MM-dd HH:mm:ss").getTime());
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                queryBuilder.should((QueryBuilder)rangeBuilder);
            } else {
                queryBuilder.must((QueryBuilder)rangeBuilder);
            }
        }
        params.remove("updateTime");
        String primaryUpdateTime = (String)params.get("primaryUpdateTime");
        String primaryUpdateTimeEnd = this.getNow();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{primaryUpdateTime})) {
            RangeQueryBuilder rangeBuilder = QueryBuilders.rangeQuery((String)"primaryUpdateLong");
            rangeBuilder.gte(DateUtil.parse((String)primaryUpdateTime, (String)"yyyy-MM-dd HH:mm:ss").getTime());
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                queryBuilder.should((QueryBuilder)rangeBuilder);
            } else {
                queryBuilder.must((QueryBuilder)rangeBuilder);
            }
        }
        params.remove("primaryUpdateTime");
    }

    public void queryCondPrepareFilter(BoolFilterBuilder filterBuilder, Map<String, Object> params, com.thebeastshop.pegasus.merchandise.constants.SearchType type) {
        String updateTime = (String)params.get("updateTime");
        String updateTimeEnd = this.getNow();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{updateTime})) {
            RangeFilterBuilder rangeBuilder = FilterBuilders.rangeFilter((String)"updateLong");
            rangeBuilder.gte(DateUtil.parse((String)updateTime, (String)"yyyy-MM-dd HH:mm:ss").getTime());
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                filterBuilder.should((FilterBuilder)rangeBuilder);
            } else {
                filterBuilder.must((FilterBuilder)rangeBuilder);
            }
        }
        params.remove("updateTime");
        String primaryUpdateTime = (String)params.get("primaryUpdateTime");
        String primaryUpdateTimeEnd = this.getNow();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{primaryUpdateTime})) {
            RangeFilterBuilder rangeBuilder = FilterBuilders.rangeFilter((String)"primaryUpdateLong");
            rangeBuilder.gte(DateUtil.parse((String)primaryUpdateTime, (String)"yyyy-MM-dd HH:mm:ss").getTime());
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                filterBuilder.should((FilterBuilder)rangeBuilder);
            } else {
                filterBuilder.must((FilterBuilder)rangeBuilder);
            }
        }
        params.remove("primaryUpdateTime");
    }

    void addQueryBuilder(BoolQueryBuilder boolQueryBuilder, QueryBuilder queryBuilder, com.thebeastshop.pegasus.merchandise.constants.SearchType type) {
        if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
            boolQueryBuilder.should(queryBuilder);
        } else {
            boolQueryBuilder.must(queryBuilder);
        }
    }

    public void testQuery() {
        this.client.prepareSearch(new String[]{this.index}).setTypes(new String[]{this.type}).setExtraSource("");
    }

    public List<T> findByFieldWithProdSearchCondVO(Map<String, Object> params, com.thebeastshop.pegasus.merchandise.constants.SearchType type, Integer from, Integer size) {
        StackTraceElement stackTraceElement = this.getStrackElement();
        String queryString = params.values().toString();
        QueryStringQueryBuilder queryStringQueryBuilder = QueryBuilders.queryStringQuery((String)queryString);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        String chnCode = MapUtils.getString(params, (Object)"chnCode");
        if (chnCode != null) {
            params.remove("chnCode");
        }
        List sortList = null;
        Map sortMap = null;
        if (params.get("sort") != null) {
            Object sortObj = params.remove("sort");
            if (sortObj instanceof List) {
                sortList = (List)sortObj;
            } else if (sortObj instanceof Map) {
                sortMap = (Map)sortObj;
            }
        }
        this.queryCondPrepare(boolQueryBuilder, params, type);
        for (String key : params.keySet()) {
            Object val = params.get(key);
            if (key.endsWith("List")) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)val.toString()).field(key));
                continue;
            }
            if (val instanceof List) {
                BoolQueryBuilder orBuilder = QueryBuilders.boolQuery();
                for (Object obj : (List)val) {
                    orBuilder.should((QueryBuilder)QueryBuilders.queryStringQuery((String)obj.toString()).field(key));
                }
                if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                    boolQueryBuilder.should((QueryBuilder)orBuilder);
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)orBuilder);
                continue;
            }
            if (val instanceof DateRange) {
                Date start = ((DateRange)val).getStart();
                Date end = ((DateRange)val).getEnd();
                BoolQueryBuilder nestedBoolQuery = QueryBuilders.boolQuery();
                nestedBoolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)key).gt((Object)start).lte((Object)end));
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.nestedQuery((String)"channelProdInfo", (QueryBuilder)nestedBoolQuery));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.OR.equals((Object)type)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.AND.equals((Object)type)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.ORLIKE.equals((Object)type)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
                continue;
            }
            if (!com.thebeastshop.pegasus.merchandise.constants.SearchType.ANDLIKE.equals((Object)type)) continue;
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
        }
        List<T> result = null;
        result = sortList != null ? this.searchByQryBuilderWithSortList((QueryBuilder)boolQueryBuilder, stackTraceElement, chnCode, from, size, sortList) : this.searchByQryBuilderWithSortMap((QueryBuilder)boolQueryBuilder, stackTraceElement, chnCode, from, size, sortMap);
        return result;
    }

    public List<T> findByFieldWithKeyWords(Map<String, Object> params, com.thebeastshop.pegasus.merchandise.constants.SearchType type, String keyWords, Integer from, Integer size) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
        BoolQueryBuilder mustQueryBuilder = QueryBuilders.boolQuery();
        BoolQueryBuilder orQueryBuilder = QueryBuilders.boolQuery();
        BoolFilterBuilder andFilterBuilder = FilterBuilders.boolFilter();
        String chnCode = MapUtils.getString(params, (Object)"chnCode");
        if (chnCode != null) {
            params.remove("chnCode");
        }
        List sortList = null;
        Map sortMap = null;
        if (params.get("sort") != null) {
            Object sortObj = params.remove("sort");
            if (sortObj instanceof List) {
                sortList = (List)sortObj;
            } else if (sortObj instanceof Map) {
                sortMap = (Map)sortObj;
            }
        }
        this.queryCondPrepareFilter(andFilterBuilder, params, type);
        for (String key : params.keySet()) {
            Object val = params.get(key);
            if (key.endsWith("List")) {
                mustQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)val.toString()).field(key));
                continue;
            }
            if (val instanceof List) {
                BoolQueryBuilder orBuilder = QueryBuilders.boolQuery();
                for (Object obj : (List)val) {
                    orBuilder.should((QueryBuilder)QueryBuilders.queryStringQuery((String)obj.toString()).field(key));
                }
                if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                    mustQueryBuilder.should((QueryBuilder)orBuilder);
                    continue;
                }
                mustQueryBuilder.must((QueryBuilder)orBuilder);
                continue;
            }
            if (val instanceof DateRange) {
                Date start = ((DateRange)val).getStart();
                Date end = ((DateRange)val).getEnd();
                RangeQueryBuilder rangeBuilder = QueryBuilders.rangeQuery((String)key);
                rangeBuilder.from((Object)start).to((Object)end).includeLower(true).includeUpper(true);
                if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                    mustQueryBuilder.should((QueryBuilder)rangeBuilder);
                    continue;
                }
                mustQueryBuilder.must((QueryBuilder)rangeBuilder);
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.OR.equals((Object)type)) {
                mustQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.AND.equals((Object)type)) {
                mustQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.ORLIKE.equals((Object)type)) {
                mustQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
                continue;
            }
            if (!com.thebeastshop.pegasus.merchandise.constants.SearchType.ANDLIKE.equals((Object)type)) continue;
            mustQueryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
        }
        if (!Strings.isNullOrEmpty((String)keyWords)) {
            ArrayList<SearchKeyword> searchKeywords = new ArrayList<SearchKeyword>();
            searchKeywords.add(new SearchKeyword(keyWords, 20.0, Character.valueOf('n')));
            for (SearchKeyword searchKeyword : searchKeywords) {
                String word = searchKeyword.getKeyword();
                if (searchKeyword.getFlag() != null && searchKeyword.getFlag().charValue() != 'n' && searchKeyword.getFlag().charValue() != 'v') continue;
                orQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"name", (Object)word).slop(3).boost(4600.0f).minimumShouldMatch("75%")).should((QueryBuilder)QueryBuilders.matchQuery((String)"nameCn", (Object)word).slop(3).boost(4600.0f).minimumShouldMatch("75%")).should((QueryBuilder)QueryBuilders.matchQuery((String)"frontCategories.categoryName", (Object)word).slop(2).boost(1600.0f).minimumShouldMatch("75%")).should((QueryBuilder)QueryBuilders.matchQuery((String)"frontCategories.categoryFullName", (Object)word).slop(3).boost(1600.0f).minimumShouldMatch("75%")).should((QueryBuilder)QueryBuilders.matchQuery((String)"brandList.brandName", (Object)word).slop(2).boost(2200.0f).minimumShouldMatch("75%")).should((QueryBuilder)QueryBuilders.matchQuery((String)"brandList.brandNameCN", (Object)word).slop(3).boost(2200.0f).minimumShouldMatch("75%")).should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"labels.labelName", (Object)word).boost(300.0f)).should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"labels.labelNameCn", (Object)word).boost(300.0f)).should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"campaignList.discountTypeName", (Object)word).boost(100.0f));
            }
            mustQueryBuilder.must((QueryBuilder)orQueryBuilder);
        }
        List<T> result = null;
        result = this.searchByQryBuilderWithKeyWordsSortMap((QueryBuilder)mustQueryBuilder, null, stackTraceElement, chnCode, from, size, sortMap);
        return result;
    }

    public List<T> findSkuByFieldWithKeyWords(String keyWords, Integer from, Integer size) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
        BoolQueryBuilder mustQueryBuilder = QueryBuilders.boolQuery();
        BoolQueryBuilder orQueryBuilder = QueryBuilders.boolQuery();
        if (!Strings.isNullOrEmpty((String)keyWords)) {
            ArrayList<SearchKeyword> searchKeywords = new ArrayList<SearchKeyword>();
            searchKeywords.add(new SearchKeyword(keyWords, 20.0, Character.valueOf('n')));
            for (SearchKeyword searchKeyword : searchKeywords) {
                String word = searchKeyword.getKeyword();
                if (searchKeyword.getFlag() != null && searchKeyword.getFlag().charValue() != 'n' && searchKeyword.getFlag().charValue() != 'v') continue;
                orQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"skuCode", (Object)word).slop(3).boost(4600.0f).minimumShouldMatch("80%")).should((QueryBuilder)QueryBuilders.matchQuery((String)"skuName", (Object)word).slop(3).boost(4600.0f).minimumShouldMatch("80%")).should((QueryBuilder)QueryBuilders.matchQuery((String)"skuNameCN", (Object)word).slop(3).boost(4600.0f).minimumShouldMatch("80%")).should((QueryBuilder)QueryBuilders.matchQuery((String)"prodNameCn", (Object)word).slop(3).boost(4600.0f).minimumShouldMatch("80%"));
            }
            mustQueryBuilder.must((QueryBuilder)orQueryBuilder);
        }
        List<T> result = null;
        result = this.searchByQryBuilderWithKeyWordsSortMap((QueryBuilder)mustQueryBuilder, null, stackTraceElement, "", from, size, null);
        return result;
    }

    public List<T> findByFieldWithSelectMap(Map<String, Object> params, com.thebeastshop.pegasus.merchandise.constants.SearchType type, Map<String, Object> selectMap, Integer from, Integer size) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
        String queryString = params.values().toString();
        QueryStringQueryBuilder queryStringQueryBuilder = QueryBuilders.queryStringQuery((String)queryString);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        String chnCode = MapUtils.getString(params, (Object)"chnCode");
        if (chnCode != null) {
            params.remove("chnCode");
        }
        List sortList = null;
        Map sortMap = null;
        if (params.get("sort") != null) {
            Object sortObj = params.remove("sort");
            if (sortObj instanceof List) {
                sortList = (List)sortObj;
            } else if (sortObj instanceof Map) {
                sortMap = (Map)sortObj;
            }
        }
        this.queryCondPrepare(boolQueryBuilder, params, type);
        for (String key : params.keySet()) {
            Integer discountType;
            Object discountTypeId;
            Object val = params.get(key);
            if (val instanceof QueryBuilder) {
                if (val instanceof QueryStringQueryBuilder) {
                    ((QueryStringQueryBuilder)val).field(key);
                }
                boolQueryBuilder.must((QueryBuilder)val);
                continue;
            }
            if (key.endsWith("List")) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)val.toString()).field(key));
                continue;
            }
            if (val instanceof List) {
                BoolQueryBuilder orBuilder = QueryBuilders.boolQuery();
                for (Object obj : (List)val) {
                    orBuilder.should((QueryBuilder)QueryBuilders.queryStringQuery((String)obj.toString()).field(key));
                }
                if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                    boolQueryBuilder.should((QueryBuilder)orBuilder);
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)orBuilder);
                continue;
            }
            if (val instanceof DateRange) {
                Date start = ((DateRange)val).getStart();
                Date end = ((DateRange)val).getEnd();
                BoolQueryBuilder nestedBoolQuery = QueryBuilders.boolQuery();
                nestedBoolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)key).gt((Object)start).lte((Object)end));
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.nestedQuery((String)"channelProdInfo", (QueryBuilder)nestedBoolQuery));
                continue;
            }
            Boolean isCrossBorder = (Boolean)selectMap.get("isCrossBorder");
            Object labels = selectMap.get("labels");
            Object brandId = selectMap.get("brandId");
            if (isCrossBorder != null && isCrossBorder.booleanValue()) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"crossBorderFlag", (String)"1"));
            }
            if (labels != null) {
                String labelsObj = labels.toString();
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"labels.labelId", (String)labelsObj));
            }
            if ((discountTypeId = selectMap.get("discountTypeId")) != null && (discountType = (Integer)discountTypeId) == 1) {
                BoolQueryBuilder nestedBoolQuery = QueryBuilders.boolQuery();
                nestedBoolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"spvList.campaignList.state", (String)"1"));
                nestedBoolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"spvList.campaignList.discountTypeId", (String)"1"));
                nestedBoolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"spvList.campaignList.active", (String)"1"));
                Date now = new Date();
                nestedBoolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"spvList.campaignList.startTime").lte((Object)now));
                nestedBoolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"spvList.campaignList.expireTime").gt((Object)now));
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.nestedQuery((String)"spvList.campaignList", (QueryBuilder)nestedBoolQuery));
            }
            if (brandId != null) {
                String brandIdObj = brandId.toString();
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brandList.brandId", (String)brandIdObj));
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.OR.equals((Object)type)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.AND.equals((Object)type)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.ORLIKE.equals((Object)type)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
                continue;
            }
            if (!com.thebeastshop.pegasus.merchandise.constants.SearchType.ANDLIKE.equals((Object)type)) continue;
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
        }
        List<T> result = null;
        result = this.searchByQryBuilderWithKeyWordsSortMap((QueryBuilder)boolQueryBuilder, null, stackTraceElement, chnCode, from, size, sortMap);
        return result;
    }

    public List<T> searchByQryBuilderWithKeyWordsSortMap(QueryBuilder queryBuilder, FilterBuilder filterBuilder, StackTraceElement stackTraceElement, String chnCode, int from, int size, Map sort) {
        ArrayList<T> list = new ArrayList<T>();
        String esQueryString = "";
        String class_method = String.valueOf(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
        Transaction t = Cat.newTransaction((String)"ES", (String)class_method);
        try {
            try {
                SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(new String[]{this.index}).setTypes(new String[]{this.type}).setQuery(queryBuilder).setFrom(from).setSize(size).setQueryCache(Boolean.valueOf(false));
                if (filterBuilder != null) {
                    searchRequestBuilder.setPostFilter(filterBuilder);
                }
                if (sort != null && sort.size() > 0) {
                    for (String key : sort.keySet()) {
                        Object value = sort.get(key);
                        if (key.equals("_script") && value instanceof Map) {
                            Map scriptMap = (Map)value;
                            String script = (String)scriptMap.get("script");
                            ScriptSortBuilder scriptSortBuilder = SortBuilders.scriptSort((String)script, (String)"number");
                            if (scriptMap.containsKey("params")) {
                                Map params = (Map)scriptMap.get("params");
                                scriptSortBuilder.setParams(params);
                            }
                            this.setFilterMap((SortBuilder)scriptSortBuilder, (Map)value);
                            searchRequestBuilder.addSort((SortBuilder)scriptSortBuilder);
                            continue;
                        }
                        FieldSortBuilder sortBuilder = SortBuilders.fieldSort((String)key);
                        if (value instanceof String) {
                            this.setOrder((SortBuilder)sortBuilder, (String)value);
                        } else if (value instanceof Map) {
                            this.setFilterMap((SortBuilder)sortBuilder, (Map)value);
                        }
                        searchRequestBuilder.addSort((SortBuilder)sortBuilder);
                    }
                }
                esQueryString = searchRequestBuilder.toString();
                esQueryString = esQueryString.replaceAll("\\n", "");
                log.info("GET " + this.index + "/" + this.type + "/_search \n" + esQueryString);
                Cat.logEvent((String)"ES.Query", (String)("GET " + this.index + "/" + this.type + "/_search"), (String)"0", (String)esQueryString);
                SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
                SearchHits hits = searchResponse.getHits();
                long total = hits.getTotalHits();
                SearchHit[] searchHists = hits.getHits();
                if (searchHists.length > 0) {
                    SearchHit[] searchHitArray = searchHists;
                    int n = searchHists.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SearchHit hit = searchHitArray[n2];
                        list.add(this.build(hit, chnCode, total));
                        ++n2;
                    }
                }
                t.setStatus("0");
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                Cat.logError((Throwable)e);
                throw new PublicException("PB0005", "\u67e5\u8be2\u51fa\u9519\uff01[ES\u67e5\u8be2]Query: " + esQueryString + "\n" + e);
            }
        }
        finally {
            t.complete();
        }
        return list;
    }

    public List<Long> findByFieldWithAggsSortMap(Map<String, Object> params, com.thebeastshop.pegasus.merchandise.constants.SearchType type, Map<String, Object> selectMap) {
        TermsBuilder aggregation;
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
        String queryString = params.values().toString();
        QueryStringQueryBuilder queryStringQueryBuilder = QueryBuilders.queryStringQuery((String)queryString);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        String chnCode = MapUtils.getString(params, (Object)"chnCode");
        if (chnCode != null) {
            params.remove("chnCode");
        }
        List sortList = null;
        Map sortMap = null;
        if (params.get("sort") != null) {
            Object sortObj = params.remove("sort");
            if (sortObj instanceof List) {
                sortList = (List)sortObj;
            } else if (sortObj instanceof Map) {
                sortMap = (Map)sortObj;
            }
        }
        this.queryCondPrepare(boolQueryBuilder, params, type);
        for (String key : params.keySet()) {
            Integer discountType;
            Object discountTypeId;
            Object val = params.get(key);
            if (val instanceof QueryBuilder) {
                if (val instanceof QueryStringQueryBuilder) {
                    ((QueryStringQueryBuilder)val).field(key);
                }
                boolQueryBuilder.must((QueryBuilder)val);
                continue;
            }
            if (key.endsWith("List")) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)val.toString()).field(key));
                continue;
            }
            if (val instanceof List) {
                BoolQueryBuilder orBuilder = QueryBuilders.boolQuery();
                for (Object obj : (List)val) {
                    orBuilder.should((QueryBuilder)QueryBuilders.queryStringQuery((String)obj.toString()).field(key));
                }
                if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                    boolQueryBuilder.should((QueryBuilder)orBuilder);
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)orBuilder);
                continue;
            }
            if (val instanceof DateRange) {
                Date start = ((DateRange)val).getStart();
                Date end = ((DateRange)val).getEnd();
                BoolQueryBuilder nestedBoolQuery = QueryBuilders.boolQuery();
                nestedBoolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)key).gt((Object)start).lte((Object)end));
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.nestedQuery((String)"channelProdInfo", (QueryBuilder)nestedBoolQuery));
                continue;
            }
            Boolean isCrossBorder = (Boolean)selectMap.get("isCrossBorder");
            Object labels = selectMap.get("labels");
            Object brandId = selectMap.get("brandId");
            if (isCrossBorder != null && isCrossBorder.booleanValue()) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"crossBorderFlag", (String)"1"));
            }
            if (labels != null) {
                String labelsObj = labels.toString();
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"labels.labelId", (String)labelsObj));
            }
            if ((discountTypeId = selectMap.get("discountTypeId")) != null && (discountType = (Integer)discountTypeId) == 1) {
                BoolQueryBuilder nestedBoolQuery = QueryBuilders.boolQuery();
                nestedBoolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"spvList.campaignList.state", (String)"1"));
                nestedBoolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"spvList.campaignList.discountTypeId", (String)"1"));
                nestedBoolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"spvList.campaignList.active", (String)"1"));
                Date now = new Date();
                nestedBoolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"spvList.campaignList.startTime").lte((Object)now));
                nestedBoolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"spvList.campaignList.expireTime").gt((Object)now));
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.nestedQuery((String)"spvList.campaignList", (QueryBuilder)nestedBoolQuery));
            }
            if (brandId != null) {
                String brandIdObj = brandId.toString();
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brandList.brandId", (String)brandIdObj));
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.OR.equals((Object)type)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.AND.equals((Object)type)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.ORLIKE.equals((Object)type)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
                continue;
            }
            if (!com.thebeastshop.pegasus.merchandise.constants.SearchType.ANDLIKE.equals((Object)type)) continue;
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
        }
        List<Long> result = null;
        Object aggsObj = selectMap.get("aggs");
        Integer aggs = (Integer)aggsObj;
        if (aggs == 1) {
            aggregation = ((TermsBuilder)AggregationBuilders.terms((String)"agg").field("brandList.brandId")).size(0);
            result = this.searchByQryBuilderWithAggsSortMap((AbstractAggregationBuilder)aggregation, (QueryBuilder)boolQueryBuilder, null, stackTraceElement, chnCode, sortMap);
        } else if (aggs == 2) {
            aggregation = ((TermsBuilder)AggregationBuilders.terms((String)"agg").field("labels.labelId")).size(0);
            result = this.searchByQryBuilderWithAggsSortMap((AbstractAggregationBuilder)aggregation, (QueryBuilder)boolQueryBuilder, null, stackTraceElement, chnCode, sortMap);
        } else if (aggs == 3) {
            aggregation = ((TermsBuilder)AggregationBuilders.terms((String)"agg").field("frontCategories.categoryId")).size(0);
            result = this.searchByQryBuilderWithAggsSortMap((AbstractAggregationBuilder)aggregation, (QueryBuilder)boolQueryBuilder, null, stackTraceElement, chnCode, sortMap);
        }
        return result;
    }

    public List<Long> searchByQryBuilderWithAggsSortMap(AbstractAggregationBuilder aggregations, QueryBuilder queryBuilder, FilterBuilder filterBuilder, StackTraceElement stackTraceElement, String chnCode, Map sort) {
        ArrayList<Long> list = new ArrayList<Long>();
        String esQueryString = "";
        String class_method = String.valueOf(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
        Transaction t = Cat.newTransaction((String)"ES", (String)class_method);
        try {
            try {
                SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(new String[]{this.index}).setTypes(new String[]{this.type}).setQuery(queryBuilder).addAggregation(aggregations).setSize(0).setQueryCache(Boolean.valueOf(false));
                if (filterBuilder != null) {
                    searchRequestBuilder.setPostFilter(filterBuilder);
                }
                if (sort != null && sort.size() > 0) {
                    for (String key : sort.keySet()) {
                        Object value = sort.get(key);
                        if (key.equals("_script") && value instanceof Map) {
                            Map scriptMap = (Map)value;
                            String script = (String)scriptMap.get("script");
                            ScriptSortBuilder scriptSortBuilder = SortBuilders.scriptSort((String)script, (String)"number");
                            if (scriptMap.containsKey("params")) {
                                Map params = (Map)scriptMap.get("params");
                                scriptSortBuilder.setParams(params);
                            }
                            this.setFilterMap((SortBuilder)scriptSortBuilder, (Map)value);
                            searchRequestBuilder.addSort((SortBuilder)scriptSortBuilder);
                            continue;
                        }
                        FieldSortBuilder sortBuilder = SortBuilders.fieldSort((String)key);
                        if (value instanceof String) {
                            this.setOrder((SortBuilder)sortBuilder, (String)value);
                        } else if (value instanceof Map) {
                            this.setFilterMap((SortBuilder)sortBuilder, (Map)value);
                        }
                        searchRequestBuilder.addSort((SortBuilder)sortBuilder);
                    }
                }
                esQueryString = searchRequestBuilder.toString();
                esQueryString = esQueryString.replaceAll("\\n", "");
                log.info("GET " + this.index + "/" + this.type + "/_search \n" + esQueryString);
                Cat.logEvent((String)"ES.Query", (String)("GET " + this.index + "/" + this.type + "/_search"), (String)"0", (String)esQueryString);
                SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
                Terms agg = (Terms)searchResponse.getAggregations().get("agg");
                System.out.println(agg.getBuckets().size());
                for (Terms.Bucket entry : agg.getBuckets()) {
                    String key = entry.getKey();
                    long docCount = entry.getDocCount();
                    list.add(Long.valueOf(key));
                    System.out.println("key " + key + " doc_count " + docCount);
                }
                t.setStatus("0");
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                Cat.logError((Throwable)e);
                throw new PublicException("PB0005", "\u67e5\u8be2\u51fa\u9519\uff01[ES\u67e5\u8be2]Query: " + esQueryString + "\n" + e);
            }
        }
        finally {
            t.complete();
        }
        return list;
    }
}

