/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.google.common.collect.Lists;
import com.thebeastshop.common.redis.RedisClient;
import com.thebeastshop.pegasus.merchandise.client.AbstractESClient;
import com.thebeastshop.pegasus.merchandise.client.ProductClient;
import com.thebeastshop.pegasus.merchandise.cond.*;
import com.thebeastshop.pegasus.merchandise.constants.SearchType;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuCategoryMapper;
import com.thebeastshop.pegasus.merchandise.domain.CampaignDomain;
import com.thebeastshop.pegasus.merchandise.exception.PublicException;
import com.thebeastshop.pegasus.merchandise.price.*;
import com.thebeastshop.pegasus.merchandise.service.*;
import com.thebeastshop.pegasus.merchandise.util.McReflectionUtil;
import com.thebeastshop.pegasus.merchandise.vo.*;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.scm.es.DiscountTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.elasticsearch.common.base.Strings;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.*;
import java.math.BigDecimal;
import java.util.*;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/6 10:06 
 */
@Path("/pub/product")
@Consumes({ContentType.APPLICATION_JSON_UTF_8})
@Produces({ContentType.APPLICATION_JSON_UTF_8})
@Service("mcPsProductService")
public class McPsProductServiceImpl extends BasePsServiceImpl<PsProductVO> implements McPsProductService {
    private static final Logger LOGGER = LoggerFactory.getLogger(McPsProductServiceImpl.class);

    @Autowired
    private CampaignDomain campaignDomain;

    @Autowired
    private ProductClient client;

    @Autowired
    private McPcsSkuCategoryService mcPcsSkuCategoryService;
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    @Autowired
    private McPsSkuService mcPsSkuService;
    @Autowired
    private McPsSpvService mcPsSpvService;
    @Autowired
    private McOpProductService mcOpProductService;

    @Autowired
    private RedisClient redisClient;

    @Autowired
    private PcsSkuCategoryMapper pcsSkuCategoryMapper;

    @Autowired
    private McOpLabelService mcOpLabelService;

    @Autowired
    private McPcsBrandService mcPcsBrandService;

    private static Map<String, Boolean> specialExcludeCampaignMap = new HashMap<>();

    private static List<String> flowerMonthDeliveryProductCodeList = Lists.newArrayList();

    private static String CHN2018 = "CHN2018";
    private static String CHN2049 = "CHN2049";

    /**
     * app首单赠Map,目前用无门槛满赠代替
     */
    private static final String APP_CHANNEL_CODE = "CHN2049";
    private static Map<Integer, PsCampaignVO> appFirstGiftMap = new HashMap<>();
    static {
        PsCampaignVO specialCampaign = new PsCampaignVO();
        specialCampaign.setProductScopeId(3);
        specialCampaign.setDiscountTypeId(4);
        specialExcludeCampaignMap = getSpecialCampaignMap(Lists.newArrayList(specialCampaign));

        //*****************************注册会员APP首单赠活动:居民证************************************
        List<Integer> accessWayIds = new ArrayList<Integer>(){{
            // 只有APP参加
            add(2);
        }};
        List<Integer> memberLevels = new ArrayList<Integer>(){{
            add(-1);
        }};
        PsCampaignVO appFirstGift1 = buildAppFirstGiftCampaign(accessWayIds, memberLevels, 1016938L);
        //*****************************注册会员APP首单赠活动:居民证************************************

        //*****************************松鼠、小猫会员APP首单赠活动:居民证 + 手机壳***********************
        memberLevels = new ArrayList<Integer>(){{
            add(0);
            add(1);
        }};
        PsCampaignVO appFirstGift2 = buildAppFirstGiftCampaign(accessWayIds, memberLevels, 1018581L);
        //*****************************松鼠、小猫会员APP首单赠活动:居民证 + 手机壳***********************

        //*****************************老虎、大象会员APP首单赠活动:居民证 + 帆布袋***********************
        memberLevels = new ArrayList<Integer>(){{
            add(2);
            add(3);
        }};
        PsCampaignVO appFirstGift3 = buildAppFirstGiftCampaign(accessWayIds, memberLevels, 1018580L);
        //*****************************老虎、大象会员APP首单赠活动:居民证 + 帆布袋***********************

        appFirstGiftMap.put(1, appFirstGift1);
        appFirstGiftMap.put(2, appFirstGift2);
        appFirstGiftMap.put(3, appFirstGift3);

        // 添加鲜花月送特殊product code
        flowerMonthDeliveryProductCodeList.add("PROD001018194");
        flowerMonthDeliveryProductCodeList.add("PROD001018196");
        flowerMonthDeliveryProductCodeList.add("PROD001018197");
    }


    @Override
    public AbstractESClient<PsProductVO> getESClient() {
        return client;
    }

    @GET
    @Path("name/{name}")
    @Override
    public List<PsProductVO> findByProdName(@PathParam("name") String name) {
        return client.findByField("name", name);
    }

    @GET
    @Path("code/{code}")
    @Override
    public List<PsProductVO> findByProdCode(@PathParam("code") String code) {
        return client.findByField("code", code);
    }

    @Override
	public PsProductVO findByProdId(Long prodId) {
		PsProductCond cond = new PsProductCond();
		cond.setId(prodId.toString());
		List<PsProductVO> prods = findByCond(cond);
		if (CollectionUtils.isNotEmpty(prods)) {
			return prods.get(0);
		}
		return null;
	}

    @Override
    public List<PsProductVO> findByCond(PsProductCond cond) {
        Map<String, Object> params = McReflectionUtil.getFieldNameValue(cond);
//        if (CollectionUtils.isNotEmpty(cond.getIds())) {
//            params.put("id",cond.getIds());
//        }
//        params.remove("ids");
        params.remove("memberLevel");
        params.remove("accessWay");
        params.remove("discount");
        params.remove("bdDiscount");
        params.remove("memberCode");

        if (CollectionUtils.isNotEmpty(cond.getCodes())) {
            params.put("code", cond.getCodes());
        }
        params.remove("codes");
        params.remove("matchCampaign");
        params.remove("matchGlobalCampaigns");
        params.remove("firstBuy");
        params.remove("channelCodes");
        List<Long> ids = (List<Long>) params.get("ids");
        Long id = MapUtils.getLong(params, "id");
        if (CollectionUtils.isNotEmpty(ids)) {
            params.put("ids", QueryBuilders.termsQuery("id", ids.toArray()));
        }
        else if (id != null) {
            params.put("id", QueryBuilders.termQuery("id", id));
        }

        if (CollectionUtils.isNotEmpty(cond.getChannelCodes())) {
            params.put("chnCode",cond.getChannelCodes());
        }

        String primaryUpdateTime = MapUtils.getString(params, "primaryUpdateTime");
        if (primaryUpdateTime != null) {
            params.remove("primaryUpdateTime");

        }

        if (cond.getMatchCampaign()
                && CollectionUtils.isEmpty(cond.getCodes())
                && StringUtils.isBlank(cond.getCode())
                && CollectionUtils.isEmpty(cond.getIds())
                && cond.getId() == null) {
            return new ArrayList<>();
        }

        List<PsProductVO> productVOList = client.findByFields(params, SearchType.ANDLIKE);
        if (cond.getMatchCampaign()) {
            campaignDomain.matchListPageCampaigns(productVOList, cond);
        }

        return productVOList;
    }

    @Override
    public List<PsProductVO> findByCond(PsProductCond cond, boolean matchGlobalCampaigns) {
        Map<String, Object> params = McReflectionUtil.getFieldNameValue(cond);
//        if (CollectionUtils.isNotEmpty(cond.getIds())) {
//            params.put("id",cond.getIds());
//        }
//        params.remove("ids");
        params.remove("memberLevel");
        params.remove("accessWay");
        params.remove("discount");
        params.remove("bdDiscount");

        if (CollectionUtils.isNotEmpty(cond.getCodes())) {
            params.put("code", cond.getCodes());
        }
        params.remove("codes");
        params.remove("matchCampaign");
        params.remove("matchGlobalCampaigns");
        params.remove("firstBuy");
        params.remove("channelCodes");

        List<Long> ids = (List<Long>) params.get("ids");
        Long id = MapUtils.getLong(params, "id");
        if (CollectionUtils.isNotEmpty(ids)) {
            params.put("ids", QueryBuilders.termsQuery("id", ids.toArray()));
        }
        else if (id != null) {
            params.put("id", QueryBuilders.termQuery("id", id));
        }

        List<String> channelCodes = cond.getChannelCodes();
        if (CollectionUtils.isNotEmpty(channelCodes)) {
            params.put("chnCode",channelCodes);
        }

        if (cond.getMatchCampaign()
                && CollectionUtils.isEmpty(cond.getCodes())
                && StringUtils.isBlank(cond.getCode())
                && CollectionUtils.isEmpty(cond.getIds())
                && cond.getId() == null) {
            return new ArrayList<>();
        }

        List<PsProductVO> productVOList = client.findByFields(params, SearchType.ANDLIKE);
        if (cond.getMatchCampaign()) {
            campaignDomain.matchListPageCampaigns(productVOList, cond);
        }
        Boolean isFirstBuy = cond.getFirstBuy();
        Boolean isApp = false;
        Integer accessWay = cond.getAccessWay();
        if(accessWay != null && accessWay.equals(2)) {
            isApp = true;
        }
        if (CollectionUtils.isNotEmpty(productVOList) && isFirstBuy && isApp) {
            // 暂时在此处默认添加上APP首单赠活动(以满赠活动代替)
            Integer memberLevel = cond.getMemberLevel();
            if (memberLevel != null && memberLevel >= -1 && memberLevel <= 3) {
                Integer key = getAppFirstGiftKey(memberLevel);
                PsCampaignVO appFirstGiftCampaign = appFirstGiftMap.get(key);
                if(appFirstGiftCampaign != null) {
                    PsProductVO psProductVO = productVOList.get(0);
                    List<PsCampaignVO> campaignList = psProductVO.getCampaignList();
                    if(campaignList == null) {
                        campaignList = Lists.newArrayList();
                    }
                    campaignList.add(appFirstGiftCampaign);
                }
            } else {
                LOGGER.info("会员等级{}不合法,不添加APP首单赠活动", memberLevel);
            }
        }
        return productVOList;
    }



    private static Map<String, Boolean> getSpecialCampaignMap(List<PsCampaignVO> specialCampaigns) {
        Map<String, Boolean> map = new HashMap<>();
        for (PsCampaignVO specialCampaign : specialCampaigns) {
            String key = getSpecialCampaignKey(specialCampaign);
            map.put(key, true);
        }
        return map;
    }

    private static String getSpecialCampaignKey(PsCampaignVO specialCampaign) {
        String key = "sid=" + specialCampaign.getProductScopeId();
        key = key + ",tid=" + specialCampaign.getDiscountTypeId();
        return key;
    }


    /**
     * 排除特殊活动
     * @param psProductVO
     */
    private void excludeSpecialCampaigns(PsProductVO psProductVO) {
        List<PsCampaignVO> newCampaignList = new ArrayList<>();
        List<PsCampaignVO> campaigns = psProductVO.getCampaignList();
        if (CollectionUtils.isNotEmpty(campaigns)) {
            for (PsCampaignVO campaignVO : campaigns) {
                String key = getSpecialCampaignKey(campaignVO);
                if (!specialExcludeCampaignMap.containsKey(key)) {
                    newCampaignList.add(campaignVO);
                }
            }
        }
        psProductVO.setCampaignList(newCampaignList);
    }

    @Override
    public Map<String, List<PsCampaignVO>> findCampaignByCond(PsProductCond cond) {
        List<PsProductVO> productList = findByCond(cond);
        if (EmptyUtil.isEmpty(productList)) {
            return new HashMap<>();
        }
        Map<String, List<PsCampaignVO>> map = new HashMap<>();
        for (PsProductVO productVO : productList) {
            List<PsCampaignVO> prodList = productVO.getCampaignList();
            map.put(productVO.getCode(), prodList);
        }
        return map;
    }

    @Override
    public List<PsCampaignVO> getGlobalCampaignList(PsMatchCampaignCond cond) {
        return campaignDomain.getGlobalCampaignList(cond);
    }

    @Override
    public List<PsProductVO> findByFields(Map<String, Object> params) {
        return client.findByFields(params, SearchType.ANDLIKE);
    }

    @Override
    public List<PsProductVO> findByNameOrNameCN(Map<String, Object> params) {
        return client.findByFields(params, SearchType.ORLIKE);
    }

    @Override
    public List<PsProductVO> calculateDiscountPrice(List<PsProductVO> productList, BigDecimal discountAmount, PsMatchCampaignCond cond) {
        if(CollectionUtils.isNotEmpty(productList)) {
            for (PsProductVO productVO : productList) {
                calculateDiscountPrice(productVO, discountAmount, cond);
            }
        }
        return productList;
    }

    @Override
    public PsProductVO calculateDiscountPrice(PsProductVO psProductVO, BigDecimal discountAmount, PsMatchCampaignCond cond) {
        if(psProductVO == null) {
            return psProductVO;
        }
        List<PsCampaignVO> allCampaignList = Lists.newArrayList();
        List<PsCampaignVO> productAdvanceCampaignList = Lists.newArrayList();
        List<PsCampaignVO> allAdvanceCampaignList = Lists.newArrayList();
        BigDecimal originalPrice = psProductVO.getListPrice();
        Boolean allowVipDiscount = (psProductVO.getAllowVipDiscount() != null && psProductVO.getAllowVipDiscount() == 1);
        Boolean allowBdDiscount = (psProductVO.getAllowBdDiscount() == null || psProductVO.getAllowBdDiscount() == 1);
        Boolean matchCampaign = cond.getMatchCampaign();
        if(matchCampaign != null && matchCampaign) {
            List<PsCampaignVO> campaignList = psProductVO.getCampaignList();
            if(CollectionUtils.isNotEmpty(campaignList)) {
                allCampaignList.addAll(campaignList);
            }
            PsAdvanceCampaignVO psAdvanceCampaignVO = psProductVO.getPsAdvanceCampaignVO();
            if(psAdvanceCampaignVO != null && CollectionUtils.isNotEmpty(psAdvanceCampaignVO.getAdvanceCampaignList())) {
                List<PsCampaignVO> advanceCampaignList = psAdvanceCampaignVO.getAdvanceCampaignList();
                allAdvanceCampaignList.addAll(advanceCampaignList);
                productAdvanceCampaignList.addAll(advanceCampaignList);
            } else {
                psAdvanceCampaignVO = new PsAdvanceCampaignVO();
            }
            /**
             * 获取列表页spvId所关联的活动列表并添加到商品的活动列表里
             */
            Long listPriceSpvId = psProductVO.getListPriceSpvId();
            List<PsSpvVO> spvList = psProductVO.getSpvList();
            if(CollectionUtils.isNotEmpty(spvList)) {
                List<PsCampaignVO> spvCampaignList;
                List<PsCampaignVO> spvAdvanceCampaignList;
                for (PsSpvVO spvVO : spvList) {
                    if(listPriceSpvId != null && listPriceSpvId.equals(spvVO.getSpvId())) {
                        spvCampaignList = spvVO.getCampaignList();
                        if(CollectionUtils.isNotEmpty(spvCampaignList)) {
                            for (PsCampaignVO psCampaignVO : spvCampaignList) {
                                if(!allCampaignList.contains(psCampaignVO)) {
                                    allCampaignList.add(psCampaignVO);
                                }
                            }
                        }
                    }
                    spvAdvanceCampaignList = spvVO.getAdvanceCampaignList();
                    if(CollectionUtils.isNotEmpty(spvAdvanceCampaignList)) {
                        allAdvanceCampaignList.addAll(spvAdvanceCampaignList);
                    }
                }
            }
            // 开始计算商品预告活动的最高和最低价格
            List<PsSpvVO> spvs = psProductVO.getSpvList();
            BigDecimal advancePrice;
            List<BigDecimal> advancePriceList = Lists.newArrayList();
            if(CollectionUtils.isNotEmpty(spvs)) {
                List<PsCampaignVO> spvAdvanceCampaignList;
                List<PsCampaignVO> resultSpvCampaignList;
                BigDecimal spvOriginalPrice;
                Boolean combined;
                for (PsSpvVO spv : spvs) {
                    resultSpvCampaignList = Lists.newArrayList();
                    combined = spv.getCombined();
                    // 非组合商品才参加折扣活动
                    if(combined != null && !combined) {
                        // spv的预告活动有两类：1.所属商品的预告活动 2.自身预告活动
                        spvAdvanceCampaignList = spv.getAdvanceCampaignList();
                        if(CollectionUtils.isNotEmpty(productAdvanceCampaignList)) {
                            resultSpvCampaignList.addAll(productAdvanceCampaignList);
                        }
                        if(CollectionUtils.isNotEmpty(spvAdvanceCampaignList)) {
                            resultSpvCampaignList.addAll(spvAdvanceCampaignList);
                        }
                    }
                    // 初始价格变为该spv的售价
                    spvOriginalPrice = spv.getSalesPrice();
                    advancePrice
                            = PriceCalculators.calculateProductDiscountPrice(null, allowVipDiscount,
                            spvOriginalPrice, resultSpvCampaignList, discountAmount);
                    advancePriceList.add(advancePrice);
                    spv.setAdvancePrice(advancePrice);
                }
            }
            if(CollectionUtils.isNotEmpty(allAdvanceCampaignList) && CollectionUtils.isNotEmpty(advancePriceList)) {
                Collections.sort(advancePriceList);
                psAdvanceCampaignVO.setMinPrice(advancePriceList.get(0));
                psAdvanceCampaignVO.setMaxPrice(advancePriceList.get(advancePriceList.size() - 1));
            } else if(CollectionUtils.isNotEmpty(productAdvanceCampaignList)){
                advancePrice
                        = PriceCalculators.calculateProductDiscountPrice(null, allowVipDiscount,
                        originalPrice, productAdvanceCampaignList, discountAmount);
                psAdvanceCampaignVO.setMinPrice(advancePrice);
                psAdvanceCampaignVO.setMaxPrice(advancePrice);
            }
            if(CollectionUtils.isNotEmpty(allAdvanceCampaignList)) {
                // 对预告活动集合进行按照预告开始时间升序排列
                Collections.sort(allAdvanceCampaignList, new Comparator<PsCampaignVO>() {
                    @Override
                    public int compare(PsCampaignVO campaign1, PsCampaignVO campaign2) {
                        if(campaign1.getAdvanceStartTime().getTime() < campaign2.getAdvanceStartTime().getTime()) {
                            return -1;
                        }
                        return 1;
                    }
                });
                psAdvanceCampaignVO.setAdvanceCampaignList(allAdvanceCampaignList);
                psProductVO.setPsAdvanceCampaignVO(psAdvanceCampaignVO);
            }
        }
        BigDecimal discountPrice
                = PriceCalculators.calculateProductDiscountPrice(psProductVO.getCode(), allowVipDiscount,
                originalPrice, allCampaignList, discountAmount);
        psProductVO.setDiscountPrice(discountPrice);
        if(cond.getBdDiscount() != null) {
            BigDecimal bdDiscountPrice
                    = PriceCalculators.calculateProductDiscountPrice(psProductVO.getCode(), allowBdDiscount,
                    originalPrice, allCampaignList, cond.getBdDiscount());
            psProductVO.setBdDiscountPrice(bdDiscountPrice);
        }

        return psProductVO;
    }

    @Override
    public PsSpvVO calculateDiscountPrice(PsProductVO productVO, PsSpvVO spvVO, PsMatchCampaignCond cond) {
		return calculateDiscountPrice(productVO, spvVO, cond, null);
    }

    @Override
	public PsSpvVO calculateDiscountPrice(PsProductVO productVO, PsSpvVO spvVO, PsMatchCampaignCond cond,
			List<PriceCalResultVO> results) {
        if (productVO == null){
            return spvVO;
        }
        BigDecimal originalPrice = new BigDecimal(String.valueOf(spvVO.getSalesPrice()));
        Boolean allowVipDiscount = (productVO.getAllowVipDiscount() != null && productVO.getAllowVipDiscount() == 1);
        Boolean allowBdDiscount = (productVO.getAllowBdDiscount() == null || productVO.getAllowBdDiscount() == 1);
        List<PsCampaignVO> resultCampaignList = Lists.newArrayList();
        Boolean combined = spvVO.getCombined();
        Boolean matchCampaign = cond.getMatchCampaign();
        if(matchCampaign != null && matchCampaign) {
            // 非组合商品才参加价格折扣
            if(combined != null && !combined) {
                List<PsCampaignVO> campaignList = productVO.getCampaignList();
                if(CollectionUtils.isNotEmpty(campaignList)) {
                    resultCampaignList.addAll(campaignList);
                }
                List<PsCampaignVO> skuCampaignList = spvVO.getCampaignList();
                // 计算SPV折扣价需要把商品维度的活动也加进来，以此兼容原来product维度的折扣活动
                if(CollectionUtils.isNotEmpty(skuCampaignList)) {
                    for (PsCampaignVO campaignVO : skuCampaignList) {
                        // 商品活动里会包含列表页SPV的活动，所以此处判断如果商品活动里不存在当前spv的活动才添加
                        if(!resultCampaignList.contains(campaignVO)) {
                            resultCampaignList.add(campaignVO);
                        }
                    }
                }
            }
            //vip折扣计算
            BigDecimal targetPrice
                    = PriceCalculators.calculateSpvDiscountPrice(spvVO, allowVipDiscount, originalPrice, resultCampaignList, cond.getDiscount(), results);
            spvVO.setDiscountPrice(targetPrice);
            spvVO.setPriceCalResults(results);
            //生日折扣计算
            if(cond.getBdDiscount() != null) {
                List<PriceCalResultVO> bdResults = org.elasticsearch.common.collect.Lists.newArrayList();
                BigDecimal targetBdPrice
                        = PriceCalculators.calculateSpvBdDiscountPrice(spvVO, allowBdDiscount, originalPrice, resultCampaignList, cond.getBdDiscount(), bdResults);
                spvVO.setBdDiscountPrice(targetBdPrice);
                spvVO.setBdPriceCalResults(bdResults);
            }


            List<PsCampaignVO> advanceCampaignList = spvVO.getAdvanceCampaignList();
            if(CollectionUtils.isNotEmpty(advanceCampaignList)) {
                BigDecimal advancePrice
                        = PriceCalculators.calculateSpvDiscountPrice(spvVO, allowVipDiscount, originalPrice, advanceCampaignList, cond.getDiscount());
                spvVO.setAdvancePrice(advancePrice);
            }
        }
        return spvVO;
    }

    @Override
    @Deprecated
    public PsSkuVO calculateDiscountPrice(PsProductVO productVO, PsSkuVO skuVO, PsMatchCampaignCond cond) {
        if(skuVO != null && productVO != null) {
            PsSpvVO spvVO = mcPsSpvService.findSpvBySkuCode(productVO.getCode(), skuVO.getSkuCode());
            if (spvVO == null) {
                return skuVO;
            }
            calculateDiscountPrice(productVO, spvVO, cond);
            skuVO.setDiscountPrice(spvVO.getDiscountPrice());
        }
        return skuVO;
    }

    @Override
    public PsSkuVO calculateDiscountPrice(PsSkuVO skuVO, PsMatchCampaignCond cond) {
        if(skuVO != null) {
            PsProductVO productVO = findProdBySkuCode(skuVO.getSkuCode());
            if(productVO != null) {
                PsSpvVO spvVO = mcPsSpvService.findSpvBySkuCode(productVO.getCode(), skuVO.getSkuCode());
                if (spvVO == null) {
                    return skuVO;
                }
                if (cond.getMatchCampaign() != null && cond.getMatchCampaign()) {
                    campaignDomain.matchCampaigns(productVO, cond);
                    campaignDomain.matchCampaigns(spvVO, cond, productVO.getCrossBorderFlag());
                }
                calculateDiscountPrice(productVO, spvVO, cond);
                skuVO.setDiscountPrice(spvVO.getDiscountPrice());
                if(CollectionUtils.isNotEmpty(productVO.getSpvList())){
                    skuVO.setCampaignList(productVO.getSpvList().get(0).getCampaignList());
                }
            }
        }
        return skuVO;
    }

    @Override
    public boolean updateBySkuCodes(List<String> skuCodes) {
        if (CollectionUtils.isEmpty(skuCodes)) {
            return true;
        }

        if (skuCodes.size() > 100) {
            int all = skuCodes.size() / 100;
            for (int i = 0; i < all; i++) {
                List<String> subSkuCodes = skuCodes.subList(i * 100, (i + 1) * 100);
                if (!updateBySkuCodes100(subSkuCodes)) {
                    throw new PublicException("更新prod updateTime 出错");
                }
            }
            if (skuCodes.size() > all * 100) {
                List<String> subSkuCodes = skuCodes.subList(all * 100, skuCodes.size());
                updateBySkuCodes100(subSkuCodes);
            }
            return true;
        } else {
            return updateBySkuCodes100(skuCodes);
        }
    }

    private boolean updateBySkuCodes100(List<String> skuCodes) {
        Map<String, Object> params = new HashMap<>();
        params.put("skuCodes", skuCodes);
        params.put("pagenum", Integer.MAX_VALUE);

        List<PsProductVO> updateProds = client.findByFields(params, SearchType.OR);

        for (PsProductVO updateProd : updateProds) {
            if (CollectionUtils.isEmpty(updateProd.getSkuCodes())) {
                continue;
            }
            List<PsSkuVO> prodSkus = mcPsSkuService.findBySkuCodes(updateProd.getSkuCodes());
            if(CollectionUtils.isEmpty(prodSkus)){
                continue;
            }
            PsSkuVO psSkuVO = prodSkus.get(0);
            //ROYS 更新列表价
            if (updateProd.getSkuCodes().size() == 1) {
                updateProd.setListPrice(new BigDecimal(psSkuVO.getSalesPrice()));
            }else{
                for (PsSkuVO prodSku : prodSkus) {
                    if (updateProd.getListPrice().doubleValue() > prodSku.getSalesPrice()) {
                        updateProd.setListPrice(new BigDecimal(prodSku.getSalesPrice()).setScale(2,BigDecimal.ROUND_HALF_DOWN));
                    }
                }
            }

            updateProd.setCategoryId(psSkuVO.getCategoryId());
            //ROYS 暂不写code
            updateProd.setCategoryCode(mcPcsSkuCategoryService.findById(psSkuVO.getCategoryId()).getCode());
        }
        if (CollectionUtils.isEmpty(updateProds)) return true;
        return update(updateProds);
    }

    public PsProductVO updateCategory(PsProductVO updateProd) {
        PsSkuVO psSkuVO = mcPsSkuService.findBySkuCode(updateProd.getSkuCodes().get(0));
        if(NumberUtil.isNullOrZero(psSkuVO.getCategoryId())){
            return updateProd;
        }
        updateProd.setCategoryId(psSkuVO.getCategoryId());

        return updateProd;
    }

    @Override
    public PsProductVO findProdByChnCodeSkuCode(String chnCode, String skuCode) {
        Map<String, Object> params = new HashMap<>();
        params.put("chnCanSaleSKu.canSkus", skuCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("skuCodes", skuCode);
        params.put("onShelfChnCodes", chnCode);
        List<PsProductVO> fs =client.findByFields(params, SearchType.ANDLIKE) ;
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }else{
            for(PsProductVO vo:fs){
                if(vo.getCombined() != null && vo.getCombined()){
                }else{
                    return vo;
                }
            }
        }
        return fs.get(0);
    }

    @Override
    public PsProductVO findProdBySkuCode(String skuCode) {
        return findProdBySkuCode(skuCode, false);
    }

    @Override
    public List<PsProductVO> findProdBySkuCodes(List<String> skuCodes) {
        return findProdBySkuCodes(skuCodes, false);
    }

    @Override
    public PsProductVO findProdBySkuCode(String skuCode, PsMatchCampaignCond matchCampaignCond) {
        PsProductVO productVO = findProdBySkuCode(skuCode);
        if (productVO == null) {
            return null;
        }
        if (matchCampaignCond != null) {
            campaignDomain.matchListPageCampaigns(Lists.newArrayList(productVO), matchCampaignCond);
        }
        return productVO;
    }

    @Override
    public List<PsProductVO> findProdBySkuCodes(List<String> skuCodes, PsMatchCampaignCond matchCampaignCond) {
        List<PsProductVO> productVOList = findProdBySkuCodes(skuCodes);
        if (CollectionUtils.isEmpty(productVOList)) {
            return productVOList;
        }
        if (matchCampaignCond != null) {
            campaignDomain.matchListPageCampaigns(productVOList, matchCampaignCond);
        }
        return productVOList;
    }

    @Override
    public PsProductVO findProdBySkuCode(String skuCode, Boolean combined) {
        Map<String, Object> params = new HashMap<>();
        params.put("skuCodes", skuCode);
        if (combined != null) {
            params.put("combined", combined ? 1 : 0);
        }
        List<PsProductVO> fs =client.findByFields(params, SearchType.ANDLIKE) ;
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        return fs.get(0);
    }

    @Override
    public List<PsProductVO> findProdBySkuCodes(List<String> skuCodes, Boolean combined) {
        Map<String, Object> params = new HashMap<>();
        params.put("pagenum", skuCodes.size());
        params.put("skuCodes", skuCodes);
        if (combined != null) {
            params.put("combined", combined ? 1 : 0);
        }
        List<PsProductVO> fs =client.findByFields(params, SearchType.ANDLIKE) ;
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        return fs;
    }

    @Override
	public PsProductVO findProdBySpvId(Long spvId) {
    	Map<String, Object> params = new HashMap<>();
        params.put("spvList.spvId", spvId);
        List<PsProductVO> fs =client.findByFields(params, SearchType.ANDLIKE) ;
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        return fs.get(0);
	}

    @Override
    public List<PsProductVO> findByChnCodeCateCode(String chnCode, String cateCode) {
        List<PcsSkuCategoryVO> categories = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
        List<Long> cateIds = new ArrayList<>(categories.size());
        for (PcsSkuCategoryVO category : categories) {
            cateIds.add(category.getId());
        }
        if (CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }
        Map<String, Object> params = new HashMap<>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("categoryId", cateIds);

        int currpage = 1;
        params.put("pagenum", 20);
        params.put("currpage", currpage);
        List<List<String>> seqList = new ArrayList<List<String>>();
        List<String> seq1 = new ArrayList<String>();
        seq1.add("categoryId");
        seq1.add("asc");
        seqList.add(seq1);
        List<String> seq = new ArrayList<String>();
        seq.add("seq");
        seq.add("asc");
        seqList.add(seq);
        params.put("sort",seqList);
        List<PsProductVO> productVOs = new ArrayList<>(100);
        List<PsProductVO> prodVos = client.findByFields(params,SearchType.ANDLIKE);
        productVOs.addAll(prodVos);
        while(prodVos.size() == 20){
            currpage++;
            params.put("currpage", currpage);
            params.put("pagenum", 20);
            params.put("sort",seqList);
            prodVos = client.findByFields(params,SearchType.ANDLIKE);
            productVOs.addAll(prodVos);
        }

        return productVOs;
    }

    @Override
    public List<PsProductVO> findRecommondProdByCodes(String chnCode, List<String> codes, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("stocks.soldOut", QueryBuilders.termQuery("stocks.soldOut", 0));
        params.put("code", codes);

        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        Map seqMap = new LinkedHashMap();


        List<String> sortUpdateTime = new ArrayList<>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");

        List<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");

        Map sNestedMap = new HashMap();
        sNestedMap.put("stocks.chnCode", chnCode);
        seqMap.put("listPrice", "asc");
        seqMap.put("saleStartDate", "desc");
        params.put("sort", seqMap);
        List<PsProductVO> productVOList = client.findByFields(params,SearchType.ANDLIKE);
        handleProductList(productVOList, matchCampaignCond);
        return productVOList;

    }

    @Override
    public List<PsProductVO> findListPageByCodes(String chnCode, List<String> codes, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
//        params.put("chnCanSaleSKu.chnCode", chnCode);
//        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("code", codes);

        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        Map seqMap = new LinkedHashMap();


        List<String> sortUpdateTime = new ArrayList<>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");

        List<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");

        Map sMap = new HashMap();
        Map sNestedMap = new HashMap();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);

        seqMap.put("listPrice", "asc");

        seqMap.put("saleStartDate", "desc");
        params.put("sort", seqMap);
        List<PsProductVO> productVOList = client.findByFields(params,SearchType.ANDLIKE);
        handleProductList(productVOList, matchCampaignCond);
        return productVOList;


    }

    @Override
    public List<PsProductVO> findTopicByCodes(String chnCode, List<String> codes, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
        params.put("code", codes);

        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        Map seqMap = new LinkedHashMap();


        List<String> sortUpdateTime = new ArrayList<>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");

        List<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");

        Map sMap = new HashMap();
        Map sNestedMap = new HashMap();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);

        seqMap.put("listPrice", "asc");

        seqMap.put("saleStartDate", "desc");
        params.put("sort", seqMap);
        List<PsProductVO> productVOList = client.findByFields(params,SearchType.ANDLIKE);
        handleProductList(productVOList, matchCampaignCond);
        return productVOList;
    }

    @Override
    public List<PsProductVO> findDiscountListByProdSearchCondVO(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====查询es 参数为 chnCode= {},findDiscountListByProdSearchCondVO={}", chnCode, prodSearchCondVO);
        Map<String,Object> selectMap = new HashMap<String,Object>();
        List<Long> cateIds = new ArrayList<>();
        Integer from = prodSearchCondVO.getFrom() != null && prodSearchCondVO.getFrom() > 0 ? (Integer) prodSearchCondVO.getFrom() : 0;
        Integer size = prodSearchCondVO.getSize() != null && prodSearchCondVO.getSize() > 0 ? (Integer) prodSearchCondVO.getSize() : 20;
        List<String> labelIds = prodSearchCondVO.getLabelIds();
        List<String> brandIds = prodSearchCondVO.getBrandIds();
        List<String> cateCodes = prodSearchCondVO.getCategoryCodes();

        List<PcsSkuCategoryVO> categoriesList = new ArrayList<PcsSkuCategoryVO>();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                List<PcsSkuCategoryVO> category = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }
        if(CollectionUtils.isNotEmpty(categoriesList)){
            cateIds = new ArrayList<>(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
        }

        Map sortMap = new LinkedHashMap();
        Map sMap = new HashMap();
        Map sMap2 = new HashMap();
        Map sNestedMap = new HashMap();
        Map map = new HashMap();
        Map paramsMap = new HashMap();
        Map slMap = new HashMap();

        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        if(CollectionUtils.isNotEmpty(cateIds)){
            params.put("frontCategories.categoryId", cateIds);
        }

        String sortField = prodSearchCondVO.getSortField();
        String sortOrder = prodSearchCondVO.getSortOrder();

        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        map.put("order", "asc");
        map.put("mode", "min");

        if (Strings.isNullOrEmpty(sortField) || Strings.isNullOrEmpty(sortOrder)) {
            sortMap.put("campaignList.expireTime", "desc");
        } else {
            if ("create_time".equals(sortField)) {
                sortMap.put("channelProdInfo.createTime", slMap);
                slMap.put("order", sortOrder);
                slMap.put("mode", "min");
            } else if ("price".equals(sortField)) {
                sortMap.put("listPrice", sortOrder);
            }
        }

//        if(CollectionUtils.isNotEmpty(categoriesList)) {
//            String fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
//            sortMap.put("_script", map);
//            map.put("script", "frontCategorySort");
//            map.put("params", paramsMap);
//            paramsMap.put("fieldName", fieldName);
//        }

        params.put("sort", sortMap);
//        params.put("spvList.campaignList.state","1");
//        params.put("spvList.campaignList.discountTypeId","1");
//        params.put("spvList.campaignList.active","1");
        selectMap.put("discountTypeId",1);
//        Date now = new Date();
//        params.put("spvList.campaignList.startTime", QueryBuilders.rangeQuery("spvList.campaignList.startTime").lte(now));
//        params.put("spvList.campaignList.expireTime", QueryBuilders.rangeQuery("spvList.campaignList.expireTime").gt(now));

//        BoolQueryBuilder orQuery = QueryBuilders.boolQuery();
//        orQuery.should(QueryBuilders.termsQuery("campaignList.discountTypeId", "1"));
//        orQuery.should(QueryBuilders.termsQuery("spvList.campaignList.discountTypeId", "1"));
//        params.put("or", orQuery);

        if(CollectionUtils.isNotEmpty(brandIds)){
            params.put("brandList.brandId",brandIds);
        }
        if(CollectionUtils.isNotEmpty(labelIds)){
            params.put("labels.labelId",labelIds);
        }

        List<PsProductVO> productVOList = client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap, from, size);
//        List<PsProductVO> newProdList = new ArrayList<>();
        LOGGER.info("返回的结果数量为={}", productVOList.size());
        handleProductList(productVOList, matchCampaignCond);
//        for(PsProductVO vo:productVOList){
//            List<PsCampaignVO> campList = vo.getCampaignList();
//            List<PsSpvVO> spvList = vo.getSpvList();
//            Boolean flag = true;
//            if(CollectionUtils.isNotEmpty(campList)){
//                Date date = new Date();
//                for(PsCampaignVO cam :campList){
//                    if(cam.getDiscountTypeId().intValue() == 1 && cam.getStartTime().before(date) && cam.getExpireTime().after(date) && cam.getCrossBorderFlag() == vo.getCrossBorderFlag()){
//                        newProdList.add(vo);
//                        flag = false;
//                        break;
//                    }
//                }
//            }
//            if(flag && CollectionUtils.isNotEmpty(spvList)){
//                Date date = new Date();
//                for(PsSpvVO spv :spvList){
//                    if(!flag){break;}
//                    List<PsCampaignVO> campList2 = spv.getCampaignList();
//                    for(PsCampaignVO cam :campList2){
//                        if(cam.getDiscountTypeId().intValue() == 1 && cam.getStartTime().before(date) && cam.getExpireTime().after(date) && cam.getCrossBorderFlag() == vo.getCrossBorderFlag()){
//                            newProdList.add(vo);
//                            flag = false;
//                            break;
//                        }
//                    }
//
//                }
//            }
//        }
        sw.stop();
        LOGGER.info("【折扣商品接口耗时】折扣商品查询列表 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
        return productVOList;
    }

    @Override
    public List<PsProductVO> findRecommondByCodesForApplet(String chnCode, List<String> codes, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
        params.put("code", codes);

        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        Map seqMap = new LinkedHashMap();

        Map sMap = new HashMap();
        Map sNestedMap = new HashMap();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);

        List<PsProductVO> productVOList = client.findByFields(params,SearchType.ANDLIKE);
        handleProductList(productVOList, matchCampaignCond);

        List<PsProductVO> list = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(codes)){
            for(String code:codes){
                if(CollectionUtils.isNotEmpty(productVOList)){
                    for(PsProductVO vo:productVOList){
                        if(code.equals(vo.getCode())){
                            list.add(vo);
                            break;
                        }
                    }
                }
            }
        }

        return list;
    }

    @Override
    public List<PsProductVO> findCrossBorderListByProdSearchCondVO(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====查询es 参数为 chnCode= {},findCrossBorderListByProdSearchCondVO={}", chnCode, prodSearchCondVO);
        Map<String,Object> selectMap = new HashMap<String,Object>();
        List<Long> cateIds = new ArrayList<>();
        Integer from = prodSearchCondVO.getFrom() != null && prodSearchCondVO.getFrom() > 0 ? (Integer) prodSearchCondVO.getFrom() : 0;
        Integer size = prodSearchCondVO.getSize() != null && prodSearchCondVO.getSize() > 0 ? (Integer) prodSearchCondVO.getSize() : 20;
        List<String> labelIds = prodSearchCondVO.getLabelIds();
        List<String> brandIds = prodSearchCondVO.getBrandIds();
        Boolean isCrossBorder = prodSearchCondVO.getIsCrossBorder() == null ? false : prodSearchCondVO.getIsCrossBorder();
        List<String> cateCodes = prodSearchCondVO.getCategoryCodes();

        List<PcsSkuCategoryVO> categoriesList = new ArrayList<PcsSkuCategoryVO>();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                List<PcsSkuCategoryVO> category = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }
        if(CollectionUtils.isNotEmpty(categoriesList)){
            cateIds = new ArrayList<>(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
        }

        Map sortMap = new LinkedHashMap();
        Map sMap = new HashMap();
        Map sMap2 = new HashMap();
        Map sNestedMap = new HashMap();
        Map map = new HashMap();
        Map paramsMap = new HashMap();
        Map slMap = new HashMap();

        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        if(CollectionUtils.isNotEmpty(cateIds)){
            params.put("frontCategories.categoryId", cateIds);
        }

        String sortField = prodSearchCondVO.getSortField();
        String sortOrder = prodSearchCondVO.getSortOrder();

        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        if(CollectionUtils.isNotEmpty(cateIds)){
            paramsMap.put("categoryIds", cateIds);
        }
        map.put("order", "asc");
        map.put("mode", "min");

        if (Strings.isNullOrEmpty(sortField) || Strings.isNullOrEmpty(sortOrder)) {
            sortMap.put("saleStartDate", "desc");
        } else {
            if ("create_time".equals(sortField)) {
                sortMap.put("channelProdInfo.createTime", slMap);
                slMap.put("order", sortOrder);
                slMap.put("mode", "min");
            } else if ("price".equals(sortField)) {
                sortMap.put("listPrice", sortOrder);
            }
        }
//        if(CollectionUtils.isNotEmpty(categoriesList)) {
//            String fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
//            sortMap.put("_script", map);
//            map.put("script", "frontCategorySort");
//            map.put("params", paramsMap);
//            paramsMap.put("fieldName", fieldName);
//        }

        params.put("sort", sortMap);
        if(CollectionUtils.isNotEmpty(brandIds)){
            params.put("brandList.brandId",brandIds);
        }
        if(CollectionUtils.isNotEmpty(labelIds)){
            params.put("labels.labelId",labelIds);
        }
        selectMap.put("isCrossBorder",isCrossBorder);

        List<PsProductVO> productVOList = client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap, from, size);
        LOGGER.info("返回的结果数量为={}",productVOList.size());
        handleProductList(productVOList, matchCampaignCond);
        sw.stop();
        LOGGER.info("【折扣商品接口耗时】折扣商品查询列表 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
        return productVOList;
    }

    @Override
    public List<PsProductVO> findCustomzeListByProdSearchCondVO(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====查询es 参数为 chnCode= {},findCustomzeListByProdSearchCondVO={}", chnCode, prodSearchCondVO);
        Map<String,Object> selectMap = new HashMap<String,Object>();
//        List<Long> cateIds = new ArrayList<>();
        Integer from = prodSearchCondVO.getFrom() != null && prodSearchCondVO.getFrom() > 0 ? (Integer) prodSearchCondVO.getFrom() : 0;
        Integer size = prodSearchCondVO.getSize() != null && prodSearchCondVO.getSize() > 0 ? (Integer) prodSearchCondVO.getSize() : 20;
        PsSkuCond cond = new PsSkuCond();
        cond.setCanCustomize(1);
        cond.setCurrpage(0);
        cond.setPagenum(100);
        List<PsSkuVO> skus = mcPsSkuService.findByCond(cond);
        List<String> skucodes = new ArrayList();
        if(CollectionUtils.isNotEmpty(skus)){
            for(PsSkuVO skuVO : skus){
                skucodes.add(skuVO.getSkuCode());
            }
        }

//        List<String> labelIds = prodSearchCondVO.getLabelIds();
//        List<String> brandIds = prodSearchCondVO.getBrandIds();
//        Boolean isCrossBorder = prodSearchCondVO.getIsCrossBorder() == null ? false : prodSearchCondVO.getIsCrossBorder();
//        List<String> cateCodes = prodSearchCondVO.getCategoryCodes();
//
//        List<PcsSkuCategoryVO> categoriesList = new ArrayList<PcsSkuCategoryVO>();
//        if (cateCodes != null && cateCodes.size() > 0) {
//            for (String cateCode : cateCodes) {
//                List<PcsSkuCategoryVO> category = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
//                categoriesList.addAll(category);
//            }
//        }
//        if(CollectionUtils.isNotEmpty(categoriesList)){
//            cateIds = new ArrayList<>(categoriesList.size());
//            for (PcsSkuCategoryVO category : categoriesList) {
//                cateIds.add(category.getId());
//            }
//        }

        Map sortMap = new LinkedHashMap();
        Map sMap = new HashMap();
        Map sMap2 = new HashMap();
        Map sNestedMap = new HashMap();
        Map map = new HashMap();
        Map paramsMap = new HashMap();
        Map slMap = new HashMap();

        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("skuCodes", skucodes);
//        if(CollectionUtils.isNotEmpty(cateIds)){
//            params.put("frontCategories.categoryId", cateIds);
//        }

        String sortField = prodSearchCondVO.getSortField();
        String sortOrder = prodSearchCondVO.getSortOrder();

        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
//        if(CollectionUtils.isNotEmpty(cateIds)){
//            paramsMap.put("categoryIds", cateIds);
//        }
        map.put("order", "asc");
        map.put("mode", "min");

//        if (Strings.isNullOrEmpty(sortField) || Strings.isNullOrEmpty(sortOrder)) {
//            sortMap.put("saleStartDate", "desc");
//        } else {
//            if ("create_time".equals(sortField)) {
        sortMap.put("channelProdInfo.createTime", slMap);
        slMap.put("order", "DESC");
        slMap.put("mode", "min");
//            } else if ("price".equals(sortField)) {
//                sortMap.put("listPrice", sortOrder);
//            }
//        }
//        if(CollectionUtils.isNotEmpty(categoriesList)) {
//            String fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
//            sortMap.put("_script", map);
//            map.put("script", "frontCategorySort");
//            map.put("params", paramsMap);
//            paramsMap.put("fieldName", fieldName);
//        }

        params.put("sort", sortMap);
//        if(CollectionUtils.isNotEmpty(brandIds)){
//            params.put("brandList.brandId",brandIds);
//        }
//        if(CollectionUtils.isNotEmpty(labelIds)){
//            params.put("labels.labelId",labelIds);
//        }
//        selectMap.put("isCrossBorder",isCrossBorder);

        List<PsProductVO> productVOList = client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap, from, size);
        LOGGER.info("返回的结果数量为={}",productVOList.size());
        handleProductList(productVOList, matchCampaignCond);
        sw.stop();
        LOGGER.info("【折扣商品接口耗时】折扣商品查询列表 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
        return productVOList;
    }

    //根据多类目和、是否新上架查询 by Lk
    @Override
    public List<PsProductVO> findByProdSearchCondVO(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====查询es 参数为 chnCode= {},prodSearchCondVO={}", chnCode, prodSearchCondVO);
        Map<String,Object> selectMap = new HashMap<String,Object>();
        List<String> cateCodes = prodSearchCondVO.getCategoryCodes();
        String key = prodSearchCondVO.getKeywords();
        String labels = prodSearchCondVO.getLabels();
        String brandId = prodSearchCondVO.getBrandId();
        List<String> labelIds = prodSearchCondVO.getLabelIds();
        List<String> brandIds = prodSearchCondVO.getBrandIds();
        Boolean isCrossBorder = prodSearchCondVO.getIsCrossBorder() == null ? false : prodSearchCondVO.getIsCrossBorder();
        Integer from = prodSearchCondVO.getFrom() != null && prodSearchCondVO.getFrom() > 0 ? (Integer) prodSearchCondVO.getFrom() : 0;
        Integer size = prodSearchCondVO.getSize() != null && prodSearchCondVO.getSize() > 0 ? (Integer) prodSearchCondVO.getSize() : 20;
        Boolean isNew = prodSearchCondVO.getIsNew() == null ? false : prodSearchCondVO.getIsNew();

        Map sortMap = new LinkedHashMap();
        Map sMap = new HashMap();
        Map sMap2 = new HashMap();
        Map sNestedMap = new HashMap();
        Map map = new HashMap();
        Map paramsMap = new HashMap();
        Map slMap = new HashMap();

        if(CollectionUtils.isNotEmpty(labelIds) || CollectionUtils.isNotEmpty(brandIds) || (isCrossBorder == true && CollectionUtils.isNotEmpty(cateCodes))) {
            List<PcsSkuCategoryVO> categoriesList = new ArrayList<PcsSkuCategoryVO>();
            if (cateCodes != null && cateCodes.size() > 0) {
                for (String cateCode : cateCodes) {
                    List<PcsSkuCategoryVO> category = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                    categoriesList.addAll(category);
                }
            }

            List<Long> cateIds = new ArrayList<>(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
            //如果不是最新上架就不返回       返回 所有的    类目 最新的东西
            if (!isNew) {
                if (CollectionUtils.isEmpty(cateIds)) {
                    return Collections.emptyList();
                }
            }
            Map<String, Object> params = new HashMap<>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);
            params.put("frontCategories.categoryId", cateIds);
            //是否新上架
            if (isNew) {
                DateRange dateRange = prodSearchCondVO.getDateRange();
                if (dateRange == null) {
                    dateRange = new DateRange();
                    //无上架范围默认14天
                    Date end = new Date();
                    dateRange.setEnd(end);
                    Calendar calendar = new GregorianCalendar();
                    calendar.setTime(end);
                    calendar.add(calendar.DATE, -14);
                    Date start = calendar.getTime();
                    dateRange.setStart(start);
                }
                params.put("channelProdInfo.createTime", dateRange);
            }

            String sortField = prodSearchCondVO.getSortField();
            String sortOrder = prodSearchCondVO.getSortOrder();

            sortMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            paramsMap.put("categoryIds", cateIds);
            map.put("order", "asc");
            map.put("mode", "min");

            if (Strings.isNullOrEmpty(sortField) || Strings.isNullOrEmpty(sortOrder)) {
                sortMap.put("saleStartDate", "desc");
            } else {
                if ("create_time".equals(sortField)) {
                    sortMap.put("channelProdInfo.createTime", slMap);
                    slMap.put("order", sortOrder);
                    slMap.put("mode", "min");
                } else if ("price".equals(sortField)) {
                    sortMap.put("listPrice", sortOrder);
                }
            }
            String fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
            sortMap.put("_script", map);
            map.put("script", "frontCategorySort");
            map.put("params", paramsMap);
            paramsMap.put("fieldName", fieldName);

            params.put("sort", sortMap);
            if(CollectionUtils.isNotEmpty(brandIds)){
                params.put("brandList.brandId",brandIds);
            }
            if(CollectionUtils.isNotEmpty(labelIds)){
                params.put("labels.labelId",labelIds);
            }
//            selectMap.put("labelIds",labelIds);
//            selectMap.put("brandIds",brandIds);
            selectMap.put("isCrossBorder",isCrossBorder);

            List<PsProductVO> productVOList = client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap, from, size);
            LOGGER.info("返回的结果数量为={}",productVOList.size());
            handleProductList(productVOList, matchCampaignCond);
            sw.stop();
            LOGGER.info("【商品接口耗时】商品查询列表 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
            return productVOList;
        }

        if(isCrossBorder){
            Map<String, Object> params = new HashMap<>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);

            sortMap.put("stocks.soldOut", sMap);
            sortMap.put("_score", sMap2);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            map.put("order", "asc");
            map.put("mode", "min");
            sMap2.put("order", "desc");
            sMap2.put("mode", "min");
            LOGGER.info("是否海淘商品查询的参数    params={} from={},size={},isCrossBorder={}", params, from, size, isCrossBorder);
            selectMap.put("isCrossBorder",isCrossBorder);
            List<PsProductVO> productVOList = client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap,from,size);
            LOGGER.info("返回的结果数量为={}",productVOList.size());
            handleProductList(productVOList, matchCampaignCond);
            sw.stop();
            LOGGER.info("【商品接口耗时】商品查询列表 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
            return productVOList;
        }

        if(!Strings.isNullOrEmpty(labels)){
            Map<String, Object> params = new HashMap<>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);

            sortMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            map.put("order", "asc");
            map.put("mode", "min");
            LOGGER.info("标签查询的参数    params={} from={},size={},psTags={}", params, from, size, labels);
            selectMap.put("labels",labels);
            List<PsProductVO> productVOList = client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap,from,size);
            LOGGER.info("返回的结果数量为={}",productVOList.size());
            handleProductList(productVOList, matchCampaignCond);
            sw.stop();
            LOGGER.info("【商品接口耗时】商品查询列表 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
            return productVOList;
        }

        if(!Strings.isNullOrEmpty(brandId)) {
            Map<String, Object> params = new HashMap<>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);

            String sortField = prodSearchCondVO.getSortField();
            String sortOrder = prodSearchCondVO.getSortOrder();

            sortMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            map.put("order", "asc");
            map.put("mode", "min");

            if (Strings.isNullOrEmpty(sortField) || Strings.isNullOrEmpty(sortOrder)) {
                sortMap.put("saleStartDate", "desc");
            } else {
                if ("create_time".equals(sortField)) {
                    sortMap.put("channelProdInfo.createTime", slMap);
                    slMap.put("order", sortOrder);
                    slMap.put("mode", "min");
                } else if ("price".equals(sortField)) {
                    sortMap.put("listPrice", sortOrder);
                }
            }

            params.put("sort", sortMap);
            selectMap.put("brandId",brandId);
            List<PsProductVO> productVOList = client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap, from, size);
            handleProductList(productVOList, matchCampaignCond);
            sw.stop();
            LOGGER.info("【商品接口耗时】商品查询列表 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
            return productVOList;
        }

        if(Strings.isNullOrEmpty(key)) {
            List<PcsSkuCategoryVO> categoriesList = new ArrayList<PcsSkuCategoryVO>();
            if (cateCodes != null && cateCodes.size() > 0) {
                for (String cateCode : cateCodes) {
                    List<PcsSkuCategoryVO> category = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                    categoriesList.addAll(category);
                }
            }
//            sw.stop();
//            LOGGER.info("【商品接口耗时】类目查询 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
            //去重
//        List<PcsSkuCategoryVO> categories = new ArrayList<PcsSkuCategoryVO>(new HashSet<PcsSkuCategoryVO>(categoriesList));

            List<Long> cateIds = new ArrayList<>(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
            //如果不是最新上架就不返回       返回 所有的    类目 最新的东西
            if(!isNew) {
                if (CollectionUtils.isEmpty(cateIds)) {
                    return Collections.emptyList();
                }
            }
            Map<String, Object> params = new HashMap<>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);
            params.put("frontCategories.categoryId", cateIds);
            //是否新上架
            if (isNew) {
                DateRange dateRange = prodSearchCondVO.getDateRange();
                if (dateRange == null) {
                    dateRange = new DateRange();
                    //无上架范围默认14天
                    Date end = new Date();
                    dateRange.setEnd(end);
                    Calendar calendar = new GregorianCalendar();
                    calendar.setTime(end);
                    calendar.add(calendar.DATE, -14);
                    Date start = calendar.getTime();
                    dateRange.setStart(start);
                }
                params.put("channelProdInfo.createTime", dateRange);
            }

            String sortField = prodSearchCondVO.getSortField();
            String sortOrder = prodSearchCondVO.getSortOrder();

            sortMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            paramsMap.put("categoryIds", cateIds);
            map.put("order", "asc");
            map.put("mode", "min");

            if (Strings.isNullOrEmpty(sortField) || Strings.isNullOrEmpty(sortOrder)) {
                String fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
                sortMap.put("_script", map);
                map.put("script", "frontCategorySort");
                map.put("params", paramsMap);
                paramsMap.put("fieldName", fieldName);
                sortMap.put("saleStartDate", "desc");
            } else {
                if ("create_time".equals(sortField)) {
                    sortMap.put("channelProdInfo.createTime", slMap);
                    slMap.put("order", sortOrder);
                    slMap.put("mode", "min");
                } else if ("price".equals(sortField)) {
                    sortMap.put("listPrice", sortOrder);
                }
                String fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
                sortMap.put("_script", map);
                map.put("script", "frontCategorySort");
                map.put("params", paramsMap);
                paramsMap.put("fieldName", fieldName);
            }

            params.put("sort", sortMap);
            List<PsProductVO> productVOList = client.findByFieldWithProdSearchCondVO(params, SearchType.ANDLIKE, from, size);
            handleProductList(productVOList, matchCampaignCond);
            sw.stop();
            LOGGER.info("【商品接口耗时】商品查询列表 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
            return productVOList;
        }else{
            Map<String, Object> params = new HashMap<>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);
            params.put("sort", sortMap);
            sortMap.put("stocks.soldOut", sMap);
            sortMap.put("_score", sMap2);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            sMap2.put("order", "desc");
            sMap2.put("mode", "min");

            String sortField = prodSearchCondVO.getSortField();
            String sortOrder = prodSearchCondVO.getSortOrder();
            if (StringUtils.isNotBlank(sortField)) {
                slMap = new HashMap();
                if ("create_time".equals(sortField)) {
                    sortMap.put("channelProdInfo.createTime", slMap);
                    slMap.put("order", sortOrder);
                    slMap.put("mode", "min");
                } else if ("price".equals(sortField)) {
                    sortMap.put("listPrice", sortOrder);
                }
            }
//            map.put("order", "asc");
//            map.put("mode", "min");
            LOGGER.info("关键字查询的参数    params={} from={},size={},key={}", params, from, size, key);
            List<PsProductVO> productVOList = client.findByFieldWithKeyWords(params, SearchType.ANDLIKE,key,from,size);
            LOGGER.info("返回的结果数量为={}", productVOList.size());
            handleProductList(productVOList, matchCampaignCond);
            sw.stop();
            LOGGER.info("【商品接口耗时】商品查询列表 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
            return productVOList;
        }
    }

    /**
     * 根据活动信息查询商品
     * @param campaignSearchCond
     * @return
     */
    @Override
    public List<PsProductVO> findByCampaignSearchCond(PsCampaignSearchCond campaignSearchCond) {
        List<String> cateCodes = campaignSearchCond.getCategoryCodes();
        Integer from = campaignSearchCond.getFrom() != null && campaignSearchCond.getFrom() > 0 ? (Integer) campaignSearchCond.getFrom() : 0;
        Integer size = campaignSearchCond.getSize() != null && campaignSearchCond.getSize() > 0 ? (Integer) campaignSearchCond.getSize() : 20;
        Map<String, Object> params = new HashMap<>();
        Map map = new HashMap();
        Map paramsMap = new HashMap();
        Map slMap = new HashMap();
        String chnCode = campaignSearchCond.getChannelCode();
        if (StringUtils.isBlank(chnCode)) {
            throw new PublicException("渠道号为空");
        }

        // 如果没有传活动ID，则报出异常
        List<Long> campaignIds = campaignSearchCond.getCampaignIds();
        if (CollectionUtils.isEmpty(campaignIds)) {
            new PublicException("[根据活动信息查询商品]没有传活动ID");
        }

        List<PcsSkuCategoryVO> categoriesList = new ArrayList<PcsSkuCategoryVO>();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                List<PcsSkuCategoryVO> category = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }

        List<Long> cateIds = new ArrayList<>(categoriesList.size());
        for (PcsSkuCategoryVO category : categoriesList) {
            cateIds.add(category.getId());
        }

        // 先去匹配活动
        PsMatchCampaignCond matchCampaignCond = PsMatchCampaignCond.buildCond(campaignSearchCond.getAccessWay(), campaignSearchCond.getMemberLevel());
        matchCampaignCond.setCampaignIds(campaignIds);
        matchCampaignCond.setProductScopeIds(campaignSearchCond.getScopeIds());
        matchCampaignCond.setStates(Lists.newArrayList(1));
        List<PsCampaignVO> matchedCampaigns = campaignDomain.getMatchedCampaignList(matchCampaignCond);

        // 如果匹配不到，则返回空列表
        if (CollectionUtils.isEmpty(matchedCampaigns) || matchedCampaigns.size() != campaignSearchCond.getCampaignIds().size()) {
            return Lists.newArrayList();
        }

        // 查询相关商品

        BoolQueryBuilder orQuery = QueryBuilders.boolQuery();
        orQuery.should(QueryBuilders.termsQuery("campaignList.id", campaignIds));
        orQuery.should(QueryBuilders.termsQuery("spvList.campaignList.id", campaignIds));
        params.put("or", orQuery);

        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("frontCategories.categoryId", cateIds);

        if(CollectionUtils.isNotEmpty(matchedCampaigns)){
            if(matchedCampaigns.size() == 1){
                PsCampaignVO psCampaignVO = matchedCampaigns.get(0);
                Integer crossflag = psCampaignVO.getCrossBorderFlag();
                params.put("crossBorderFlag", crossflag);
            }
        }

        List<Integer> discountTypeIds = campaignSearchCond.getDiscountTypeIds();

        if (CollectionUtils.isNotEmpty(discountTypeIds)) {
            params.put("campaignList.discountTypeId",
                    QueryBuilders.termsQuery("campaignList.discountTypeId", discountTypeIds));
        }


        Map seqMap = new LinkedHashMap();


        List<String> sortUpdateTime = new ArrayList<>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");

        List<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");

        Map sMap = new HashMap();
        Map sNestedMap = new HashMap();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        paramsMap.put("categoryIds", cateIds);
        map.put("order", "asc");
        map.put("mode", "min");

//        seqMap.put("listPrice", "asc");
//
//        seqMap.put("saleStartDate", "desc");
        params.put("sort", seqMap);
        params.put("from", from);
        params.put("size", size);


        String sortField = campaignSearchCond.getSortField();
        String sortOrder = campaignSearchCond.getSortOrder();

        if (Strings.isNullOrEmpty(sortField) || Strings.isNullOrEmpty(sortOrder)) {
            String fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
            seqMap.put("_script", map);
            map.put("script", "frontCategorySort");
            map.put("params", paramsMap);
            paramsMap.put("fieldName", fieldName);
            seqMap.put("saleStartDate", "desc");
        } else {
            if ("create_time".equals(sortField)) {
                seqMap.put("channelProdInfo.createTime", slMap);
                slMap.put("order", sortOrder);
                slMap.put("mode", "min");
            } else if ("price".equals(sortField)) {
                seqMap.put("listPrice", sortOrder);
            }
            String fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
            seqMap.put("_script", map);
            map.put("script", "frontCategorySort");
            map.put("params", paramsMap);
            paramsMap.put("fieldName", fieldName);
        }

        List<PsProductVO> productVOList = client.findByFields(params, SearchType.ANDLIKE);

        matchCampaignCond.setDiscount(campaignSearchCond.getDiscount());
        matchCampaignCond.setBdDiscount(campaignSearchCond.getBdDiscount());
        handleProductList(productVOList, matchCampaignCond);
        return productVOList;

    }



    @Override
    public List<PsProductVO> findByChnCodeCateCode(
            String chnCode, String cateCode, final PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        if (pagenum < 1) {
            return Collections.emptyList();
        }

        List<PcsSkuCategoryVO> categories = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
        List<Long> cateIds = new ArrayList<>(categories.size());
        for (PcsSkuCategoryVO category : categories) {
            cateIds.add(category.getId());
        }
        if (CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }

        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("frontCategories.categoryId", cateIds);

        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        List<Object> seqList = new ArrayList<Object>();
        Map seqMap = new LinkedHashMap();


        List<String> sortUpdateTime = new ArrayList<>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");

        List<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");

        Map sMap = new HashMap();
        Map sNestedMap = new HashMap();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);

        String fieldName = categories.size() > 1 ? "sort1" : "sort2";
        Map map = new HashMap();
//        Map nestedMap = new HashMap();
        Map paramsMap = new HashMap();
        seqMap.put("_script", map);
        map.put("script", "frontCategorySort");
        map.put("params", paramsMap);
        paramsMap.put("categoryIds", cateIds);
        paramsMap.put("fieldName", fieldName);
        map.put("order", "asc");
        map.put("mode", "min");

        seqMap.put("saleStartDate", "desc");

        params.put("sort",seqMap);
        List<PsProductVO> productVOList = client.findByFields(params,SearchType.ANDLIKE);
        handleProductList(productVOList, matchCampaignCond);
        return productVOList;
    }
    
    @Override
    public List<PsProductVO> findByChnCodeCateCodeCreateTime(
            String chnCode, Map<String,Date> dateRange, final PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        if (pagenum < 1) {
            return Collections.emptyList();
        }

        Map<String, Object> params = new HashMap<>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);

        //params.put("channelProdInfo.channelCode", chnCode);
        params.put("pagenum", pagenum);
        params.put("currpage", currpage);

        // sort排序
        Map sortRootMap = new LinkedHashMap();
        Map sortSoldOut = new HashMap();
        sortRootMap.put("stocks.soldOut", sortSoldOut);
        sortSoldOut.put("order", "asc");
        sortSoldOut.put("mode", "min");
        Map soldOutNestedFilter = new HashMap();
        sortSoldOut.put("nested_filter", soldOutNestedFilter);
        soldOutNestedFilter.put("stocks.chnCode", chnCode);
        
        Map sortCreateTime = new HashMap();
        sortRootMap.put("channelProdInfo.createTime", sortCreateTime);
        sortCreateTime.put("order", "desc");
        sortCreateTime.put("mode", "min");
        Map createTimeNestedFilter = new HashMap();
        sortCreateTime.put("nested_filter", createTimeNestedFilter);
        Map rangeMap = new HashMap();
        createTimeNestedFilter.put("range", rangeMap);
        Map createTimeRangeMap = new HashMap();
        rangeMap.put("channelProdInfo.createTime", createTimeRangeMap);
        createTimeRangeMap.put("from", dateRange.get("createTimeStart"));
        createTimeRangeMap.put("to", dateRange.get("createTimeEnd"));

        params.put("sort",sortRootMap);
        
        Map chanelProdTime = new HashMap();
        chanelProdTime.put("createTimeStart", dateRange.get("createTimeStart"));
        chanelProdTime.put("createTimeEnd", dateRange.get("createTimeEnd"));
        chanelProdTime.put("channelCode", chnCode);
        params.put("chanelProdTime", chanelProdTime);
        params.put("chnCode", chnCode);
        List<PsProductVO> productVOList = client.findByFields(params,SearchType.ANDLIKE);
        handleProductList(productVOList, matchCampaignCond);
        return productVOList;
    }

    @Override
    public List<PsProductVO> findByChnCodeCateCodeRightLike(String chnCode, String cateCode) {
        List<PsProductVO> allProds = new ArrayList<>();
        Map<String, Object> params = new HashMap<>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("categoryCode", cateCode);
        List<PsProductVO> productVOs = client.findByFields(params, SearchType.AND);
        if (CollectionUtils.isNotEmpty(productVOs)) {
            allProds.addAll(productVOs);
        }
        params.remove("categoryCode");
        params.put("categoryCodePRE", cateCode+"_");
        List<PsProductVO> productVOList =  client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isNotEmpty(productVOList)) {
            allProds.addAll(productVOList);
        }
        return allProds;
    }
    @Override
    public PsProductVO findProdByCode(String code) {
        Map<String, Object> params = new HashMap<>();
        params.put("code", code);
        List<PsProductVO> fs =client.findByFields(params, SearchType.ANDLIKE) ;
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        for (PsProductVO vo : fs) {
            vo.setCampaignList(Lists.<PsCampaignVO>newArrayList());
        }
        return fs.get(0);
    }

	@Override
	public Map<String, PsProductVO> mapByProdIds(List<String> prodIds) {
		if (CollectionUtils.isNotEmpty(prodIds)) {
			Map<String, PsProductVO> rt = Maps.newHashMapWithExpectedSize(prodIds.size());
			PsProductCond cond = new PsProductCond();
			cond.setIds(prodIds);
			List<PsProductVO> prods = findByCond(cond);
			for (PsProductVO prod : prods) {
				rt.put(prod.getId(), prod);
			}
			return rt;
		}
		return null;
	}
    @Override
    public Map<String, PsProductVO> mapByProdCodes(List<String> codes) {
        if (CollectionUtils.isNotEmpty(codes)) {
            Map<String, PsProductVO> rt = Maps.newHashMapWithExpectedSize(codes.size());
            PsProductCond cond = new PsProductCond();
            cond.setCodes(codes);
            cond.setPagenum(200);
            List<PsProductVO> prods = findByCond(cond);
            for (PsProductVO prod : prods) {
                rt.put(prod.getCode(), prod);
            }
            return rt;
        }
        return null;
    }

    /**
     * 获取商品详情
     * @param chnCode
     * @param productCode
     * @param matchCampaignCond
     * @return
     */
    @Override
    public PsProductVO getProductDetailByCode(String chnCode, String productCode, PsMatchCampaignCond matchCampaignCond) {
        if (matchCampaignCond == null)
            throw new PublicException("未传活动匹配条件");
        LOGGER.info("【获取商品详情】 chnCode: {} prodCode: {}", chnCode, productCode);
        // 获取PROD
        Map<String, Object> params = new HashedMap();
        params.put("code", productCode);
        List<PsProductVO> list = client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isEmpty(list)) {
            params = new HashedMap();
            params.put("skuCodes", productCode);
            params.put("combined", 0);
            list = client.findByFields(params, SearchType.ANDLIKE);
            if (CollectionUtils.isEmpty(list)) {
                params = new HashedMap();
                params.put("skuCodes", productCode);
                params.put("combined", 1);
                list = client.findByFields(params, SearchType.ANDLIKE);
                if (CollectionUtils.isEmpty(list)) {
                    LOGGER.info("【获取商品详情】 找不到PROD详情: {}", productCode);
                    return null;
                }
            }
        }
        PsProductVO psProductVO = list.get(0);

        if (matchCampaignCond.getMatchCampaign()) {
            // 匹配活动
            campaignDomain.matchCampaigns(psProductVO, matchCampaignCond);
            // 排除全场换购
            excludeSpecialCampaigns(psProductVO);
        }

        // 是鲜花月送商品，则设置商品所关联的campaignList为所有适用商品为该商品的有效单商品满赠活动
        if (flowerMonthDeliveryProductCodeList.contains(productCode)) {
            List<PsCampaignVO> campaignList = psProductVO.getCampaignList();
            if (CollectionUtils.isNotEmpty(campaignList)) {
                List<PsCampaignVO> specialCampaignList = Lists.newArrayList();
                for (PsCampaignVO item : campaignList) {
                    // 只有是单商品换购活动才加入
                    if (item.getDiscountTypeId().equals(DiscountTypeEnum.CHEAPEN_OTHER.getId())
                            && item.getProductScopeId().equals(1)) {
                        specialCampaignList.add(item);
                    }
                }
                psProductVO.setCampaignList(specialCampaignList);
            }
        }

        // 计算折扣价
        calculateDiscountPrice(psProductVO, matchCampaignCond.getDiscount(), matchCampaignCond);

        List<PsSpvVO> spvList = psProductVO.getSpvList();
        if (CollectionUtils.isEmpty(spvList)) {
            LOGGER.error("【商品详情】商品中SPV列表为空");
            return psProductVO;
        }

        String productIdStr = psProductVO.getId();
        Long productId = Long.valueOf(productIdStr);

        // 如果为单品，先获取所有SKU
        Map<String, PsSkuVO> skuMap = new HashedMap();
        List<String> skuCodes = psProductVO.getSkuCodes();
        if (CollectionUtils.isEmpty(skuCodes)) {
            LOGGER.warn("【商品详情】商品中SKU CODE列表为空");
        }
        List<PsSkuVO> skuList = mcPsSkuService.findBySkuCodes(skuCodes);
        if (CollectionUtils.isEmpty(skuList)) {
            LOGGER.warn("未找到任何SKU");
        }
        for (PsSkuVO skuVO : skuList) {
            skuMap.put(skuVO.getSkuCode(), skuVO);
        }

        Map<String, String> canSaleSkuMap = getCanSaleSkuMap(chnCode, psProductVO);
        Map<String, String> canSeeSkuMap = getCanSeeSkuMap(chnCode, psProductVO);
        List<PsSpvVO> newSpvList = new ArrayList<>();
        PsBrandVO psBrandVO = new PsBrandVO();
        boolean flag = true;
        for (PsSpvVO spvVO : spvList) {
            spvVO.setProductId(productId);
            spvVO.setProductCode(psProductVO.getCode());
            if (psProductVO.getCombined()) { // 组合SPV
                buildCombinedSpv(psProductVO, spvVO, skuMap, matchCampaignCond);
            }
            else { // 单品SPV
                buildSingleSpv(psProductVO, spvVO, skuMap, matchCampaignCond);
            }
            // 判断是否可用
            if (isSpvAvailable(canSaleSkuMap, canSeeSkuMap, spvVO)) {
                newSpvList.add(spvVO);
            }
            if (psProductVO.getCombined()) {
                if(flag){
                    PsSkuVO psSkuVO = spvVO.getSkuCombinationList().get(0).getSubSkuVO();
                    Long brandId = psSkuVO.getBrandId();
                    String brandName = psSkuVO.getBrandName();
                    String brandNameCn = psSkuVO.getBrandNameCN();
                    String countryName = psSkuVO.getBrandCountryName();
                    Long countryId = psSkuVO.getBrandCountryId();
                    psBrandVO.setBrandCountryId(countryId);
                    psBrandVO.setBrandCountryName(countryName);
                    psBrandVO.setBrandId(brandId);
                    psBrandVO.setBrandName(brandName);
                    psBrandVO.setBrandNameCN(brandNameCn);
                    flag = false;
                }
            }
        }
        //商品详情页获取第一个SKU的品牌
        if (psProductVO.getCombined()) {
            List<PsBrandVO> brands = psProductVO.getBrands();
            brands.remove(psBrandVO);
            List<PsBrandVO> listCopy = new ArrayList();
            listCopy.add(psBrandVO);
            listCopy.addAll(brands);
            psProductVO.setBrands(listCopy);
        }

        psProductVO.setSpvList(newSpvList);
        LOGGER.debug("【获取商品详情】 结果 CODE: {}, PROD:{}", productCode, psProductVO);
        return psProductVO;
    }

    /**
     * 构建组合SPV
     */
    private void buildCombinedSpv(PsProductVO productVO, PsSpvVO spvVO, Map<String, PsSkuVO> skuMap, PsMatchCampaignCond matchCampaignCond) {
        calculateDiscountPrice(productVO, spvVO, matchCampaignCond);
        List<PsSkuCombinationVO> skuCombinationList = spvVO.getSkuCombinationList();
        if (CollectionUtils.isEmpty(skuCombinationList)) {
            LOGGER.error("【商品详情】组合SPV中的SKU组合为空");
            return;
        }
        for (PsSkuCombinationVO skuCombinationVO : skuCombinationList) {
            String skuCode = skuCombinationVO.getSubSkuCode();
            PsSkuVO skuVO = getSkuFromCodeOrCache(skuCode, skuMap);
            skuCombinationVO.setSubSkuVO(skuVO);
        }
    }

    /**
     * 构建单品SPV
     */
    private void buildSingleSpv(PsProductVO psProductVO, PsSpvVO spvVO, Map<String, PsSkuVO> skuMap, PsMatchCampaignCond matchCampaignCond) {
        String skuCode = spvVO.getSkuCode();
        if (StringUtils.isBlank(skuCode)) {
            LOGGER.error("【商品详情】单品SPV中的SKU CODE为空");
            return;
        }
        PsSkuVO skuVO = getSkuFromCodeOrCache(skuCode, skuMap);

        // 设置SKU和价格
        spvVO.setSkuVO(skuVO);
        spvVO.setSalesPrice(new BigDecimal(skuVO.getSalesPrice()));
        spvVO.setCostPrice(skuVO.getCostPrice());
        spvVO.setDiscountPrice(skuVO.getDiscountPrice());
        spvVO.setAdvancePrice(skuVO.getAdvancePrice());
        spvVO = calculateDiscountPrice(psProductVO, spvVO, matchCampaignCond);
        skuVO.setDiscountPrice(spvVO.getDiscountPrice());

        // 组装规格
        String skuCategoryDesc = psProductVO.getSkuCategoryDesc();
        String skuCateName = skuVO.getSkuCateName();
        if (StringUtils.isNoneEmpty(skuCategoryDesc) && StringUtils.isNotEmpty(skuCateName)) {
            PsAttributeValuePairVO attributeValuePairVO = new PsAttributeValuePairVO();
            attributeValuePairVO.setCombined(false);
            attributeValuePairVO.setAttrName(skuCategoryDesc);
            attributeValuePairVO.setValue(skuCateName);
            spvVO.setAttributeValuePairList(Arrays.asList(attributeValuePairVO));
        }
    }

    private boolean isSpvAvailable(Map<String, String> canSaleMap,
                                   Map<String, String> canSeeMap,
                                   PsSpvVO spvVO) {
        if (spvVO.getCombined()) { // 组合
            List<PsSkuCombinationVO> skuCombinationList = spvVO.getSkuCombinationList();
            for (PsSkuCombinationVO skuCombinationVO : skuCombinationList) {
                if (!isSkuAvailable(canSaleMap, canSeeMap, skuCombinationVO.getSubSkuCode())) {
                    return false;
                }
            }
            return true;
        }
        else { // 单品
            return isSkuAvailable(canSaleMap, canSeeMap, spvVO.getSkuCode());
        }
    }



    /**
     * SKU是否可用
     * @param canSaleMap
     * @param canSeeMap
     * @param skuCode
     * @return
     */
    private boolean isSkuAvailable(Map<String, String> canSaleMap,
                                   Map<String, String> canSeeMap,
                                   String skuCode) {
        return canSaleMap.containsKey(skuCode) && canSeeMap.containsKey(skuCode);
    }


    private PsSkuVO getSkuFromCodeOrCache(String skuCode, Map<String, PsSkuVO> skuMap) {
        if (StringUtils.isBlank(skuCode)) {
            LOGGER.error("【商品详情】单品SPV中的SKU CODE为空");
            return null;
        }
        PsSkuVO skuVO = skuMap.get(skuCode);
        if (skuVO == null) {
            LOGGER.warn("【商品详情】单品SPV中的SKU[{}]未能在SKU CODE中找到", skuCode);
            skuVO = mcPsSkuService.findBySkuCode(skuCode);
        }
        return skuVO;
    }


    private Map<String, String> getCanSeeSkuMap(String chnCode, PsProductVO psProductVO) {
        Map<String, String> canSeeSkuMap = new HashedMap();
        List<PsChnProdSaleSkuVO> canSeeSkuList = psProductVO.getChnCanSeeSKu();
        if (CollectionUtils.isEmpty(canSeeSkuList)) return canSeeSkuMap;
        PsChnProdSaleSkuVO canSeeSku = null;
        for (PsChnProdSaleSkuVO chnProdSaleSkuVO : canSeeSkuList) {
            if (org.apache.commons.lang.StringUtils.equals(chnProdSaleSkuVO.getChnCode(), chnCode)) {
                canSeeSku = chnProdSaleSkuVO;
                break;
            }
        }
        if (canSeeSku != null) {
            for (String skuCode : canSeeSku.getCanSkus()) {
                canSeeSkuMap.put(skuCode, skuCode);
            }
        }
        return canSeeSkuMap;
    }

    private Map<String, String> getCanSaleSkuMap(String chnCode, PsProductVO psProductVO) {
        Map<String, String> canSaleSkuMap = new HashedMap();
        List<PsChnProdSaleSkuVO> canSaleSkuList = psProductVO.getChnCanSaleSKu();
        if (CollectionUtils.isEmpty(canSaleSkuList)) return canSaleSkuMap;
        PsChnProdSaleSkuVO canSaleSku = null;
        for (PsChnProdSaleSkuVO chnProdSaleSkuVO : canSaleSkuList) {
            if (org.apache.commons.lang.StringUtils.equals(chnProdSaleSkuVO.getChnCode(), chnCode)) {
                canSaleSku = chnProdSaleSkuVO;
                break;
            }
        }
        if (canSaleSku != null) {
            for (String skuCode : canSaleSku.getCanSkus()) {
                canSaleSkuMap.put(skuCode, skuCode);
            }
        }
        return canSaleSkuMap;
    }

    /**
     * 对ProductVOList进行处理
     * @param productVOList 待处理集合
     * @param matchCampaignCond 匹配活动规则
     */
    private void handleProductList(List<PsProductVO> productVOList, final PsMatchCampaignCond matchCampaignCond) {
        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign()) {
            // 匹配活动
            campaignDomain.matchListPageCampaigns(productVOList, matchCampaignCond);
        }
        // 计算特殊价格
        if (matchCampaignCond != null) {
        	calculateDiscountPrice(productVOList, matchCampaignCond.getDiscount(), matchCampaignCond);
		}
    }

    /**
     * 售价小于99的所有prod，按价格由低到高排序
     */
    public List<PsProductVO> addOnItemList(String chnCode, int pagenum, PsMatchCampaignCond matchCampaignCond) {
        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("stocks.soldOut", QueryBuilders.termQuery("stocks.soldOut", 0));
        //params.put("code", codes);
        RangeQueryBuilder listPriceRangeQueryBuilder = QueryBuilders.rangeQuery("listPrice").gt(0).lte(99);
        params.put("listPrice", listPriceRangeQueryBuilder);
        params.put("currpage", 1);
        params.put("pagenum", pagenum);
        Map seqMap = new LinkedHashMap();

        List<String> sortUpdateTime = new ArrayList<>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");

        List<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");

        Map sNestedMap = new HashMap();
        sNestedMap.put("stocks.chnCode", chnCode);
        seqMap.put("listPrice", "asc");
        seqMap.put("saleStartDate", "desc");
        params.put("sort", seqMap);
        List<PsProductVO> productVOList = client.findByFields(params,SearchType.ANDLIKE);
        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign()) {
//          matchProductsCampaigns(productVOList, matchCampaignCond, true);
            campaignDomain.matchListPageCampaigns(productVOList, matchCampaignCond);
            productVOList = calculateDiscountPrice(productVOList,matchCampaignCond.getDiscount(), matchCampaignCond);
        }
        return productVOList;
    }

    /**
     * 自动推荐 商品详情页推荐列表
     * @param brandId
     * @return
     */
    public List<PsProductVO> prodDetailsList(String chnCode, Long brandId, Long categoryId, Integer startListPrices, Integer endListPrice, int pagenum, PsMatchCampaignCond matchCampaignCond) {
        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("stocks.soldOut", QueryBuilders.termQuery("stocks.soldOut", 0));
        params.put("listPrice", QueryBuilders.rangeQuery("listPrice").gt(startListPrices).lte(endListPrice));
        params.put("currpage", 1);
        params.put("pagenum", pagenum);

        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (categoryId != null) {
        	boolQueryBuilder.should(QueryBuilders.termQuery("frontCategories.categoryId", categoryId));
        }
        if (brandId != null) {
        	boolQueryBuilder.should(QueryBuilders.termQuery("brandList.brandId", brandId));
		}
        params.put("or", boolQueryBuilder);

        Map sortMap = new LinkedHashMap();
        sortMap.put("_id", "desc");
        params.put("sort", sortMap);
        List<PsProductVO> productVOList = client.findByFields(params,SearchType.ANDLIKE);
        handleProductList(productVOList, matchCampaignCond);
        return productVOList;
    }

    /**
     * 根据会员等级返回获取APP首单赠的活动的key
     * @param memberLevel
     * @return
     */
    private Integer getAppFirstGiftKey(Integer memberLevel) {
        if(memberLevel == null) {
            return -1;
        }
        switch (memberLevel){
            case -1:{
                return 1;
            }
            case 0:
            case 1:{
                return 2;
            }
            case 2:
            case 3:{
               return 3;
            }
            default:{
                return -2;
            }
        }
    }

    /**
     * 构建APP首单赠的优惠区间
     * @param productId 赠品编号
     * @return
     */
    private static List<PsCampaignSectionVO> buildCampaignSections(Long productId) {
        List<PsCampaignSectionVO> campaignSectionList = Lists.newArrayList();
        PsCampaignSectionVO sectionVO = new PsCampaignSectionVO();
        sectionVO.setLine(BigDecimal.ZERO);
        sectionVO.setConditionType(1);
        sectionVO.setFactorType(1);
        sectionVO.setFactor(new BigDecimal(1));
        sectionVO.setRanking(1D);
        List<PsCampaignSectionProductVO> campaignSectionProducts = Lists.newArrayList();
        PsCampaignSectionProductVO sectionProductVO = new PsCampaignSectionProductVO();
        sectionProductVO.setProductId(productId);
        sectionProductVO.setPricePrice(BigDecimal.ZERO);
        sectionProductVO.setPriceCount(1);
        campaignSectionProducts.add(sectionProductVO);
        sectionVO.setCampaignSectionProducts(campaignSectionProducts);
        campaignSectionList.add(sectionVO);
        return campaignSectionList;
    }

    /**
     * 构建APP首单赠活动
     * @param accessWayIds 适用平台集合
     * @param memberLevels 适用会员等级集合
     * @param productId 赠品编号
     * @return
     */
    private static PsCampaignVO buildAppFirstGiftCampaign(List<Integer> accessWayIds, List<Integer> memberLevels,
                                                          Long productId) {
        PsCampaignVO appFirstGift = new PsCampaignVO();
        appFirstGift.setId(-1L);
        appFirstGift.setCode("xxx");
        appFirstGift.setName("首单赠");
        appFirstGift.setTitle("首单赠好礼");
        appFirstGift.setState(2);
        Date now = new Date();
        appFirstGift.setStartTime(now);
        appFirstGift.setExpireTime(DateUtils.addYears(now, 5));
        // 全场满赠
        appFirstGift.setProductScopeId(3);
        appFirstGift.setDiscountTypeId(3);
        appFirstGift.setDiscountTypeName("首单赠");
        appFirstGift.setAccessWayIds(accessWayIds);
        appFirstGift.setMemberLevels(memberLevels);
        appFirstGift.setCumulative(0);
        appFirstGift.setCreateTime(now);
        appFirstGift.setApprovalState(4);
        List<PsCampaignSectionVO> campaignSectionList = buildCampaignSections(productId);
        appFirstGift.setCampaignSectionList(campaignSectionList);
        return appFirstGift;
    }

    @Override
    public void queryNewProductCategoryListCron() {
        ProdSearchCond prodSearchCond = new ProdSearchCond();
        prodSearchCond.setFrom(0);
        prodSearchCond.setSize(1000);
        prodSearchCond.setIsNew(true);
        List<PsProductVO> prodList = findByProdSearchCondVO(CHN2018,null,prodSearchCond);
        List<PcsSkuCategoryVO> combinedCategoryList = new ArrayList<>();
        List idList = new ArrayList();
        for (PsProductVO psProductVO : prodList) {
            Boolean combined = psProductVO.getCombined() == null ? false : psProductVO.getCombined();
            if(combined){
                List<String> skuCodes = psProductVO.getSkuCodes();
                combinedCategoryList = pcsSkuCategoryMapper.findCodeBySkuCodeList(skuCodes);
            }else{
                idList.add(psProductVO.getId());
            }
        }
        PcsSkuCategoryCond cond = new PcsSkuCategoryCond();
        cond.setProductIds(idList);
        List<PcsSkuCategoryVO> categoryList = mcPcsSkuCategoryService.findByCondCategoryCron(cond);
        categoryList.addAll(combinedCategoryList);
        List<PcsSkuCategoryVO> categories = new ArrayList<PcsSkuCategoryVO>(new HashSet<PcsSkuCategoryVO>(categoryList));
        redisClient.putCache(CHN2018 + "NewProdCategory", categories);

        List<PcsSkuCategoryVO> combinedCategoryList2 = new ArrayList<>();
        List<PsProductVO> prodList2 = findByProdSearchCondVO(CHN2049,null,prodSearchCond);
        List idList2 = new ArrayList();
        for (PsProductVO psProductVO : prodList2) {
            Boolean combined = psProductVO.getCombined() == null ? false : psProductVO.getCombined();
            if(combined){
                List<String> skuCodes = psProductVO.getSkuCodes();
                combinedCategoryList2 = pcsSkuCategoryMapper.findCodeBySkuCodeList(skuCodes);
            }else{
                idList2.add(psProductVO.getId());
            }
        }
        PcsSkuCategoryCond cond2 = new PcsSkuCategoryCond();
        cond2.setProductIds(idList2);
        List<PcsSkuCategoryVO> categoryList2 = mcPcsSkuCategoryService.findByCondCategoryCron(cond2);
        categoryList2.addAll(combinedCategoryList2);
        List<PcsSkuCategoryVO> categories2 = new ArrayList<PcsSkuCategoryVO>(new HashSet<PcsSkuCategoryVO>(categoryList2));
        redisClient.putCache(CHN2049 + "NewProdCategory", categories2);
    }

    @Override
    public void queryDiscountProductCategoryListCron() {
        ProdSearchCond prodSearchCond = new ProdSearchCond();
        prodSearchCond.setFrom(0);
        prodSearchCond.setSize(1000);
        List<PsProductVO> prodList = findDiscountListByProdSearchCondVO(CHN2018, null, prodSearchCond);
        List idList = new ArrayList();
        List<PcsSkuCategoryVO> combinedCategoryList = new ArrayList<>();
        for (PsProductVO psProductVO : prodList) {
            Boolean combined = psProductVO.getCombined() == null ? false : psProductVO.getCombined();
            if(combined){
                List<String> skuCodes = psProductVO.getSkuCodes();
                combinedCategoryList = pcsSkuCategoryMapper.findCodeBySkuCodeList(skuCodes);
            }else{
                idList.add(psProductVO.getId());
            }
        }
        PcsSkuCategoryCond cond = new PcsSkuCategoryCond();
        cond.setProductIds(idList);
        List<PcsSkuCategoryVO> categoryList = mcPcsSkuCategoryService.findByCondCategoryCron(cond);
        categoryList.addAll(combinedCategoryList);
        List<PcsSkuCategoryVO> categories = new ArrayList<PcsSkuCategoryVO>(new HashSet<PcsSkuCategoryVO>(categoryList));
        redisClient.putCache(CHN2018 +"DiscountProdCategory", categories);

        List<PcsSkuCategoryVO> combinedCategoryList2 = new ArrayList<>();
        List<PsProductVO> prodList2 = findDiscountListByProdSearchCondVO(CHN2049, null, prodSearchCond);
        List idList2 = new ArrayList();
        for (PsProductVO psProductVO : prodList2) {
            Boolean combined = psProductVO.getCombined() == null ? false : psProductVO.getCombined();
            if(combined){
                List<String> skuCodes = psProductVO.getSkuCodes();
                combinedCategoryList2 = pcsSkuCategoryMapper.findCodeBySkuCodeList(skuCodes);
            }else{
                idList2.add(psProductVO.getId());
            }
        }
        PcsSkuCategoryCond cond2 = new PcsSkuCategoryCond();
        cond2.setProductIds(idList2);
        List<PcsSkuCategoryVO> categoryList2 = mcPcsSkuCategoryService.findByCondCategoryCron(cond2);
        categoryList2.addAll(combinedCategoryList2);
        List<PcsSkuCategoryVO> categories2 = new ArrayList<PcsSkuCategoryVO>(new HashSet<PcsSkuCategoryVO>(categoryList2));
        redisClient.putCache(CHN2049 + "DiscountProdCategory",categories2);
    }

    @Override
    public PcsSkuCategoryBrandLabelVO queryNewtCategoryBrandLabel(ProdSearchCond prodSearchCond) {
        PcsSkuCategoryBrandLabelVO vo = new PcsSkuCategoryBrandLabelVO();
//        prodSearchCond.setFrom(0);
//        prodSearchCond.setSize(1000);
        prodSearchCond.setIsNew(true);
        prodSearchCond.setAggs(1);
        String chncode = prodSearchCond.getChannelCode();
//        List<PcsSkuCategoryVO> categoryList = new ArrayList<>();
//        List<PsBrandVO> brandList = new ArrayList<>();
//        List<PsLabelVO> labelList = new ArrayList<>();
        List<PcsBrandVO> brands = new ArrayList<>();
        List<OpLabelVO> labels = new ArrayList<>();
        List<PcsSkuCategoryVO> categorys = new ArrayList<>();

        if(CollectionUtils.isEmpty(prodSearchCond.getBrandIds())){
            List<Long> brandIds= findNewProdListByAggs(chncode, null, prodSearchCond);
            if(CollectionUtils.isNotEmpty(brandIds)){
                PcsBrandCond cond = new PcsBrandCond();
                cond.setBrandIds(brandIds);
                brands = mcPcsBrandService.findByCondIds(cond);
            }
        }
        if(CollectionUtils.isEmpty(prodSearchCond.getLabelIds())) {
            prodSearchCond.setAggs(2);
            List<Long> labelIds= findNewProdListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(labelIds)) {
                OpLabelCond cond = new OpLabelCond();
                cond.setLabelIds(labelIds);
                labels = mcOpLabelService.findByIds(cond);
            }
        }

        //查询分类
        if(CollectionUtils.isEmpty(prodSearchCond.getCategoryCodes())) {
            prodSearchCond.setAggs(3);
            List<Long> categoryIds= findNewProdListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(categoryIds)) {
                PcsSkuCategoryCond cond = new PcsSkuCategoryCond();
                cond.setIds(categoryIds);
                categorys = mcPcsSkuCategoryService.findCategoryByIds(cond);
            }
        }

//        List<PsProductVO> prodList = findByProdSearchCondVO(chncode,null,prodSearchCond);
//        for (PsProductVO psProductVO : prodList) {
//
//            if(CollectionUtils.isEmpty(prodSearchCond.getBrandIds())){
//                if(CollectionUtils.isNotEmpty(psProductVO.getBrands())){
//                    brandList.addAll(psProductVO.getBrands());
//                }
//            }
//            if(CollectionUtils.isEmpty(prodSearchCond.getLabelIds())) {
//                if (CollectionUtils.isNotEmpty(psProductVO.getLabels())) {
//                    labelList.addAll(psProductVO.getLabels());
//                }
//            }
//        }
//        List<PsBrandVO> brandList2 = new ArrayList<PsBrandVO>(new HashSet<PsBrandVO>(brandList));
//        List<PsLabelVO> labelList2 = new ArrayList<PsLabelVO>(new HashSet<PsLabelVO>(labelList));
//        categoryList = redisClient.getCache(chncode + "NewProdCategory");
//        vo.setBrandList(brandList2);
//        vo.setLabelList(labelList2);
        vo.setBrands(brands);
        vo.setLabels(labels);
        vo.setCategoryList(categorys);
        return vo;
    }

    @Override
    public PcsSkuCategoryBrandLabelVO queryDiscountCategoryBrandLabel(ProdSearchCond prodSearchCond) {
        PcsSkuCategoryBrandLabelVO vo = new PcsSkuCategoryBrandLabelVO();
//        prodSearchCond.setFrom(0);
//        prodSearchCond.setSize(1000);
        prodSearchCond.setAggs(1);
        String chncode = prodSearchCond.getChannelCode();
//        List<PcsSkuCategoryVO> categoryList = new ArrayList<>();
//        List<PsBrandVO> brandList = new ArrayList<>();
//        List<PsLabelVO> labelList = new ArrayList<>();
        List<PcsBrandVO> brands = new ArrayList<>();
        List<OpLabelVO> labels = new ArrayList<>();
        List<PcsSkuCategoryVO> categorys = new ArrayList<>();
        //查询品牌
        if(CollectionUtils.isEmpty(prodSearchCond.getBrandIds())){
            List<Long> brandIds= findDiscountListByAggs(chncode, null, prodSearchCond);
            if(CollectionUtils.isNotEmpty(brandIds)){
                PcsBrandCond cond = new PcsBrandCond();
                cond.setBrandIds(brandIds);
                brands = mcPcsBrandService.findByCondIds(cond);
            }
        }
        //查询标签
        if(CollectionUtils.isEmpty(prodSearchCond.getLabelIds())) {
            prodSearchCond.setAggs(2);
            List<Long> labelIds= findDiscountListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(labelIds)) {
                OpLabelCond cond = new OpLabelCond();
                cond.setLabelIds(labelIds);
                labels = mcOpLabelService.findByIds(cond);
            }
        }
        //查询分类，官网不需要分类
        if(!CHN2018.equals(chncode)) {
            if (CollectionUtils.isEmpty(prodSearchCond.getCategoryCodes())) {
                prodSearchCond.setAggs(3);
                List<Long> categoryIds = findDiscountListByAggs(chncode, null, prodSearchCond);
                if (CollectionUtils.isNotEmpty(categoryIds)) {
                    PcsSkuCategoryCond cond = new PcsSkuCategoryCond();
                    cond.setIds(categoryIds);
                    categorys = mcPcsSkuCategoryService.findCategoryByIds(cond);
                }
            }
        }

//        List<PsProductVO> prodList = findDiscountListByProdSearchCondVO(chncode, null, prodSearchCond);
//        for (PsProductVO psProductVO : prodList) {
//            if(CollectionUtils.isEmpty(prodSearchCond.getBrandIds())){
//                if(CollectionUtils.isNotEmpty(psProductVO.getBrands())){
//                    brandList.addAll(psProductVO.getBrands());
//                }
//            }
//            if(CollectionUtils.isEmpty(prodSearchCond.getLabelIds())) {
//                if (CollectionUtils.isNotEmpty(psProductVO.getLabels())) {
//                    labelList.addAll(psProductVO.getLabels());
//                }
//            }
//        }
//        List<PsBrandVO> brandList2 = new ArrayList<PsBrandVO>(new HashSet<PsBrandVO>(brandList));
//        List<PsLabelVO> labelList2 = new ArrayList<PsLabelVO>(new HashSet<PsLabelVO>(labelList));
//        categoryList = redisClient.getCache(chncode + "DiscountProdCategory");
//        vo.setBrandList(brandList2);
//        vo.setLabelList(labelList2);
        vo.setBrands(brands);
        vo.setLabels(labels);
        vo.setCategoryList(categorys);
        return vo;
    }

    @Override
    public PcsSkuCategoryBrandLabelVO queryCrossBorderCategoryBrandLabel(ProdSearchCond prodSearchCond) {
        PcsSkuCategoryBrandLabelVO vo = new PcsSkuCategoryBrandLabelVO();
//        prodSearchCond.setFrom(0);
//        prodSearchCond.setSize(1000);
        prodSearchCond.setIsCrossBorder(true);
        prodSearchCond.setAggs(1);
        String chncode = prodSearchCond.getChannelCode();
//        List<PcsSkuCategoryVO> categoryList = new ArrayList<>();
//        List<PsBrandVO> brandList = new ArrayList<>();
//        List<PsLabelVO> labelList = new ArrayList<>();
        List<PcsBrandVO> brands = new ArrayList<>();
        List<OpLabelVO> labels = new ArrayList<>();
        Long start = System.currentTimeMillis();

        if(CollectionUtils.isEmpty(prodSearchCond.getBrandIds())){
            List<Long> brandIds= findCrossBorderListByAggs(chncode, null, prodSearchCond);
            if(CollectionUtils.isNotEmpty(brandIds)){
                PcsBrandCond cond = new PcsBrandCond();
                cond.setBrandIds(brandIds);
                brands = mcPcsBrandService.findByCondIds(cond);
            }
        }
        if(CollectionUtils.isEmpty(prodSearchCond.getLabelIds())) {
            prodSearchCond.setAggs(2);
            List<Long> labelIds= findCrossBorderListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(labelIds)) {
                OpLabelCond cond = new OpLabelCond();
                cond.setLabelIds(labelIds);
                labels = mcOpLabelService.findByIds(cond);
            }
        }


//        List<PsProductVO> prodList = findCrossBorderListByProdSearchCondVO(chncode, null, prodSearchCond);
//        for (PsProductVO psProductVO : prodList) {
//            if(CollectionUtils.isEmpty(prodSearchCond.getBrandIds())){
//                if(CollectionUtils.isNotEmpty(psProductVO.getBrands())){
//                    brandList.addAll(psProductVO.getBrands());
//                }
//            }
//            if(CollectionUtils.isEmpty(prodSearchCond.getLabelIds())) {
//                if (CollectionUtils.isNotEmpty(psProductVO.getLabels())) {
//                    labelList.addAll(psProductVO.getLabels());
//                }
//            }
//        }

//        List<PsBrandVO> brandList2 = new ArrayList<PsBrandVO>(new HashSet<PsBrandVO>(brandList));
//        List<PsLabelVO> labelList2 = new ArrayList<PsLabelVO>(new HashSet<PsLabelVO>(labelList));
//        categoryList = redisClient.getCache(chncode + "NewProdCategory");
//        vo.setBrandList(brandList2);
//        vo.setLabelList(labelList2);
        vo.setBrands(brands);
        vo.setLabels(labels);
//        vo.setCategoryList(categoryList);
        return vo;
    }

    @Override
    public PcsSkuCategoryBrandLabelVO queryCategoryBrandLabelByCodes(ProdSearchCond prodSearchCond) {
        PcsSkuCategoryBrandLabelVO vo = new PcsSkuCategoryBrandLabelVO();
//        prodSearchCond.setFrom(0);
//        prodSearchCond.setSize(1000);
        prodSearchCond.setAggs(1);
        String chncode = prodSearchCond.getChannelCode();
//        List<PcsSkuCategoryVO> categoryList = new ArrayList<>();
//        List<PsBrandVO> brandList = new ArrayList<>();
//        List<PsLabelVO> labelList = new ArrayList<>();
        List<PcsBrandVO> brands = new ArrayList<>();
        List<OpLabelVO> labels = new ArrayList<>();
        List<PcsSkuCategoryVO> categorys = new ArrayList<>();

        if(CollectionUtils.isEmpty(prodSearchCond.getBrandIds())){
            List<Long> brandIds= findProdListByAggs(chncode, null, prodSearchCond);
            if(CollectionUtils.isNotEmpty(brandIds)){
                PcsBrandCond cond = new PcsBrandCond();
                cond.setBrandIds(brandIds);
                brands = mcPcsBrandService.findByCondIds(cond);
            }
        }
        if(CollectionUtils.isEmpty(prodSearchCond.getLabelIds())) {
            prodSearchCond.setAggs(2);
            List<Long> labelIds= findProdListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(labelIds)) {
                OpLabelCond cond = new OpLabelCond();
                cond.setLabelIds(labelIds);
                labels = mcOpLabelService.findByIds(cond);
            }
        }

        //查询分类,官网不需要分类
        if(!CHN2018.equals(chncode)){
            if(CollectionUtils.isNotEmpty(prodSearchCond.getCategoryCodes())) {
                PcsSkuCategoryCond cond = new PcsSkuCategoryCond();
                cond.setCodes(prodSearchCond.getCategoryCodes());
                categorys = mcPcsSkuCategoryService.findCategoryByIds(cond);
            }
        }

//        List<PsProductVO> prodList = findByProdSearchCondVO(chncode, null, prodSearchCond);
//        for (PsProductVO psProductVO : prodList) {
//            if(CollectionUtils.isEmpty(prodSearchCond.getBrandIds())){
//                if(CollectionUtils.isNotEmpty(psProductVO.getBrands())){
//                    brandList.addAll(psProductVO.getBrands());
//                }
//            }
//            if(CollectionUtils.isEmpty(prodSearchCond.getLabelIds())) {
//                if (CollectionUtils.isNotEmpty(psProductVO.getLabels())) {
//                    labelList.addAll(psProductVO.getLabels());
//                }
//            }
//        }
//        Long end = System.currentTimeMillis();
//        System.out.println(end - start);
//        List<PsBrandVO> brandList2 = new ArrayList<PsBrandVO>(new HashSet<PsBrandVO>(brandList));
//        List<PsLabelVO> labelList2 = new ArrayList<PsLabelVO>(new HashSet<PsLabelVO>(labelList));
//        categoryList = redisClient.getCache(chncode + "NewProdCategory");
//        vo.setBrandList(brandList2);
//        vo.setLabelList(labelList2);
        vo.setBrands(brands);
        vo.setLabels(labels);
        vo.setCategoryList(categorys);
        return vo;
    }

    @Override
    public PcsSkuCategoryBrandLabelVO queryCategoryBrandLabelByBrandId(ProdSearchCond prodSearchCond) {
        PcsSkuCategoryBrandLabelVO vo = new PcsSkuCategoryBrandLabelVO();
        String brandId = prodSearchCond.getBrandId();
        String chncode = prodSearchCond.getChannelCode();
        List<PcsBrandVO> brands = new ArrayList<>();
        List<OpLabelVO> labels = new ArrayList<>();
        List<PcsSkuCategoryVO> categorys = new ArrayList<>();

        if(brandId != null){
            PcsBrandVO brandVO = mcPcsBrandService.findById(Long.valueOf(brandId));
            brands.add(brandVO);
        }

        if(CollectionUtils.isEmpty(prodSearchCond.getLabelIds())) {
            prodSearchCond.setAggs(2);
            List<Long> labelIds = findBrandListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(labelIds)) {
                OpLabelCond cond = new OpLabelCond();
                cond.setLabelIds(labelIds);
                labels = mcOpLabelService.findByIds(cond);
            }
        }

        ///查询分类
        if(CollectionUtils.isEmpty(prodSearchCond.getCategoryCodes())) {
            prodSearchCond.setAggs(3);
            List<Long> categoryIds= findBrandListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(categoryIds)) {
                PcsSkuCategoryCond cond = new PcsSkuCategoryCond();
                cond.setIds(categoryIds);
                categorys = mcPcsSkuCategoryService.findCategoryByIds(cond);
            }
        }

        vo.setBrands(brands);
        vo.setLabels(labels);
        vo.setCategoryList(categorys);
        return vo;
    }

    public List<Long> findCrossBorderListByAggs(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====查询es 参数为 chnCode= {},findCrossBorderListByProdSearchCondVO={}", chnCode, prodSearchCondVO);
        Map<String,Object> selectMap = new HashMap<String,Object>();
        List<Long> cateIds = new ArrayList<>();
        Integer aggs = prodSearchCondVO.getAggs() == null ? 0 : prodSearchCondVO.getAggs();
        List<String> labelIds = prodSearchCondVO.getLabelIds();
        List<String> brandIds = prodSearchCondVO.getBrandIds();
        Boolean isCrossBorder = prodSearchCondVO.getIsCrossBorder() == null ? false : prodSearchCondVO.getIsCrossBorder();
        List<String> cateCodes = prodSearchCondVO.getCategoryCodes();

        List<PcsSkuCategoryVO> categoriesList = new ArrayList<PcsSkuCategoryVO>();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                List<PcsSkuCategoryVO> category = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }
        if(CollectionUtils.isNotEmpty(categoriesList)){
            cateIds = new ArrayList<>(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
        }

        Map sortMap = new LinkedHashMap();
        Map sMap = new HashMap();
        Map sMap2 = new HashMap();
        Map sNestedMap = new HashMap();
        Map map = new HashMap();
        Map paramsMap = new HashMap();
        Map slMap = new HashMap();

        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        if(CollectionUtils.isNotEmpty(cateIds)){
            params.put("frontCategories.categoryId", cateIds);
        }

        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        if(CollectionUtils.isNotEmpty(cateIds)){
            paramsMap.put("categoryIds", cateIds);
        }
        map.put("order", "asc");
        map.put("mode", "min");


        params.put("sort", sortMap);
        if(CollectionUtils.isNotEmpty(brandIds)){
            params.put("brandList.brandId",brandIds);
        }
        if(CollectionUtils.isNotEmpty(labelIds)){
            params.put("labels.labelId",labelIds);
        }
        selectMap.put("isCrossBorder",isCrossBorder);
        selectMap.put("aggs", aggs);

        List<Long> ids = client.findByFieldWithAggsSortMap(params, SearchType.ANDLIKE, selectMap);
        sw.stop();
        LOGGER.info("【海淘商品查询品牌标签接口耗时】 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
        return ids;
    }

    public List<Long> findDiscountListByAggs(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====查询es 参数为 chnCode= {},findDiscountListByProdSearchCondVO={}", chnCode, prodSearchCondVO);
        Map<String,Object> selectMap = new HashMap<String,Object>();
        List<Long> cateIds = new ArrayList<>();
        Integer aggs = prodSearchCondVO.getAggs() == null ? 0 : prodSearchCondVO.getAggs();
        List<String> labelIds = prodSearchCondVO.getLabelIds();
        List<String> brandIds = prodSearchCondVO.getBrandIds();
        List<String> cateCodes = prodSearchCondVO.getCategoryCodes();

        List<PcsSkuCategoryVO> categoriesList = new ArrayList<PcsSkuCategoryVO>();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                List<PcsSkuCategoryVO> category = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }
        if(CollectionUtils.isNotEmpty(categoriesList)){
            cateIds = new ArrayList<>(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
        }

        Map sortMap = new LinkedHashMap();
        Map sMap = new HashMap();
        Map sMap2 = new HashMap();
        Map sNestedMap = new HashMap();
        Map map = new HashMap();
        Map paramsMap = new HashMap();
        Map slMap = new HashMap();

        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        if(CollectionUtils.isNotEmpty(cateIds)){
            params.put("frontCategories.categoryId", cateIds);
        }

        String sortField = prodSearchCondVO.getSortField();
        String sortOrder = prodSearchCondVO.getSortOrder();

        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        map.put("order", "asc");
        map.put("mode", "min");

        params.put("sort", sortMap);
//        params.put("spvList.campaignList.state","1");
//        params.put("spvList.campaignList.discountTypeId","1");
//        params.put("spvList.campaignList.active","1");
        selectMap.put("discountTypeId",1);
//        Date now = new Date();
//        params.put("spvList.campaignList.startTime", QueryBuilders.rangeQuery("spvList.campaignList.startTime").lte(now));
//        params.put("spvList.campaignList.expireTime", QueryBuilders.rangeQuery("spvList.campaignList.expireTime").gt(now));

//        BoolQueryBuilder orQuery = QueryBuilders.boolQuery();
//        orQuery.should(QueryBuilders.termsQuery("campaignList.discountTypeId", "1"));
//        orQuery.should(QueryBuilders.termsQuery("spvList.campaignList.discountTypeId", "1"));
//        params.put("or", orQuery);

        if(CollectionUtils.isNotEmpty(brandIds)){
            params.put("brandList.brandId",brandIds);
        }
        if(CollectionUtils.isNotEmpty(labelIds)){
            params.put("labels.labelId",labelIds);
        }
        selectMap.put("aggs", aggs);

        List<Long> ids = client.findByFieldWithAggsSortMap(params, SearchType.ANDLIKE, selectMap);
        sw.stop();
        LOGGER.info("【折扣标签品牌查询接口耗时】 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
        return ids;
    }

    //是否新上架查询品牌标签 by Lk
    public List<Long> findNewProdListByAggs(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====查询es 参数为 chnCode= {},prodSearchCondVO={}", chnCode, prodSearchCondVO);
        Map<String, Object> selectMap = new HashMap<String, Object>();
        List<String> cateCodes = prodSearchCondVO.getCategoryCodes();
        List<String> labelIds = prodSearchCondVO.getLabelIds();
        List<String> brandIds = prodSearchCondVO.getBrandIds();
        Boolean isNew = prodSearchCondVO.getIsNew() == null ? false : prodSearchCondVO.getIsNew();
        Integer aggs = prodSearchCondVO.getAggs() == null ? 0 : prodSearchCondVO.getAggs();

        Map sortMap = new LinkedHashMap();
        Map sMap = new HashMap();
        Map sMap2 = new HashMap();
        Map sNestedMap = new HashMap();
        Map map = new HashMap();
        Map paramsMap = new HashMap();
        Map slMap = new HashMap();

        List<PcsSkuCategoryVO> categoriesList = new ArrayList<PcsSkuCategoryVO>();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                List<PcsSkuCategoryVO> category = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }

        List<Long> cateIds = new ArrayList<>(categoriesList.size());
        for (PcsSkuCategoryVO category : categoriesList) {
            cateIds.add(category.getId());
        }
        //如果不是最新上架就不返回       返回 所有的    类目 最新的东西
        if(!isNew) {
            if (CollectionUtils.isEmpty(cateIds)) {
                return Collections.emptyList();
            }
        }
        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("frontCategories.categoryId", cateIds);
        //是否新上架
        if (isNew) {
            DateRange dateRange = prodSearchCondVO.getDateRange();
            if (dateRange == null) {
                dateRange = new DateRange();
                //无上架范围默认14天
                Date end = new Date();
                dateRange.setEnd(end);
                Calendar calendar = new GregorianCalendar();
                calendar.setTime(end);
                calendar.add(calendar.DATE, -14);
                Date start = calendar.getTime();
                dateRange.setStart(start);
            }
            params.put("channelProdInfo.createTime", dateRange);
        }

        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        paramsMap.put("categoryIds", cateIds);
        map.put("order", "asc");
        map.put("mode", "min");

        params.put("sort", sortMap);
        if(CollectionUtils.isNotEmpty(brandIds)){
            params.put("brandList.brandId",brandIds);
        }
        if(CollectionUtils.isNotEmpty(labelIds)){
            params.put("labels.labelId",labelIds);
        }
        selectMap.put("aggs", aggs);
        List<Long> ids = client.findByFieldWithAggsSortMap(params, SearchType.ANDLIKE, selectMap);
        sw.stop();
        LOGGER.info("【最新商品接口耗时】 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
        return ids;
    }

    //根据类目查询品牌标签 by Lk
    public List<Long> findProdListByAggs(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====查询es 参数为 chnCode= {},prodSearchCondVO={}", chnCode, prodSearchCondVO);
        Map<String, Object> selectMap = new HashMap<String, Object>();
        List<String> cateCodes = prodSearchCondVO.getCategoryCodes();
        List<String> labelIds = prodSearchCondVO.getLabelIds();
        List<String> brandIds = prodSearchCondVO.getBrandIds();
        Boolean isNew = prodSearchCondVO.getIsNew() == null ? false : prodSearchCondVO.getIsNew();
        Integer aggs = prodSearchCondVO.getAggs() == null ? 0 : prodSearchCondVO.getAggs();

        Map sortMap = new LinkedHashMap();
        Map sMap = new HashMap();
        Map sMap2 = new HashMap();
        Map sNestedMap = new HashMap();
        Map map = new HashMap();
        Map paramsMap = new HashMap();
        Map slMap = new HashMap();

        List<PcsSkuCategoryVO> categoriesList = new ArrayList<PcsSkuCategoryVO>();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                List<PcsSkuCategoryVO> category = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }

        List<Long> cateIds = new ArrayList<>(categoriesList.size());
        for (PcsSkuCategoryVO category : categoriesList) {
            cateIds.add(category.getId());
        }
        //如果不是最新上架就不返回       返回 所有的    类目 最新的东西
        if(!isNew) {
            if (CollectionUtils.isEmpty(cateIds)) {
                return Collections.emptyList();
            }
        }
        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("frontCategories.categoryId", cateIds);

        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        paramsMap.put("categoryIds", cateIds);
        map.put("order", "asc");
        map.put("mode", "min");

        params.put("sort", sortMap);
        if(CollectionUtils.isNotEmpty(brandIds)){
            params.put("brandList.brandId",brandIds);
        }
        if(CollectionUtils.isNotEmpty(labelIds)){
            params.put("labels.labelId",labelIds);
        }
        selectMap.put("aggs", aggs);
        List<Long> ids = client.findByFieldWithAggsSortMap(params, SearchType.ANDLIKE, selectMap);
        sw.stop();
        LOGGER.info("【最新商品接口耗时】 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
        return ids;
    }

    public List<Long> findBrandListByAggs(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====查询es 参数为 chnCode= {},findDiscountListByProdSearchCondVO={}", chnCode, prodSearchCondVO);
        Map<String,Object> selectMap = new HashMap<String,Object>();
        List<Long> cateIds = new ArrayList<>();
        Integer from = prodSearchCondVO.getFrom() != null && prodSearchCondVO.getFrom() > 0 ? (Integer) prodSearchCondVO.getFrom() : 0;
        Integer size = prodSearchCondVO.getSize() != null && prodSearchCondVO.getSize() > 0 ? (Integer) prodSearchCondVO.getSize() : 20;
        Integer aggs = prodSearchCondVO.getAggs() == null ? 0 : prodSearchCondVO.getAggs();
        List<String> labelIds = prodSearchCondVO.getLabelIds();
        List<String> brandIds = new ArrayList<>();
        String brandId = prodSearchCondVO.getBrandId();
        brandIds.add(brandId);
        List<String> cateCodes = prodSearchCondVO.getCategoryCodes();

        List<PcsSkuCategoryVO> categoriesList = new ArrayList<PcsSkuCategoryVO>();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                List<PcsSkuCategoryVO> category = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }
        if(CollectionUtils.isNotEmpty(categoriesList)){
            cateIds = new ArrayList<>(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
        }

        Map sortMap = new LinkedHashMap();
        Map sMap = new HashMap();
        Map sMap2 = new HashMap();
        Map sNestedMap = new HashMap();
        Map map = new HashMap();
        Map paramsMap = new HashMap();
        Map slMap = new HashMap();

        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        if(CollectionUtils.isNotEmpty(cateIds)){
            params.put("frontCategories.categoryId", cateIds);
        }

        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        map.put("order", "asc");
        map.put("mode", "min");

//        if(CollectionUtils.isNotEmpty(categoriesList)) {
//            String fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
//            sortMap.put("_script", map);
//            map.put("script", "frontCategorySort");
//            map.put("params", paramsMap);
//            paramsMap.put("fieldName", fieldName);
//        }

        params.put("sort", sortMap);

        if(CollectionUtils.isNotEmpty(brandIds)){
            params.put("brandList.brandId",brandIds);
        }
        if(CollectionUtils.isNotEmpty(labelIds)){
            params.put("labels.labelId",labelIds);
        }
        selectMap.put("aggs", aggs);

        List<Long> ids = client.findByFieldWithAggsSortMap(params, SearchType.ANDLIKE, selectMap);
        sw.stop();
        LOGGER.info("【商品接口耗时】商品查询列表 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
        return ids;
    }
}
