/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;


import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.merchandise.domain.PcsCustomizeImageDomain;
import com.thebeastshop.pegasus.merchandise.service.McPcsCustomizeImageService;
import com.thebeastshop.pegasus.merchandise.vo.PcsCustomizeImageVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: McPcsBrandServiceImpl.java, v 0.1 2015-07-10 下午4:53
 */

@Service("mcPcsCustomizeImageService")
public class McPcsCustomizeImageServiceImpl implements McPcsCustomizeImageService {

    @Autowired
    private PcsCustomizeImageDomain pcsCustomizeImageDomain;


    @Override
    public Long create(PcsCustomizeImageVO record) {
        return pcsCustomizeImageDomain.create(pcsCustomizeImageDomain.buildFromVO(record));
    }

    @Override
    public boolean update(PcsCustomizeImageVO record) {
        return pcsCustomizeImageDomain.update(pcsCustomizeImageDomain.buildFromVO(record));
    }

    @Override
    public List<PcsCustomizeImageVO> findByCode(String code) {
        List<PcsCustomizeImageVO> list = pcsCustomizeImageDomain.findByCode(code);
        if (CollectionUtils.isNotEmpty(list)) {
            for (PcsCustomizeImageVO vo : list) {
                String attr = vo.getAttr();
                List<List> listObj = JSON.parseObject(attr, List.class);
                vo.setAttrs(listObj);
            }
        }
        return list;
    }
}