/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;


import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.merchandise.cond.PcsCustomizeElementCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsCustomizeElementDomain;
import com.thebeastshop.pegasus.merchandise.service.McPcsCustomizeElementService;
import com.thebeastshop.pegasus.merchandise.vo.PcsCustomizeColorVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsCustomizeElementVO;
import com.thebeastshop.pegasus.merchandise.vo.SupportTypeVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: McPcsBrandServiceImpl.java, v 0.1 2015-07-10 下午4:53
 */

@Service("mcPcsCustomizeElementService")
public class McPcsCustomizeElementServiceImpl implements McPcsCustomizeElementService {

    @Autowired
    private PcsCustomizeElementDomain pcsCustomizeElementDomain;


    @Override
    public Long create(PcsCustomizeElementVO record) {
        return pcsCustomizeElementDomain.create(pcsCustomizeElementDomain.buildFromVO(record));
    }

    @Override
    public boolean update(PcsCustomizeElementVO record) {
        return pcsCustomizeElementDomain.update(pcsCustomizeElementDomain.buildFromVO(record));
    }

    @Override
    public List<PcsCustomizeElementVO> findByCode(String code) {
        return pcsCustomizeElementDomain.findByCode(code);
    }

    @Override
    public List<PcsCustomizeElementVO> findByCond(PcsCustomizeElementCond cond) {
        List<PcsCustomizeElementVO> list = pcsCustomizeElementDomain.findByCond(cond);
        for(PcsCustomizeElementVO vo:list){
            Integer type = vo.getElementType();
            List<PcsCustomizeColorVO> colorVOs = new ArrayList<PcsCustomizeColorVO>();
            String color = vo.getColor();
            List<List<String>> ListObj = JSON.parseObject(color, List.class);
           
            if(CollectionUtils.isNotEmpty(ListObj)){
            	
                for(List<String> listVO : ListObj){
                	int colorListSize = listVO.size();
                    PcsCustomizeColorVO colorVO = new PcsCustomizeColorVO();
                    colorVO.setColorName(listVO.get(0));
                    colorVO.setColorValue(listVO.get(1));
                    if(colorListSize > 2) {
                    	colorVO.setBackgroundColorValue(listVO.get(2));
                        colorVO.setWordColorValue(listVO.get(3));
                    }
                    colorVOs.add(colorVO);
                }
            }
            vo.setColorList(colorVOs);
            if(type != null && "2".equals(type.toString())){
                String supportType =  vo.getSupportType();
                SupportTypeVO supportTypeVO = new SupportTypeVO();
                if(supportType.contains("1")){
                    supportTypeVO.setUppercaseLetter("1");
                }
                if(supportType.contains("0")){
                    supportTypeVO.setLowercaseLetter("1");
                }
                if(supportType.contains("2")){
                    supportTypeVO.setNumber("1");
                }
                if(supportType.contains("3")){
                    supportTypeVO.setExpression("1");
                }
                vo.setSupportTypeVO(supportTypeVO);
            }
        }
        return list;
    }


}