package com.thebeastshop.pegasus.merchandise.price;

import java.math.BigDecimal;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.thebeastshop.pegasus.merchandise.enums.PriceCalTypeEnum;
import com.thebeastshop.pegasus.merchandise.vo.PriceCalResultVO;

/**
 * VIP折扣计算器
 * @author gongjun
 * @since 2016-12-29
 */
public class VIPDiscountPriceCalculator extends AbstractPriceCalculator implements PriceCalculator {

    private BigDecimal discountAmount;

    // 是否有抢购
    private boolean hasRush = false;

    // 是否允许抢购
    private boolean allowVipDiscount = false;

    public VIPDiscountPriceCalculator(PriceCalculator sourcePriceCalculator, BigDecimal discountAmount, boolean hasRush, boolean allowVipDiscount) {
        super(sourcePriceCalculator);
        this.discountAmount = discountAmount;
        this.hasRush = hasRush;
        this.allowVipDiscount = allowVipDiscount;
    }

    @Override
    public BigDecimal calculate(List<PriceCalResultVO> results) {
        BigDecimal targetPrice = getPrevPrice(results);
        
        PriceCalResultVO result = new PriceCalResultVO(); //计算价格结果
    	result.setType(PriceCalTypeEnum.MEMBER_LEVEL);
    	result.setOriginalPrice(targetPrice);
        
        if (allowVipDiscount && !hasRush) {
            targetPrice = targetPrice.multiply(discountAmount);
        }
        
        if(results != null){
        	// 添加计算价格结果
        	result.setFinalPrice(targetPrice);
        	results.add(result);
        }
        return targetPrice;
    }
}
