package com.thebeastshop.pegasus.merchandise.price;

import com.thebeastshop.pegasus.merchandise.service.impl.McPsProductServiceImpl;
import com.thebeastshop.pegasus.merchandise.vo.PriceCalResultVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.List;

/**
 * 特殊商品活动价格计算器
 * @author gongjun
 * @since 2016-12-29
 */
public class SpecialProductPriceCalculator extends AbstractSpecialPriceCalculator implements PriceCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger(McPsProductServiceImpl.class);

    private String productCode;

    private PsCampaignVO campaign;

    public SpecialProductPriceCalculator(PriceCalculator sourcePriceCalculator, String productCode, PsCampaignVO campaign) {
        super(sourcePriceCalculator);
        this.productCode = productCode;
        this.campaign = campaign;
    }

    @Override
    public BigDecimal calculate(List<PriceCalResultVO> results) {
        BigDecimal targetPrice = getPrevPrice(results);
        Long campaignId = campaign.getId();
        LOGGER.info("===列表价参数为 campaignId= {},code= {}", campaignId, productCode);
        if (specialNum.equals(String.valueOf(campaignId)) && specialProdMap.containsKey(productCode)) {
            targetPrice = specialProdMap.get(productCode);
            LOGGER.info("===特殊列表价参数为 targetPrice= {}", targetPrice);
        }
        else if(special481Num.equals(String.valueOf(campaignId)) && special481ProdMap.containsKey(productCode)) {
            targetPrice = special481ProdMap.get(productCode);
            LOGGER.info("===481特殊列表价参数为 targetPrice= {}", targetPrice);
        } else if(special482Num.equals(String.valueOf(campaignId)) && special482ProdMap.containsKey(productCode)) {
            targetPrice = special482ProdMap.get(productCode);
            LOGGER.info("===482特殊列表价参数为 targetPrice= {}", targetPrice);
        } else if(special463Num.equals(String.valueOf(campaignId)) && special463ProdMap.containsKey(productCode)) {
            targetPrice = special463ProdMap.get(productCode);
            LOGGER.info("===463特殊列表价参数为 targetPrice= {}", targetPrice);
        } else if(special503Num.equals(String.valueOf(campaignId)) && special503ProdMap.containsKey(productCode)) {
            targetPrice = special503ProdMap.get(productCode);
            LOGGER.info("===503特殊列表价参数为 targetPrice= {}", targetPrice);
        } else if(special574Num.equals(String.valueOf(campaignId)) && special574ProdMap.containsKey(productCode)) {
            targetPrice = special574ProdMap.get(productCode);
            LOGGER.info("===574特殊列表价参数为 targetPrice= {}", targetPrice);
        } else if(special590Num.equals(String.valueOf(campaignId)) && special590ProdMap.containsKey(productCode)) {
            targetPrice = special590ProdMap.get(productCode);
            LOGGER.info("===590特殊列表价参数为 targetPrice= {}", targetPrice);
        } else if(special591Num.equals(String.valueOf(campaignId)) && special591ProdMap.containsKey(productCode)) {
            targetPrice = special591ProdMap.get(productCode);
            LOGGER.info("===591特殊列表价参数为 targetPrice= {}", targetPrice);
        } else if(special592Num.equals(String.valueOf(campaignId)) && special592ProdMap.containsKey(productCode)) {
            targetPrice = special592ProdMap.get(productCode);
            LOGGER.info("===592特殊列表价参数为 targetPrice= {}", targetPrice);
        } else if(special594Num.equals(String.valueOf(campaignId)) && special594ProdMap.containsKey(productCode)) {
            targetPrice = special594ProdMap.get(productCode);
            LOGGER.info("===594特殊列表价参数为 targetPrice= {}", targetPrice);
        }
        // 特殊处理等双十一以后会删掉 end
        return targetPrice;
    }

}
