package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsWatermarkCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsWatermarkMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsClPsDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsWatermarkDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuWatermark;
import com.thebeastshop.pegasus.merchandise.model.ProdWatermark;
import com.thebeastshop.pegasus.merchandise.vo.PcsWatermarkVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.ProductWatermarkVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.management.OperationsException;
import java.util.*;

/**
 * @author gongjun
 * @since 2016-08-30
 */
@Component("pcsWatermarkDomain")
public class PcsWatermarkDomainImpl implements PcsWatermarkDomain {

    private final Logger log = LoggerFactory.getLogger(PcsWatermarkDomainImpl.class);

    @Autowired
    private PcsWatermarkMapper pcsWatermarkMapper;

    @Autowired
    private PcsClPsDomain pcsClPsDomain;

    @Override
    @Transactional
    public int addIcon(PcsWatermarkVO watermarkVO) {
        int ret = pcsWatermarkMapper.insert(watermarkVO);
        if (ret > 0) {
            Random random = new Random();
            int n = random.nextInt(99);
            watermarkVO.setCode("W0" + n + watermarkVO.getId());
            pcsWatermarkMapper.update(watermarkVO);
        }
        return ret;
    }

    @Override
    @Transactional
    public int updateIcon(PcsWatermarkVO watermarkVO) {
        int ret = pcsWatermarkMapper.update(watermarkVO);
        if (ret > 0) {
            List<String> codeList = pcsWatermarkMapper.querySkuCodeListByWatermarkId(watermarkVO.getId());
            pcsClPsDomain.saveSkuCodeList(codeList, 1);
        }
        return ret;
    }

    @Override
    @Transactional
    public int updateSkuWatrmarkByCodeList(String skuCode, List<String> codeList) {
        Map<String, Object> params = new HashMap<>();
        params.put("skuCode", skuCode);
        params.put("nowCodeList", codeList);

        // 删除无用的关联
        List<PcsSkuWatermark> toDeleteSkuWatermarkList = pcsWatermarkMapper.queryToDeleteSkuWatermarkList(params);
        if (!toDeleteSkuWatermarkList.isEmpty()) {
            List<Long> toDelIdList = new ArrayList<>();
            for (int i = 0; i < toDeleteSkuWatermarkList.size(); i++) {
                PcsSkuWatermark toDelSkuWatermark = toDeleteSkuWatermarkList.get(i);
                toDelIdList.add(toDelSkuWatermark.getId());
            }
            Map<String, Object> delParams = new HashMap<>();
            delParams.put("ids", toDelIdList);
            pcsWatermarkMapper.deleteSkuWatermarkByIds(delParams);
        }

        List<PcsSkuWatermark> skuWatermarkList = new ArrayList<>();
        for (int i = 0; i < codeList.size(); i++) {
            String code = codeList.get(i);
            PcsSkuWatermark skuWatermark = new PcsSkuWatermark();
            skuWatermark.setSkuCode(skuCode);
            skuWatermark.setWatermarkCode(code);
            skuWatermarkList.add(skuWatermark);
        }

        // 添加或更新关联
        int ret = 0;
        for (int i = 0; i < skuWatermarkList.size(); i++) {
            PcsSkuWatermark skuWatermark = skuWatermarkList.get(i);
            skuWatermark.setSort(i);
            ret += saveOrUpdateSkuWatermark(skuWatermark);
        }
        return ret;
    }

    @Override
    @Transactional
    public int updateProdWatrmarkByCodeList(ProdSkuVO prod, List<String> watermarkCodeList,boolean isEmptyBeforeUpdate){
        Map<String, Object> params = new HashMap<>();
        //params.put("nowCodeList", watermarkCodeList);

        // 客户关系管理--PROD维护时，需要先清空
        if (isEmptyBeforeUpdate){
            // 删除无用的关联 每次更新时，先解除原先的关联关系
            params.put("productId", prod.getProdId());
            List<ProdWatermark> toDeleteProdWatermarkList = pcsWatermarkMapper.queryToDeleteProductWatermarkList(params);
            if (!toDeleteProdWatermarkList.isEmpty()) {
                List<Long> toDelIdList = new ArrayList<>();
                for (int i = 0; i < toDeleteProdWatermarkList.size(); i++) {
                    ProdWatermark toDelProdWatermark = toDeleteProdWatermarkList.get(i);
                    toDelIdList.add(toDelProdWatermark.getId());
                }
                Map<String, Object> delParams = new HashMap<>();
                delParams.put("ids", toDelIdList);
                delParams.put("active", 0);
                delParams.put("isDelete", 1);
                // pcsWatermarkMapper.deleteProdWatermarkByIds(delParams);
                // 逻辑删除
                int count = pcsWatermarkMapper.updateProdWatermarkActiveByIds(delParams);
                log.info("删除："+count);
            }
        }

        List<ProdWatermark> prodWatermarkList = new ArrayList<>();
        List<String>  validStartTimeList = prod.getValidStartTimeList();
        List<String>  validEndTimeList = prod.getValidEndTimeList();
        
        for (int i = 0; i < watermarkCodeList.size(); i++) {
            String code = watermarkCodeList.get(i);
            ProdWatermark prodWatermark = new ProdWatermark();
            prodWatermark.setProductCode(prod.getProdCode());
            prodWatermark.setProductId(prod.getProdId());
            prodWatermark.setWatermarkCode(code);
            //prod界面维护水印有效期
            if(EmptyUtil.isNotEmpty(validStartTimeList)) {
            	 prodWatermark.setValidStartTime(EmptyUtil.isEmpty(validStartTimeList.get(i)) ? 
            			 null : DateUtil.parse(validStartTimeList.get(i), "yyyy-MM-dd HH:mm:ss"));
            } else {
            	 prodWatermark.setValidStartTime(prod.getValidStartTime());
            }
            if(EmptyUtil.isNotEmpty(validEndTimeList)) {
            	prodWatermark.setValidEndTime(EmptyUtil.isEmpty(validStartTimeList.get(i)) ? 
           			 	null : DateUtil.parse(validEndTimeList.get(i), "yyyy-MM-dd HH:mm:ss"));
            } else {
            	prodWatermark.setValidEndTime(prod.getValidEndTime());
            }
            
            prodWatermarkList.add(prodWatermark);
        }

        // 添加或更新  产品水印关联表
        int ret = 0;
        for (int i = 0; i < prodWatermarkList.size(); i++) {
            ProdWatermark prodWatermark = prodWatermarkList.get(i);
            prodWatermark.setSort(i);
            try {
                ret = saveOrUpdateProdWatermark(prodWatermark);
            } catch (OperationsException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    @Transactional
    public int deleteProdWatermarkByIds(List<String> idList) {
        Map<String, Object> params = new HashMap<>();
        params.put("ids", idList);
        params.put("active", 0);
        params.put("isDelete", 1);
        //int ret = pcsWatermarkMapper.deleteProdWatermarkByIds(params);
        // 逻辑删除  active=0
        int ret = pcsWatermarkMapper.updateProdWatermarkActiveByIds(params);
        return ret;
    }

    @Override
    public int saveOrUpdateSkuWatermark(PcsSkuWatermark skuWatermark) {
        int count = pcsWatermarkMapper.countOfSkuWatermark(skuWatermark);
        if (count == 0) {
            return pcsWatermarkMapper.insertSkuWatermark(skuWatermark);
        }
        return pcsWatermarkMapper.updateSkuWatermark(skuWatermark);
    }

    @Override
    public int saveOrUpdateProdWatermark(ProdWatermark prodWatermark) throws OperationsException {
        int count = pcsWatermarkMapper.countOfProdWatermark(prodWatermark);
        // ProdWatermark pw = pcsWatermarkMapper.findProductWatermark(prodWatermark);
        Date validStartTime = prodWatermark.getValidStartTime();
        Date validEndTime = prodWatermark.getValidEndTime();
        Date now = new Date();
        //水印有效期以外的设置不可用
        if((EmptyUtil.isNotEmpty(validStartTime) &&  now.before(validStartTime))
        		|| EmptyUtil.isNotEmpty(validEndTime) &&  now.after(validEndTime)) {
        	prodWatermark.setActive(0);
        } else {
        	prodWatermark.setActive(1);
        }
        prodWatermark.setIsDelete((short) 0);
        if (count == 0) {
            count = pcsWatermarkMapper.insertProdWatermark(prodWatermark);
            log.info("add record:"+prodWatermark.toString());
            if (count == 0){
                throw new OperationsException("新增失败!");
            }
            return 1;// 新增
        }
        // prodWatermark.setId(pw.getId());
        
        count = pcsWatermarkMapper.updateProdWatermark(prodWatermark);
        if (count == 0){
            throw new OperationsException("更新失败!");
        }
        log.info("update record:"+prodWatermark.toString());
        return 2;// 更新
    }

    @Override
    public PcsWatermarkVO findWatermarkById(Long id) {
        return pcsWatermarkMapper.findWatermarkById(id);
    }

    @Override
    public List<PcsWatermarkVO> queryWatermarkList(PcsWatermarkCond cond) {
        return pcsWatermarkMapper.queryWatermarkList(cond);
    }

    @Override
    public List<ProdSkuVO> queryProdWatermarkList(PcsWatermarkCond cond) {
        return pcsWatermarkMapper.queryProdWatermarkList(cond);
    }

    @Override
    public List<ProdSkuVO> queryProdWatermarkListByParams(List<String> idList) {
        Map<String, Object> params = new HashMap<>();
        params.put("ids", idList);

        List<ProdSkuVO> prodWatermarkList = pcsWatermarkMapper.queryProdWatermarkListByParams(params);
        return prodWatermarkList;
    }

    @Override
    public List<ProdSkuVO> querySkuListByProd(Long prodId) {
        return pcsWatermarkMapper.querySkuListByProd(prodId);
    }

    @Override
    public List<ProdSkuVO> queryProdListBySkuCode(String code) {
        return pcsWatermarkMapper.queryProdListBySkuCode(code);
    }

    @Override
    public ProdSkuVO queryProductByProdId(Long prodId) {
        return pcsWatermarkMapper.queryProductByProdId(prodId);
    }

    @Override
    public Map<String, ProductWatermarkVO> seleckWatermarkByProductCodes(List<String> productCodes) {
        log.info("===通过productcodes 查询可以使用的水印标签的参数为 productCodes={} ",productCodes);
        Map<String, ProductWatermarkVO> returnMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(productCodes)){
            List<ProductWatermarkVO> productWatermarkVOs = pcsWatermarkMapper.seleckWatermarkByProductCodes(productCodes);
            if(CollectionUtils.isNotEmpty(productWatermarkVOs)){
                for(ProductWatermarkVO productWatermarkVO : productWatermarkVOs){
                    returnMap.put(productWatermarkVO.getProductCode(),productWatermarkVO);
                }
            }
        }
        return returnMap;
    }

	@Override
	public int setProdWatermarkValidityByIds(Map<String, Object> params) {
		return pcsWatermarkMapper.setProdWatermarkValidityByIds(params);
	}

	@Override
	public int checkProdWatermarkHasValid(String watermarkCode, String skuCode) {
        //查询字母开头的skuCode报错 NullPointerException
        try{
            int ret = pcsWatermarkMapper.checkProdWatermarkHasValid(watermarkCode, skuCode);
            return ret;
        }catch (NullPointerException e){
            return 0;
        }
	}

    @Override
    public int updateActiveTrueWatermark() {
        return pcsWatermarkMapper.updateActiveTrueWatermark();
    }

    @Override
    public int updateActiveFalseWatermark() {
        return pcsWatermarkMapper.updateActiveFalseWatermark();
    }
}
