/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.model.OpChannel;
import com.thebeastshop.pegasus.merchandise.cond.OpChannelCond;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;

import java.util.List;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:28
 */
public interface OpChannelDomain extends BaseDomain<OpChannelVO, OpChannel> {

    boolean create(OpChannel channel);

    boolean update(OpChannel channel);

    boolean deleteById(Long id);

    OpChannel findById(Long id);

    /**
     * 根据条件查找渠道
     *
     * @param cond
     * @return 渠道列表
     */
    public List<OpChannel> findChannelByCond(String cond);

    /**
     * 条件查询 渠道
     *
     * @param cond
     * @return
     */
    List<OpChannel> findByCriteria(OpChannelCond cond);

    /**
     * 根据编码查找
     *
     * @param code
     * @return
     */
    OpChannel findByCode(String code);

    /**
     * 所有渠道
     *
     * @return
     */
    List<OpChannel> findAll();
    /**
     * 所有鲜花店
     *
     * @return
     */
    List<OpChannel> selectAllFlowerShops();
    
    
    List<OpChannel> findChannelByType(int type);

    /**
     * 根据渠道类型查找所有记录
     *
     * @param type
     *
     * @return
     */
    List<ChannelSelector> findByChannelType(Integer type);
}
