package com.thebeastshop.pegasus.merchandise.domain;

import java.util.List;

/**
 * 公用领域类
 * @author gongjun
 * @since 2016-10-17
 */
public interface BaseDomain<VO, MO> {

    /**
     * model转vo
     *
     * @param record
     * @return
     */
    VO buildFromModel(MO record);

    /**
     * model list 转vo list
     *
     * @param record
     * @return
     */
    List<VO> buildFromModelList(List<MO> record);

    /**
     * vo转model
     *
     * @param vo
     * @return
     */
    MO buildFromVO(VO vo);


    /**
     * vo list 转model list
     *
     * @param vo
     * @return
     */
    List<MO> buildFromVOList(List<VO> vo);

}
