package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.thebeastshop.pegasus.merchandise.cond.PcsWatermarkCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsWatermarkDomain;
import com.thebeastshop.pegasus.merchandise.service.McPcsWatermarkService;
import com.thebeastshop.pegasus.merchandise.vo.PcsWatermarkVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.ProductWatermarkVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.*;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2016/5/6.
 */
@Path("/watermark")
@Consumes({ContentType.APPLICATION_JSON_UTF_8})
@Produces({ContentType.APPLICATION_JSON_UTF_8})
@Service("mcPcsWatermarkService")
public class McPcsWatermarkServiceImpl implements McPcsWatermarkService {

    private static Logger log = LoggerFactory.getLogger(McPcsWatermarkServiceImpl.class);

    @Autowired
    private PcsWatermarkDomain pcsWatermarkDomain;

    @POST
    @Override
    public Long addWatermark(PcsWatermarkVO watermarkVO) {
        pcsWatermarkDomain.addIcon(watermarkVO);
        return watermarkVO.getId();
    }

    @PUT
    @Override
    public int updateWatermark(PcsWatermarkVO watermarkVO) {
        return pcsWatermarkDomain.updateIcon(watermarkVO) ;
    }

    @Override
    public int updateSkuWatrmarkByCodeList(String skuCode, List<String> codeList) {
        return pcsWatermarkDomain.updateSkuWatrmarkByCodeList(skuCode, codeList);
    }

    @Override
    public int updateProdWatrmarkByCodeList(ProdSkuVO prod, List<String> watermarkCodeList, boolean isEmptyBeforeUpdate) {
        return pcsWatermarkDomain.updateProdWatrmarkByCodeList(prod, watermarkCodeList,isEmptyBeforeUpdate);
    }

    @GET
    @Path("{id:\\d+}")
    @Override
    public PcsWatermarkVO findWatermarkById(@PathParam("id") Long id) {
        log.info("-- findWatermarkById -- id:{}", id);
        return pcsWatermarkDomain.findWatermarkById(id);
    }

    @GET
    @Path("list/params")
    @Override
    public List<PcsWatermarkVO> queryWatermarkList(Map<String, Object> params) {
        return pcsWatermarkDomain.queryWatermarkList(params);
    }

    @GET
    @Path("list/cond")
    @Override
    public List<ProdSkuVO> queryProdWatermarkList(PcsWatermarkCond cond) {
//        log.info("-- queryProdWatermarkList -- id:{}", JSON.toJSONString(cond));
        return pcsWatermarkDomain.queryProdWatermarkList(cond);
    }

    @GET
    @Path("list/prod/{id}")
    @Override
    public List<ProdSkuVO> querySkuListByProd(@PathParam("id") Long prodId) {
        return pcsWatermarkDomain.querySkuListByProd(prodId);
    }

    @GET
    @Path("list/sku_code/{skuCode}")
    @Override
    public List<ProdSkuVO> queryProdListBySkuCode(@PathParam("skuCode") String code) {
        return pcsWatermarkDomain.queryProdListBySkuCode(code);
    }

    @Override
    public int deleteProdWatermarkByIds(List<String> idList) {
        return pcsWatermarkDomain.deleteProdWatermarkByIds(idList);
    }

    @Override
    public List<ProdSkuVO> queryProdWatermarkListByParams(List<String> params) {
        return pcsWatermarkDomain.queryProdWatermarkListByParams(params);
    }

    @Override
    public ProdSkuVO queryProductByProdId(Long prodId) {
        return pcsWatermarkDomain.queryProductByProdId(prodId);
    }

    @Override
    public Map<String, ProductWatermarkVO> seleckWatermarkByProductCodes(List<String> productCodes) {
        return pcsWatermarkDomain.seleckWatermarkByProductCodes(productCodes);
    }

	@Override
	public int setProdWatermarkValidityByIds(Map<String, Object> params) {
		Date validStartTime = (Date) params.get("validStartTime");
		Date validEndTime = (Date) params.get("validEndTime");
		Date now = new Date();
		//ˮӡ��Ч���ѹ�����û���������öԵ�ǰprod������
		if(validStartTime.after(now) || validEndTime.before(now)) {
			params.put("active", 0);
		} else {
			params.put("active", 1);
		}
		return pcsWatermarkDomain.setProdWatermarkValidityByIds(params);
	}

	@Override
	public int checkProdWatermarkHasValid(String watermarkCode, String skuCode) {
		return pcsWatermarkDomain.checkProdWatermarkHasValid(watermarkCode, skuCode);
	}

    @Override
    public void updateActiveWatermark() {
        pcsWatermarkDomain.updateActiveFalseWatermark();
        pcsWatermarkDomain.updateActiveTrueWatermark();
    }

}
