package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.thebeastshop.pegasus.merchandise.cond.PcsTagCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsTagDomain;
import com.thebeastshop.pegasus.merchandise.service.McPcsTagService;
import com.thebeastshop.pegasus.merchandise.vo.PcsTagVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.*;
import java.util.*;

/**
 * @author gongjun
 * @since 2016-05-09
 */
@Path("/tag")
@Consumes({ContentType.APPLICATION_JSON_UTF_8})
@Produces({ContentType.APPLICATION_JSON_UTF_8})
@Service("mcPcsTagService")
public class McPcsTagServiceImpl implements McPcsTagService {

	@Autowired
	private PcsTagDomain pcsTagDomain;

	@POST
	@Override
	public Long addTag(PcsTagVO tagVO) {
		pcsTagDomain.addTag(tagVO);
		return tagVO.getId();
	}

	@PUT
	@Override
	public int updateTag(PcsTagVO tagVO) {
		return pcsTagDomain.updateTag(tagVO);
	}

	@GET
	@Path("{id:\\d+}")
	@Override
	public PcsTagVO findTagById(@PathParam("id") Long id) {
		return pcsTagDomain.findTagById(id);
	}
	
	@Override
	public List<PcsTagVO> queryTagListByProdId(Long prodId) {
		return pcsTagDomain.queryTagListByProdId(prodId);
	}

	@Override
	public List<PcsTagVO> queryTagList(Map<String, Object> params) {
		return pcsTagDomain.queryTagList(params);
	}

	@Override
	public List<ProdSkuVO> queryProdTagListByTagCode(PcsTagCond cond) {
		return pcsTagDomain.queryProdTagListByTagCode(cond);
	}

	@Override
	public List<ProdSkuVO> queryProdSkuListByTagParams(List<String> params) {
		return pcsTagDomain.queryProdSkuListByTagParams(params);
	}


	@Override
	public int updateProdTagByCodeList(ProdSkuVO prod, List<String> codeList, boolean isEmptyBeforeUpdate) {
		return pcsTagDomain.updateProdTagByCodeList(prod, codeList, isEmptyBeforeUpdate);
	}

	@DELETE
	@Override
	public int deleteProdTagByIds(@FormParam("idList") List<String> idList) {
		return pcsTagDomain.deleteProdTagByIds(idList);
	}
	
}
