package com.thebeastshop.pegasus.merchandise.service.impl;

import java.util.*;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsCustomizeElementMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsCustomizeElementDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsCustomizeImageDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuSalesPriceChangeDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.PcsCustomizeElement;
import com.thebeastshop.pegasus.merchandise.model.PcsCustomizeImage;
import com.thebeastshop.pegasus.merchandise.model.PcsSku;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCostPriceChange;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuSalesPriceChange;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.*;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.apache.commons.collections4.CollectionUtils;

/**
 * @author gongjun
 * @since 2016-08-30
 */
@Service("mcPcsSkuService")
public class McPcsSkuServiceImpl implements McPcsSkuService {

    @Autowired
    private PcsSkuDomain pcsSkuDomain;
    @Autowired
    private PcsCustomizeElementDomain pcsCustomizeElementDomain;
    @Autowired
    private PcsCustomizeImageDomain pcsCustomizeImageDomain;
    @Autowired
    PcsCustomizeElementMapper pcsCustomizeElementMapper;

    @Autowired
    private PcsSkuSalesPriceChangeDomain pcsSkuSalesPriceChangeDomain;
    
    @Override
    public Long create(PcsSkuVO vo) {
        Long id  = pcsSkuDomain.create(pcsSkuDomain.buildFromVO(vo));
        PcsSku pcsSku = pcsSkuDomain.findById(id);
        vo.setCode(pcsSku.getCode());
        if(vo.getCanCustomize() == 1) {
            createCustomize(vo);
        }
        return id;
    }

    public void createCustomize(PcsSkuVO vo) {
        List<PcsCustomizeElementVO> colorElementList = vo.getCustomizeVO().getColorElementList();
        List<PcsCustomizeElementVO> wordElementList = vo.getCustomizeVO().getWordElementList();
        List<PcsCustomizeImageVO> customizeImageList= vo.getCustomizeVO().getCustomizeImageList();
        Map<Long,String> elementIdMap = new HashMap<Long,String>();
        for(PcsCustomizeElementVO obj:colorElementList){
            List<PcsCustomizeColorVO> colorList = obj.getColorList();
            List<List> newAttrList = new ArrayList<List>();
            if(CollectionUtils.isNotEmpty(colorList)){
                for(PcsCustomizeColorVO colorVO:colorList){
                    List list = new ArrayList();
                    list.add(colorVO.getColorName());
                    list.add(colorVO.getColorValue());
                    list.add(colorVO.getBackgroundColorValue());
                    list.add(colorVO.getWordColorValue());
                    newAttrList.add(list);
                }
            }
            String colorJson = JSON.toJSON(newAttrList).toString();
            PcsCustomizeElement pcsCustomizeElement = pcsCustomizeElementDomain.buildFromVO(obj);
            pcsCustomizeElement.setColor(colorJson);
            pcsCustomizeElement.setSkuCode(vo.getCode());
            if(obj.getElementType() == 1){
                pcsCustomizeElement.setIsmatch(true);
            }else{
                pcsCustomizeElement.setIsmatch(false);
            }
            Long id = pcsCustomizeElementDomain.create(pcsCustomizeElement);
            if(obj.getElementType() == 1){
                elementIdMap.put(id, pcsCustomizeElement.getDisplayName());
            }
        }
        for(PcsCustomizeElementVO obj:wordElementList){
            List<PcsCustomizeColorVO> colorList = obj.getColorElement().getColorList();
            SupportTypeVO supportTypeVO = obj.getSupportTypeVO();
            String temp = "";
            String temp1 = supportTypeVO.getUppercaseLetter() == null ? "" : "1";
            String temp2 = supportTypeVO.getNumber() == null ? "" : "2";
            String temp3 = supportTypeVO.getExpression() == null ? "" : "3";
            String temp4 = supportTypeVO.getLowercaseLetter() == null ? "" : "0";
            temp = temp1 + "," + temp4 + "," + temp2 + "," +temp3;
            PcsCustomizeElement pcsCustomizeElement = pcsCustomizeElementDomain.buildFromVO(obj);
            pcsCustomizeElement.setSkuCode(vo.getCode());
            pcsCustomizeElement.setIsmatch(false);
            pcsCustomizeElement.setSupportType(temp);
            Long id = pcsCustomizeElementDomain.create(pcsCustomizeElement);
            PcsCustomizeElement child = new PcsCustomizeElement();
            List<List> newAttrList = new ArrayList<List>();
            if(CollectionUtils.isNotEmpty(colorList)){
                for(PcsCustomizeColorVO colorVO:colorList){
                    List list = new ArrayList();
                    list.add(colorVO.getColorName());
                    list.add(colorVO.getColorValue());
                    newAttrList.add(list);
                }
            }
            String colorJson = JSON.toJSON(newAttrList).toString();
            child.setSkuCode(vo.getCode());
            child.setColor(colorJson);
            child.setParentId(id.intValue());
            child.setDisplayName(obj.getColorElement().getDisplayName());
            child.setCreateUserId(obj.getCreateUserId());
            child.setIsmatch(false);
            pcsCustomizeElementDomain.create(child);
        }
        for(PcsCustomizeImageVO obj:customizeImageList){
            PcsCustomizeImage pcsCustomizeImage = pcsCustomizeImageDomain.buildFromVO(obj);
            pcsCustomizeImage.setSkuCode(vo.getCode());
            List<List> attrList = obj.getAttrs();
            List<List> newAttrList = new ArrayList<List>();
            Boolean flag = false;
            for(List list2:attrList){
                for(Long elementId:elementIdMap.keySet()){
                    String value = elementIdMap.get(elementId);
                    String displayName = list2.get(0).toString();
                    String color = list2.get(1).toString();
                    if(value.equals(displayName)){
                        List list = new ArrayList();
                        list.add(elementId);
                        list.add(color);
                        newAttrList.add(list);
                        flag = true;
                        break;
                    }
                }
            }
            if(!flag) {
                for (List list2 : attrList) {
                    for (Long elementId : elementIdMap.keySet()) {
                        String value = elementIdMap.get(elementId);
                        String displayName = list2.get(0).toString();
                        String color = list2.get(1).toString();
                        PcsCustomizeElement pcsCustomizeElement = pcsCustomizeElementMapper.selectByPrimaryKey(Long.valueOf(displayName));
                        displayName = pcsCustomizeElement.getDisplayName();
                        if (value.equals(displayName)) {
                            List list = new ArrayList();
                            list.add(elementId);
                            list.add(color);
                            newAttrList.add(list);
                            break;
                        }
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(newAttrList)) {
                String json = JSON.toJSON(newAttrList).toString();
                pcsCustomizeImage.setAttr(json);
                pcsCustomizeImageDomain.create(pcsCustomizeImage);
            }
        }

    }

    public void updateCustomize(List<PcsCustomizeElementVO> pcsCustomizeElementVOList,List<PcsCustomizeImageVO> pcsCustomizeImageVOList){
        for(PcsCustomizeElementVO ceVO:pcsCustomizeElementVOList){
            PcsCustomizeElement pcsCustomizeElement = new PcsCustomizeElement();
            pcsCustomizeElement.setId(ceVO.getId());
            pcsCustomizeElement.setActive(false);
            pcsCustomizeElementDomain.update(pcsCustomizeElement);
        }
        for(PcsCustomizeImageVO ciVO:pcsCustomizeImageVOList){
            PcsCustomizeImage pcsCustomizeImage = new PcsCustomizeImage();
            pcsCustomizeImage.setId(ciVO.getId());
            pcsCustomizeImage.setActive(false);
            pcsCustomizeImageDomain.update(pcsCustomizeImage);
        }
    }

    @Override
    public List<Long> createSkus(List<PcsSkuVO> list) {
        List<PcsSku> skuList = new ArrayList<>();
        for (PcsSkuVO pcsSkuVO : list) {
            pcsSkuVO.setSkuStatus(PcsSku.SKU_STATUS_DRAFT);
            skuList.add(pcsSkuDomain.buildFromVO(pcsSkuVO));
        }
        return pcsSkuDomain.createSkus(skuList);
    }


    @Override
    public boolean update(PcsSkuVO vo) {
        pcsSkuDomain.update(pcsSkuDomain.buildFromVO(vo));
        //上传SKU图片不走定制
        if(vo.getOptType() != 1) {
            List<PcsCustomizeElementVO> pcsCustomizeElementVOList = pcsCustomizeElementDomain.findByCode(vo.getCode());
            List<PcsCustomizeImageVO> pcsCustomizeImageVOList = pcsCustomizeImageDomain.findByCode(vo.getCode());

            if (CollectionUtils.isEmpty(pcsCustomizeElementVOList)) {
                if (vo.getCanCustomize() != null && vo.getCanCustomize() == 1) {
                    createCustomize(vo);
                }
            } else {
                updateCustomize(pcsCustomizeElementVOList, pcsCustomizeImageVOList);
                if (vo.getCanCustomize() != null && vo.getCanCustomize() == 1) {
                    createCustomize(vo);
                }
            }
        }
        return true;
    }

    @Override
    public PcsSkuVO findById(long id) {
        PcsSku record = pcsSkuDomain.findById(id);
        PcsSkuVO vo = pcsSkuDomain.buildFromModel(record);
        return vo;
    }

    @Override
    public PcsSkuVO findByCode(String code) {
        return pcsSkuDomain.findByCode(code);
    }

    @Override
    public PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories) {
        return pcsSkuDomain.findByCode(code, widthFrontCategories, withBackCategories);
    }

    @Override
    public PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories, boolean withBuyerName) {
        return pcsSkuDomain.findByCode(code, widthFrontCategories, withBackCategories, withBuyerName);
    }

    @Override
    public List<Map<String, Object>> findSkuCanSaleAndCanSeeByChannelCode(String channelCode) {
        return pcsSkuDomain.findSkuCanSaleAndCanSeeByChannelCode(channelCode);
    }

    @Override
    public Map<String, Object> findSkuCanSaleAndCanSeeInfo(String channelCode, String skuCode) {
        return pcsSkuDomain.findSkuCanSaleAndCanSeeInfo(channelCode, skuCode);
    }

    @Override
    public List<PcsSkuVO> findByNameOrCode(String nameCode) {
        return pcsSkuDomain.findByNameOrCode(nameCode);
    }

    @Override
    public List<PcsSkuVO> findByCond(PcsSkuCond cond) {
        return pcsSkuDomain.findByCond(cond);
    }

    @Override
    public List<PcsSkuVO> findByCondForExport(PcsSkuCond cond) {
        return pcsSkuDomain.findByCondForExport(cond);
    }

    @Override
    public List<PcsSkuVO> findSkuTagByCond(PcsSkuCond cond) {
        return pcsSkuDomain.findSkuTagByCond(cond);
    }

    @Override
    public Boolean canUpdateSkuSalesPrice(String code) {
        PcsSkuVO vo = pcsSkuDomain.findByCode(code);
        if (EmptyUtil.isNotEmpty(vo)) {
            return pcsSkuDomain.canUpdateSalesPrice(code);
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_NOTHING, "无效的code");
        }
    }

    @Override
    public Boolean auditSkuSalesPriceChange(String code, Boolean isPass, Integer type) {
        return pcsSkuDomain.auditSkuSalesPriceChange(code, isPass, type);
    }

    @Override
    public PcsSkuSalesPriceChangeVO findSkuSalesPriceChangeByCodeAndProcessing(String code) {
        return pcsSkuDomain.findSkuSalesPriceChangeByCodeAndProcessing(code);
    }

    @Override
    public List<PcsSkuVO> findSkuByCodes(List<String> codes) {
        return pcsSkuDomain.findByCodes(codes);
    }

    @Override
    public List<PcsSkuVO> findSkuByCodes(List<String> codes, boolean withCategories) {
        return pcsSkuDomain.findByCodes(codes, withCategories);
    }

    @Override
    public List<PcsSkuVO> findSkuByCodesWithCategories(List<String> codes, boolean withCategories) {
        return pcsSkuDomain.findByCodes(codes, withCategories);
    }

    @Override
    public Boolean convertSku(PcsSkuVO sku, long skuCustomMadeId) {
        PcsSku pcsSku = pcsSkuDomain.buildFromVO(sku);
        return pcsSkuDomain.convertSku(pcsSku, skuCustomMadeId);
    }

    @Override
    public boolean transferSku(List<String> skuCodes, Long buyerId) {
        return pcsSkuDomain.transferSku(skuCodes,buyerId);
    }

    @Override
    public List<PcsSkuInfoVO> allSkuInfo() {
        return pcsSkuDomain.allSkuInfo();
    }

    @Override
    public PcsSkuInfoVO findStockByCode(String skuCode) {
        return pcsSkuDomain.findStockByCode(skuCode);
    }

    @Override
    public List<PcsSkuVO> findChannelSkuForNoDistribute(PcsSkuCond cond) {
        return pcsSkuDomain.findChannelSkuForNoDistribute(cond);
    }

    @Override
    public void setSkuChannel(List<String> skuCodeList, List<String> channelCodeList, Long operatorId) {
        pcsSkuDomain.setSkuChannel(skuCodeList,channelCodeList,operatorId);
    }

    @Override
    public List<PcsSkuVO> findSkuByIds(List<Long> ids) {
        return pcsSkuDomain.findSkuByIds(ids);
    }

    @Override
    public Boolean canUpdateCostPrice(String code) {
        PcsSkuVO vo = pcsSkuDomain.findByCode(code);
        if (EmptyUtil.isNotEmpty(vo)) {
            return pcsSkuDomain.canUpdateCostPrice(code);
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_NOTHING, "无效的code");
        }

    }

    @Override
    public Boolean canUpdateSupplier(String code) {
        PcsSkuVO vo = pcsSkuDomain.findByCode(code);
        if (EmptyUtil.isNotEmpty(vo)) {
            return pcsSkuDomain.canUpdateSupplier(code);
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_NOTHING, "无效的code");
        }
    }

    @Override
    public long countSkuByCond(PcsSkuCond cond) {
        return pcsSkuDomain.countSkuByCond(cond);
    }

    @Override
    public String getCrossBorderFlagByCodes(List<String> codes) {
        return pcsSkuDomain.getCrossBorderFlagByCodes(codes);
    }

    @Override
    public Integer updateSkuCategoryNameByCode(String skuCategoryName, String skuCode) {
        return pcsSkuDomain.updateSkuCategoryNameByCode(skuCategoryName, skuCode);
    }

    @Override
    public List<Integer> getSalesPriceByCodes(List<String> codes) {
        return pcsSkuDomain.getSalesPriceByCodes(codes);
    }

    @Override
    public List<Map> getSalesPriceByProdId(Long prodId) {
        return pcsSkuDomain.getSalesPriceByProdId(prodId);
    }

    @Override
    public List<PcsSkuVO> findSkuAuditByIds(List<Long> ids) {
        return pcsSkuDomain.findSkuAuditByIds(ids);
    }

    @Override
    public List<PcsSkuBarcodeVO> selectByBarCode(String barCode) {
        return pcsSkuDomain.selectByBarCode(barCode);
    }

	@Override
	public List<PcsSkuVO> findSkuBySupplierId(Long supplierId) {
		return pcsSkuDomain.findSkuBySupplierId(supplierId);
	}

	@Override
	public boolean updatePrdcRecipeSkuCost(PcsSkuVO vo) {
		int skuStatus = vo.getSkuStatus();
		String skuCode = vo.getCode();
		PcsSku pcsSku = new PcsSku();
		pcsSku.setId(vo.getId());
		switch(skuStatus) {
			case 0://草稿
				pcsSku.setCostPrice(vo.getCostPrice());
				pcsSku.setOldCostPrice(vo.getCostPrice());
				break;
				
			case 1://待财务审核
				pcsSku.setSkuStatus(1);
				List<PcsSkuCostPriceChange> costPriceChangeList = pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(skuCode, 1);
				if(EmptyUtil.isNotEmpty(costPriceChangeList)) {
					PcsSkuCostPriceChange pcsSkuCostPriceChange = costPriceChangeList.get(0);
					pcsSkuCostPriceChange.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
					pcsSkuCostPriceChange.setChangeTime(new Date());
					pcsSkuCostPriceChange.setNewPrice(vo.getCostPrice());
					pcsSkuSalesPriceChangeDomain.updateCostPriceChange(pcsSkuCostPriceChange);
				}
				break;
				
			case 2://已驳回
				pcsSku.setSkuStatus(1);
				PcsSkuCostPriceChange pcsSkuCostPriceChange = new PcsSkuCostPriceChange();
				pcsSkuCostPriceChange.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
				pcsSkuCostPriceChange.setNewPrice(vo.getCostPrice());
				pcsSkuCostPriceChange.setSkuCode(skuCode);
				pcsSkuCostPriceChange.setChangeTime(new Date());
				pcsSkuSalesPriceChangeDomain.addCostPriceChange(pcsSkuCostPriceChange);
				break;
				
			case 3://待品类经理审核
				pcsSku.setSkuStatus(1);
				costPriceChangeList = pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(skuCode, 4);
				if(EmptyUtil.isNotEmpty(costPriceChangeList)) {
					pcsSkuCostPriceChange = costPriceChangeList.get(0);
					pcsSkuCostPriceChange.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
					pcsSkuCostPriceChange.setChangeTime(new Date());
					pcsSkuCostPriceChange.setNewPrice(vo.getCostPrice());
					pcsSkuSalesPriceChangeDomain.updateCostPriceChange(pcsSkuCostPriceChange);
				}
				break;
				
			case 9://可用
				pcsSku.setSkuStatus(1);
				PcsSkuCostPriceChange pcsSkuCostPriceChange1 = new PcsSkuCostPriceChange();
				pcsSkuCostPriceChange1.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
				pcsSkuCostPriceChange1.setNewPrice(vo.getCostPrice());
				pcsSkuCostPriceChange1.setSkuCode(skuCode);
				pcsSkuCostPriceChange1.setChangeTime(new Date());
				pcsSkuSalesPriceChangeDomain.addCostPriceChange(pcsSkuCostPriceChange1);
				break;
				
				default:
					break;
				
		}
		pcsSku.setOldCostPrice(vo.getCostPrice());
		pcsSkuDomain.updateSku(pcsSku);
		return false;
	}

	@Override
	public int updateSku(PcsSkuVO vo) {
		PcsSku pcsSku = new PcsSku();
		BeanUtils.copyProperties(vo, pcsSku);
		//耗材成本减少
		if(vo.getOptType() == 3) {
			int skuStatus = vo.getSkuStatus();
			List<PcsSkuCostPriceChange> costPriceChangeList = pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(vo.getCode(), skuStatus ==1 ? 1 : 4);
				if(EmptyUtil.isNotEmpty(costPriceChangeList)) { 
					PcsSkuCostPriceChange pcsSkuCostPriceChange = costPriceChangeList.get(0);
					pcsSkuCostPriceChange.setChangeTime(new Date());
					pcsSkuCostPriceChange.setNewPrice(vo.getCostPrice());
					pcsSkuSalesPriceChangeDomain.updateCostPriceChange(pcsSkuCostPriceChange);
			}
				pcsSku.setOldCostPrice(vo.getCostPrice());
		}
		return pcsSkuDomain.updateSku(pcsSku);
	}

	@Override
	public boolean costPriceNeedApproval(PcsSkuVO vo) {
		PcsSku pcsSku = new PcsSku();
		BeanUtils.copyProperties(vo, pcsSku);
		return pcsSkuDomain.costPriceNeedApproval(pcsSku);
	}

	@Override
	public Integer getMonthlyByCodes(List<String> skuCodes) {
		return pcsSkuDomain.getMonthlyByCodes(skuCodes);
	}
}
