package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuQcImgDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuQcImg;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuQcImgService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuQcImgVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.*;
import java.util.List;

/**
 * @author gongjun
 * @since 2016-08-30
 */
@Path("/sku/qc_img")
@Consumes({ContentType.APPLICATION_JSON_UTF_8})
@Produces({ContentType.APPLICATION_JSON_UTF_8})
@Service("mcPcsSkuQcImgService")
public class McPcsSkuQcImgServiceImpl implements McPcsSkuQcImgService {

    @Autowired
    private PcsSkuQcImgDomain pcsSkuQcImgDomain;

    @POST
    @Override
    public Long createQcImg(PcsSkuQcImgVO vo) {
        PcsSkuQcImg pcsSkuQcImg = BeanUtil.buildFrom(vo, PcsSkuQcImg.class);
        pcsSkuQcImgDomain.createQcImg(pcsSkuQcImg);
        return pcsSkuQcImg.getId();
    }

    @DELETE
    @Path("sku_code/{skuCode}")
    @Override
    public int deleteQcImgBySkuCode(@PathParam("skuCode") String skuCode) {
        return pcsSkuQcImgDomain.deleteQcImgBySkuCode(skuCode);
    }

    @GET
    @Path("sku_code/{skuCode}")
    @Override
    public List<PcsSkuQcImgVO> findPcsSkuQcImgBySkuCode(@PathParam("skuCode") String skuCode) {
        List<PcsSkuQcImg> skuQcImgs = pcsSkuQcImgDomain.findPcsSkuQcImgBySkuCode(skuCode);
        List<PcsSkuQcImgVO> vos = BeanUtil.buildListFrom(skuQcImgs, PcsSkuQcImgVO.class);
        return vos;
    }
}
