/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.OpChnCanSaleProdCond;
import com.thebeastshop.pegasus.merchandise.domain.OpChnCanSaleProdDomain;
import com.thebeastshop.pegasus.merchandise.model.OpChnCanSaleProd;
import com.thebeastshop.pegasus.merchandise.service.McOpChnCanSaleProdService;
import com.thebeastshop.pegasus.merchandise.vo.OpChnCanSaleProdVO;
import com.thebeastshop.pegasus.merchandise.vo.UpdateOpChnCanSaleProdVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Roy.Chen
 * @version $Id: OpChannelCanSaleSkuServiceImpl.java, v 0.1 2015-08-07 15:25
 */
@Service("mcOpChnCanSaleProdService")
public class McOpChnCanSaleProdServiceImpl implements McOpChnCanSaleProdService {
    @Autowired
    private OpChnCanSaleProdDomain opChannelCanSaleSkuDomain;

    public List<OpChnCanSaleProdVO> findChannelListByProdIds(List<Long> prodIds) {
        return opChannelCanSaleSkuDomain.findByProdIds(prodIds);
    }

    @Override
    public List<Long> findProdIdBySkuCode(List<String> skuCodes) {
        return null;
    }

    @Override
    public Long create(OpChnCanSaleProdVO prod) {
        OpChnCanSaleProd OpChnCanSaleProd = BeanUtil.buildFrom(prod, OpChnCanSaleProd.class);
        opChannelCanSaleSkuDomain.create(OpChnCanSaleProd);
        return OpChnCanSaleProd.getId();
    }

    @Override
    public boolean update(UpdateOpChnCanSaleProdVO prod) {
        OpChnCanSaleProd opChnCanSaleProd = BeanUtil.buildFrom(prod, OpChnCanSaleProd.class);
        return opChannelCanSaleSkuDomain.update(opChnCanSaleProd);
    }

    @Override
    public List<OpChnCanSaleProdVO> findByChannelCode(String channelCode) {
        List<OpChnCanSaleProd> list = opChannelCanSaleSkuDomain.findByChannelCode(channelCode);
        return BeanUtil.buildListFrom(list,OpChnCanSaleProdVO.class);
    }

    @Override
    public boolean deleteById(Long id) {
        return opChannelCanSaleSkuDomain.deleteById(id);
    }

    @Override
    public void deleteByChannelCode(String channelCode) {
        opChannelCanSaleSkuDomain.deleteByChannelCode(channelCode);
    }

    @Override
    public List<OpChnCanSaleProdVO> findByChannelCodeProdId(String channelCode, Long prodId) {
        List<OpChnCanSaleProd> list = opChannelCanSaleSkuDomain.findByChannelCodeProdId(channelCode, prodId);
        return BeanUtil.buildListFrom(list,OpChnCanSaleProdVO.class);
    }

    @Override
    public List<OpChnCanSaleProdVO> findByCond(OpChnCanSaleProdCond cond) {
        List<OpChnCanSaleProdVO> list = opChannelCanSaleSkuDomain.findByCond(cond);
        return list;
    }

    @Override
    public List<OpChnCanSaleProdVO> findByProdIds(List<Long> prodIds) {
        List<OpChnCanSaleProdVO> list = opChannelCanSaleSkuDomain.findByProdIds(prodIds);
        return list;
    }

    @Override
    public OpChnCanSaleProdVO findById(Long id) {
        return opChannelCanSaleSkuDomain.findById(id);
    }

    @Override
    public void deleteByProdId(Long prodId) {
        opChannelCanSaleSkuDomain.deleteByProdId(prodId);
    }
}
