package com.thebeastshop.pegasus.merchandise.service;

import java.util.List;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.merchandise.IService.IProductUpDownRecordService;
import com.thebeastshop.pegasus.merchandise.vo.ProdUpDownOperVO;
import com.thebeastshop.scm.dao.ChnCanSaleProdDao;
import com.thebeastshop.scm.dao.ProductUpDownRecordDao;
import com.thebeastshop.scm.dao.ProductUpDownTimerDao;
import com.thebeastshop.scm.po.ChnCanSaleProd;
import com.thebeastshop.scm.po.ProductUpDownRecord;
import com.thebeastshop.scm.po.ProductUpDownTimer;

@Service
public class ProductUpDownRecordService implements IProductUpDownRecordService {
	protected final Logger log = LoggerFactory.getLogger(getClass());
	
	@Resource private ProductUpDownRecordDao productUpDownRecordDao;
	@Resource private ProductUpDownTimerDao productUpDownTimerDao;
	@Resource private ChnCanSaleProdDao chnCanSaleProdDao;
	
	public void upDownOperation(ProdUpDownOperVO vo) {
		if (vo.getTimerOperTime() == null) {//修改上下操作并保存上下架记录
    		chnCanSaleProdDao.updateOnshelfById(vo.getCanSaleProdId(), ChnCanSaleProd.OnShelf.byValue(vo.getOnShelf()));
    		ProductUpDownRecord opProdctUpDownRecord = vo.toProdctUpDownRecord();
    		productUpDownRecordDao.insert(opProdctUpDownRecord);
		} else {//保存定时记录,定时任务操作
			ProductUpDownTimer productUpDownTimer = vo.toOpProductUpDownTimer();
			productUpDownTimerDao.insert(productUpDownTimer);
		}		
	}

	public List<ProductUpDownRecord> byChnCanSaleProdId(Integer canSaleProdId) {
		return productUpDownRecordDao.byChnCanSaleProdId(canSaleProdId);
	}

	
	

}
