package com.thebeastshop.pegasus.merchandise.price;

import com.thebeastshop.pegasus.merchandise.enums.PriceCalTypeEnum;
import com.thebeastshop.pegasus.merchandise.vo.PriceCalResultVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 生日折扣计算器
 * @author lk
 * @since 2016-12-29
 */
public class BDDiscountPriceCalculator extends AbstractPriceCalculator implements PriceCalculator {

    private BigDecimal bdDiscountAmount;

    // 是否有抢购
    private boolean hasRush = false;

    // 是否允许抢购
    private boolean allowBdDiscount = false;

    public BDDiscountPriceCalculator(PriceCalculator sourcePriceCalculator, BigDecimal bdDiscountAmount, boolean hasRush, boolean allowBdDiscount) {
        super(sourcePriceCalculator);
        this.bdDiscountAmount = bdDiscountAmount;
        this.hasRush = hasRush;
        this.allowBdDiscount = allowBdDiscount;
    }

    @Override
    public BigDecimal calculate(List<PriceCalResultVO> results) {
        BigDecimal targetPrice = getPrevPrice(results);
        
        PriceCalResultVO result = new PriceCalResultVO(); //计算价格结果
    	result.setType(PriceCalTypeEnum.BIRTHDAY);
    	result.setOriginalPrice(targetPrice);
        
        if (allowBdDiscount && !hasRush) {
            targetPrice = targetPrice.multiply(bdDiscountAmount);
        }
        
        if(results != null){
        	// 添加计算价格结果
        	result.setFinalPrice(targetPrice);
        	results.add(result);
        }
        return targetPrice;
    }
}
