package com.thebeastshop.pegasus.merchandise.price;

import com.thebeastshop.pegasus.merchandise.exception.PublicException;
import com.thebeastshop.pegasus.merchandise.vo.PriceCalResultVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 价格计算器抽象类
 * @author gongjun
 * @since 2016-12-29
 */
public abstract class AbstractPriceCalculator implements PriceCalculator {

    protected PriceCalculator sourcePriceCalculator;


    public AbstractPriceCalculator(PriceCalculator sourcePriceCalculator) {
        this.sourcePriceCalculator = sourcePriceCalculator;
    }

    @Override
    public boolean getHasRush() {
        return false;
    }

    @Override
    public PriceCalculator getPrevPriceCalculator() {
        return sourcePriceCalculator;
    }

    @Override
    public BigDecimal getPrevPrice(List<PriceCalResultVO> results) {
        if (sourcePriceCalculator == null) {
            throw new PublicException("价格计算异常：原价为空");
        }
        BigDecimal targetPrice = sourcePriceCalculator.calculate(results);
        return targetPrice;
    }
}
