package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.OpSpvAttributeValueMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpSpvAttributeValueDomain;
import com.thebeastshop.pegasus.merchandise.model.OpSpvAttributeValue;
import com.thebeastshop.pegasus.merchandise.model.OpSpvAttributeValueExample;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 * @author gongjun
 * @since 2016-10-20
 */
@Component("opSpvAttributeValueDomain")
public class OpSpvAttributeValueDomainImpl implements OpSpvAttributeValueDomain {

    @Autowired
    private OpSpvAttributeValueMapper opSpvAttributeValueMapper;

    @Override
    public int create(OpSpvAttributeValue opSpvAttributeValue) {
        opSpvAttributeValue.setCreateTime(new Date());
        opSpvAttributeValue.setUpdateTime(new Date());
        return opSpvAttributeValueMapper.insert(opSpvAttributeValue);
    }

    @Override
    public OpSpvAttributeValue getBySpvId(Long spvId) {
        OpSpvAttributeValueExample example = new OpSpvAttributeValueExample();
        example.createCriteria().andSpvIdEqualTo(spvId);
        List<OpSpvAttributeValue> list = opSpvAttributeValueMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public int createOrUpdateBySpvId(Long spvId, OpSpvAttributeValue opSpvAttributeValue) {
        OpSpvAttributeValue oldOpSpvAttributeValue = getBySpvId(spvId);
        if (oldOpSpvAttributeValue != null) {
            oldOpSpvAttributeValue.setAttrs(opSpvAttributeValue.getAttrs());
            oldOpSpvAttributeValue.setUpdateTime(new Date());
            return opSpvAttributeValueMapper.updateByPrimaryKeySelective(oldOpSpvAttributeValue);
        }
        opSpvAttributeValue.setSpvId(spvId);
        return create(opSpvAttributeValue);
    }

}
