/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.merchandise.cond.OpSpvCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCombinationCond;
import com.thebeastshop.pegasus.merchandise.constants.ProductConstants;
import com.thebeastshop.pegasus.merchandise.dao.OpProdSkuMapper;
import com.thebeastshop.pegasus.merchandise.domain.*;
import com.thebeastshop.pegasus.merchandise.exception.OperationException;
import com.thebeastshop.pegasus.merchandise.exception.OperationExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.*;
import com.thebeastshop.pegasus.merchandise.vo.*;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.*;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:27
 */
@Component("opProdSkuDomain")
public class OpProdSkuDomainImpl extends AbstractBaseDomain<OpSpvVO, OpProdSku> implements OpProdSkuDomain {

    @Autowired
    private OpProdSkuMapper opProdSkuMapper;

    @Autowired
    private PcsSkuDomain pcsSkuDomain;

    @Autowired
    private PcsSkuCombinationDomain pcsSkuCombinationDomain;

    @Autowired
    private OpSpvAttributeValueDomain opSpvAttributeValueDomain;

    @Autowired
    private OpSpvPriceChangeDomain opSpvPriceChangeDomain;


    @Override
    public boolean create(OpProdSku prodSku) {
        if (prodSku.getMinAmount() == null) {
            // 默认最小起售数为1
            prodSku.setMinAmount(1);
        }
        validateProdSku(prodSku.getProductId(), prodSku.getSkuCode());
        return opProdSkuMapper.insert(prodSku) != 0;
    }

    /**
     * 创建组合SPV
     * @author gongjun
     * @since 2016-10-20
     *
     * @param attrIdMap
     * @param spvVO
     * @return
     */
    @Override
    public boolean createCombinedSpv(Map<String, OpAttributeVO> attrIdMap, OpSpvVO spvVO,Integer prodStatus) {

        // 设置组合为true
        spvVO.setCombined(true);
        OpProdSku spv = buildFromVO(spvVO);
        spv.setActive(true);
        // 创建SPV
        int id = opProdSkuMapper.insert(spv);
        if (id == 0) {
            return false;
        }

        if(prodStatus == ProductConstants.PROD_WAIT_STATUS){
            OpSpvPriceChange spvPriceChange = new OpSpvPriceChange();
            spvPriceChange.setIsCurrent(1);
            spvPriceChange.setSpvId(spv.getId());
            spvPriceChange.setSalesPrice(spvVO.getSalesPrice());
            spvPriceChange.setChangeStatus(ProductConstants.SPV_PRICE_CHANGE_STATUS);
            spvPriceChange.setCreateTime(new Date());
            spvPriceChange.setUpdateTime(new Date());
            opSpvPriceChangeDomain.create(spvPriceChange);
        }

        // 循环遍历创建SKU组合
        List<PcsSkuCombinationVO> skuCombinationList = spvVO.getSkuCombinationList();
        String attrJsonText = spvVO.getAttrJSONText();
        List<List<Long>> spvAttrsJson = new ArrayList<>();

        // 判断是否带有SPV属性信息
        if (StringUtils.isNotEmpty(attrJsonText) && MapUtils.isNotEmpty(attrIdMap)) {
            JSONArray attrMapList = JSON.parseArray(attrJsonText);
            for (int i = 0; i < attrMapList.size(); i++) {
                JSONObject attrMap = attrMapList.getJSONObject(i);
                String attrName = attrMap.getString("attrName");
                String attrValueText = attrMap.getString("attrValue");
                OpAttributeVO attrVO = attrIdMap.get(attrName);
                if (attrVO == null) continue;
                OpAttributeValueVO attrValueVO = attrVO.getAttributeValueMap().get(attrValueText);
                if (attrValueVO == null) continue;
                List<Long> attrJson = new ArrayList<>();
                attrJson.add(attrVO.getId());
                attrJson.add(attrValueVO.getId());
                spvAttrsJson.add(attrJson);
            }

            // 创建SPV关联属性值
            OpSpvAttributeValue spvAttributeValue = new OpSpvAttributeValue();
            String attrsJsonText = JSON.toJSONString(spvAttrsJson);
            spvAttributeValue.setAttrs(attrsJsonText);
            opSpvAttributeValueDomain.createOrUpdateBySpvId(spv.getId(), spvAttributeValue);

            // 创建Sku Combination
            if (CollectionUtils.isNotEmpty(skuCombinationList)) {
                for (PcsSkuCombinationVO skuCombinationVO : skuCombinationList) {
                    skuCombinationVO.setSpvId(spv.getId());
                    OpAttributeVO attrVO = attrIdMap.get(skuCombinationVO.getAttrName());
                    OpAttributeValueVO attrValueVO = attrVO.getAttributeValueMap().get(skuCombinationVO.getAttrValue());
                    PcsSkuCombination skuCombination = pcsSkuCombinationDomain.buildFromVO(skuCombinationVO);
                    skuCombination.setGroupName(attrVO.getGroupName());
                    String attrs = JSONArray.toJSONString(
                            Arrays.asList(new Object[] {
                                    Arrays.asList(new Object [] {attrVO.getId(), attrValueVO.getId()})
                            })
                    );
                    skuCombination.setAttrs(attrs);
                    pcsSkuCombinationDomain.create(skuCombination);
                }
            }

        }
        return true;
    }

    /**
     * 编辑组合SPV
     * @author likai
     * @since 2016-11-2
     *
     * @param spvVO
     * @return
     */
    @Override
    public boolean updateCombinedSpv(OpSpvVO spvVO,int temProdStatus,int prodStatus) {
        Long spvId = spvVO.getId();
        //驳回和草稿状态 编辑提交草稿 只更新产品部表
        if((temProdStatus == ProductConstants.PROD_DRAFT_STATUS && prodStatus == ProductConstants.PROD_DRAFT_STATUS) ||
                (temProdStatus == ProductConstants.PROD_NOPASS_STATUS && prodStatus == ProductConstants.PROD_DRAFT_STATUS)) {
//            OpProdSku prodSku = new OpProdSku();
//            prodSku.setId(spvId);
//            prodSku.setSalesPrice(spvVO.getSalesPrice());
//            int flag = opProdSkuMapper.updateByPrimaryKeySelective(prodSku);
//            if (flag < 1) {
//                return false;
//            }
            //审批通过 编辑提交审核 更新产品部表插入价格临时表
        }else if(temProdStatus == ProductConstants.PROD_PASS_STATUS){
            OpSpvPriceChange obj = opSpvPriceChangeDomain.getCurrentAduitPrice(spvId);
            BigDecimal salesPrice = obj.getSalesPrice();
            Map<String,Object> map = new HashMap<String,Object>();
            map.put("spvId",spvId);
            opSpvPriceChangeDomain.updateBySpvId(map);

            OpSpvPriceChange spvPriceChange = new OpSpvPriceChange();
            spvPriceChange.setIsCurrent(1);
            spvPriceChange.setSpvId(spvId);
            spvPriceChange.setSalesPrice(spvVO.getSalesPrice());
            spvPriceChange.setLastSalesPrice(salesPrice);
            spvPriceChange.setChangeStatus(ProductConstants.SPV_PRICE_CHANGE_STATUS);
            spvPriceChange.setCreateTime(new Date());
            spvPriceChange.setUpdateTime(new Date());
            opSpvPriceChangeDomain.create(spvPriceChange);
            //驳回 编辑提交审核 更新产品部表插入价格临时表
        }else if(temProdStatus == ProductConstants.PROD_NOPASS_STATUS && prodStatus == ProductConstants.PROD_WAIT_STATUS) {
//            OpProdSku prodSku = new OpProdSku();
//            prodSku.setId(spvId);
//            prodSku.setSalesPrice(spvVO.getSalesPrice());
//            int flag = opProdSkuMapper.updateByPrimaryKeySelective(prodSku);
//            if (flag < 1) {
//                return false;
//            }

            OpSpvPriceChange obj = opSpvPriceChangeDomain.getCurrentAduitPrice(spvId);
            BigDecimal salesPrice = obj.getSalesPrice();

            //更新原记录价格为失效
            Map<String,Object> map = new HashMap<String,Object>();
            map.put("spvId", spvId);
            opSpvPriceChangeDomain.updateBySpvId(map);

            OpSpvPriceChange spvPriceChange = new OpSpvPriceChange();
            spvPriceChange.setIsCurrent(1);
            spvPriceChange.setSpvId(spvId);
            spvPriceChange.setSalesPrice(spvVO.getSalesPrice());
            spvPriceChange.setLastSalesPrice(salesPrice);
            spvPriceChange.setChangeStatus(ProductConstants.SPV_PRICE_NOPASS_STATUS);
            spvPriceChange.setCreateTime(new Date());
            spvPriceChange.setUpdateTime(new Date());
            opSpvPriceChangeDomain.create(spvPriceChange);
        }else{
//            OpProdSku prodSku = new OpProdSku();
//            prodSku.setId(spvId);
//            prodSku.setSalesPrice(spvVO.getSalesPrice());
//            int flag = opProdSkuMapper.updateByPrimaryKeySelective(prodSku);
//            if (flag < 1) {
//                return false;
//            }

            OpSpvPriceChange spvPriceChange = new OpSpvPriceChange();
            spvPriceChange.setIsCurrent(1);
            spvPriceChange.setSpvId(spvId);
            spvPriceChange.setSalesPrice(spvVO.getSalesPrice());
            spvPriceChange.setChangeStatus(ProductConstants.SPV_PRICE_CHANGE_STATUS);
            spvPriceChange.setCreateTime(new Date());
            spvPriceChange.setUpdateTime(new Date());
            opSpvPriceChangeDomain.create(spvPriceChange);
        }

        List<PcsSkuCombinationVO> skuCombinationList = spvVO.getSkuCombinationList();
        // 更新Sku Combination
        if (CollectionUtils.isNotEmpty(skuCombinationList)) {
            for (PcsSkuCombinationVO skuCombinationVO : skuCombinationList) {
                List<PcsSkuCombination> list = pcsSkuCombinationDomain.findBySpvIdAndCode(spvVO.getId(), skuCombinationVO.getSubSkuCode());
                PcsSkuCombination skuCombination = list.get(0);
                skuCombination.setQuantity(skuCombinationVO.getQuantity());
                boolean flag2 = pcsSkuCombinationDomain.update(skuCombination);
                if(!flag2) return flag2;
            }
        }

        return true;
    }

    @Override
    public boolean update(OpProdSku prodSku) {
        return opProdSkuMapper.updateByPrimaryKeySelective(prodSku) != 0;
    }

    @Override
    public boolean deleteById(Long id) {
        return opProdSkuMapper.deleteByPrimaryKey(id) != 0;
    }

    @Override
    public List<OpProdSku> findByProdId(Long prodId) {
        OpProdSkuExample example = new OpProdSkuExample();
        example.createCriteria().andProductIdEqualTo(prodId);
        example.setOrderByClause("SKU_CODE");
        return opProdSkuMapper.selectByExample(example);
    }

    @Override
    public boolean deleteByProdId(Long prodId) {
        OpProdSkuExample example = new OpProdSkuExample();
        example.createCriteria().andProductIdEqualTo(prodId);
        return opProdSkuMapper.deleteByExample(example) != 0;
    }

    @Override
    public List<OpProdSku> findByProdIds(List<Long> prodIds) {
        OpProdSkuExample example = new OpProdSkuExample();
        example.createCriteria().andProductIdIn(prodIds);
        return opProdSkuMapper.selectByExample(example);
    }

    @Override
    public List<OpProdSku> findBySkuCode(String skuCode) {
        OpProdSkuExample example = new OpProdSkuExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode);
        return opProdSkuMapper.selectByExample(example);
    }

    @Override
    public Integer getProductIdByskuCode(String skuCode) {
        return opProdSkuMapper.getProductIdByskuCode(skuCode);
    }

    @Override
    public List<OpProdSku> findAll() {
        OpProdSkuExample example = new OpProdSkuExample();
        example.setOrderByClause("SKU_CODE");
        return opProdSkuMapper.selectByExample(example);
    }

    @Override
    public List<String> getALLSkuCode() {
        return opProdSkuMapper.getALLSkuCode();
    }

    @Override
    public List<OpSpvVO> findByPcsProdSkuCond(OpSpvCond opSpvCond) {
        List<OpSpvVO> list = opProdSkuMapper.findByPcsProdSkuCond(opSpvCond);
//        List<OpSpvVO> list = buildFromModelList(psList);
        if (opSpvCond.isWithSku()) {
            for (OpSpvVO spvVO : list) {
                if (!spvVO.getCombined() && StringUtils.isNotEmpty(spvVO.getSkuCode())) {
                    PcsSkuVO skuVO = pcsSkuDomain.findByCode(spvVO.getSkuCode());
                    spvVO.setSkuVO(skuVO);
                }
                else if (spvVO.getCombined()) {
                    List<PcsSkuCombination> combinationList = pcsSkuCombinationDomain.findBySpvId(spvVO.getId());
                    spvVO.setSkuCombinationList(pcsSkuCombinationDomain.buildFromModelList(combinationList));
                }
            }
        }
        if(opSpvCond.getWithSkuCombination()){
            for (OpSpvVO prodSkuVO : list) {
                if (prodSkuVO.getCombined()) {
                    PcsSkuCombinationCond pcsSkucombinationCond = new PcsSkuCombinationCond();
                    pcsSkucombinationCond.setSpvId(prodSkuVO.getId());
                    pcsSkucombinationCond.setWithAttribute(true);
                    pcsSkucombinationCond.setWithAttributeValue(true);
                    pcsSkucombinationCond.setWithSku(true);
                    prodSkuVO.setSkuCombinationList(pcsSkuCombinationDomain.findSkuCombinationBySpvId(pcsSkucombinationCond));
                }
            }
        }
        return list;
    }

    private void validateProdSku(Long prodId, String skuCode){
        OpProdSkuExample example = new OpProdSkuExample();
        OpProdSkuExample.Criteria criteria = example.createCriteria();
        criteria.andSkuCodeEqualTo(skuCode);
        criteria.andProductIdEqualTo(prodId);
        List<OpProdSku> skus = opProdSkuMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(skus)) {
            throw new OperationException(OperationExceptionErrorCode.CHANNEL_CREATE_ERROR, "sku:" + skuCode + ",已经在其它PROD中存在！");
        }
    }

    @Override
    public List<OpSpvVO> findSpvCombinedByProdId(Long prodId){
        OpProdSkuExample example = new OpProdSkuExample();
        example.createCriteria().andProductIdEqualTo(prodId);
        List<OpProdSku> list = opProdSkuMapper.selectByExample(example);
        List<OpSpvVO> spvList = BeanUtil.buildListFrom(list,OpSpvVO.class);
        for (OpSpvVO prodSkuVO : spvList) {
            if (prodSkuVO.getCombined()) {
                prodSkuVO.setSkuCombinationList(pcsSkuCombinationDomain.findSkuCombinationBySpvId(prodSkuVO.getId()));
            }
        }
        return spvList;
    }
}
