package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.OpProdAssembleMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpProdAssembleDomain;
import com.thebeastshop.pegasus.merchandise.model.OpProdAssemble;
import com.thebeastshop.pegasus.merchandise.vo.OpProdAssembleVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/12/29 14:22
 */
@Component("opProdAssembleDomain")
public class OpProdAssembleDomainImpl extends AbstractBaseDomain<OpProdAssembleVO, OpProdAssemble> implements OpProdAssembleDomain {

    @Autowired
    private OpProdAssembleMapper opProdAssembleMapper;

    @Override
    @Transactional
    public Long create(OpProdAssemble record) {
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        record.setActive(true);
        opProdAssembleMapper.insertSelective(record);
        return record.getId();
    }

    @Override
    public boolean update(OpProdAssemble record) {
        record.setUpdateTime(new Date());
        return opProdAssembleMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    public List<OpProdAssembleVO> findByProdId(Long prodId) {
        return opProdAssembleMapper.findByProdId(prodId);
    }
}
