package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.OpAttributeValueMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpAttributeValueDomain;
import com.thebeastshop.pegasus.merchandise.model.OpAttributeValue;
import com.thebeastshop.pegasus.merchandise.model.OpAttributeValueExample;
import com.thebeastshop.pegasus.merchandise.vo.OpAttributeValueVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 * @author gongjun
 * @since 2016-10-20
 */
@Component("opAttributeValueDomain")
public class OpAttributeValueDomainImpl extends AbstractBaseDomain<OpAttributeValueVO, OpAttributeValue>
        implements OpAttributeValueDomain {

    @Autowired
    private OpAttributeValueMapper opAttributeValueMapper;

    @Override
    public int create(OpAttributeValue attributeValue) {
        attributeValue.setCreateTime(new Date());
        attributeValue.setUpdateTime(new Date());
        attributeValue.setActive(1);
        return opAttributeValueMapper.insert(attributeValue);
    }

    public int update(OpAttributeValue attributeValue){
        attributeValue.setUpdateTime(new Date());
        return opAttributeValueMapper.updateByPrimaryKeySelective(attributeValue);
    }

    @Override
    public OpAttributeValueVO findOpAttributeValueById(Long id){
        return BeanUtil.buildFrom(opAttributeValueMapper.selectByPrimaryKey(id),OpAttributeValueVO.class);
    }

    @Override
    public List<OpAttributeValueVO> findOpAttributeValueByAttributeId(Long attributeId) {
        OpAttributeValueExample example = new OpAttributeValueExample();
        example.createCriteria().andAttributeIdEqualTo(attributeId);
        List<OpAttributeValue> list = opAttributeValueMapper.selectByExample(example);
        return buildFromModelList(list);
    }

}
