package com.thebeastshop.pegasus.merchandise.domain;

import org.apache.commons.collections.CollectionUtils;
import java.util.List;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-02-21 19:55
 */
public class SearchKeyword {
    private String keyword;
    private Double boost;
    private Character flag;

    public SearchKeyword(String keyword, Double boost, Character flag) {
        this.keyword = keyword;
        this.boost = boost;
        this.flag = flag;
    }

    public SearchKeyword(List<String> wordArr) {
        if (CollectionUtils.isNotEmpty(wordArr) && wordArr.size() == 2) {
            String num = wordArr.get(0);
            String word = wordArr.get(1);
            Double boost = Double.parseDouble(num) * 10;
            int index = word.indexOf("/");
            if (index != -1) {
                this.flag = word.charAt(index + 1);
            }
            this.keyword = word.replaceAll("\\/(.)+", "");
            this.boost = boost;

        }
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Double getBoost() {
        return boost;
    }

    public void setBoost(Double boost) {
        this.boost = boost;
    }

    public Character getFlag() {
        return flag;
    }

    public void setFlag(Character flag) {
        this.flag = flag;
    }
}
