package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.model.PcsSkuCostPriceChange;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuSalesPriceChange;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuSupplierChange;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuSalesPriceChangeVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author gongjun
 * @since 2016-08-30
 */
public interface PcsSkuSalesPriceChangeDomain {


    /**
     * model转vo
     *
     * @param record
     * @return
     */
    PcsSkuSalesPriceChangeVO buildFromModel(PcsSkuSalesPriceChange record);

    /**
     * vo转model
     *
     * @param vo
     * @return
     */
    PcsSkuSalesPriceChange bulidFromVO(PcsSkuSalesPriceChangeVO vo);

    /**
     * 创建sku售价变动
     *
     * @param code
     * @return
     */
    Long create(String code, BigDecimal price);

    /**
     * 更新sku售价变动
     *
     * @param record
     * @return
     */
    boolean update(PcsSkuSalesPriceChange record);

    /**
     * 根据主键查找sku售价变动
     *
     * @param id
     * @return
     */
    PcsSkuSalesPriceChange findById(long id);

    /**
     * 根据CODE和STATUS查找sku售价变动
     *
     * @param code
     * @return
     */
    List<PcsSkuSalesPriceChange> findByCodeAndStatus(String code, Integer status);
    /**
     * 根据CODE查找sku售价变动
     *
     * @param code
     * @return
     */
    List<PcsSkuSalesPriceChange> findByCode(String code);

    List<PcsSkuCostPriceChange> findCostPriceChangeByCode(String code);

    List<PcsSkuSupplierChange> findSupplierChangeByCode(String code);

    /**
     * 售价变动审核
     *
     * @param code
     * @param isPass
     */
    PcsSkuSalesPriceChange auditSkuSalesPriceChange(String code, Boolean isPass, Integer type);

    /**
     * 根据skucode查找 售价变更记录
     *
     * @param code
     * @return
     */
    PcsSkuSalesPriceChange findSkuSalesPriceChangeByCodeAndProcessing(String code, Integer type);

    public Long createSupplierChange(String code, Integer price);

    public Long createCostPriceChange(String code, BigDecimal price);

    /**
     * 成本变动审核
     *
     * @param code
     * @param isPass
     */
    PcsSkuCostPriceChange auditSkuCostPriceChange(String code, Boolean isPass, Integer type);

    /**
     * 供应商变动审核
     *
     * @param code
     * @param isPass
     */
    PcsSkuSupplierChange auditSkuSupplierChange(String code, Boolean isPass, Integer type);


    List<PcsSkuCostPriceChange> findCostPriceChangeByCodeAndStatus(String code, Integer status);

    List<PcsSkuSupplierChange> findSupplierChangeByCodeAndStatus(String code, Integer status);

    
    /**
     * 更新sku成本变动
     *
     * @param record
     * @return
     */
    int updateCostPriceChange(PcsSkuCostPriceChange record);
    
    /**
     * 新增sku成本变动
     *
     * @param record
     * @return
     */
    int addCostPriceChange(PcsSkuCostPriceChange record);
    
    
}
