package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.cond.PcsSkuReceiveStandardCond;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuReceiveStandardRuleVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuReceiveStandardVO;

import java.util.List;

/**
 * @author gongjun
 * @since 2016-08-30
 */
public interface PcsSkuReceiveStandardDomain {

    List<PcsSkuReceiveStandardVO> listSkuByCond(PcsSkuReceiveStandardCond cond);

    PcsSkuReceiveStandardVO findPcsSkuReceiveStandardBySkuCode(String skuCode);

    boolean createOrEditSkuReceiveStandard(PcsSkuReceiveStandardVO vo);

    boolean editSkuReceiveStandard(PcsSkuReceiveStandardVO vo);

    boolean createSkuReceiveStandard(PcsSkuReceiveStandardVO vo);

    List<PcsSkuReceiveStandardRuleVO> findAllReceiveStandardRule();

    List<PcsSkuReceiveStandardRuleVO> findSkuReceiveStandardRule(String skuCode);

    PcsSkuReceiveStandardRuleVO findReceiveStandardRuleVOById(Long id);

    boolean createReceiveStandardRule(PcsSkuReceiveStandardRuleVO vo);

    boolean updateReceiveStandardRule(PcsSkuReceiveStandardRuleVO vo);

    boolean deleteReceiveStandardRule(Long id);

}
