package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCategoryCond;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategory;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategoryRelation;
import com.thebeastshop.pegasus.merchandise.vo.CategoryTreeNodeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsFrontBackCategoryVO;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCategoryRelationCond;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;

import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-08-30
 */
public interface PcsSkuCategoryDomain extends BaseDomain<PcsSkuCategoryVO, PcsSkuCategory> {

    /**
     * 创建品类
     *
     * @param record
     * @return
     */
    Long create(PcsSkuCategory record);

    /**
     * 创建后台品类
     *
     * @param record
     * @return
     */
    Long createBackCategory(PcsSkuCategory record);

    /**
     * 更新品类
     *
     * @param record
     * @return
     */
    boolean update(PcsSkuCategory record);

    /**
     * 更新后台品类
     *
     * @param record
     * @return
     */
    boolean updateBackCategory(PcsSkuCategory record);


    /**
     * 根据主键查找分类,唯一
     *
     * @param id
     * @return
     */
    PcsSkuCategory findById(long id);

    PcsSkuCategory findBackCategoryById(long id);

    public List<PcsSkuCategory> findFrontCategoriesBySkuCode(String skuCode);

    public List<PcsSkuCategory> findBackCategoriesBySkuCode(String skuCode);

    List<PcsSkuCategory> findFrontCategoriesBySkuCodeList(List<String> skuCodeList);

    /**
     * 根据父id查找所有子数据
     *
     * @param parentId
     * @return
     */
    List<PcsSkuCategory> findAllChildrens(long parentId);

    /**
     * 根据父id查找所有后台类目子数据
     *
     * @param parentId
     * @return
     */
    List<PcsSkuCategory> findAllBackCategoryChildrens(long parentId);


    /**
     * 查出所有品类
     *
     * @return
     */
    List<PcsSkuCategory> findAll();


    /**
     * 查出所有品类
     *
     * @return
     */
    List<PcsSkuCategory> findAllFrontCategories();



    /**
     * 根据CODE查找品类
     *
     * @param code
     * @return
     */
    PcsSkuCategory findByCode(String code);

    /**
     * 根据名称查找品类
     *
     * @param name
     * @return
     */
    List<PcsSkuCategory> findByName(String name);


    /**
     * 根据名称查找后台品类
     *
     * @param name
     * @return
     */
    List<PcsSkuCategory> findBackCategoryByName(String name);



    /**
     * 根据id集合查找品类
     *
     * @param ids
     * @return
     */
    List<PcsSkuCategory> findByIds(List<Long> ids);


    /**
     * 根据id集合查找后台品类
     *
     * @param ids
     * @return
     */
    List<PcsSkuCategory> findBackCategoriesByIds(List<Long> ids);


    /**
     * 根据code 和 右like code查找分类
     *
     * @param code
     * @return
     */
    List<PcsSkuCategory> findByCodeAndRightLikeCode(String code);



    /**
     * 查找第一层sku品类
     *
     * @return
     */
    List<PcsSkuCategory> findSkuCategoryByParentIdIsNull();

    /**
     * 根据一父ID查找品类
     * @param parentID
     * @return
     */
    PcsSkuCategory findByParentID(Long parentID);

    List<Long> findProductIdsBySkuCodes(List<String> skuCodes);

    List<Long> findProductIdListByCategoryFrontRelationIds(List<Long> ids);

    List<PcsFrontBackCategoryVO> findFrontBackCategoryList(Map<String, Object> params);

    List<PcsSkuCategoryVO> findFrontCategoryList(Map<String, Object> params);

    List<PcsSkuCategoryVO> findBackCategoryList(Map<String, Object> params);

    List<PcsSkuCategoryRelation> findBackCategoryRelationList(PcsSkuCategoryRelationCond cond);

    void saveOrUpdateBackCategoryRelationList(List<PcsSkuCategoryRelation> relationList);

    void saveOrUpdateBackCategoryRelation(PcsSkuCategoryRelation relation);

    Integer addFrontCategoryRelation(PcsSkuCategoryRelation relation);

    Integer addBackCategoryRelation(PcsSkuCategoryRelation relation);

    Integer addFrontBackCategoryRelation(PcsFrontBackCategoryVO frontBackCategoryVO);

    Integer updateBackCategoryRelation(PcsSkuCategoryRelation relation);

    List<PcsSkuCategoryRelation> findFrontCategoryRelation(PcsSkuCategoryRelationCond cond);

    List<Long> findFrontCategoryIdListByBackCategoryId(Long backCategoryRelationId);

    List<Long> findFrontCategoryIdListByBackCategoryIds(List<Long> backCategoryRelationIds);

    List<Long> findBackCategoryIdListByFrontCategoryId(Long frontCategoryRelationId);

    Integer countOfFrontCategoryRelation(PcsSkuCategoryRelationCond cond);

    Integer updateFrontCategoryRelation(PcsSkuCategoryRelation relation);

    Integer deleteFrontCategoryRelationList(List<Long> idList);

    Integer deleteBackCategoryRelationList(List<Long> idList);
    
    /**
     * 所有后台的一级分类
     * @return
     */
    List<PcsSkuCategoryVO> findAllFirstBackCategoryList();

    List<PcsFrontBackCategoryVO> findRelationBackCategoryByFrontCategoryId(Long frontId);
    PcsSkuCategoryVO findFirstCategoryByParentId(Long id);


    //=======================前台品类相关
    /**
     * 创建前台品类
     *
     * @param record
     * @return
     */
    Long createFrontCategory(PcsSkuCategory record);

    /**
     * 更新前台品类
     *
     * @param record
     * @return
     */
    boolean updateFrontCategory(PcsSkuCategory record);

    /**
     * 根据前台类目id删除对应关系
     * @param frontId
     * @return
     */
    Integer deleteFrontBackCategoryRelationByFrontId(Long frontId);

    /**
     * 根据类目品牌、标签、类目ID过滤查询类目
     * @param cond
     * @return
     */
    List<Long> findByCondCategory(PcsSkuCategoryCond cond);

    /**
     * 根据类目产品ID查询次级类目
     * @param cond
     * @return
     */
    List<PcsSkuCategoryVO> findByCondCategoryCron(PcsSkuCategoryCond cond);

    /**
     * 查找类目树的所有节点
     *
     * @return
     */
    List<CategoryTreeNodeVO> listAllCategoryTreeNode();

    /**
     * 获取指定编号类目的信息
     *
     * @param ids 类目编号集合
     *
     * @return
     */
    List<CategoryTreeNodeVO> listTreeNodeByCategoryIds(List<Long> ids);

    /**
     * 根据类目IDS查询次级类目
     * @param cond
     * @return
     */
    List<PcsSkuCategoryVO> findCategoryByIds(PcsSkuCategoryCond cond);
}