package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.model.OpAttributeValue;
import com.thebeastshop.pegasus.merchandise.vo.OpAttributeValueVO;

import java.util.List;

/**
 * @author gongjun
 * @since 2016-10-20
 */
public interface OpAttributeValueDomain extends BaseDomain<OpAttributeValueVO, OpAttributeValue> {

    int create(OpAttributeValue attributeValue);

    int update(OpAttributeValue attributeValue);

    /**
     * 查询属性值对象根据id
     * @param id
     * @return
     */
    OpAttributeValueVO findOpAttributeValueById(Long id);


    /**
     * 根据属性ID查询属性值列表
     * @param attributeId
     * @return
     */
    List<OpAttributeValueVO> findOpAttributeValueByAttributeId(Long attributeId);

}
