package com.thebeastshop.pegasus.merchandise.tools;

import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.ResourceUtils;

import javax.sql.DataSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;

/**
 * Created by Administrator on 2016/8/26.
 */
public class ApplicationContextUtil {

    private static ConfigurableApplicationContext context = null;

    private static ApplicationContextUtil instance = null;

    public static ApplicationContextUtil getInstance() {
        if (instance == null) {
            synchronized (ApplicationContextUtil.class) {
                if (instance == null) {
                    instance = new ApplicationContextUtil();
                }
            }
        }
        return instance;
    }

    public ConfigurableApplicationContext getContext() {
        return context;
    }

    private ApplicationContextUtil() {

    }


    static {

//        Resource logFileRource = new ClassPathResource("classpath:*resources/log4j2.xml");
        String logConfigLocation = "classpath:log4j2.xml";
        File configFile = null;
        try {
            configFile = ResourceUtils.getFile(logConfigLocation);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (!configFile.exists()) {
            System.err.println("log4j2 config file:" + configFile.getAbsolutePath() + " not exist");
            System.exit(0);
        }
        System.out.println("log4j2 config file:" + configFile.getAbsolutePath());

        try {

            System.setProperty("log4j.configurationFile", configFile.getAbsolutePath());
        } catch (Exception e) {
            System.err.println("log4j2 initialize error:" + e.getLocalizedMessage());
            System.exit(0);
        }

        //约定:spring入口配置文件为resources/spring-context.xml
        String configLocation = "classpath:spring.xml";
        try {
            configFile = ResourceUtils.getFile(logConfigLocation);
        } catch (IOException e) {
            e.printStackTrace();
        }

        if (!configFile.exists()) {
            System.err.println("spring config file:" + configFile.getAbsolutePath() + " not exist");
            System.exit(0);
        }

        System.out.println("spring config file:" + configFile.getAbsolutePath());

        if (context == null) {
            context = new ClassPathXmlApplicationContext("spring.xml");
            if (context.containsBean("dataSource")) {
                javax.sql.DataSource dataSource = context.getBean("dataSource", DataSource.class);
                if (dataSource != null) {
                    java.sql.Connection connection;
                    try {
                        connection = dataSource.getConnection();
                        connection.close();
                    } catch (SQLException e) {
                        System.err.println("spring initialize error:" + e.getLocalizedMessage());
                        System.exit(0);
                    }
                }
            }
        }

    }

}
