/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.client.SkuESClient;
import com.thebeastshop.pegasus.merchandise.cond.PsSkuCond;
import com.thebeastshop.pegasus.merchandise.constants.SearchType;
import com.thebeastshop.pegasus.merchandise.exception.PublicException;
import com.thebeastshop.pegasus.merchandise.exception.PublicExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.util.McReflectionUtil;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/6 10:09
 */
@Service("mcPsSkuService")
public class McPsSKuServiceImpl implements McPsSkuService {
    @Autowired
    private SkuESClient client;

    public boolean create(PsSkuVO vo) {
        return client.create(vo);
    }

    public boolean update(PsSkuVO vo) {
        return client.update(vo);
    }

    @Override
    public boolean update(List<PsSkuVO> vos) {
        return client.update(vos);
    }

    public boolean deleteBySkuCode(String skuCode) {
        return client.deleteByPrimaryKey(skuCode);
    }

    public List<PsSkuVO> findBySkuName(String name) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("skuName", name);
        params.put("skuNameCN", name);
        return client.findByFields(params, SearchType.OR);
    }

    public PsSkuVO findBySkuCode(String code) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("skuCode", code);
        List<PsSkuVO> skuVOs = client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isEmpty(skuVOs)) return null;
        return skuVOs.get(0);
    }

    @Override
    public List<PsSkuVO> findBySkuCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }

//        DisMaxQueryBuilder queryBuilder = QueryBuilders.disMaxQuery();
//        for (String code : codes
//            queryBuilder.add(QueryBuilders.termQuery("skuCode", code));
//        }
//        return client.searchByQryBuilder(queryBuilder, 0, Integer.MAX_VALUE);

        Map<String, Object> params = new HashMap<String, Object>();
        params.put("pagenum", Integer.MAX_VALUE);
        int _page_max = 50;
        if (codes.size() > _page_max) {
            int length = codes.size();
            int len = length / _page_max;
            List<PsSkuVO> allSkus = new ArrayList<>(codes.size());
            for (int i = 0; i < len; i++) {
                params.put("skuCode", codes.subList(_page_max * i, _page_max * (i + 1)));
                params.put("pagenum", Integer.MAX_VALUE);
                allSkus.addAll(client.findByFields(params, SearchType.OR));
            }
            if (length % _page_max > 0) {
                params.put("skuCode", codes.subList(_page_max * len, length));
                params.put("pagenum", Integer.MAX_VALUE);
                allSkus.addAll(client.findByFields(params, SearchType.OR));
            }
            return allSkus;
        }

        params.put("skuCode", codes);

        return client.findByFields(params, SearchType.OR);
    }

    @Override
    public List<PsSkuVO> findBySuppIds(List<Long> suppIds) {
        if (CollectionUtils.isEmpty(suppIds)) {
            return Collections.emptyList();
        }
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("supplierId", suppIds);
        return client.findByFields(params, SearchType.OR);
    }

    @Override
    public List<PsSkuVO> findByBrandIds(List<Long> brandIds) {
        if (CollectionUtils.isEmpty(brandIds)) {
            return Collections.emptyList();
        }
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("brandId", brandIds);
        return client.findByFields(params, SearchType.OR);
    }

    @Override
    public List<PsSkuVO> findByCateIds(List<Long> cateIds) {
        if (CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", cateIds);
        return client.findByFields(params, SearchType.OR);
    }

    public List<PsSkuVO> findByCond(PsSkuCond cond) {
        Map<String, Object> params = McReflectionUtil.getFieldNameValue(cond);
        return client.findByFields(params, SearchType.ANDLIKE);
    }


    public List<PsSkuVO> findAll() {
        return client.findAllByField(null, null);
    }

    public boolean create(List<PsSkuVO> vos) {
        return client.create(vos);
    }

    private PsSkuVO validateSkuCode(String skuCode) {
        PsSkuVO vos = findBySkuCode(skuCode);
        if (vos == null) {
            throw new PublicException(PublicExceptionErrorCode.UPDATE_ERROR, "SKU 不存在");
        }
        return vos;
    }

    @Override
    public List<PsSkuVO> findByCodeName(String codeName) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("skuCode", codeName);
        params.put("skuName", codeName);
        params.put("skuNameCN", codeName);
        params.put("pagenum", 100);
        return client.findByFields(params, SearchType.ORLIKE);
    }
    
    @Override
    public List<PsSkuVO> findByCodeName(String codeName,Integer currpage,Integer pagenum) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("skuCode", codeName);
        params.put("skuName", codeName);
        params.put("skuNameCN", codeName);
        params.put("pagenum", pagenum);
        return client.findByFields(params, SearchType.ORLIKE);
    }


}
