/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.campaign.client.CampaignClient;
import com.thebeastshop.pegasus.component.campaign.vo.*;
import com.thebeastshop.pegasus.component.json.ApiResult;
import com.thebeastshop.pegasus.component.utils.ApiUtils;
import com.thebeastshop.pegasus.component.vo.TypeVO;
import com.thebeastshop.pegasus.merchandise.client.AbstractESClient;
import com.thebeastshop.pegasus.merchandise.client.CampaignESClient;
import com.thebeastshop.pegasus.merchandise.client.ProductClient;
import com.thebeastshop.pegasus.merchandise.cond.DateRange;
import com.thebeastshop.pegasus.merchandise.cond.ProdSearchCond;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.constants.SearchType;
import com.thebeastshop.pegasus.merchandise.exception.PublicException;
import com.thebeastshop.pegasus.merchandise.service.*;
import com.thebeastshop.pegasus.merchandise.util.McReflectionUtil;
import com.thebeastshop.pegasus.merchandise.vo.*;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PsAttributeValuePairVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.elasticsearch.common.base.Strings;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.index.query.QueryBuilders;
import org.forest.core.ForestConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.*;
import java.math.BigDecimal;
import java.util.*;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/6 10:06 
 */
@Path("/pub/product")
@Consumes({ContentType.APPLICATION_JSON_UTF_8})
@Produces({ContentType.APPLICATION_JSON_UTF_8})
@Service("mcPsProductService")
public class McPsProductServiceImpl extends BasePsServiceImpl<PsProductVO> implements McPsProductService {
    private static final Logger LOGGER = LoggerFactory.getLogger(McPsProductServiceImpl.class);

    @Autowired
    private ForestConfiguration forestConfiguration;
    private CampaignClient campaignForestClient;

    @Autowired
    private CampaignESClient campaignClient;

    @Autowired
    private ProductClient client;
    @Autowired
    private McPcsSkuCategoryService mcPcsSkuCategoryService;
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    @Autowired
    private McPsSkuService mcPsSkuService;
    @Autowired
    private McPsSpvService mcPsSpvService;
    @Autowired
    private McOpProductService mcOpProductService;

    private final  static String specialNum = "462";
    private final  static String special481Num = "481";
    private final  static String special482Num = "482";
    private final  static String special463Num = "463";
    private final  static String special503Num = "503";
    private final  static String special574Num = "574";
    private final  static String special590Num = "590";
    private final  static String special591Num = "591";
    private final  static String special592Num = "592";
    private final  static String special594Num = "594";

    private final  static Map<String,BigDecimal> specialProdMap = new HashMap();
    private final  static Map<String,BigDecimal> specialSkuMap = new HashMap();
    private final  static Map<String,BigDecimal> special481ProdMap = new HashMap();
    private final  static Map<String,BigDecimal> special481SkuMap = new HashMap();
    private final  static Map<String,BigDecimal> special482ProdMap = new HashMap();
    private final  static Map<String,BigDecimal> special482SkuMap = new HashMap();
    private final  static Map<String,BigDecimal> special463ProdMap = new HashMap();
    private final  static Map<String,BigDecimal> special463SkuMap = new HashMap();
    private final  static Map<String,BigDecimal> special503ProdMap = new HashMap();
    private final  static Map<String,BigDecimal> special503SkuMap = new HashMap();
    private final  static Map<String,BigDecimal> special574ProdMap = new HashMap();
    private final  static Map<String,BigDecimal> special574SkuMap = new HashMap();
    private final  static Map<String,BigDecimal> special590ProdMap = new HashMap();
    private final  static Map<String,BigDecimal> special590SkuMap = new HashMap();
    private final  static Map<String,BigDecimal> special591ProdMap = new HashMap();
    private final  static Map<String,BigDecimal> special591SkuMap = new HashMap();
    private final  static Map<String,BigDecimal> special592ProdMap = new HashMap();
    private final  static Map<String,BigDecimal> special592SkuMap = new HashMap();
    private final  static Map<String,BigDecimal> special594ProdMap = new HashMap();
    private final  static Map<String,BigDecimal> special594SkuMap = new HashMap();
    static {
        specialProdMap.put("PROD001014105",new BigDecimal(499));
        specialProdMap.put("PROD001013171",new BigDecimal(499));
        specialProdMap.put("PROD001016880",new BigDecimal(499));
        specialProdMap.put("PROD001016881",new BigDecimal(499));
        specialProdMap.put("PROD001016628",new BigDecimal(599));
        specialProdMap.put("PROD001016627",new BigDecimal(599));
        specialProdMap.put("PROD001015528",new BigDecimal(1399));
        specialProdMap.put("PROD001015529",new BigDecimal(1999));

        specialSkuMap.put("411160162",new BigDecimal(499));
        specialSkuMap.put("411160172",new BigDecimal(599));
        specialSkuMap.put("S00300000013492",new BigDecimal(499));
        specialSkuMap.put("S00300000013493",new BigDecimal(599));
        specialSkuMap.put("S00300000013958",new BigDecimal(499));
        specialSkuMap.put("S00300000013959",new BigDecimal(599));
        specialSkuMap.put("S00300000013954",new BigDecimal(499));
        specialSkuMap.put("S00300000013955",new BigDecimal(599));
        specialSkuMap.put("411161992",new BigDecimal(599));
        specialSkuMap.put("411162002",new BigDecimal(699));
        specialSkuMap.put("411162012",new BigDecimal(599));
        specialSkuMap.put("411162022",new BigDecimal(699));
        specialSkuMap.put("412160542",new BigDecimal(1399));
        specialSkuMap.put("412160552",new BigDecimal(1499));
        specialSkuMap.put("412160582",new BigDecimal(1999));
        specialSkuMap.put("412160592",new BigDecimal(2199));

        special481ProdMap.put("PROD001013069",new BigDecimal(60));
        special481ProdMap.put("PROD001013065",new BigDecimal(60));
        special481ProdMap.put("PROD001013068",new BigDecimal(60));
        special481ProdMap.put("PROD001013067",new BigDecimal(60));

        special481SkuMap.put("17035071",new BigDecimal(169));
        special481SkuMap.put("17035073",new BigDecimal(169));
        special481SkuMap.put("17035076",new BigDecimal(169));
        special481SkuMap.put("16036075",new BigDecimal(169));

        special482ProdMap.put("PROD001013910",new BigDecimal(78));
        special482SkuMap.put("17035081",new BigDecimal(263));

        special463ProdMap.put("PROD001015182",new BigDecimal(299));
        special463ProdMap.put("PROD001015184",new BigDecimal(299));
        special463ProdMap.put("PROD001015185",new BigDecimal(299));

        special463SkuMap.put("411161282",new BigDecimal(799));
        special463SkuMap.put("411161292",new BigDecimal(899));
        special463SkuMap.put("411161302",new BigDecimal(799));
        special463SkuMap.put("411161312",new BigDecimal(899));
        special463SkuMap.put("411161322",new BigDecimal(799));
        special463SkuMap.put("411161332",new BigDecimal(899));

        special503ProdMap.put("PROD001016628",new BigDecimal(599));
        special503ProdMap.put("PROD001016627",new BigDecimal(599));

        special503SkuMap.put("411161992",new BigDecimal(599));
        special503SkuMap.put("411162002",new BigDecimal(699));
        special503SkuMap.put("411162012",new BigDecimal(599));
        special503SkuMap.put("411162022",new BigDecimal(699));

        special574ProdMap.put("PROD001013910",new BigDecimal(45));

        special574SkuMap.put("16035125",new BigDecimal(45));
        special574SkuMap.put("16035131",new BigDecimal(45));
        special574SkuMap.put("16035130",new BigDecimal(45));
        special574SkuMap.put("16035129",new BigDecimal(45));
        special574SkuMap.put("17035081",new BigDecimal(169));

        special590ProdMap.put("PROD001015182",new BigDecimal(299));
        special590ProdMap.put("PROD001015184",new BigDecimal(299));
        special590ProdMap.put("PROD001015185",new BigDecimal(299));

        special590SkuMap.put("411161282",new BigDecimal(799));
        special590SkuMap.put("411161292",new BigDecimal(899));
        special590SkuMap.put("411161302",new BigDecimal(799));
        special590SkuMap.put("411161312",new BigDecimal(899));
        special590SkuMap.put("411161322",new BigDecimal(799));
        special590SkuMap.put("411161332",new BigDecimal(899));

        special591ProdMap.put("PROD001015528",new BigDecimal(1399));

        special591SkuMap.put("412160542",new BigDecimal(1399));
        special591SkuMap.put("412160552",new BigDecimal(1499));

        special592ProdMap.put("PROD001015529",new BigDecimal(1999));

        special592SkuMap.put("412160582",new BigDecimal(1999));
        special592SkuMap.put("412160592",new BigDecimal(2199));

        special594ProdMap.put("PROD001016671",new BigDecimal(499));
        special594ProdMap.put("PROD001016672",new BigDecimal(499));
        special594ProdMap.put("PROD001016880",new BigDecimal(499));
        special594ProdMap.put("PROD001016881",new BigDecimal(499));

        special594SkuMap.put("411162070",new BigDecimal(499));
        special594SkuMap.put("411162080",new BigDecimal(599));
        special594SkuMap.put("411162110",new BigDecimal(499));
        special594SkuMap.put("411162120",new BigDecimal(599));
        special594SkuMap.put("S00300000013958",new BigDecimal(499));
        special594SkuMap.put("S00300000013959",new BigDecimal(599));
        special594SkuMap.put("S00300000013954",new BigDecimal(499));
        special594SkuMap.put("S00300000013955",new BigDecimal(599));

    }

    private static Map<String, Boolean> specialExcludeCampaignMap = new HashMap<>();
    static {
        PsCampaignVO specialCampaign = new PsCampaignVO();
        specialCampaign.setProductScopeId(3);
        specialCampaign.setDiscountTypeId(4);
        specialExcludeCampaignMap = getSpecialCampaignMap(Lists.newArrayList(specialCampaign));
    }

    @Autowired
    public void init() {
        campaignForestClient = forestConfiguration.createInstance(CampaignClient.class);
    }

    @Override
    public AbstractESClient<PsProductVO> getESClient() {
        return client;
    }

    @GET
    @Path("name/{name}")
    @Override
    public List<PsProductVO> findByProdName(@PathParam("name") String name) {
        return client.findByField("name", name);
    }

    @GET
    @Path("code/{code}")
    @Override
    public List<PsProductVO> findByProdCode(@PathParam("code") String code) {
        return client.findByField("code", code);
    }

    @Override
	public PsProductVO findByProdId(Long prodId) {
		PsProductCond cond = new PsProductCond();
		cond.setId(prodId.toString());
		List<PsProductVO> prods = findByCond(cond);
		if (CollectionUtils.isNotEmpty(prods)) {
			return prods.get(0);
		}
		return null;
	}

    @Override
    public List<PsProductVO> findByCond(PsProductCond cond) {
        Map<String, Object> params = McReflectionUtil.getFieldNameValue(cond);
        if (CollectionUtils.isNotEmpty(cond.getIds())) {
            params.put("id",cond.getIds());
        }
        params.remove("ids");
        params.remove("memberLevel");
        params.remove("accessWay");
        params.remove("discount");

        if (CollectionUtils.isNotEmpty(cond.getCodes())) {
            params.put("code", cond.getCodes());
        }
        params.remove("codes");
        params.remove("matchCampaign");
        params.remove("matchGlobalCampaigns");

        String primaryUpdateTime = MapUtils.getString(params, "primaryUpdateTime");
        if (primaryUpdateTime != null) {
            params.remove("primaryUpdateTime");

        }

        if (cond.getMatchCampaign()
                && CollectionUtils.isEmpty(cond.getCodes())
                && StringUtils.isBlank(cond.getCode())
                && CollectionUtils.isEmpty(cond.getIds())
                && cond.getId() == null) {
            return new ArrayList<>();
        }

        List<PsProductVO> productVOList = client.findByFields(params, SearchType.ANDLIKE);
        if (cond.getMatchCampaign()) {
//            matchProductsCampaigns(productVOList, cond, true);
            matchListPageCampaigns(productVOList, cond);
/*
            List<PsCampaignVO> globalCampaignList = getGlobalCampaignList(cond.getMemberLevel(), cond.getAccessWay());
            //if (cond.getMatchGlobalCampaigns()) {
            for (PsProductVO productVO : productVOList) {
//                productVO.getCampaignList().addAll(globalCampaignList);
//                getProductCampaignList()
                //                productVO.getCampaignList().addAll(globalCampaignList);
                List<PsCampaignVO> campList = getProductCampaignList(Long.valueOf(productVO.getId()),
                        productVO.getCategoryId(), cond.getMemberLevel(), cond.getAccessWay());
                List<PsCampaignVO> list = new ArrayList<>();
                list.addAll(campList);
                list.addAll(globalCampaignList);
                productVO.setCampaignList(list);
            }
            matchProductCampaigns(productVOList, cond);
*/
            //}
        }
        return productVOList;
    }

    @Override
    public List<PsProductVO> findByCond(PsProductCond cond, boolean matchGlobalCampaigns) {
        Map<String, Object> params = McReflectionUtil.getFieldNameValue(cond);
        if (CollectionUtils.isNotEmpty(cond.getIds())) {
            params.put("id",cond.getIds());
        }
        params.remove("ids");
        params.remove("memberLevel");
        params.remove("accessWay");
        params.remove("discount");

        if (CollectionUtils.isNotEmpty(cond.getCodes())) {
            params.put("code", cond.getCodes());
        }
        params.remove("codes");
        params.remove("matchCampaign");
        params.remove("matchGlobalCampaigns");

        if (cond.getMatchCampaign()
                && CollectionUtils.isEmpty(cond.getCodes())
                && StringUtils.isBlank(cond.getCode())
                && CollectionUtils.isEmpty(cond.getIds())
                && cond.getId() == null) {
            return new ArrayList<>();
        }

        List<PsProductVO> productVOList = client.findByFields(params, SearchType.ANDLIKE);
        if (cond.getMatchCampaign()) {
            matchListPageCampaigns(productVOList, cond);
        }
        return productVOList;
    }



    private static Map<String, Boolean> getSpecialCampaignMap(List<PsCampaignVO> specialCampaigns) {
        Map<String, Boolean> map = new HashMap<>();
        for (PsCampaignVO specialCampaign : specialCampaigns) {
            String key = getSpecialCampaignKey(specialCampaign);
            map.put(key, true);
        }
        return map;
    }

    private static String getSpecialCampaignKey(PsCampaignVO specialCampaign) {
        String key = "sid=" + specialCampaign.getProductScopeId();
        key = key + ",tid=" + specialCampaign.getDiscountTypeId();
        return key;
    }


    /**
     * 排除特殊活动
     * @param psProductVO
     */
    private void excludeSpecialCampaigns(PsProductVO psProductVO) {
        List<PsCampaignVO> newCampaignList = new ArrayList<>();
        List<PsCampaignVO> campaigns = psProductVO.getCampaignList();
        if (CollectionUtils.isNotEmpty(campaigns)) {
            for (PsCampaignVO campaignVO : campaigns) {
                String key = getSpecialCampaignKey(campaignVO);
                if (!specialExcludeCampaignMap.containsKey(key)) {
                    newCampaignList.add(campaignVO);
                }
            }
        }
        psProductVO.setCampaignList(newCampaignList);
    }


/*
    private void matchProductsCampaigns(List<PsProductVO> productVOList, PsMatchCampaignCond cond, boolean matchGlobalCampaigns) {
//        List<PsCampaignVO> globalCampaignList = getGlobalCampaignList(cond.getMemberLevel(), cond.getAccessWay());
        if (matchGlobalCampaigns) {
            StopWatch sw = new StopWatch();
            sw.start();
            List<CampaignProductCondVO> productCondList = new ArrayList<>();
            for (PsProductVO productVO : productVOList) {
                CampaignProductCondVO productCondVO = new CampaignProductCondVO();
                productCondVO.setProductId(Long.valueOf(productVO.getId()));
                productCondVO.setCategoryId(productVO.getCategoryId());
                productCondVO.setCrossBorderFlag(productVO.getCrossBorderFlag());
                productCondList.add(productCondVO);
            }
            Map<String, List<PsCampaignVO>> campaignListMap = getProductCampaignListMapV2(productCondList,
                    true, cond.getMemberLevel(), cond.getAccessWay());
            for (PsProductVO productVO : productVOList) {
//                productVO.getCampaignList().addAll(globalCampaignList);
                List<PsCampaignVO> campList = campaignListMap.get(productVO.getId());
                List<PsCampaignVO> list = new ArrayList<>();
                if(CollectionUtils.isNotEmpty(campList)){
                	list.addAll(campList);
                }
                
//                list.addAll(globalCampaignList);
                productVO.setCampaignList(list);
            }
            sw.stop();
            LOGGER.info("【商品接口耗时】匹配活动 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
        }
        matchProductCampaigns(productVOList, cond);
    }
*/


    @Override
    public Map<String, List<PsCampaignVO>> findCampaignByCond(PsProductCond cond) {
        List<PsProductVO> productList = findByCond(cond);
        if (EmptyUtil.isEmpty(productList)) {
            return new HashMap<>();
        }
        Map<String, List<PsCampaignVO>> map = new HashMap<>();
        for (PsProductVO productVO : productList) {
            List<PsCampaignVO> prodList = productVO.getCampaignList();
            map.put(productVO.getCode(), prodList);
        }
        return map;
    }

    @Deprecated
    public Map<String, List<PsCampaignVO>> getProductCampaignListMap(List<Long> productIdList, boolean containsGlobal, Long cateId, Integer memberLevel, Integer accessWay) {
        CampaignCondVO cond = new CampaignCondVO();
        cond.setStateId(1);
        cond.setMemberLevel(memberLevel);
        cond.setAccessWay(accessWay);
        cond.setProductIdList(productIdList);
        cond.setCategoryId(cateId);
        cond.setFromRedis(true);
        cond.setContainsGlobal(containsGlobal);
        String params = JSON.toJSONString(cond);
        ApiResult<Map<Long, List<CampaignVO>>> campaignResult = campaignForestClient.mapListCampaign(params);
        if (ApiUtils.isSuccess(campaignResult)) {
            Map<String, List<PsCampaignVO>> psCampaignListMap = new HashMap<>();
            Map<Long, List<CampaignVO>> campaignVOListMap = campaignResult.getData();
            for (Iterator<Long> iterator = campaignVOListMap.keySet().iterator(); iterator.hasNext(); ) {
                Long id = iterator.next();
                List<CampaignVO> campaignVOList = campaignVOListMap.get(id);
                List<PsCampaignVO> psCampaignVOList = convertCampaignList(campaignVOList);
                psCampaignListMap.put(String.valueOf(id), psCampaignVOList);
            }
            return psCampaignListMap;
        }
        return new HashMap<>();
    }


    public Map<String, List<PsCampaignVO>> getProductCampaignListMapV2(List<CampaignProductCondVO> productCondList, boolean containsGlobal, Integer memberLevel, Integer accessWay) {
        CampaignCondVO cond = new CampaignCondVO();
        cond.setStateId(-1);
        cond.setMemberLevel(memberLevel);
        cond.setAccessWay(accessWay);
        cond.setProductCondList(productCondList);
        cond.setFromRedis(true);
        cond.setContainsGlobal(containsGlobal);
        String params = JSON.toJSONString(cond);
        ApiResult<Map<Long, List<CampaignVO>>> campaignResult = campaignForestClient.mapListCampaign_V1_0_1(params);
        if (ApiUtils.isSuccess(campaignResult)) {
            Map<String, List<PsCampaignVO>> psCampaignListMap = new HashMap<>();
            Map<Long, List<CampaignVO>> campaignVOListMap = campaignResult.getData();
            for (Iterator<Long> iterator = campaignVOListMap.keySet().iterator(); iterator.hasNext(); ) {
                Long id = iterator.next();
                List<CampaignVO> campaignVOList = campaignVOListMap.get(id);
                List<PsCampaignVO> psCampaignVOList = convertCampaignList(campaignVOList);
                psCampaignListMap.put(String.valueOf(id), psCampaignVOList);
            }
            return psCampaignListMap;
        }
        return new HashMap<>();
    }



    public static List<PsCampaignVO> convertCampaignList(List<CampaignVO> voList) {
        List<PsCampaignVO> psList = new ArrayList<>();
        for (CampaignVO vo : voList) {
            PsCampaignVO ps = new PsCampaignVO();
            ps.setId(vo.getId());
            ps.setName(vo.getName());
            ps.setTitle(vo.getTitle());
            ps.setState(vo.getState());
            ps.setCumulative(vo.getCumulative());
            ps.setDiscountTypeId(vo.getDiscountTypeId());
            TypeVO dicountType = vo.getDiscountType();
            if (dicountType != null) {
                ps.setDiscountTypeName(dicountType.getName());
            }
            ps.setCrossBorderFlag(vo.getCrossBorderFlag());
            ps.setMemberLevels(vo.getMemberLevels());
            ps.setAccessWayIds(vo.getAccessWayIds());
            ps.setCreateTime(vo.getCreateTime());
            ps.setStartTime(vo.getStartTime());
            ps.setExpireTime(vo.getExpireTime());
            ps.setProductScopeId(vo.getProductScopeId());
            ps.setApprovalState(vo.getApprovalState());
            List<CampaignSectionVO> campaignSectionVOList = vo.getCampaignSectionList();
            if (EmptyUtil.isNotEmpty(campaignSectionVOList)) {
                List<PsCampaignSectionVO> psCampaignSectionList = new ArrayList<>();
                for (CampaignSectionVO campaignSectionVO : campaignSectionVOList) {
                    PsCampaignSectionVO psCampaignSectionVO = new PsCampaignSectionVO();
                    psCampaignSectionVO.setId(campaignSectionVO.getId());
                    psCampaignSectionVO.setCampaignId(vo.getId());
                    TypeVO conditionType = campaignSectionVO.getConditionType();
                    if (conditionType != null) {
                        psCampaignSectionVO.setConditionType(conditionType.getId());
                    }
                    psCampaignSectionVO.setLine(campaignSectionVO.getLine());
                    // 新增价格因子影响类型
                    psCampaignSectionVO.setFactorType(campaignSectionVO.getFactorType());
                    psCampaignSectionVO.setFactor(campaignSectionVO.getFactor());
                    psCampaignSectionVO.setRanking(campaignSectionVO.getRanking());
                    List<CampaignSectionProductVO> campaignSectionProductVOList = campaignSectionVO.getCampaignSectionProductList();
                    if (EmptyUtil.isNotEmpty(campaignSectionProductVOList)) {
                        List<PsCampaignSectionProductVO> psCampaignSectionProductList = new ArrayList<>();
                        for (CampaignSectionProductVO campaignSectionProductVO : campaignSectionProductVOList) {
                            PsCampaignSectionProductVO psCampaignSectionProductVO = new PsCampaignSectionProductVO();
                            psCampaignSectionProductVO.setId(campaignSectionProductVO.getId());
                            psCampaignSectionProductVO.setCampaignId(vo.getId());
                            psCampaignSectionProductVO.setCampaignSectionId(campaignSectionProductVO.getCampaignSectionId());
                            psCampaignSectionProductVO.setProductId(campaignSectionProductVO.getAdditionalProductId());
                            psCampaignSectionProductVO.setPricePrice(campaignSectionProductVO.getAdditionalProductPrice());
                            psCampaignSectionProductVO.setPriceCount(campaignSectionProductVO.getAdditionalProductCount());
                            psCampaignSectionProductList.add(psCampaignSectionProductVO);
                        }
                        psCampaignSectionVO.setCampaignSectionProducts(psCampaignSectionProductList);
                    }
                    psCampaignSectionList.add(psCampaignSectionVO);
                }
                ps.setCampaignSectionList(psCampaignSectionList);
            }
            psList.add(ps);
        }
        return psList;
    }



    public List<PsCampaignVO> getProductCampaignList(Long productId, boolean containsGlobal, Long cateId, Integer memberLevel, Integer accessWay) {
        CampaignCondVO cond = new CampaignCondVO();
        cond.setMemberLevel(memberLevel);
        cond.setAccessWay(accessWay);
        cond.setProductId(productId);
        cond.setCategoryId(cateId);
        cond.setFromRedis(true);
        cond.setContainsGlobal(containsGlobal);
        ApiResult<List<CampaignVO>> campaignResult = campaignForestClient.listCampaign(cond);
        if (ApiUtils.isSuccess(campaignResult)) {
            List<CampaignVO> campaignVOList = campaignResult.getData();
            List<PsCampaignVO> psCampaignList = convertCampaignList(campaignVOList);
            return psCampaignList;
        }
        return new ArrayList<>();
    }
    
    @Override
    public List<PsCampaignVO> getGlobalCampaignList(PsMatchCampaignCond cond) {
/*
        CampaignCondVO cond = new CampaignCondVO();
        cond.setStateIds(Lists.newArrayList(-1));
        cond.setProductScopes(Lists.newArrayList(3));
        cond.setMemberLevel(memberLevel);
        cond.setAccessWay(accessWay);
        cond.setFromRedis(true);
        ApiResult<List<CampaignVO>> campaignResult = campaignForestClient.listCampaign(cond);
        if (ApiUtils.isSuccess(campaignResult)) {
            List<CampaignVO> campaignVOList = campaignResult.getData();
            List<PsCampaignVO> psCampaignList = convertCampaignList(campaignVOList);
            return psCampaignList;
        }
        return new ArrayList<>();
*/
        Integer memberLevel = cond.getMemberLevel();
        Integer accessWay = cond.getAccessWay();

        Map<String, Object> params = new HashMap<>();
        params.put("pagenum", 999);
        params.put("state", QueryBuilders.termQuery("state", 1));
        params.put("productScopeId", QueryBuilders.termQuery("productScopeId", 3));
        params.put("accessWayIds", QueryBuilders.termQuery("accessWayIds", accessWay));
        params.put("memberLevels", QueryBuilders.termQuery("memberLevels", memberLevel));
        Date now = new Date();
        params.put("startTime", QueryBuilders.rangeQuery("startTime").lte(now));
        params.put("expireTime", QueryBuilders.rangeQuery("expireTime").gt(now));
        List<PsCampaignVO> campaigns = campaignClient.findByFields(params, SearchType.ANDLIKE);
        return campaigns;
    }




    public void matchCampaignList(List<PsCampaignVO> campaignList,
                                                PsProductVO productVO, Integer memberLavel, Integer accessWay) {
        if(CollectionUtils.isNotEmpty(campaignList)) {
            List<PsCampaignVO> matchedCampaignList = new ArrayList<>();
            List<PsCampaignVO> matchedAdvanceCampaignList = Lists.newArrayList();
            for (PsCampaignVO campaignVO : campaignList) {
                int awId = accessWay == null ? -1 : accessWay.intValue();
                int mlId = memberLavel == null ? -1 : memberLavel.intValue();
                boolean cbFlag = productVO.getCrossBorderFlag() != null && productVO.getCrossBorderFlag() == 1;
                if (campaignVO.match(awId, mlId, cbFlag)) {
                    matchedCampaignList.add(campaignVO);
                } else if (campaignVO.isMatchAdvance(awId, mlId, cbFlag)) {
                    matchedAdvanceCampaignList.add(campaignVO);
                }
            }
            // 设置匹配的进行中活动
            productVO.setCampaignList(matchedCampaignList);
            // 设置匹配的预告活动
            productVO.setAdvanceCampaignList(matchedAdvanceCampaignList);
        }
    }

    @Override
    public List<PsProductVO> findByFields(Map<String, Object> params) {
        return client.findByFields(params,SearchType.ANDLIKE);
    }

    @Override
    public List<PsProductVO> findByNameOrNameCN(Map<String, Object> params) {
        return client.findByFields(params,SearchType.ORLIKE);
    }

    @Override
    public List<PsProductVO> calculateDiscountPrice(List<PsProductVO> productList, Integer memberLevel, Integer accessWay, BigDecimal discountAmount) {
        for (PsProductVO productVO : productList) {
            setProductSpecialPrice(productVO, discountAmount);
        }
        return productList;
    }

    /**
     * 设置商品特殊价格
     * @param productVO
     * @param discountAmount
     * @return
     */
    private PsProductVO setProductSpecialPrice(PsProductVO productVO, BigDecimal discountAmount) {
        BigDecimal originalPrice = productVO.getListPrice();
        Boolean allowVipDiscount = (productVO.getAllowVipDiscount() != null && productVO.getAllowVipDiscount() == 1);
        List<PsCampaignVO> campaignList = productVO.getCampaignList();
        productVO.setDiscountPrice(
                calculateDiscountPrice(productVO.getCode(), allowVipDiscount, originalPrice, campaignList, discountAmount));
        List<PsCampaignVO> advanceCampaignList = productVO.getAdvanceCampaignList();
        if(CollectionUtils.isNotEmpty(advanceCampaignList)) {
            productVO.setAdvancePrice(
                    calculateDiscountPrice(null, allowVipDiscount, originalPrice, advanceCampaignList, discountAmount));
        }
        return productVO;
    }

    @Override
    public PsSkuVO calculateDiscountPrice(PsProductVO productVO, PsSkuVO skuVO, PsMatchCampaignCond cond) {
        BigDecimal originalPrice = new BigDecimal(String.valueOf(skuVO.getSalesPrice()));
        List<PsCampaignVO> campaignList = productVO.getCampaignList();
        skuVO.setCampaignList(campaignList);
        boolean allowVipDiscount = productVO.getAllowVipDiscount() != null && productVO.getAllowVipDiscount() == 1;
        //原方法为calculateDiscountPrice 特殊处理双十一之后处理删掉
        BigDecimal targetPrice = calculateDiscountPriceSpecial(skuVO,allowVipDiscount,originalPrice, campaignList,cond.getDiscount());
        skuVO.setDiscountPrice(targetPrice);
        List<PsCampaignVO> advanceCampaignList = productVO.getAdvanceCampaignList();
        if(CollectionUtils.isNotEmpty(advanceCampaignList)) {
            skuVO.setAdvancePrice(calculateDiscountPriceSpecial(null, allowVipDiscount, originalPrice, advanceCampaignList, cond.getDiscount()));
        }
        return skuVO;
    }

    @Override
    public PsSkuVO calculateDiscountPrice(PsSkuVO skuVO, PsMatchCampaignCond cond) {
        PsProductVO productVO = findProdBySkuCode(skuVO.getSkuCode());
        if (productVO == null) return skuVO;
        if (cond.getMatchCampaign() != null && cond.getMatchCampaign()) {
            matchCampaigns(productVO, cond, true);
        }
        calculateDiscountPrice(productVO, skuVO, cond);
        return skuVO;
    }

    @Override
    public PsSpvVO calculateDiscountPrice(PsProductVO productVO, PsSpvVO spvVO, PsMatchCampaignCond cond) {
        if (productVO == null) return spvVO;
        BigDecimal originalPrice = new BigDecimal(String.valueOf(spvVO.getSalesPrice()));
        if (cond.getMatchCampaign() != null && cond.getMatchCampaign()) {
            List<PsCampaignVO> campaignList = productVO.getCampaignList();
            boolean allowVipDiscount = productVO.getAllowVipDiscount() != null && productVO.getAllowVipDiscount() == 1;
            BigDecimal targetPrice = calculateDiscountPriceSpecial(allowVipDiscount,
                    originalPrice, campaignList, cond.getDiscount(),spvVO);
            spvVO.setDiscountPrice(targetPrice);
            List<PsCampaignVO> advanceCampaignList = productVO.getAdvanceCampaignList();
            if(CollectionUtils.isNotEmpty(advanceCampaignList)) {
                spvVO.setAdvancePrice(calculateDiscountPriceSpecial(allowVipDiscount, originalPrice, advanceCampaignList, cond.getDiscount(), null));
            }
        }
        return spvVO;
    }

    @Override
    public PsProductVO calculateDiscountPrice(PsProductVO product, Integer memberLevel, Integer accessWay, BigDecimal discountAmount) {
        return setProductSpecialPrice(product, discountAmount);
    }

    /**
     * 计算折扣价格
     * @param productCode
     * @param allowVipDiscount
     * @param originalPrice
     * @param campaignList
     * @param discountAmount
     * @return
     */
    private BigDecimal calculateDiscountPrice(String productCode, Boolean allowVipDiscount, BigDecimal originalPrice,
                                              List<PsCampaignVO> campaignList, BigDecimal discountAmount) {
        BigDecimal targetPrice = originalPrice;
        for (PsCampaignVO campaign : campaignList) {
            if (campaign.getDiscountTypeId() != 1){
                continue;
            }
            List<PsCampaignSectionVO> sectionList = campaign.getCampaignSectionList();
            if (CollectionUtils.isEmpty(sectionList)){
                continue;
            }
            PsCampaignSectionVO section = sectionList.get(0);

            if(productCode != null) {
                //start 特殊处理等双十一以后会删掉
                Long campaignId = campaign.getId();
                LOGGER.info("===列表价参数为 campaignId= {},code= {}", campaignId, productCode);
                if (specialNum.equals(String.valueOf(campaignId)) && specialProdMap.containsKey(productCode)) {
                    targetPrice = specialProdMap.get(productCode);
                    LOGGER.info("===特殊列表价参数为 targetPrice= {}", targetPrice);
                }
                else if(special481Num.equals(String.valueOf(campaignId)) && special481ProdMap.containsKey(productCode)) {
                    targetPrice = special481ProdMap.get(productCode);
                    LOGGER.info("===481特殊列表价参数为 targetPrice= {}", targetPrice);
                } else if(special482Num.equals(String.valueOf(campaignId)) && special482ProdMap.containsKey(productCode)) {
                    targetPrice = special482ProdMap.get(productCode);
                    LOGGER.info("===482特殊列表价参数为 targetPrice= {}", targetPrice);
                } else if(special463Num.equals(String.valueOf(campaignId)) && special463ProdMap.containsKey(productCode)) {
                    targetPrice = special463ProdMap.get(productCode);
                    LOGGER.info("===463特殊列表价参数为 targetPrice= {}", targetPrice);
                } else if(special503Num.equals(String.valueOf(campaignId)) && special503ProdMap.containsKey(productCode)) {
                    targetPrice = special503ProdMap.get(productCode);
                    LOGGER.info("===503特殊列表价参数为 targetPrice= {}", targetPrice);
                } else if(special574Num.equals(String.valueOf(campaignId)) && special574ProdMap.containsKey(productCode)) {
                    targetPrice = special574ProdMap.get(productCode);
                    LOGGER.info("===574特殊列表价参数为 targetPrice= {}", targetPrice);
                } else if(special590Num.equals(String.valueOf(campaignId)) && special590ProdMap.containsKey(productCode)) {
                    targetPrice = special590ProdMap.get(productCode);
                    LOGGER.info("===590特殊列表价参数为 targetPrice= {}", targetPrice);
                } else if(special591Num.equals(String.valueOf(campaignId)) && special591ProdMap.containsKey(productCode)) {
                    targetPrice = special591ProdMap.get(productCode);
                    LOGGER.info("===591特殊列表价参数为 targetPrice= {}", targetPrice);
                } else if(special592Num.equals(String.valueOf(campaignId)) && special592ProdMap.containsKey(productCode)) {
                    targetPrice = special592ProdMap.get(productCode);
                    LOGGER.info("===592特殊列表价参数为 targetPrice= {}", targetPrice);
                } else if(special594Num.equals(String.valueOf(campaignId)) && special594ProdMap.containsKey(productCode)) {
                    targetPrice = special594ProdMap.get(productCode);
                    LOGGER.info("===594特殊列表价参数为 targetPrice= {}", targetPrice);
                }
                // 特殊处理等双十一以后会删掉 end
            }

            BigDecimal factor = section.getFactor();
            Integer factorType = section.getFactorType();
            if (factor == null)
                continue;
            if (factorType == null) {
                continue;
            }
            if (factorType.equals(1)) {
                // 是统一折扣，则计算折扣价
                targetPrice = targetPrice.multiply(factor.divide(BigDecimal.TEN));
            } else if (factorType.equals(2)) {
                // 是固定价格，直接把价格设置成固定的价格
                targetPrice = factor;
            }
        }
        // 计算VIP价格
        if (allowVipDiscount != null && allowVipDiscount && discountAmount != null) {
            targetPrice = targetPrice.multiply(discountAmount);
        }
        LOGGER.info("===最终价格 targetPrice= {}", targetPrice);
        return targetPrice;
    }

    //start 特殊处理等双十一以后会删掉 整个方法 end
    private BigDecimal calculateDiscountPriceSpecial(Boolean allowVipDiscount,BigDecimal originalPrice,List<PsCampaignVO> campaignList,BigDecimal discountAmount, PsSpvVO spvVO) {

        if (discountAmount == null) {
            throw new PublicException("会员折扣率参数没有传");
        }

        BigDecimal targetPrice = originalPrice;

        for (PsCampaignVO campaign : campaignList) {

            if (campaign.getDiscountTypeId() != 1){
                continue;
            }

            List<PsCampaignSectionVO> sectionList = campaign.getCampaignSectionList();
            if (CollectionUtils.isEmpty(sectionList))
                continue;
            PsCampaignSectionVO section = sectionList.get(0);
            if(spvVO != null) {
                Long campaignId = campaign.getId();
                if (spvVO.getCombined() != null && spvVO.getCombined()) {
                    String skuCode = spvVO.getSkuCode();
                    if (specialNum.equals(String.valueOf(campaignId))) {
                        LOGGER.info("===查询商品详情SKUCODE 参数为 code= {}", skuCode);
                        if (specialSkuMap.containsKey(skuCode)) {
                            LOGGER.info("===查询商品详情price 参数为 code= {}", specialSkuMap.get(skuCode));
                            targetPrice = specialSkuMap.get(skuCode);
                        }
                    } else if (special481Num.equals(String.valueOf(campaignId))) {
                        LOGGER.info("===481查询商品详情SKUCODE 参数为 code= {}", skuCode);
                        if (special481SkuMap.containsKey(skuCode)) {
                            LOGGER.info("===481查询商品详情price 参数为 code= {}", special481SkuMap.get(skuCode));
                            targetPrice = special481SkuMap.get(skuCode);
                        }
                    } else if (special482Num.equals(String.valueOf(campaignId))) {
                        LOGGER.info("===482查询商品详情SKUCODE 参数为 code= {}", skuCode);
                        if (special482SkuMap.containsKey(skuCode)) {
                            LOGGER.info("===482查询商品详情price 参数为 code= {}", special482SkuMap.get(skuCode));
                            targetPrice = special482SkuMap.get(skuCode);
                        }
                    } else if (special463Num.equals(String.valueOf(campaignId))) {
                        LOGGER.info("===463查询商品详情SKUCODE 参数为 code= {}", skuCode);
                        if (special463SkuMap.containsKey(skuCode)) {
                            LOGGER.info("===463查询商品详情price 参数为 code= {}", special463SkuMap.get(skuCode));
                            targetPrice = special463SkuMap.get(skuCode);
                        }
                    } else if (special503Num.equals(String.valueOf(campaignId))) {
                        if (special503SkuMap.containsKey(skuCode)) {
                            targetPrice = special503SkuMap.get(skuCode);
                        }
                    } else if (special574Num.equals(String.valueOf(campaignId))) {
                        if (special574SkuMap.containsKey(skuCode)) {
                            targetPrice = special574SkuMap.get(skuCode);
                        }
                    } else if (special590Num.equals(String.valueOf(campaignId))) {
                        if (special590SkuMap.containsKey(skuCode)) {
                            targetPrice = special590SkuMap.get(skuCode);
                        }
                    } else if (special591Num.equals(String.valueOf(campaignId))) {
                        if (special591SkuMap.containsKey(skuCode)) {
                            targetPrice = special591SkuMap.get(skuCode);
                        }
                    } else if (special592Num.equals(String.valueOf(campaignId))) {
                        if (special592SkuMap.containsKey(skuCode)) {
                            targetPrice = special592SkuMap.get(skuCode);
                        }
                    } else if (special594Num.equals(String.valueOf(campaignId))) {
                        if (special594SkuMap.containsKey(skuCode)) {
                            targetPrice = special594SkuMap.get(skuCode);
                        }
                    }
                }
            }
            BigDecimal factor = section.getFactor();
            Integer factorType = section.getFactorType();
            if (factor == null)
                continue;
            if(null == factorType) {
                continue;
            }
            if(factorType.equals(1)) {
                // 是统一折扣，则计算折扣价
                targetPrice = targetPrice.multiply(factor.divide(BigDecimal.TEN));
            } else if (factorType.equals(2)) {
                // 是固定价格，直接把价格设置成固定的价格
                targetPrice = factor;
            }
        }
        if (allowVipDiscount != null && allowVipDiscount) {
            targetPrice = targetPrice.multiply(discountAmount);
        }
        return targetPrice;
    }


    /**
     * 特殊处理等双十一以后会删掉 整个方法
     * @param skuVO
     * @param allowVipDiscount
     * @param originalPrice
     * @param campaignList
     * @param discountAmount
     * @return
     */
    private BigDecimal calculateDiscountPriceSpecial(PsSkuVO skuVO, Boolean allowVipDiscount, BigDecimal originalPrice,List<PsCampaignVO> campaignList, BigDecimal discountAmount) {
        BigDecimal targetPrice = originalPrice;

        for (PsCampaignVO campaign : campaignList) {
            if (campaign.getDiscountTypeId() != 1){
                continue;
            }
            List<PsCampaignSectionVO> sectionList = campaign.getCampaignSectionList();
            if (CollectionUtils.isEmpty(sectionList)){
                continue;
            }
            PsCampaignSectionVO section = sectionList.get(0);

            if(skuVO != null) {
                Long campaignId = campaign.getId();
                String skuCode = skuVO.getSkuCode();
                if (specialNum.equals(String.valueOf(campaignId))) {
                    LOGGER.info("===查询商品详情SKUCODE 参数为 code= {}", skuCode);
                    if (specialSkuMap.containsKey(skuCode)) {
                        LOGGER.info("===查询商品详情price 参数为 code= {}", specialSkuMap.get(skuCode));
                        targetPrice = specialSkuMap.get(skuCode);
                    }
                } else if (special481Num.equals(String.valueOf(campaignId))) {
                    LOGGER.info("===481查询商品详情SKUCODE 参数为 code= {}", skuCode);
                    if (special481SkuMap.containsKey(skuCode)) {
                        LOGGER.info("===481查询商品详情price 参数为 code= {}", special481SkuMap.get(skuCode));
                        targetPrice = special481SkuMap.get(skuCode);
                    }
                } else if (special482Num.equals(String.valueOf(campaignId))) {
                    LOGGER.info("===482查询商品详情SKUCODE 参数为 code= {}", skuCode);
                    if (special482SkuMap.containsKey(skuCode)) {
                        LOGGER.info("===482查询商品详情price 参数为 code= {}", special482SkuMap.get(skuCode));
                        targetPrice = special482SkuMap.get(skuCode);
                    }
                } else if (special463Num.equals(String.valueOf(campaignId))) {
                    LOGGER.info("===463查询商品详情SKUCODE 参数为 code= {}", skuCode);
                    if (special463SkuMap.containsKey(skuCode)) {
                        LOGGER.info("===463查询商品详情price 参数为 code= {}", special463SkuMap.get(skuCode));
                        targetPrice = special463SkuMap.get(skuCode);
                    }
                } else if (special503Num.equals(String.valueOf(campaignId))) {
                    if (special503SkuMap.containsKey(skuCode)) {
                        targetPrice = special503SkuMap.get(skuCode);
                    }
                } else if (special574Num.equals(String.valueOf(campaignId))) {
                    if (special574SkuMap.containsKey(skuCode)) {
                        targetPrice = special574SkuMap.get(skuCode);
                    }
                } else if (special590Num.equals(String.valueOf(campaignId))) {
                    if (special590SkuMap.containsKey(skuCode)) {
                        targetPrice = special590SkuMap.get(skuCode);
                    }
                } else if (special591Num.equals(String.valueOf(campaignId))) {
                    if (special591SkuMap.containsKey(skuCode)) {
                        targetPrice = special591SkuMap.get(skuCode);
                    }
                } else if (special592Num.equals(String.valueOf(campaignId))) {
                    if (special592SkuMap.containsKey(skuCode)) {
                        targetPrice = special592SkuMap.get(skuCode);
                    }
                } else if (special594Num.equals(String.valueOf(campaignId))) {
                    if (special594SkuMap.containsKey(skuCode)) {
                        targetPrice = special594SkuMap.get(skuCode);
                    }
                }
            }

            BigDecimal factor = section.getFactor();
            Integer factorType = section.getFactorType();
            if (factor == null)
                continue;
            if(null == factorType) {
                continue;
            }
            if(factorType.equals(1)) {
                // 是统一折扣，则计算折扣价
                targetPrice = targetPrice.multiply(factor.divide(BigDecimal.TEN));
            } else if (factorType.equals(2)) {
                // 是固定价格，直接把价格设置成固定的价格
                targetPrice = factor;
            }
        }
        if (allowVipDiscount != null && allowVipDiscount) {
            targetPrice = targetPrice.multiply(discountAmount);
        }
        return targetPrice;
    }


    @Override
    public boolean updateBySkuCodes(List<String> skuCodes) {
        if (CollectionUtils.isEmpty(skuCodes)) {
            return true;
        }

        if (skuCodes.size() > 100) {
            int all = skuCodes.size() / 100;
            for (int i = 0; i < all; i++) {
                List<String> subSkuCodes = skuCodes.subList(i * 100, (i + 1) * 100);
                if (!updateBySkuCodes100(subSkuCodes)) {
                    throw new PublicException("更新prod updateTime 出错");
                }
            }
            if (skuCodes.size() > all * 100) {
                List<String> subSkuCodes = skuCodes.subList(all * 100, skuCodes.size());
                updateBySkuCodes100(subSkuCodes);
            }
            return true;
        } else {
            return updateBySkuCodes100(skuCodes);
        }
    }

    private boolean updateBySkuCodes100(List<String> skuCodes) {
        Map<String, Object> params = new HashMap<>();
        params.put("skuCodes", skuCodes);
        params.put("pagenum", Integer.MAX_VALUE);

        List<PsProductVO> updateProds = client.findByFields(params, SearchType.OR);

        for (PsProductVO updateProd : updateProds) {
            if (CollectionUtils.isEmpty(updateProd.getSkuCodes())) {
                continue;
            }
            List<PsSkuVO> prodSkus = mcPsSkuService.findBySkuCodes(updateProd.getSkuCodes());
            if(CollectionUtils.isEmpty(prodSkus)){
                continue;
            }
            PsSkuVO psSkuVO = prodSkus.get(0);
            //ROYS 更新列表价
            if (updateProd.getSkuCodes().size() == 1) {
                updateProd.setListPrice(new BigDecimal(psSkuVO.getSalesPrice()));
            }else{
                for (PsSkuVO prodSku : prodSkus) {
                    if (updateProd.getListPrice().doubleValue() > prodSku.getSalesPrice()) {
                        updateProd.setListPrice(new BigDecimal(prodSku.getSalesPrice()).setScale(2,BigDecimal.ROUND_HALF_DOWN));
                    }
                }
            }

            updateProd.setCategoryId(psSkuVO.getCategoryId());
            //ROYS 暂不写code
            updateProd.setCategoryCode(mcPcsSkuCategoryService.findById(psSkuVO.getCategoryId()).getCode());
        }
        if (CollectionUtils.isEmpty(updateProds)) return true;
        return update(updateProds);
    }

    public PsProductVO updateCategory(PsProductVO updateProd) {
        PsSkuVO psSkuVO = mcPsSkuService.findBySkuCode(updateProd.getSkuCodes().get(0));
        if(NumberUtil.isNullOrZero(psSkuVO.getCategoryId())){
            return updateProd;
        }
        updateProd.setCategoryId(psSkuVO.getCategoryId());

        return updateProd;
    }

    @Override
    public PsProductVO findProdByChnCodeSkuCode(String chnCode, String skuCode) {
        Map<String, Object> params = new HashMap<>();
        params.put("chnCanSaleSKu.canSkus", skuCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("skuCodes", skuCode);
        params.put("onShelfChnCodes", chnCode);
        List<PsProductVO> fs =client.findByFields(params, SearchType.ANDLIKE) ;
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        return fs.get(0);
    }

    @Override
    public PsProductVO findProdBySkuCode(String skuCode) {
        return findProdBySkuCode(skuCode, false);
    }

    @Override
    public PsProductVO findProdBySkuCode(String skuCode, PsMatchCampaignCond matchCampaignCond) {
        PsProductVO productVO = findProdBySkuCode(skuCode);
        if (productVO == null) {
            return null;
        }
        if (matchCampaignCond != null) {
            matchListPageCampaigns(Lists.newArrayList(productVO), matchCampaignCond);
        }
        return productVO;
    }

    @Override
    public PsProductVO findProdBySkuCode(String skuCode, Boolean combined) {
        Map<String, Object> params = new HashMap<>();
        params.put("skuCodes", skuCode);
        if (combined != null) {
            params.put("combined", combined ? 1 : 0);
        }
        List<PsProductVO> fs =client.findByFields(params, SearchType.ANDLIKE) ;
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        return fs.get(0);
    }

    @Override
	public PsProductVO findProdBySpvId(Long spvId) {
    	Map<String, Object> params = new HashMap<>();
        params.put("spvId", spvId);
        List<PsProductVO> fs =client.findByFields(params, SearchType.ANDLIKE) ;
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        return fs.get(0);
	}

    @Override
    public List<PsProductVO> findByChnCodeCateCode(String chnCode, String cateCode) {
        List<PcsSkuCategoryVO> categories = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
        List<Long> cateIds = new ArrayList<>(categories.size());
        for (PcsSkuCategoryVO category : categories) {
            cateIds.add(category.getId());
        }
        if (CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }
        Map<String, Object> params = new HashMap<>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("categoryId", cateIds);

        int currpage = 1;
        params.put("pagenum", 20);
        params.put("currpage", currpage);
        List<List<String>> seqList = new ArrayList<List<String>>();
        List<String> seq1 = new ArrayList<String>();
        seq1.add("categoryId");
        seq1.add("asc");
        seqList.add(seq1);
        List<String> seq = new ArrayList<String>();
        seq.add("seq");
        seq.add("asc");
        seqList.add(seq);
        params.put("sort",seqList);
        List<PsProductVO> productVOs = new ArrayList<>(100);
        List<PsProductVO> prodVos = client.findByFields(params,SearchType.ANDLIKE);
        productVOs.addAll(prodVos);
        while(prodVos.size() == 20){
            currpage++;
            params.put("currpage", currpage);
            params.put("pagenum", 20);
            params.put("sort",seqList);
            prodVos = client.findByFields(params,SearchType.ANDLIKE);
            productVOs.addAll(prodVos);
        }

        return productVOs;
    }

    @Override
    public List<PsProductVO> findRecommondProdByCodes(String chnCode, List<String> codes, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("stocks.soldOut", QueryBuilders.termQuery("stocks.soldOut", 0));
        params.put("code", codes);

        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        Map seqMap = new LinkedHashMap();


        List<String> sortUpdateTime = new ArrayList<>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");

        List<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");

        Map sNestedMap = new HashMap();
        sNestedMap.put("stocks.chnCode", chnCode);
        seqMap.put("listPrice", "asc");
        seqMap.put("saleStartDate", "desc");
        params.put("sort", seqMap);
        List<PsProductVO> productVOList = client.findByFields(params,SearchType.ANDLIKE);

        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign()) {
//            matchProductsCampaigns(productVOList, matchCampaignCond, true);
            matchListPageCampaigns(productVOList, matchCampaignCond);
            productVOList = calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
        }
        return productVOList;

    }

    @Override
    public List<PsProductVO> findListPageByCodes(String chnCode, List<String> codes, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
//        params.put("chnCanSaleSKu.chnCode", chnCode);
//        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("code", codes);

        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        Map seqMap = new LinkedHashMap();


        List<String> sortUpdateTime = new ArrayList<>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");

        List<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");

        Map sMap = new HashMap();
        Map sNestedMap = new HashMap();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);

        seqMap.put("listPrice", "asc");

        seqMap.put("saleStartDate", "desc");
        params.put("sort", seqMap);
        List<PsProductVO> productVOList = client.findByFields(params,SearchType.ANDLIKE);

        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign()) {
//            matchProductsCampaigns(productVOList, matchCampaignCond, true);
            matchListPageCampaigns(productVOList, matchCampaignCond);
            productVOList = calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
        }
        return productVOList;


    }

    //根据多类目和、是否新上架查询 by Lk
    @Override
    public List<PsProductVO> findByProdSearchCondVO(String chnCode, final PsMatchCampaignCond matchCampaignCond, final ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====查询es 参数为 chnCode= {},prodSearchCondVO={}",chnCode,prodSearchCondVO);
        Map<String,Object> selectMap = new HashMap<String,Object>();
        List<String> cateCodes = prodSearchCondVO.getCategoryCodes();
        String key = prodSearchCondVO.getKeywords();
        String labels = prodSearchCondVO.getLabels();
        String brandId = prodSearchCondVO.getBrandId();
        Boolean isCrossBorder = prodSearchCondVO.getIsCrossBorder() == null ? false : prodSearchCondVO.getIsCrossBorder();
        Integer from = prodSearchCondVO.getFrom() != null && prodSearchCondVO.getFrom() > 0 ? (Integer) prodSearchCondVO.getFrom() : 0;
        Integer size = prodSearchCondVO.getSize() != null && prodSearchCondVO.getSize() > 0 ? (Integer) prodSearchCondVO.getSize() : 20;
        Boolean isNew = prodSearchCondVO.getIsNew() == null ? false : prodSearchCondVO.getIsNew();

        Map seqMap = new LinkedHashMap();
        Map sMap = new HashMap();
        Map sNestedMap = new HashMap();
        Map map = new HashMap();
        Map paramsMap = new HashMap();
        Map slMap = new HashMap();

        if(isCrossBorder){
            Map<String, Object> params = new HashMap<>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);

            seqMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            map.put("order", "asc");
            map.put("mode", "min");
            LOGGER.info("是否海淘商品查询的参数    params={} from={},size={},isCrossBorder={}", params, from, size, isCrossBorder);
            selectMap.put("isCrossBorder",isCrossBorder);
            List<PsProductVO> productVOList = client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap,from,size);
            LOGGER.info("返回的结果数量为={}",productVOList.size());
            if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign()) {
//                matchProductsCampaigns(productVOList, matchCampaignCond, true);
                matchListPageCampaigns(productVOList, matchCampaignCond);
                calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
            }
            sw.stop();
            LOGGER.info("【商品接口耗时】商品查询列表 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
            return productVOList;
        }

        if(!Strings.isNullOrEmpty(labels)){
            Map<String, Object> params = new HashMap<>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);

            seqMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            map.put("order", "asc");
            map.put("mode", "min");

            String sortField = prodSearchCondVO.getSortField();
            String sortOrder = prodSearchCondVO.getSortOrder();

            if (Strings.isNullOrEmpty(sortField) || Strings.isNullOrEmpty(sortOrder)) {
                seqMap.put("saleStartDate", "desc");
            } else {
                if ("create_time".equals(sortField)) {
                    seqMap.put("channelProdInfo.createTime", slMap);
                    slMap.put("order", sortOrder);
                    slMap.put("mode", "min");
                } else if ("price".equals(sortField)) {
                    seqMap.put("listPrice", sortOrder);
                }
            }

            LOGGER.info("标签查询的参数    params={} from={},size={},psTags={}", params, from, size, labels);
            params.put("sort", seqMap);
            selectMap.put("labels",labels);
            List<PsProductVO> productVOList = client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap,from,size);
            LOGGER.info("返回的结果数量为={}",productVOList.size());
            if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign()) {
//                matchProductsCampaigns(productVOList, matchCampaignCond, true);
                matchListPageCampaigns(productVOList, matchCampaignCond);
                calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
            }
            sw.stop();
            LOGGER.info("【商品接口耗时】商品查询列表 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
            return productVOList;
        }

        if(!Strings.isNullOrEmpty(brandId)) {
            Map<String, Object> params = new HashMap<>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);

            String sortField = prodSearchCondVO.getSortField();
            String sortOrder = prodSearchCondVO.getSortOrder();

            seqMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            map.put("order", "asc");
            map.put("mode", "min");

            if (Strings.isNullOrEmpty(sortField) || Strings.isNullOrEmpty(sortOrder)) {
                seqMap.put("saleStartDate", "desc");
            } else {
                if ("create_time".equals(sortField)) {
                    seqMap.put("channelProdInfo.createTime", slMap);
                    slMap.put("order", sortOrder);
                    slMap.put("mode", "min");
                } else if ("price".equals(sortField)) {
                    seqMap.put("listPrice", sortOrder);
                }
            }

            params.put("sort", seqMap);
            selectMap.put("brandId",brandId);
            List<PsProductVO> productVOList = client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap, from, size);

            if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign()) {
//                matchProductsCampaigns(productVOList, matchCampaignCond, true);
                matchListPageCampaigns(productVOList, matchCampaignCond);
                calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
            }
            sw.stop();
            LOGGER.info("【商品接口耗时】商品查询列表 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
            return productVOList;
        }

        if(Strings.isNullOrEmpty(key)) {
            List<PcsSkuCategoryVO> categoriesList = new ArrayList<PcsSkuCategoryVO>();
            if (cateCodes != null && cateCodes.size() > 0) {
                for (String cateCode : cateCodes) {
                    List<PcsSkuCategoryVO> category = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                    categoriesList.addAll(category);
                }
            }
//            sw.stop();
//            LOGGER.info("【商品接口耗时】类目查询 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
            //去重
//        List<PcsSkuCategoryVO> categories = new ArrayList<PcsSkuCategoryVO>(new HashSet<PcsSkuCategoryVO>(categoriesList));

            List<Long> cateIds = new ArrayList<>(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
            //如果不是最新上架就不返回       返回 所有的    类目 最新的东西
            if(!isNew) {
                if (CollectionUtils.isEmpty(cateIds)) {
                    return Collections.emptyList();
                }
            }
            Map<String, Object> params = new HashMap<>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);
            params.put("frontCategories.categoryId", cateIds);
            //是否新上架
            if (isNew) {
                DateRange dateRange = prodSearchCondVO.getDateRange();
                if (dateRange == null) {
                    dateRange = new DateRange();
                    //无上架范围默认14天
                    Date end = new Date();
                    dateRange.setEnd(end);
                    Calendar calendar = new GregorianCalendar();
                    calendar.setTime(end);
                    calendar.add(calendar.DATE, -14);
                    Date start = calendar.getTime();
                    dateRange.setStart(start);
                }
                params.put("channelProdInfo.createTime", dateRange);
            }

            String sortField = prodSearchCondVO.getSortField();
            String sortOrder = prodSearchCondVO.getSortOrder();

            seqMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            paramsMap.put("categoryIds", cateIds);
            map.put("order", "asc");
            map.put("mode", "min");

            if (Strings.isNullOrEmpty(sortField) || Strings.isNullOrEmpty(sortOrder)) {
                seqMap.put("saleStartDate", "desc");
            } else {
                if ("create_time".equals(sortField)) {
                    seqMap.put("channelProdInfo.createTime", slMap);
                    slMap.put("order", sortOrder);
                    slMap.put("mode", "min");
                } else if ("price".equals(sortField)) {
                    seqMap.put("listPrice", sortOrder);
                }
            }
            String fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
            seqMap.put("_script", map);
            map.put("script", "frontCategorySort");
            map.put("params", paramsMap);
            paramsMap.put("fieldName", fieldName);

            params.put("sort", seqMap);
            List<PsProductVO> productVOList = client.findByFieldWithProdSearchCondVO(params, SearchType.ANDLIKE, from, size);

            if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign()) {
//                matchProductsCampaigns(productVOList, matchCampaignCond, true);
                matchListPageCampaigns(productVOList, matchCampaignCond);
                calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
            }
            sw.stop();
            LOGGER.info("【商品接口耗时】商品查询列表 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
            return productVOList;
        }else{
            Map<String, Object> params = new HashMap<>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);

            seqMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            map.put("order", "asc");
            map.put("mode", "min");
            LOGGER.info("关键字查询的参数    params={} from={},size={},key={}", params, from, size, key);
            List<PsProductVO> productVOList = client.findByFieldWithKeyWords(params, SearchType.ANDLIKE,key,from,size);
            LOGGER.info("返回的结果数量为={}", productVOList.size());
            if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign()) {
//                matchProductsCampaigns(productVOList, matchCampaignCond, true);
                matchListPageCampaigns(productVOList, matchCampaignCond);
                calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
            }
            sw.stop();
            LOGGER.info("【商品接口耗时】商品查询列表 {}", DurationFormatUtils.formatDurationHMS(sw.getTime()));
            return productVOList;
        }
    }

    /**
     * 匹配商品列表页活动
     * @param productVOList
     * @param cond
     */
    private void matchListPageCampaigns(List<PsProductVO> productVOList, PsMatchCampaignCond cond) {
        Integer memberLevel = cond.getMemberLevel();
        Integer accessWay = cond.getAccessWay();
        List<PsCampaignVO> globalCampaigns = new ArrayList<>();
        if (cond.getMatchGlobalCampaigns() != null && cond.getMatchGlobalCampaigns()) {
            globalCampaigns = getGlobalCampaignList(cond);
        }
        for (PsProductVO psProductVO : productVOList) {
            List<PsCampaignVO> campaignList = psProductVO.getCampaignList();
            campaignList.addAll(globalCampaigns);
            // 匹配进行中和预告的活动
            matchCampaignList(campaignList, psProductVO, memberLevel, accessWay);
        }
    }

    /**
     * 匹配商品活动
     * @param psProductVO
     * @param cond
     */
    private void matchCampaigns(PsProductVO psProductVO, PsMatchCampaignCond cond, boolean matchGlobalCampaigns) {
        Integer memberLevel = cond.getMemberLevel();
        Integer accessWay = cond.getAccessWay();
        List<PsCampaignVO> campaignList = psProductVO.getCampaignList();
        if (matchGlobalCampaigns) {
            List<PsCampaignVO> globalCampaigns = getGlobalCampaignList(cond);
            campaignList.addAll(globalCampaigns);
        }
        // 匹配进行中和预告的活动
        matchCampaignList(campaignList, psProductVO, memberLevel, accessWay);
    }


    @Override
    public List<PsProductVO> findByChnCodeCateCode(
            String chnCode, String cateCode, final PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        if (pagenum < 1) {
            return Collections.emptyList();
        }

        List<PcsSkuCategoryVO> categories = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
        List<Long> cateIds = new ArrayList<>(categories.size());
        for (PcsSkuCategoryVO category : categories) {
            cateIds.add(category.getId());
        }
        if (CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }

        Map<String, Object> params = new HashMap<>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
//        params.put("categoryId", cateIds);
        params.put("frontCategories.categoryId", cateIds);

        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        List<Object> seqList = new ArrayList<Object>();
        Map seqMap = new LinkedHashMap();


        List<String> sortUpdateTime = new ArrayList<>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");

        List<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");

/*
        if (categories.size() > 1) {
            List<String> sort1 = new ArrayList<String>();
            sort1.add("sort1");
            sort1.add("asc");
            seqList.add(sort1);
//            seqList.add(sort2);
        }
        else if (categories.size() == 1) {
            List<String> sort2 = new ArrayList<String>();
            sort2.add("sort2");
            sort2.add("asc");
            seqList.add(sort2);
//            seqList.add(sort1);
        }
*/

        Map sMap = new HashMap();
        Map sNestedMap = new HashMap();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);

/*
        if (categories.size() > 1) {
            Map map = new HashMap();
            Map nestedMap = new HashMap();
            seqMap.put("frontCategories.sort1", map);
            map.put("order", "asc");
            map.put("mode", "min");
            map.put("nested_filter", nestedMap);
            nestedMap.put("frontCategories.categoryId", cateIds);
        }
        else if (categories.size() == 1) {
            Map map = new HashMap();
            Map nestedMap = new HashMap();
            seqMap.put("frontCategories.sort2", map);
            map.put("order", "asc");
            map.put("mode", "min");
            map.put("nested_filter", nestedMap);
            nestedMap.put("frontCategories.categoryId", cateIds);
        }
*/
        String fieldName = categories.size() > 1 ? "sort1" : "sort2";
        Map map = new HashMap();
//        Map nestedMap = new HashMap();
        Map paramsMap = new HashMap();
        seqMap.put("_script", map);
        map.put("script", "frontCategorySort");
        map.put("params", paramsMap);
        paramsMap.put("categoryIds", cateIds);
        paramsMap.put("fieldName", fieldName);
        map.put("order", "asc");
        map.put("mode", "min");
//        map.put("nested_filter", nestedMap);
//        nestedMap.put("frontCategories.categoryId", cateIds);


//        List<String> saleStartDate = new ArrayList<>();
//        saleStartDate.add("saleStartDate");
//        saleStartDate.add("desc");
        seqMap.put("saleStartDate", "desc");

//        seqList.add(saleStartDate);

//        seqList.add(sortCode);

/*
        List<String> seq1 = new ArrayList<String>();
        seq1.add("categoryId");
        seq1.add("asc");
        seqList.add(seq1);
        List<String> seq = new ArrayList<String>();
        seq.add("seq");
        seq.add("asc");
        seqList.add(seq);
*/
        params.put("sort",seqMap);
        List<PsProductVO> productVOList = client.findByFields(params,SearchType.ANDLIKE);

        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign()) {
//            matchProductsCampaigns(productVOList, matchCampaignCond, true);
            matchListPageCampaigns(productVOList, matchCampaignCond);
            productVOList = calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
        }
        return productVOList;
    }
    
    @Override
    public List<PsProductVO> findByChnCodeCateCodeCreateTime(
            String chnCode, Map<String,Date> dateRange, final PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        if (pagenum < 1) {
            return Collections.emptyList();
        }

        Map<String, Object> params = new HashMap<>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);

        //params.put("channelProdInfo.channelCode", chnCode);
        params.put("pagenum", pagenum);
        params.put("currpage", currpage);

        // sort排序
        Map sortRootMap = new LinkedHashMap();
        Map sortSoldOut = new HashMap();
        sortRootMap.put("stocks.soldOut", sortSoldOut);
        sortSoldOut.put("order", "asc");
        sortSoldOut.put("mode", "min");
        Map soldOutNestedFilter = new HashMap();
        sortSoldOut.put("nested_filter", soldOutNestedFilter);
        soldOutNestedFilter.put("stocks.chnCode", chnCode);
        
        Map sortCreateTime = new HashMap();
        sortRootMap.put("channelProdInfo.createTime", sortCreateTime);
        sortCreateTime.put("order", "desc");
        sortCreateTime.put("mode", "min");
        Map createTimeNestedFilter = new HashMap();
        sortCreateTime.put("nested_filter", createTimeNestedFilter);
        Map rangeMap = new HashMap();
        createTimeNestedFilter.put("range", rangeMap);
        Map createTimeRangeMap = new HashMap();
        rangeMap.put("channelProdInfo.createTime", createTimeRangeMap);
        createTimeRangeMap.put("from", dateRange.get("createTimeStart"));
        createTimeRangeMap.put("to", dateRange.get("createTimeEnd"));

        params.put("sort",sortRootMap);
        
        Map chanelProdTime = new HashMap();
        chanelProdTime.put("createTimeStart", dateRange.get("createTimeStart"));
        chanelProdTime.put("createTimeEnd", dateRange.get("createTimeEnd"));
        chanelProdTime.put("channelCode", chnCode);
        params.put("chanelProdTime", chanelProdTime);
        List<PsProductVO> productVOList = client.findByFields(params,SearchType.ANDLIKE);
        
        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign()) {
            matchListPageCampaigns(productVOList, matchCampaignCond);
            calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
        }
        return productVOList;
    }

    @Override
    public List<PsProductVO> findByChnCodeCateCodeRightLike(String chnCode, String cateCode) {
        List<PsProductVO> allProds = new ArrayList<>();
        Map<String, Object> params = new HashMap<>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("categoryCode", cateCode);
        List<PsProductVO> productVOs = client.findByFields(params, SearchType.AND);
        if (CollectionUtils.isNotEmpty(productVOs)) {
            allProds.addAll(productVOs);
        }
        params.remove("categoryCode");
        params.put("categoryCodePRE", cateCode+"_");
        List<PsProductVO> productVOList =  client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isNotEmpty(productVOList)) {
            allProds.addAll(productVOList);
        }
        return allProds;
    }
    @Override
    public PsProductVO findProdByCode(String code) {
        Map<String, Object> params = new HashMap<>();
        params.put("code", code);
        List<PsProductVO> fs =client.findByFields(params, SearchType.ANDLIKE) ;
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        for (PsProductVO vo : fs) {
            vo.setCampaignList(Lists.<PsCampaignVO>newArrayList());
        }
        return fs.get(0);
    }

	@Override
	public Map<String, PsProductVO> mapByProdIds(List<String> prodIds) {
		if (CollectionUtils.isNotEmpty(prodIds)) {
			Map<String, PsProductVO> rt = Maps.newHashMapWithExpectedSize(prodIds.size());
			PsProductCond cond = new PsProductCond();
			cond.setIds(prodIds);
			List<PsProductVO> prods = findByCond(cond);
			for (PsProductVO prod : prods) {
				rt.put(prod.getId(), prod);
			}
			return rt;
		}
		return null;
	}

    /**
     * 获取商品详情
     * @param chnCode
     * @param productCode
     * @param matchCampaignCond
     * @return
     */
    @Override
    public PsProductVO getProductDetailByCode(String chnCode, String productCode, PsMatchCampaignCond matchCampaignCond) {
        if (matchCampaignCond == null)
            throw new PublicException("未传活动匹配条件");

        // 获取PROD
        Map<String, Object> params = new HashedMap();
        params.put("code", productCode);
        List<PsProductVO> list = client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isEmpty(list)) {
            params = new HashedMap();
            params.put("skuCode", productCode);
            params.put("combined", 0);
            list = client.findByFields(params, SearchType.ANDLIKE);
            if (CollectionUtils.isEmpty(list)) {
                params = new HashedMap();
                params.put("skuCode", productCode);
                params.put("combined", 1);
                list = client.findByFields(params, SearchType.ANDLIKE);
                if (CollectionUtils.isEmpty(list)) {
                    return null;
                }
            }
        }
        PsProductVO psProductVO = list.get(0);

        if (matchCampaignCond.getMatchCampaign()) {
            // 匹配活动
            matchCampaigns(psProductVO, matchCampaignCond, true);
            // 排除全场换购
            excludeSpecialCampaigns(psProductVO);
            // 计算折扣价
            calculateDiscountPrice(
                    psProductVO,
                    matchCampaignCond.getMemberLevel(),
                    matchCampaignCond.getAccessWay(),
                    matchCampaignCond.getDiscount());
        }

        List<PsSpvVO> spvList = psProductVO.getSpvList();
        if (CollectionUtils.isEmpty(spvList)) {
            LOGGER.error("【商品详情】商品中SPV列表为空");
            return psProductVO;
        }

        String productIdStr = psProductVO.getId();
        Long productId = Long.valueOf(productIdStr);

        // 如果为单品，先获取所有SKU
        Map<String, PsSkuVO> skuMap = new HashedMap();
        List<String> skuCodes = psProductVO.getSkuCodes();
        if (CollectionUtils.isEmpty(skuCodes)) {
            LOGGER.warn("【商品详情】商品中SKU CODE列表为空");
        }
        List<PsSkuVO> skuList = mcPsSkuService.findBySkuCodes(skuCodes);
        if (CollectionUtils.isEmpty(skuList)) {
            LOGGER.warn("未找到任何SKU");
        }
        for (PsSkuVO skuVO : skuList) {
            skuMap.put(skuVO.getSkuCode(), skuVO);
        }

        Map<String, String> canSaleSkuMap = getCanSaleSkuMap(chnCode, psProductVO);
        Map<String, String> canSeeSkuMap = getCanSeeSkuMap(chnCode, psProductVO);
        List<PsSpvVO> newSpvList = new ArrayList<>();
        for (PsSpvVO spvVO : spvList) {
            spvVO.setProductId(productId);
            spvVO.setProductCode(psProductVO.getCode());
            if (psProductVO.getCombined()) { // 组合SPV
                buildCombinedSpv(psProductVO, spvVO, skuMap, matchCampaignCond);
            }
            else { // 单品SPV
                buildSingleSpv(psProductVO, spvVO, skuMap, matchCampaignCond);
            }
            // 判断是否可用
            if (isSpvAvailable(canSaleSkuMap, canSeeSkuMap, spvVO)) {
                newSpvList.add(spvVO);
            }
            psProductVO.setSpvList(newSpvList);
        }
        return psProductVO;
    }

    /**
     * 构建组合SPV
     */
    private void buildCombinedSpv(PsProductVO productVO, PsSpvVO spvVO, Map<String, PsSkuVO> skuMap, PsMatchCampaignCond matchCampaignCond) {
        calculateDiscountPrice(productVO, spvVO, matchCampaignCond);
        List<PsSkuCombinationVO> skuCombinationList = spvVO.getSkuCombinationList();
        if (CollectionUtils.isEmpty(skuCombinationList)) {
            LOGGER.error("【商品详情】组合SPV中的SKU组合为空");
            return;
        }
        for (PsSkuCombinationVO skuCombinationVO : skuCombinationList) {
            String skuCode = skuCombinationVO.getSubSkuCode();
            PsSkuVO skuVO = getSkuFromCodeOrCache(skuCode, skuMap);
            skuCombinationVO.setSubSkuVO(skuVO);
        }
    }

    /**
     * 构建单品SPV
     */
    private void buildSingleSpv(PsProductVO psProductVO, PsSpvVO spvVO, Map<String, PsSkuVO> skuMap, PsMatchCampaignCond matchCampaignCond) {
        String skuCode = spvVO.getSkuCode();
        if (StringUtils.isBlank(skuCode)) {
            LOGGER.error("【商品详情】单品SPV中的SKU CODE为空");
            return;
        }
        PsSkuVO skuVO = getSkuFromCodeOrCache(skuCode, skuMap);
        skuVO = calculateDiscountPrice(psProductVO, skuVO, matchCampaignCond);

        // 设置SKU和价格
        spvVO.setSkuVO(skuVO);
        spvVO.setSalesPrice(new BigDecimal(skuVO.getSalesPrice()));
        spvVO.setCostPrice(skuVO.getCostPrice());
        spvVO.setDiscountPrice(skuVO.getDiscountPrice());
        spvVO.setAdvancePrice(skuVO.getAdvancePrice());
        // 组装规格
        String skuCategoryDesc = psProductVO.getSkuCategoryDesc();
        String skuCateName = skuVO.getSkuCateName();
        if (StringUtils.isNoneEmpty(skuCategoryDesc) && StringUtils.isNotEmpty(skuCateName)) {
            PsAttributeValuePairVO attributeValuePairVO = new PsAttributeValuePairVO();
            attributeValuePairVO.setCombined(false);
            attributeValuePairVO.setAttrName(skuCategoryDesc);
            attributeValuePairVO.setValue(skuCateName);
            spvVO.setAttributeValuePairList(Arrays.asList(attributeValuePairVO));
        }
    }

    private boolean isSpvAvailable(Map<String, String> canSaleMap,
                                   Map<String, String> canSeeMap,
                                   PsSpvVO spvVO) {
        if (spvVO.getCombined()) { // 组合
            List<PsSkuCombinationVO> skuCombinationList = spvVO.getSkuCombinationList();
            for (PsSkuCombinationVO skuCombinationVO : skuCombinationList) {
                if (!isSkuAvailable(canSaleMap, canSeeMap, skuCombinationVO.getSubSkuCode())) {
                    return false;
                }
            }
            return true;
        }
        else { // 单品
            return isSkuAvailable(canSaleMap, canSeeMap, spvVO.getSkuCode());
        }
    }



    /**
     * SKU是否可用
     * @param canSaleMap
     * @param canSeeMap
     * @param skuCode
     * @return
     */
    private boolean isSkuAvailable(Map<String, String> canSaleMap,
                                   Map<String, String> canSeeMap,
                                   String skuCode) {
        return canSaleMap.containsKey(skuCode) && canSeeMap.containsKey(skuCode);
    }


    private PsSkuVO getSkuFromCodeOrCache(String skuCode, Map<String, PsSkuVO> skuMap) {
        if (StringUtils.isBlank(skuCode)) {
            LOGGER.error("【商品详情】单品SPV中的SKU CODE为空");
            return null;
        }
        PsSkuVO skuVO = skuMap.get(skuCode);
        if (skuVO == null) {
            LOGGER.warn("【商品详情】单品SPV中的SKU[{}]未能在SKU CODE中找到", skuCode);
            skuVO = mcPsSkuService.findBySkuCode(skuCode);
        }
        return skuVO;
    }


    private Map<String, String> getCanSeeSkuMap(String chnCode, PsProductVO psProductVO) {
        Map<String, String> canSeeSkuMap = new HashedMap();
        List<PsChnProdSaleSkuVO> canSeeSkuList = psProductVO.getChnCanSeeSKu();
        if (CollectionUtils.isEmpty(canSeeSkuList)) return canSeeSkuMap;
        PsChnProdSaleSkuVO canSeeSku = null;
        for (PsChnProdSaleSkuVO chnProdSaleSkuVO : canSeeSkuList) {
            if (org.apache.commons.lang.StringUtils.equals(chnProdSaleSkuVO.getChnCode(), chnCode)) {
                canSeeSku = chnProdSaleSkuVO;
                break;
            }
        }
        if (canSeeSku != null) {
            for (String skuCode : canSeeSku.getCanSkus()) {
                canSeeSkuMap.put(skuCode, skuCode);
            }
        }
        return canSeeSkuMap;
    }

    private Map<String, String> getCanSaleSkuMap(String chnCode, PsProductVO psProductVO) {
        Map<String, String> canSaleSkuMap = new HashedMap();
        List<PsChnProdSaleSkuVO> canSaleSkuList = psProductVO.getChnCanSaleSKu();
        if (CollectionUtils.isEmpty(canSaleSkuList)) return canSaleSkuMap;
        PsChnProdSaleSkuVO canSaleSku = null;
        for (PsChnProdSaleSkuVO chnProdSaleSkuVO : canSaleSkuList) {
            if (org.apache.commons.lang.StringUtils.equals(chnProdSaleSkuVO.getChnCode(), chnCode)) {
                canSaleSku = chnProdSaleSkuVO;
                break;
            }
        }
        if (canSaleSku != null) {
            for (String skuCode : canSaleSku.getCanSkus()) {
                canSaleSkuMap.put(skuCode, skuCode);
            }
        }
        return canSaleSkuMap;
    }


}
