/*
 * Copyright (C), 涓婃捣甯冮瞾鐖辩數瀛愬晢鍔℃湁闄愬叕鍙�
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.thebeastshop.pegasus.merchandise.cond.PcsSupplierCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsSupplierDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsPurchaseCategoryPermission;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplier;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplierBusinessCategory;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplierPurchaseCategory;
import com.thebeastshop.pegasus.merchandise.service.McPcsSupplierService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSupplierVO;
import com.thebeastshop.pegasus.merchandise.vo.SupplierBrandRelation;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.*;
import java.util.*;

/**
 * @author Eric.Lou
 * @version $Id: McPcsSupplierServiceImpl.java, v 0.1 2015-07-27 17:55
 */
@Path("/supplier")
@Consumes({ContentType.APPLICATION_JSON_UTF_8})
@Produces({ContentType.APPLICATION_JSON_UTF_8})
@Service("mcPcsSupplierService")
public class McPcsSupplierServiceImpl implements McPcsSupplierService {

    @Autowired
    private PcsSupplierDomain pcsSupplierDomain;

    @POST
    @Override
    public Long create(PcsSupplierVO vo, boolean saveDraft) {
    	Long supplierId = pcsSupplierDomain.create(pcsSupplierDomain.buildFromVO(vo), saveDraft);
    	addBusinessCategory(supplierId.intValue(), vo.getCategoryList());
    	addPurchaseCategory(supplierId.intValue(), vo.getPurchaseCategoryList());
        return supplierId;
    }

    @Override
    public Long createSupplier(PcsSupplierVO vo) {
    	Long supplierId = pcsSupplierDomain.create(pcsSupplierDomain.buildFromVO(vo), vo.isSaveDraft());
    	addBusinessCategory(supplierId.intValue(), vo.getCategoryList());
    	addPurchaseCategory(supplierId.intValue(), vo.getPurchaseCategoryList());
        return supplierId;
    }

    @PUT
    @Override
    public Boolean update(PcsSupplierVO vo, boolean saveDraft) {
    	Long supplierId = vo.getId();
    	addBusinessCategory(supplierId.intValue(), vo.getCategoryList());
    	addPurchaseCategory(supplierId.intValue(), vo.getPurchaseCategoryList());
        return pcsSupplierDomain.update(pcsSupplierDomain.buildFromVO(vo), saveDraft);
    }

    @Override
    public Boolean updateSupplier(PcsSupplierVO vo) {
    	if(vo.isSaveDraft()) {
	    	Long supplierId = vo.getId();
	    	addBusinessCategory(supplierId.intValue(), vo.getCategoryList());
	    	addPurchaseCategory(supplierId.intValue(), vo.getPurchaseCategoryList());
    	}
        return pcsSupplierDomain.update(pcsSupplierDomain.buildFromVO(vo), vo.isSaveDraft());
    }

    @GET
    @Path("{id:\\d+}")
    @Override
    public PcsSupplierVO findById(@PathParam("id") Long id) {
        PcsSupplier record = pcsSupplierDomain.findById(id);
        PcsSupplierVO vo = pcsSupplierDomain.buildFromModel(record);
        if(vo != null) {
	        vo.setCategoryList(pcsSupplierDomain.findBusinessCategoryBySupplierId(vo != null ? id.intValue() : null));
	        vo.setPurchaseCategoryList(pcsSupplierDomain.findPurchaseCategoryBySupplierId(vo != null ? id.intValue() : null));
        }
        return vo;

    }

    @Override
    public List<PcsSupplierVO> findByCond(PcsSupplierCond cond) {
        List<PcsSupplierVO> recordList = pcsSupplierDomain.findByCond(cond);
       /* List<PcsSupplierVO> vos = new ArrayList<PcsSupplierVO>(recordList.size());
        for (PcsSupplier record : recordList) {
            PcsSupplierVO vo = pcsSupplierService.buildFromModel(record);
            vos.add(vo);
        }*/
        return recordList;

    }

    @Override
    public List<PcsSupplierVO> findByCriteria(PcsSupplierCond cond) {
        List<PcsSupplier> recordList = pcsSupplierDomain.findByCriteria(cond);
        List<PcsSupplierVO> vos = new ArrayList<PcsSupplierVO>(recordList.size());
        for (PcsSupplier record : recordList) {
            PcsSupplierVO vo = pcsSupplierDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    @GET
    @Path("name/{name}")
    @Override
    public List<PcsSupplierVO> findByName(@PathParam("name") String name) {
        List<PcsSupplier> recordList = pcsSupplierDomain.findByName(name);
        List<PcsSupplierVO> vos = new ArrayList<>(recordList.size());
        for (PcsSupplier record : recordList) {
            PcsSupplierVO vo = pcsSupplierDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public List<PcsSupplierVO> findByIds(List<Long> ids) {
        List<PcsSupplier> recordList = pcsSupplierDomain.findByIds(ids);
        List<PcsSupplierVO> vos = new ArrayList<>(recordList.size());
        for (PcsSupplier record : recordList) {
            PcsSupplierVO vo = pcsSupplierDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;

    }

    @Override
    public Boolean audiSupplier(Long userId, long id, Boolean isPass, Integer type) {
        return pcsSupplierDomain.audiSupplier(userId, id, isPass, type);
    }

    @Override
    public long countByCond(PcsSupplierCond cond) {
        return pcsSupplierDomain.countByCond(cond);
    }

	@Override
	public List<SupplierBrandRelation> findSupplierBrandRelation() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<Integer> addPurchaseCategory(Integer supplierId, List<String> categoryList) {
		pcsSupplierDomain.deletePurchaseCategoryBySupplierId(supplierId);
		if(EmptyUtil.isNotEmpty(categoryList)) {
			for(String categoryId : categoryList) {
				PcsSupplierPurchaseCategory supplierBusinessCategory = new PcsSupplierPurchaseCategory();
				supplierBusinessCategory.setPurchaseCategory(categoryId);
				supplierBusinessCategory.setSupplierId(supplierId);
				pcsSupplierDomain.addSupplierPurchaseCategory(supplierBusinessCategory);
			}
		}
		return null;
	}

	@Override
	public List<Integer> addBusinessCategory(Integer supplierId, List<String> categoryList) {
		pcsSupplierDomain.deleteBusinessCategoryBySupplierId(supplierId);
		if(EmptyUtil.isNotEmpty(categoryList)) {
			for(String categoryId : categoryList) {
				PcsSupplierBusinessCategory supplierBusinessCategory = new PcsSupplierBusinessCategory();
				supplierBusinessCategory.setBusinessCategory(categoryId);
				supplierBusinessCategory.setSupplierId(supplierId);
				pcsSupplierDomain.addSupplierBusinessCategory(supplierBusinessCategory);
			}
		}
		return null;
	}
	
	

}
