/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuSalesPriceChangeDomain;
import com.thebeastshop.pegasus.merchandise.model.*;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuSalesPriceChangeService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCostPriceChangeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuSalesPriceChangeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuSupplierChangeVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;

import javax.ws.rs.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: McPcsSkuSalesPriceChangeServiceImpl.java, v 0.1 2015-08-05 14:47
 */
@Path("/sku/sales/price/change")
@Consumes({ContentType.APPLICATION_JSON_UTF_8})
@Produces({ContentType.APPLICATION_JSON_UTF_8})
@Service("mcPcsSkuSalesPriceChangeService")
public class McPcsSkuSalesPriceChangeServiceImpl implements McPcsSkuSalesPriceChangeService {

    @Autowired
    private PcsSkuSalesPriceChangeDomain pcsSkuSalesPriceChangeDomain;

    @Override
    public Long create(String code, BigDecimal price) {
        return pcsSkuSalesPriceChangeDomain.create(code, price);
    }

    @Override
    public boolean update(PcsSkuSalesPriceChangeVO record) {
        return pcsSkuSalesPriceChangeDomain.update(pcsSkuSalesPriceChangeDomain.bulidFromVO(record));
    }

    @Override
    public PcsSkuSalesPriceChangeVO findById(long id) {
        return pcsSkuSalesPriceChangeDomain.buildFromModel(
                pcsSkuSalesPriceChangeDomain.findById(id));
    }

    @Override
    public List<PcsSkuSalesPriceChangeVO> findByCode(String code) {
        return BeanUtil.buildListFrom(
                pcsSkuSalesPriceChangeDomain.findByCode(code),
                PcsSkuSalesPriceChangeVO.class
        );
    }

    @GET
    @Path("code/{code}/status/{status}")
    @Override
    public List<PcsSkuSalesPriceChangeVO> findByCodeAndStatus(
            @PathParam("code") String code, @PathParam("status") Integer status) {
        List<PcsSkuSalesPriceChange> pcsSkuSalesPriceChanges = pcsSkuSalesPriceChangeDomain.findByCodeAndStatus(code, status);
        return BeanUtil.buildListFrom(pcsSkuSalesPriceChanges, PcsSkuSalesPriceChangeVO.class);
    }

    @Override
    public List<PcsSkuCostPriceChangeVO> findCostPriceChangeByCode(String code) {
        return BeanUtil.buildListFrom(
                pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCode(code),
                PcsSkuCostPriceChangeVO.class
        );
    }

    @Override
    public List<PcsSkuSupplierChangeVO> findSupplierChangeByCode(String code) {
        return BeanUtil.buildListFrom(
                pcsSkuSalesPriceChangeDomain.findSupplierChangeByCode(code),
                PcsSkuSupplierChangeVO.class
        );
    }

    @Override
    public PcsSkuSalesPriceChangeVO auditSkuSalesPriceChange(String code, Boolean isPass, Integer type) {
        return pcsSkuSalesPriceChangeDomain.buildFromModel(
                pcsSkuSalesPriceChangeDomain.auditSkuSalesPriceChange(code, isPass,type));
    }

    @Override
    public PcsSkuSalesPriceChangeVO findSkuSalesPriceChangeByCodeAndProcessing(String code, Integer type) {
        return pcsSkuSalesPriceChangeDomain.buildFromModel(
                pcsSkuSalesPriceChangeDomain.findSkuSalesPriceChangeByCodeAndProcessing(code,type));
    }

    @Override
    public Long createSupplierChange(String code, Integer price) {
        return pcsSkuSalesPriceChangeDomain.createSupplierChange(code, price);
    }

    @Override
    public Long createCostPriceChange(String code, BigDecimal price) {
        return pcsSkuSalesPriceChangeDomain.createCostPriceChange(code, price);
    }

    @Override
    public PcsSkuCostPriceChangeVO auditSkuCostPriceChange(String code, Boolean isPass) {
        return BeanUtil.buildFrom(
                pcsSkuSalesPriceChangeDomain.auditSkuCostPriceChange(code, isPass,1),
                PcsSkuCostPriceChangeVO.class
        );
    }

    @Override
    public PcsSkuSupplierChangeVO auditSkuSupplierChange(String code, Boolean isPass) {
        return BeanUtil.buildFrom(
                pcsSkuSalesPriceChangeDomain.auditSkuSupplierChange(code, isPass,1),
                PcsSkuSupplierChangeVO.class
        );
    }

    @Override
    public List<PcsSkuCostPriceChangeVO> findCostPriceChangeByCodeAndStatus(String code, Integer status) {
        return BeanUtil.buildListFrom(
                pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(code, status),
                PcsSkuCostPriceChangeVO.class
        );
    }

    @Override
    public List<PcsSkuSupplierChangeVO> findSupplierChangeByCodeAndStatus(String code, Integer status) {
        return BeanUtil.buildListFrom(
                pcsSkuSalesPriceChangeDomain.findSupplierChangeByCodeAndStatus(code, status),
                PcsSkuSupplierChangeVO.class
        );
    }
}
