/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCmSplDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCustomMadeDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCmSpl;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCustomMade;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuCustomMadeService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCmSplVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCustomMadeVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.*;
import java.util.*;


/**
 * @author Eric.Lou
 * @version $Id: PcsSkuCustomMade.java, v 0.1 2015-08-06 13:06
 */
@Path("/sku/custom_made")
@Consumes({ContentType.APPLICATION_JSON_UTF_8})
@Produces({ContentType.APPLICATION_JSON_UTF_8})
@Service("pcsSkuCustomMadeService")
public class McPcsSkuCustomMadeServiceImpl implements McPcsSkuCustomMadeService {

    @Autowired
    private PcsSkuCustomMadeDomain pcsSkuCustomMadeDomain;

    @Autowired
    private PcsSkuCmSplDomain pcsSkuCmSplDomain;

    @Override
    public PcsSkuCustomMadeVO create(PcsSkuCustomMadeVO record) {
        PcsSkuCustomMade customMade = pcsSkuCustomMadeDomain.create(pcsSkuCustomMadeDomain.buildFromVO(record));
        return pcsSkuCustomMadeDomain.buildFromModel(customMade);
    }

    @Override
    public boolean update(PcsSkuCustomMadeVO record) {
        return pcsSkuCustomMadeDomain.update(pcsSkuCustomMadeDomain.buildFromVO(record));
    }

    @GET
    @Path("{id:\\d+}")
    @Override
    public PcsSkuCustomMadeVO findSkuCustomMadeById(@PathParam("id") long id) {
        return pcsSkuCustomMadeDomain.findSkuCustomMadeById(id);
    }

    @Override
    public PcsSkuCustomMadeVO findById(long id) {
        return null;
    }

    @Override
    public PcsSkuCustomMadeVO findSkuCustomMadeByCode(String code) {
        return null;
    }


    @Override
    public List<PcsSkuCustomMadeVO> findSkuCustomMadeByCond(PcsSkuCond cond) {
        return pcsSkuCustomMadeDomain.findSkuCustomMadeByCond(cond);
    }

    @POST
    @Override
    public Boolean createCustomMadeAndLine(PcsSkuCustomMadeVO pcsSkuCustomMadeVO) {
        PcsSkuCustomMade pcsSkuCustomMade = pcsSkuCustomMadeDomain.buildFromVO(pcsSkuCustomMadeVO);
        List<PcsSkuCmSpl> pcsSkuCmSplList = new ArrayList<PcsSkuCmSpl>();
        if (CollectionUtils.isEmpty(pcsSkuCustomMadeVO.getSupplierList())) {
            pcsSkuCmSplList = Collections.emptyList();
        } else {
            for (PcsSkuCmSplVO pcsSkuCmSplVO : pcsSkuCustomMadeVO.getSupplierList()) {
                PcsSkuCmSpl pcsSkuCmSpl = pcsSkuCmSplDomain.buildFromVO(pcsSkuCmSplVO);
                pcsSkuCmSplList.add(pcsSkuCmSpl);
            }
        }
        return pcsSkuCustomMadeDomain.createCustomMadeAndLine(pcsSkuCustomMade, pcsSkuCmSplList);

    }

    @PUT
    @Override
    public Boolean updateCustomMadeAndLine(PcsSkuCustomMadeVO pcsSkuCustomMadeVO) {
        PcsSkuCustomMade pcsSkuCustomMade = pcsSkuCustomMadeDomain.buildFromVO(pcsSkuCustomMadeVO);
        List<PcsSkuCmSpl> pcsSkuCmSplList = new ArrayList<PcsSkuCmSpl>();
        if (CollectionUtils.isEmpty(pcsSkuCustomMadeVO.getSupplierList())) {
            pcsSkuCmSplList = Collections.emptyList();
        } else {
            for (PcsSkuCmSplVO pcsSkuCmSplVO : pcsSkuCustomMadeVO.getSupplierList()) {
                PcsSkuCmSpl pcsSkuCmSpl = pcsSkuCmSplDomain.buildFromVO(pcsSkuCmSplVO);
                pcsSkuCmSplList.add(pcsSkuCmSpl);
            }
        }
        return pcsSkuCustomMadeDomain.updateCustomMadeAndLine(pcsSkuCustomMade, pcsSkuCmSplList);
    }

    @DELETE
    @Path("{id:\\d+}/sku_cm_qpl/{skuCmSplId}")
    @Override
    public Boolean deletePcsCmSpl(
            @PathParam("id") long skuCustomMadeId, @PathParam("skuCmSplId") long skuCmSplId) {
        return pcsSkuCustomMadeDomain.deletePcsCmSpl(skuCustomMadeId, skuCmSplId);
    }

    @Override
    public Boolean convertCustomMadeAndLine(long skuCustomMadeId, long skuCmSplId) {
        return pcsSkuCustomMadeDomain.convertCustomMadeAndLine(skuCustomMadeId, skuCmSplId);
    }

    @Override
    public Boolean rejectCustomMade(long skuCustomMadeId) {
        return pcsSkuCustomMadeDomain.rejectCustomMade(skuCustomMadeId);
    }
}
