package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.thebeastshop.pegasus.merchandise.cond.PcsBuyerCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsBuyerDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsBusinessCategoryPermission;
import com.thebeastshop.pegasus.merchandise.model.PcsBuyerInfo;
import com.thebeastshop.pegasus.merchandise.model.PcsPurchaseCategoryPermission;
import com.thebeastshop.pegasus.merchandise.service.McPcsBuyerInfoService;
import com.thebeastshop.pegasus.merchandise.vo.PcsBuyerInfoVO;
import com.thebeastshop.pegasus.merchandise.vo.UserInfo;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.*;
import java.util.*;

/**
 * Created by devin.li on 2016/2/12.
 */
@Path("/buyer")
@Consumes({ContentType.APPLICATION_JSON_UTF_8})
@Produces({ContentType.APPLICATION_JSON_UTF_8})
@Service("mcPcsBuyerInfoService")
public class McPcsBuyerInfoServiceImpl implements McPcsBuyerInfoService {

    @Autowired
    private PcsBuyerDomain pcsBuyerDomain;


    @GET
    @Path("{id:\\d+}")
    @Override
    public PcsBuyerInfoVO getBuyerInfoById(@PathParam("id") Long id) {
    	List<String> categoryList = new ArrayList<>();
    	PcsBuyerInfoVO pcsBuyerInfoVO = pcsBuyerDomain.getBuyerInfoById(id);
		if(EmptyUtil.isNotEmpty(pcsBuyerInfoVO.getBussinessCategory())) {
			String[] array = pcsBuyerInfoVO.getBussinessCategory().split(",");
			for(String categoryId : array) {
				categoryList.add(categoryId);
			}
		}
		pcsBuyerInfoVO.setCategoryList(categoryList);
		List<String> purchaseCategoryList = new ArrayList<>();
		if(EmptyUtil.isNotEmpty(pcsBuyerInfoVO.getPurchaseCategory())) {
			String[] array = pcsBuyerInfoVO.getPurchaseCategory().split(",");
			for(String categoryId : array) {
				purchaseCategoryList.add(categoryId);
			}
		}
		pcsBuyerInfoVO.setPurchaseCategoryList(purchaseCategoryList);
        return pcsBuyerInfoVO;
    }

    @GET
    @Path("all")
    @Override
    public List<PcsBuyerInfoVO> getAllBuyers() {
        return pcsBuyerDomain.getAllBuyers();
    }

    @Override
    public List<Map<String, String>> getAllBuyerInfos() {
        return pcsBuyerDomain.getAllBuyerInfos();
    }

    @Override
    public List<PcsBuyerInfoVO> getBuyerByCond(PcsBuyerCond cond) {
        List<PcsBuyerInfo> list = pcsBuyerDomain.getBuyerByCond(cond);
        return BeanUtil.buildListFrom(list, PcsBuyerInfoVO.class);
    }

    @POST
    @Override
    public Boolean newBuyer(PcsBuyerInfoVO vo) {
        PcsBuyerInfo buyer = BeanUtil.buildFrom(vo, PcsBuyerInfo.class);
        return pcsBuyerDomain.newBuyer(buyer);
    }

    @PUT
    @Override
    public Boolean updateBuyerInfo(PcsBuyerInfoVO vo) {
        PcsBuyerInfo buyer = BeanUtil.buildFrom(vo, PcsBuyerInfo.class);
        return pcsBuyerDomain.updateBuyerInfo(buyer);
    }

    @GET
    @Path("category/buyer_id/{id:\\d+}")
    @Override
    public UserInfo findCategoryManagerByBuyer(Integer buyerId) {
        return pcsBuyerDomain.findCategoryManagerByBuyer(buyerId);
    }

    @Transactional
	@Override
	public List<Integer> addPurchaseCategoryPermission(Integer userId, List<String> categoryList) {
    	pcsBuyerDomain.deletePurchaseCategoryPermByUserId(userId);
		if(EmptyUtil.isNotEmpty(categoryList)) {
			for(String categoryId : categoryList) {
				PcsPurchaseCategoryPermission purchaseCategoryPermission = new PcsPurchaseCategoryPermission();
				purchaseCategoryPermission.setOperatorId(userId);
				purchaseCategoryPermission.setPurchaseCategoryId(Integer.parseInt(categoryId));
				pcsBuyerDomain.addPurchaseCategoryPermission(purchaseCategoryPermission);
			}
		}
    	return null;
	}

    @Transactional
	@Override
	public List<Integer> addBusinessCategoryPermission(Integer userId, List<String> categoryList) {
    	pcsBuyerDomain.deleteBusinessCategoryPermByUserId(userId);
    	if(EmptyUtil.isNotEmpty(categoryList)) {
			
			for(String categoryId : categoryList) {
				PcsBusinessCategoryPermission businessCategoryPermission = new PcsBusinessCategoryPermission();
				businessCategoryPermission.setOperatorId(userId);
				businessCategoryPermission.setBusinessCategoryId(Integer.parseInt(categoryId));
				pcsBuyerDomain.addBusinessCategoryPermission(businessCategoryPermission);
			}
		}
		return null;
	}
}

