/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.merchandise.cond.OpSpvCond;
import com.thebeastshop.pegasus.merchandise.domain.OpProdSkuDomain;
import com.thebeastshop.pegasus.merchandise.model.OpProdSku;
import com.thebeastshop.pegasus.merchandise.service.McOpSpvService;
import com.thebeastshop.pegasus.merchandise.vo.OpSpvVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Service("mcOpSpvService")
public class McOpSpvServiceImpl implements McOpSpvService {
    @Autowired
    private OpProdSkuDomain opProdSkuDomain;

    @Override
    public List<OpSpvVO> findByProdIds(List<Long> prodIds) {
        List<OpProdSku> list = opProdSkuDomain.findByProdIds(prodIds);
        return BeanUtil.buildListFrom(list,OpSpvVO.class);
    }

    @Override
    public List<OpSpvVO> findBySkuCode(String skuCode) {
        List<OpProdSku> list = opProdSkuDomain.findBySkuCode(skuCode);
        return BeanUtil.buildListFrom(list,OpSpvVO.class);
    }

    @Override
    public Integer getProductIdByskuCode(String skuCode) {
        Integer productId = opProdSkuDomain.getProductIdByskuCode(skuCode);
        return productId;
    }

    @Override
    public List<OpSpvVO> findAll() {
        List<OpProdSku> list = opProdSkuDomain.findAll();
        return BeanUtil.buildListFrom(list,OpSpvVO.class);
    }

    @Override
    public List<String> getALLSkuCode() {
        return opProdSkuDomain.getALLSkuCode();
    }

    @Override
    public Long create(OpSpvVO prodSkuVO) {
        opProdSkuDomain.create(opProdSkuDomain.buildFromVO(prodSkuVO));
        return prodSkuVO.getId();
    }

    @Override
    public boolean update(OpSpvVO prodSkuVO) {
        return opProdSkuDomain.update(opProdSkuDomain.buildFromVO(prodSkuVO));
    }

    @Override
    public Long createOrUpdate(OpSpvVO prodSku) {
        OpSpvCond cond = new OpSpvCond();
        cond.setProductId(prodSku.getProductId());
        cond.setSkuCodes(Lists.newArrayList(prodSku.getSkuCode()));
        List<OpSpvVO> list = findByPcsProdSkuCond(cond);
        if (CollectionUtils.isEmpty(list)) {
            return create(prodSku);
        }
        else {
            prodSku.setId(list.get(0).getId());
            boolean ret = update(prodSku);
            if (ret) return prodSku.getId();
        }
        return -1L;
    }

    @Override
    public boolean deleteById(Long id) {
        return opProdSkuDomain.deleteById(id);
    }

    @Override
    public boolean deleteByProdId(Long prodId) {
        return opProdSkuDomain.deleteByProdId(prodId);
    }

    @Override
    public List<OpSpvVO> findByProdId(Long prodId) {
        List<OpProdSku> list = opProdSkuDomain.findByProdId(prodId);
        return BeanUtil.buildListFrom(list, OpSpvVO.class);
    }
    @Override
    public List<OpSpvVO> findByPcsProdSkuCond(OpSpvCond opSpvCond) {
        List<OpSpvVO> list = opProdSkuDomain.findByPcsProdSkuCond(opSpvCond);
        return list;
    }

    @Override
    public Map<String, List<OpSpvVO>> mapBySkuCodes(List<String> skuCodes) {
        OpSpvCond spvCond = new OpSpvCond();
        spvCond.setSkuCodes(skuCodes);
        List<OpSpvVO> list = opProdSkuDomain.findByPcsProdSkuCond(spvCond);
        Map<String, List<OpSpvVO>> map = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (OpSpvVO spvVO : list) {
                String skuCode = spvVO.getSkuCode();
                List<OpSpvVO> spvList = map.get(skuCode);
                if (spvList == null) {
                    spvList = new ArrayList<>();
                    map.put(skuCode, spvList);
                }
                spvList.add(spvVO);
            }
        }
        return map;
    }

}
