/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.domain.OpClPsProdDomain;
import com.thebeastshop.pegasus.merchandise.model.OpClPsProd;
import com.thebeastshop.pegasus.merchandise.service.McOpClPsProdService;
import com.thebeastshop.pegasus.merchandise.vo.OpClPsProdVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Roy.Chen
 * @version $Id: OpClPsSkuServiceImpl.java, v 0.1 2015-08-07 15:24
 */
@Service("mcOpClPsProdService")
public class McOpClPsProdServiceImpl implements McOpClPsProdService {
    private static final Logger log = LoggerFactory.getLogger(McOpClPsProdService.class);

    @Autowired
    private OpClPsProdDomain opClPsSkuDomain;

    @Override
    public Long findMaxId() {
        return opClPsSkuDomain.findMaxId();
    }

    @Override
    public Integer add(OpClPsProdVO opClPsProdVO) {
        OpClPsProd opClPsProd = opClPsSkuDomain.buildFromVO(opClPsProdVO);
        return opClPsSkuDomain.add(opClPsProd);
    }

    @Override
    public List<OpClPsProdVO> findByMaxId(Long maxId) {
        List<OpClPsProd> list =  opClPsSkuDomain.findByMaxId(maxId);
        return BeanUtil.buildListFrom(list,OpClPsProdVO.class);
    }

    @Override
    public boolean deleteByMaxId(Long maxId) {
        return opClPsSkuDomain.deleteByMaxId(maxId);
    }
}
