package com.thebeastshop.pegasus.merchandise.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.merchandise.IService.IRecommendService;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.service.impl.McPsProductServiceImpl;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.scm.dao.RecommendDao;
import com.thebeastshop.scm.dao.RecommendProductDao;
import com.thebeastshop.scm.po.Recommend;
import com.thebeastshop.scm.vo.recommend.RecommendEditVO;
import com.thebeastshop.scm.vo.recommend.RecommendSaveVO;

@Service
public class RecommendService implements IRecommendService {

	@Resource McPsProductServiceImpl mcPsProductService;
	@Resource RecommendDao recommendDao;
	@Resource RecommendProductDao recommendProductDao;
	
	@Override
	public List<Recommend> list(){
		return recommendDao.findAll();
	}
	
	@Override
	public void save(RecommendSaveVO vo) {
		Recommend recommend = vo.toRecommend();
		recommendDao.saveByPosition(recommend);
		recommendProductDao.save(vo.getProductCode(), recommend.getId());
	}
	
	@Override
	public RecommendEditVO edit(Integer recommendId) {
		Recommend recommend = recommendDao.selectOne(recommendId);
		List<Map> list = recommendProductDao.getProductListMapByRecommendId(recommendId);
		return new RecommendEditVO(recommend, list);
	}
	
	@Override
	public List<PsProductVO> getShoppingCartProcutList(Integer memberLevel, Integer accessWay, BigDecimal discount, Integer limitSize){
		String rule = recommendDao.getRuleByCart();
		List<String> productCodeList = recommendProductDao.getProductCodeByCart(rule, 200);
		PsMatchCampaignCond psMatchCampaignCond = new PsMatchCampaignCond();
		psMatchCampaignCond.setAccessWay(accessWay);
		psMatchCampaignCond.setMemberLevel(memberLevel);
		psMatchCampaignCond.setDiscount(discount);
		List<PsProductVO> productVOs = mcPsProductService.findRecommondProdByCodes("CHN2018", productCodeList, psMatchCampaignCond, 1, 200);
		Map<String, PsProductVO> map = new HashMap<>();
		for (PsProductVO psProductVO : productVOs) {
			map.put(psProductVO.getCode(), psProductVO);
		}
		List<PsProductVO> result = new ArrayList<PsProductVO>();
		for (String code : productCodeList) {
			PsProductVO vo = map.get(code);
			if (vo != null) {
				result.add(vo);
			}
		}
		int toIndex = productVOs.size() < limitSize ? productVOs.size() : limitSize;
		return result.subList(0, toIndex);
	}

}