package com.thebeastshop.pegasus.merchandise.service;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import pers.richard.ormybatis.dao.IDao;
import pers.richard.ormybatis.service.BaseService;

import com.thebeastshop.pegasus.merchandise.IService.IProductService;
import com.thebeastshop.scm.dao.ProductDao;
import com.thebeastshop.scm.po.Product;

@Service
public class ProductService extends BaseService<Product> implements IProductService {

	private ProductDao productDao;
	
	@Autowired
	public ProductService(@Qualifier("productDao") IDao dao) {
		super(dao);
		productDao = (ProductDao)super.dao;
	}
	
	public Product byCode(String code){
		return productDao.byCode(code);
	}

	public List<Map> listProdMat(Map params) {
		return productDao.listProdMat(params);
	}

	@Override
	public List<String> getSkuCodesById(Integer id) {
		return productDao.getSkuCodesById(id);
	}
}
