/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.common.base.Strings;
import org.elasticsearch.common.collect.Maps;
import org.forest.core.ForestConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.component.campaign.client.CampaignClient;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignCondVO;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignProductCondVO;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignSectionProductVO;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignSectionVO;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignVO;
import com.thebeastshop.pegasus.component.json.ApiResult;
import com.thebeastshop.pegasus.component.utils.ApiUtils;
import com.thebeastshop.pegasus.component.vo.TypeVO;
import com.thebeastshop.pegasus.merchandise.client.AbstractESClient;
import com.thebeastshop.pegasus.merchandise.client.ProductClient;
import com.thebeastshop.pegasus.merchandise.cond.DateRange;
import com.thebeastshop.pegasus.merchandise.cond.ProdSearchCond;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.constants.SearchType;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCategoryDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuDomain;
import com.thebeastshop.pegasus.merchandise.domain.PsProductDomain;
import com.thebeastshop.pegasus.merchandise.domain.PsSkuDomain;
import com.thebeastshop.pegasus.merchandise.exception.PublicException;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategory;
import com.thebeastshop.pegasus.merchandise.service.impl.BasePsServiceImpl;
import com.thebeastshop.pegasus.merchandise.util.McReflectionUtil;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:28
 */
@Service
public class PsProductDomainImpl extends BasePsServiceImpl<PsProductVO> implements PsProductDomain {
    private static final Logger LOGGER = LoggerFactory.getLogger(PsProductDomainImpl.class);
    @Autowired
    private ForestConfiguration forestConfiguration;
    private CampaignClient campaignClient;

    @Autowired
    private ProductClient client;
    @Autowired
    private PcsSkuCategoryDomain pcsSkuCategoryService;
    @Autowired
    private PcsSkuDomain pcsSkuService;
    @Autowired
    private PsSkuDomain psSkuService;

    public static List<PsCampaignVO> convertCampaignList(List<CampaignVO> voList) {
        List<PsCampaignVO> psList = new ArrayList<>();
        for (CampaignVO vo : voList) {
            PsCampaignVO ps = new PsCampaignVO();
            ps.setId(vo.getId());
            ps.setName(vo.getName());
            ps.setTitle(vo.getTitle());
            ps.setState(vo.getState());
            ps.setCumulative(vo.getCumulative());
            ps.setDiscountTypeId(vo.getDiscountTypeId());
            TypeVO dicountType = vo.getDiscountType();
            if (dicountType != null) {
                ps.setDiscountTypeName(dicountType.getName());
            }
            ps.setMemberLevels(vo.getMemberLevels());
            ps.setAccessWayIds(vo.getAccessWayIds());
            ps.setCreateTime(vo.getCreateTime());
            ps.setStartTime(vo.getStartTime());
            ps.setExpireTime(vo.getExpireTime());
            ps.setProductScopeId(vo.getProductScopeId());
            List<CampaignSectionVO> campaignSectionVOList = vo.getCampaignSectionList();
            if (EmptyUtil.isNotEmpty(campaignSectionVOList)) {
                List<PsCampaignSectionVO> psCampaignSectionList = new ArrayList<>();
                for (CampaignSectionVO campaignSectionVO : campaignSectionVOList) {
                    PsCampaignSectionVO psCampaignSectionVO = new PsCampaignSectionVO();
                    psCampaignSectionVO.setId(campaignSectionVO.getId());
                    psCampaignSectionVO.setCampaignId(campaignSectionVO.getId());
                    TypeVO conditionType = campaignSectionVO.getConditionType();
                    if (conditionType != null) {
                        psCampaignSectionVO.setConditionType(conditionType.getId());
                    }
                    psCampaignSectionVO.setLine(campaignSectionVO.getLine());
                    psCampaignSectionVO.setFactor(campaignSectionVO.getFactor());
                    psCampaignSectionVO.setRanking(campaignSectionVO.getRanking());
                    List<CampaignSectionProductVO> campaignSectionProductVOList = campaignSectionVO.getCampaignSectionProductList();
                    if (EmptyUtil.isNotEmpty(campaignSectionProductVOList)) {
                        List<PsCampaignSectionProductVO> psCampaignSectionProductList = new ArrayList<>();
                        for (CampaignSectionProductVO campaignSectionProductVO : campaignSectionProductVOList) {
                            PsCampaignSectionProductVO psCampaignSectionProductVO = new PsCampaignSectionProductVO();
                            psCampaignSectionProductVO.setId(campaignSectionProductVO.getId());
                            psCampaignSectionProductVO.setCampaignId(campaignSectionProductVO.getCampaignId());
                            psCampaignSectionProductVO.setCampaignSectionId(campaignSectionProductVO.getCampaignSectionId());
                            psCampaignSectionProductVO.setProductId(campaignSectionProductVO.getAdditionalProductId());
                            psCampaignSectionProductVO.setPricePrice(campaignSectionProductVO.getAdditionalProductPrice());
                            psCampaignSectionProductVO.setPriceCount(campaignSectionProductVO.getAdditionalProductCount());
                            psCampaignSectionProductList.add(psCampaignSectionProductVO);
                        }
                        psCampaignSectionVO.setCampaignSectionProducts(psCampaignSectionProductList);
                    }
                    psCampaignSectionList.add(psCampaignSectionVO);
                }
                ps.setCampaignSectionList(psCampaignSectionList);
            }
            psList.add(ps);
        }
        return psList;
    }

    @Autowired
    public void init() {
        campaignClient = forestConfiguration.createInstance(CampaignClient.class);
    }

    @Override
    public AbstractESClient<PsProductVO> getESClient() {
        return client;
    }

    @Override
    public List<PsProductVO> findByProdName(String name) {
        return client.findByField("name", name);
    }

    @Override
    public List<PsProductVO> findByProdCode(String code) {
        return client.findByField("code", code);
    }

    @Override
    public List<PsProductVO> findByCond(PsProductCond cond) {
        Map<String, Object> params = McReflectionUtil.getFieldNameValue(cond);
        if (CollectionUtils.isNotEmpty(cond.getIds())) {
            params.put("id",cond.getIds());
        }
        params.remove("ids");
        params.remove("memberLevel");
        params.remove("accessWay");

        if (CollectionUtils.isNotEmpty(cond.getCodes())) {
            params.put("code", cond.getCodes());
        }
        params.remove("codes");
        params.remove("matchCampaign");
        params.remove("matchGlobalCampaigns");

        if (cond.getMatchCampaign() && (CollectionUtils.isEmpty(cond.getCodes()) && CollectionUtils.isEmpty(cond.getIds()))) {
            return new ArrayList<>();
        }

        List<PsProductVO> productVOList = client.findByFields(params, SearchType.ANDLIKE);
        if (cond.getMatchCampaign()) {
            matchProductsCampaigns(productVOList, cond, true);
/*
            List<PsCampaignVO> globalCampaignList = getGlobalCampaignList(cond.getMemberLevel(), cond.getAccessWay());
            //if (cond.getMatchGlobalCampaigns()) {
            for (PsProductVO productVO : productVOList) {
//                productVO.getCampaignList().addAll(globalCampaignList);
//                getProductCampaignList()
                //                productVO.getCampaignList().addAll(globalCampaignList);
                List<PsCampaignVO> campList = getProductCampaignList(Long.valueOf(productVO.getId()),
                        productVO.getCategoryId(), cond.getMemberLevel(), cond.getAccessWay());
                List<PsCampaignVO> list = new ArrayList<>();
                list.addAll(campList);
                list.addAll(globalCampaignList);
                productVO.setCampaignList(list);
            }
            matchProductCampaigns(productVOList, cond);
*/
            //}
        }
        return productVOList;
    }

    @Override
    public List<PsProductVO> findByCond(PsProductCond cond,boolean matchGlobalCampaigns) {
        Map<String, Object> params = McReflectionUtil.getFieldNameValue(cond);
        if (CollectionUtils.isNotEmpty(cond.getIds())) {
            params.put("id",cond.getIds());
        }
        params.remove("ids");
        params.remove("memberLevel");
        params.remove("accessWay");

        if (CollectionUtils.isNotEmpty(cond.getCodes())) {
            params.put("code", cond.getCodes());
        }
        params.remove("codes");
        params.remove("matchCampaign");
        params.remove("matchGlobalCampaigns");

        if (cond.getMatchCampaign() && (CollectionUtils.isEmpty(cond.getCodes()) && CollectionUtils.isEmpty(cond.getIds()))) {
            return new ArrayList<>();
        }

        List<PsProductVO> productVOList = client.findByFields(params, SearchType.ANDLIKE);
        if (cond.getMatchCampaign()) {
            matchProductsCampaigns(productVOList, cond, matchGlobalCampaigns);
        }
        return productVOList;
    }

    private void matchProductsCampaigns(List<PsProductVO> productVOList, PsMatchCampaignCond cond, boolean matchGlobalCampaigns) {
//        List<PsCampaignVO> globalCampaignList = getGlobalCampaignList(cond.getMemberLevel(), cond.getAccessWay());
        if (matchGlobalCampaigns) {
            List<CampaignProductCondVO> productCondList = new ArrayList<>();
            for (PsProductVO productVO : productVOList) {
                CampaignProductCondVO productCondVO = new CampaignProductCondVO();
                productCondVO.setProductId(Long.valueOf(productVO.getId()));
                productCondVO.setCategoryId(productVO.getCategoryId());
                productCondList.add(productCondVO);
            }
            Map<String, List<PsCampaignVO>> campaignListMap = getProductCampaignListMapV2(productCondList,
                    true, cond.getMemberLevel(), cond.getAccessWay());
            for (PsProductVO productVO : productVOList) {
//                productVO.getCampaignList().addAll(globalCampaignList);
                List<PsCampaignVO> campList = campaignListMap.get(productVO.getId());
                List<PsCampaignVO> list = new ArrayList<>();
                if(CollectionUtils.isNotEmpty(campList)){
                    list.addAll(campList);
                }

//                list.addAll(globalCampaignList);
                productVO.setCampaignList(list);
            }
        }
        matchProductCampaigns(productVOList, cond);
    }

    @Override
    public Map<String, List<PsCampaignVO>> findCampaignByCond(PsProductCond cond) {
        List<PsProductVO> productList = findByCond(cond);
        if (EmptyUtil.isEmpty(productList)) {
            return new HashMap<>();
        }
        Map<String, List<PsCampaignVO>> map = new HashMap<>();
        for (PsProductVO productVO : productList) {
            List<PsCampaignVO> prodList = productVO.getCampaignList();
            map.put(productVO.getCode(), prodList);
        }
        return map;
    }

    @Deprecated
    public Map<String, List<PsCampaignVO>> getProductCampaignListMap(List<Long> productIdList, boolean containsGlobal, Long cateId, Integer memberLevel, Integer accessWay) {
        CampaignCondVO cond = new CampaignCondVO();
        cond.setStateId(1);
        cond.setMemberLevel(memberLevel);
        cond.setAccessWay(accessWay);
        cond.setProductIdList(productIdList);
        cond.setCategoryId(cateId);
        cond.setFromRedis(true);
        cond.setContainsGlobal(containsGlobal);
        String params = JSON.toJSONString(cond);
        ApiResult<Map<Long, List<CampaignVO>>> campaignResult = campaignClient.mapListCampaign(params);
        if (ApiUtils.isSuccess(campaignResult)) {
            Map<String, List<PsCampaignVO>> psCampaignListMap = new HashMap<>();
            Map<Long, List<CampaignVO>> campaignVOListMap = campaignResult.getData();
            for (Iterator<Long> iterator = campaignVOListMap.keySet().iterator(); iterator.hasNext(); ) {
                Long id = iterator.next();
                List<CampaignVO> campaignVOList = campaignVOListMap.get(id);
                List<PsCampaignVO> psCampaignVOList = convertCampaignList(campaignVOList);
                psCampaignListMap.put(String.valueOf(id), psCampaignVOList);
            }
            return psCampaignListMap;
        }
        return new HashMap<>();
    }

    public Map<String, List<PsCampaignVO>> getProductCampaignListMapV2(List<CampaignProductCondVO> productCondList, boolean containsGlobal, Integer memberLevel, Integer accessWay) {
        CampaignCondVO cond = new CampaignCondVO();
        cond.setStateId(1);
        cond.setMemberLevel(memberLevel);
        cond.setAccessWay(accessWay);
        cond.setProductCondList(productCondList);
        cond.setFromRedis(true);
        cond.setContainsGlobal(containsGlobal);
        String params = JSON.toJSONString(cond);
        ApiResult<Map<Long, List<CampaignVO>>> campaignResult = campaignClient.mapListCampaign_V1_0_1(params);
        if (ApiUtils.isSuccess(campaignResult)) {
            Map<String, List<PsCampaignVO>> psCampaignListMap = new HashMap<>();
            Map<Long, List<CampaignVO>> campaignVOListMap = campaignResult.getData();
            for (Iterator<Long> iterator = campaignVOListMap.keySet().iterator(); iterator.hasNext(); ) {
                Long id = iterator.next();
                List<CampaignVO> campaignVOList = campaignVOListMap.get(id);
                List<PsCampaignVO> psCampaignVOList = convertCampaignList(campaignVOList);
                psCampaignListMap.put(String.valueOf(id), psCampaignVOList);
            }
            return psCampaignListMap;
        }
        return new HashMap<>();
    }

    public List<PsCampaignVO> getProductCampaignList(Long productId, boolean containsGlobal, Long cateId, Integer memberLevel, Integer accessWay) {
        CampaignCondVO cond = new CampaignCondVO();
        cond.setMemberLevel(memberLevel);
        cond.setAccessWay(accessWay);
        cond.setProductId(productId);
        cond.setCategoryId(cateId);
        cond.setFromRedis(true);
        cond.setContainsGlobal(containsGlobal);
        ApiResult<List<CampaignVO>> campaignResult = campaignClient.listCampaign(cond);
        if (ApiUtils.isSuccess(campaignResult)) {
            List<CampaignVO> campaignVOList = campaignResult.getData();
            List<PsCampaignVO> psCampaignList = convertCampaignList(campaignVOList);
            return psCampaignList;
        }
        return new ArrayList<>();
    }

    @Override
    public List<PsCampaignVO> getGlobalCampaignList(Integer memberLevel, Integer accessWay) {
        CampaignCondVO cond = new CampaignCondVO();
//        cond.setStateId(4);
        cond.setProductScope(3);
        cond.setMemberLevel(memberLevel);
        cond.setAccessWay(accessWay);
        cond.setFromRedis(true);
        ApiResult<List<CampaignVO>> campaignResult = campaignClient.listCampaign(cond);
        if (ApiUtils.isSuccess(campaignResult)) {
            List<CampaignVO> campaignVOList = campaignResult.getData();
            List<PsCampaignVO> psCampaignList = convertCampaignList(campaignVOList);
            return psCampaignList;
        }
        return new ArrayList<>();
    }

    private void matchProductCampaigns(List<PsProductVO> productVOList, PsMatchCampaignCond matchCampaignCond) {
        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign() != null && matchCampaignCond.getMatchCampaign()) {
            matchProductCampaigns(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay());
        }
    }

    private void matchProductCampaigns(List<PsProductVO> productVOList, Integer memberLavel, Integer accessWay) {
        for (PsProductVO productVO : productVOList) {
            List<PsCampaignVO> campaignList = productVO.getCampaignList();
            if (EmptyUtil.isEmpty(campaignList)) {
                continue;
            }
            List<PsCampaignVO> matchedCampaignList = matchCampaignList(campaignList, memberLavel, accessWay);
            productVO.setCampaignList(matchedCampaignList);
        }
    }


    public List<PsCampaignVO> matchCampaignList(List<PsCampaignVO> campaignList, Integer memberLavel, Integer accessWay) {
        List<PsCampaignVO> results = new ArrayList<>();
        for (PsCampaignVO campaignVO : campaignList) {
            if (matchCampaign(campaignVO, memberLavel, accessWay)) {
                results.add(campaignVO);
            }
        }
        return results;
    }


    private boolean matchCampaign(PsCampaignVO campaignVO, Integer memberLavel, Integer accessWay) {
        List<Integer> memberLevels = campaignVO.getMemberLevels();
        if (campaignVO.getState() != 1) {
            return false;
        }
        if (EmptyUtil.isNotEmpty(memberLevels) && memberLavel != null) {
            if (!memberLevels.contains(memberLavel)) {
                return false;
            }
        }

        List<Integer> accessWayIds = campaignVO.getAccessWayIds();
        if (EmptyUtil.isNotEmpty(accessWayIds) && accessWay != null) {
            if (!accessWayIds.contains(accessWay)) {
                return false;
            }
        }

        Date startTime = campaignVO.getStartTime();
        Date expiredTime = campaignVO.getExpireTime();
        if (startTime != null && expiredTime != null) {
            Date now = new Date();
            if (now.before(startTime) || now.after(expiredTime)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<PsProductVO> findByFields(Map<String, Object> params) {
        return client.findByFields(params,SearchType.ANDLIKE);
    }

    @Override
    public List<PsProductVO> findByNameOrNameCN(Map<String, Object> params) {
        return client.findByFields(params,SearchType.ORLIKE);
    }

    @Override
    public void calculateDiscountPrice(List<PsProductVO> productList, Integer memberLevel, Integer accessWay, BigDecimal discountAmount) {
        for (PsProductVO productVO : productList) {
            calulateProductDiscountPrice(productVO, memberLevel, accessWay, discountAmount);
        }
    }

    @Override
    public void calculateDiscountPrice(PsProductVO productVO, PsSkuVO skuVO, PsMatchCampaignCond cond) {
        BigDecimal originalPrice = new BigDecimal(String.valueOf(skuVO.getSalesPrice()));
        if (cond.getMatchCampaign() != null && cond.getMatchCampaign()) {
            matchProductsCampaigns(Arrays.asList(new PsProductVO[]{productVO}), cond, true);
            List<PsCampaignVO> campaignList = productVO.getCampaignList();
            skuVO.setCampaignList(campaignList);
            boolean allowVipDiscount = productVO.getAllowVipDiscount() != null && productVO.getAllowVipDiscount() == 1;
            BigDecimal targetPrice = calculateDiscountPrice(allowVipDiscount,
                    originalPrice, campaignList, cond.getMemberLevel(), cond.getAccessWay(), cond.getDiscount());
            skuVO.setDiscountPrice(targetPrice);
        }
    }

    @Override
    public void calculateDiscountPrice(PsSkuVO skuVO, PsMatchCampaignCond cond) {
        PsProductVO productVO = findProdBySkuCode(skuVO.getSkuCode());
        if (productVO == null) return;
        calculateDiscountPrice(productVO, skuVO, cond);
    }

    private void calulateProductDiscountPrice(PsProductVO productVO, Integer memberLevel, Integer accessWay, BigDecimal discountAmount) {
        List<PsCampaignVO> campaignList = productVO.getCampaignList();
        BigDecimal originalPrice = productVO.getListPrice();
        boolean allowVipDiscount = productVO.getAllowVipDiscount() != null && productVO.getAllowVipDiscount() == 1;
        BigDecimal targetPrice = calculateDiscountPrice(allowVipDiscount, originalPrice, campaignList, memberLevel, accessWay, discountAmount);
        productVO.setDiscountPrice(targetPrice);
    }



    private BigDecimal calculateDiscountPrice(
            Boolean allowVipDiscount,
            BigDecimal originalPrice,
            List<PsCampaignVO> campaignList,
            Integer memberLevel, Integer accessWay,
            BigDecimal discountAmount) {
        BigDecimal targetPrice = originalPrice;
        if (allowVipDiscount != null && allowVipDiscount) {
            targetPrice = targetPrice.multiply(discountAmount);
        }
        for (PsCampaignVO campaign : campaignList) {
            if (campaign.getState() == null || campaign.getState() != 1)
                continue;
            if (campaign.getDiscountTypeId() != 1)
                continue;
//            if (campaign.getProductScopeId() != 1 && campaign.getProductScopeId() != 3)
//                continue;
            if (campaign.getStartTime() == null || campaign.getExpireTime() == null)
                continue;
            Date now = new Date();
            if (campaign.getStartTime().after(now) || campaign.getExpireTime().before(now))
                continue;

            List<PsCampaignSectionVO> sectionList = campaign.getCampaignSectionList();
            if (CollectionUtils.isEmpty(sectionList))
                continue;
            PsCampaignSectionVO section = sectionList.get(0);
            BigDecimal factor = section.getFactor();
            if (factor == null)
                continue;
            targetPrice = targetPrice.multiply(factor.divide(BigDecimal.TEN));
        }
        return targetPrice;
    }

    @Override
    public boolean updateBySkuCodes(List<String> skuCodes) {
        if (CollectionUtils.isEmpty(skuCodes)) {
            return true;
        }

        if (skuCodes.size() > 100) {
            int all = skuCodes.size() / 100;
            for (int i = 0; i < all; i++) {
                List<String> subSkuCodes = skuCodes.subList(i * 100, (i + 1) * 100);
                if (!updateBySkuCodes100(subSkuCodes)) {
                    throw new PublicException("更新prod updateTime 出错");
                }
            }
            if (skuCodes.size() > all * 100) {
                List<String> subSkuCodes = skuCodes.subList(all * 100, skuCodes.size());
                updateBySkuCodes100(subSkuCodes);
            }
            return true;
        } else {
            return updateBySkuCodes100(skuCodes);
        }
    }

    private boolean updateBySkuCodes100(List<String> skuCodes) {
        Map<String, Object> params = new HashMap<>();
        params.put("skuCodes", skuCodes);
        params.put("pagenum", Integer.MAX_VALUE);

        List<PsProductVO> updateProds = client.findByFields(params, SearchType.OR);

        for (PsProductVO updateProd : updateProds) {
            if (CollectionUtils.isEmpty(updateProd.getSkuCodes())) {
                continue;
            }
            List<PsSkuVO> prodSkus = psSkuService.findBySkuCodes(updateProd.getSkuCodes());
            if(CollectionUtils.isEmpty(prodSkus)){
                continue;
            }
            PsSkuVO psSkuVO = prodSkus.get(0);
            //ROYS 更新列表价
            if (updateProd.getSkuCodes().size() == 1) {
                updateProd.setListPrice(new BigDecimal(psSkuVO.getSalesPrice()));
            }else{
                for (PsSkuVO prodSku : prodSkus) {
                    if (updateProd.getListPrice().doubleValue() > prodSku.getSalesPrice()) {
                        updateProd.setListPrice(new BigDecimal(prodSku.getSalesPrice()).setScale(2,BigDecimal.ROUND_HALF_DOWN));
                    }
                }
            }

            updateProd.setCategoryId(psSkuVO.getCategoryId());
            //ROYS 暂不写code
            updateProd.setCategoryCode(pcsSkuCategoryService.findById(psSkuVO.getCategoryId()).getCode());
        }
        if (CollectionUtils.isEmpty(updateProds)) return true;
        return update(updateProds);
    }

    public PsProductVO updateCategory(PsProductVO updateProd) {
        PsSkuVO psSkuVO = psSkuService.findBySkuCode(updateProd.getSkuCodes().get(0));
        if(NumberUtil.isNullOrZero(psSkuVO.getCategoryId())){
            return updateProd;
        }
        updateProd.setCategoryId(psSkuVO.getCategoryId());

        return updateProd;
    }

    @Override
    public PsProductVO findProdByChnCodeSkuCode(String chnCode, String skuCode) {
        Map<String, Object> params = new HashMap<>();
        params.put("chnCanSaleSKu.canSkus", skuCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("skuCodes", skuCode);
        params.put("onShelfChnCodes", chnCode);
        List<PsProductVO> fs =client.findByFields(params, SearchType.ANDLIKE) ;
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        return fs.get(0);
    }

    @Override
    public PsProductVO findProdBySkuCode(String skuCode) {
        Map<String, Object> params = new HashMap<>();
        params.put("skuCodes", skuCode);
        List<PsProductVO> fs =client.findByFields(params, SearchType.ANDLIKE) ;
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        return fs.get(0);
    }

    @Override
    public List<PsProductVO> findByChnCodeCateCode(String chnCode, String cateCode) {
        List<PcsSkuCategory> list = pcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
        List<PcsSkuCategoryVO> categories = BeanUtil.buildListFrom(list,PcsSkuCategoryVO.class);
        List<Long> cateIds = new ArrayList<>(categories.size());
        for (PcsSkuCategoryVO category : categories) {
            cateIds.add(category.getId());
        }
        if (CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }
        Map<String, Object> params = new HashMap<>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("categoryId", cateIds);

        int currpage = 1;
        params.put("pagenum", 20);
        params.put("currpage", currpage);
        List<List<String>> seqList = new ArrayList<List<String>>();
        List<String> seq1 = new ArrayList<String>();
        seq1.add("categoryId");
        seq1.add("asc");
        seqList.add(seq1);
        List<String> seq = new ArrayList<String>();
        seq.add("seq");
        seq.add("asc");
        seqList.add(seq);
        params.put("sort",seqList);
        List<PsProductVO> productVOs = new ArrayList<>(100);
        List<PsProductVO> prodVos = client.findByFields(params,SearchType.ANDLIKE);
        productVOs.addAll(prodVos);
        while(prodVos.size() == 20){
            currpage++;
            params.put("currpage", currpage);
            params.put("pagenum", 20);
            params.put("sort",seqList);
            prodVos = client.findByFields(params,SearchType.ANDLIKE);
            productVOs.addAll(prodVos);
        }

        return productVOs;
    }
    //根据多类目和、是否新上架查询 by Lk
    @Override
    public List<PsProductVO> findByProdSearchCondVO(String chnCode,  final PsMatchCampaignCond matchCampaignCond,final ProdSearchCond prodSearchCondVO) {
        LOGGER.info("===查询es 参数为 chnCode= {},prodSearchCondVO={}",chnCode,prodSearchCondVO);
        List<String> cateCodes = prodSearchCondVO.getCategoryCodes();
        String key = prodSearchCondVO.getKeywords();
        Integer from = prodSearchCondVO.getFrom() != null && prodSearchCondVO.getFrom() > 0 ? (Integer) prodSearchCondVO.getFrom() : 0;
        Integer size = prodSearchCondVO.getSize() != null && prodSearchCondVO.getSize() > 0 ? (Integer) prodSearchCondVO.getSize() : 20;
        Boolean isNew = prodSearchCondVO.getIsNew() == null ? false : prodSearchCondVO.getIsNew();

        Map seqMap = new LinkedHashMap();
        Map sMap = new HashMap();
        Map sNestedMap = new HashMap();
        Map map = new HashMap();
        Map paramsMap = new HashMap();

        if(Strings.isNullOrEmpty(key)) {

            List<PcsSkuCategoryVO> categoriesList = new ArrayList<PcsSkuCategoryVO>();
            if (cateCodes != null && cateCodes.size() > 0) {
                for (String cateCode : cateCodes) {
                    List<PcsSkuCategory> list = pcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                    List<PcsSkuCategoryVO> category = BeanUtil.buildListFrom(list,PcsSkuCategoryVO.class);
                    categoriesList.addAll(category);
                }
            }
            //去重
//        List<PcsSkuCategoryVO> categories = new ArrayList<PcsSkuCategoryVO>(new HashSet<PcsSkuCategoryVO>(categoriesList));

            List<Long> cateIds = new ArrayList<>(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
            if (CollectionUtils.isEmpty(cateIds)) {
                return Collections.emptyList();
            }
            Map<String, Object> params = new HashMap<>();
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);
            params.put("frontCategories.categoryId", cateIds);
            //是否新上架
            if (isNew) {
                DateRange dateRange = prodSearchCondVO.getDateRange();
                if (dateRange == null) {
                    dateRange = new DateRange();
                    //无上架范围默认14天
                    Date end = new Date();
                    dateRange.setEnd(end);
                    Calendar calendar = new GregorianCalendar();
                    calendar.setTime(end);
                    calendar.add(calendar.DATE, -14);
                    Date start = calendar.getTime();
                    dateRange.setStart(start);
                }
                params.put("channelProdInfo.createTime", dateRange);
            }

            String sortField = prodSearchCondVO.getSortField();
            String sortOrder = prodSearchCondVO.getSortOrder();

            seqMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            paramsMap.put("categoryIds", cateIds);
            map.put("order", "asc");
            map.put("mode", "min");

            if (Strings.isNullOrEmpty(sortField) || Strings.isNullOrEmpty(sortOrder)) {
                seqMap.put("saleStartDate", "desc");
            } else {
                if ("create_time".equals(sortField)) {
                    seqMap.put("channelProdInfo.createTime", sortOrder);
                } else if ("price".equals(sortField)) {
                    seqMap.put("listPrice", sortOrder);
                }
            }
            String fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
            seqMap.put("_script", map);
            map.put("script", "frontCategorySort");
            map.put("params", paramsMap);
            paramsMap.put("fieldName", fieldName);

            params.put("sort", seqMap);
            List<PsProductVO> productVOList = client.findByFieldWithProdSearchCondVO(params, SearchType.ANDLIKE, from, size);

            if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign()) {
                matchProductsCampaigns(productVOList, matchCampaignCond, true);
                calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
            }
            return productVOList;
        }else{
            Map<String, Object> params = new HashMap<>();
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);

            seqMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            map.put("order", "asc");
            map.put("mode", "min");
            LOGGER.info("关键字查询的参数    params={} from={},size={},key={}", params, from, size,key);
            List<PsProductVO> productVOList = client.findByFieldWithKeyWords(params, SearchType.ANDLIKE,key,from,size);
            LOGGER.info("返回的结果数量为={}",productVOList.size());
            if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign()) {
                matchProductsCampaigns(productVOList, matchCampaignCond, true);
                calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
            }
            return productVOList;
        }
    }

    @Override
    public List<PsProductVO> findByChnCodeCateCode(
            String chnCode, String cateCode, final PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        if (pagenum < 1) {
            return Collections.emptyList();
        }
        List<PcsSkuCategory> list = pcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
        List<PcsSkuCategoryVO> categories = BeanUtil.buildListFrom(list, PcsSkuCategoryVO.class);
        List<Long> cateIds = new ArrayList<>(categories.size());
        for (PcsSkuCategoryVO category : categories) {
            cateIds.add(category.getId());
        }
        if (CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }

        Map<String, Object> params = new HashMap<>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
//        params.put("categoryId", cateIds);
        params.put("frontCategories.categoryId", cateIds);

        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        List<Object> seqList = new ArrayList<Object>();
        Map seqMap = new LinkedHashMap();


        List<String> sortUpdateTime = new ArrayList<>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");

        List<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");

/*
        if (categories.size() > 1) {
            List<String> sort1 = new ArrayList<String>();
            sort1.add("sort1");
            sort1.add("asc");
            seqList.add(sort1);
//            seqList.add(sort2);
        }
        else if (categories.size() == 1) {
            List<String> sort2 = new ArrayList<String>();
            sort2.add("sort2");
            sort2.add("asc");
            seqList.add(sort2);
//            seqList.add(sort1);
        }
*/

        Map sMap = new HashMap();
        Map sNestedMap = new HashMap();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);

/*
        if (categories.size() > 1) {
            Map map = new HashMap();
            Map nestedMap = new HashMap();
            seqMap.put("frontCategories.sort1", map);
            map.put("order", "asc");
            map.put("mode", "min");
            map.put("nested_filter", nestedMap);
            nestedMap.put("frontCategories.categoryId", cateIds);
        }
        else if (categories.size() == 1) {
            Map map = new HashMap();
            Map nestedMap = new HashMap();
            seqMap.put("frontCategories.sort2", map);
            map.put("order", "asc");
            map.put("mode", "min");
            map.put("nested_filter", nestedMap);
            nestedMap.put("frontCategories.categoryId", cateIds);
        }
*/
        String fieldName = categories.size() > 1 ? "sort1" : "sort2";
        Map map = new HashMap();
//        Map nestedMap = new HashMap();
        Map paramsMap = new HashMap();
        seqMap.put("_script", map);
        map.put("script", "frontCategorySort");
        map.put("params", paramsMap);
        paramsMap.put("categoryIds", cateIds);
        paramsMap.put("fieldName", fieldName);
        map.put("order", "asc");
        map.put("mode", "min");
//        map.put("nested_filter", nestedMap);
//        nestedMap.put("frontCategories.categoryId", cateIds);


//        List<String> saleStartDate = new ArrayList<>();
//        saleStartDate.add("saleStartDate");
//        saleStartDate.add("desc");
        seqMap.put("saleStartDate", "desc");

//        seqList.add(saleStartDate);

//        seqList.add(sortCode);

/*
        List<String> seq1 = new ArrayList<String>();
        seq1.add("categoryId");
        seq1.add("asc");
        seqList.add(seq1);
        List<String> seq = new ArrayList<String>();
        seq.add("seq");
        seq.add("asc");
        seqList.add(seq);
*/
        params.put("sort",seqMap);
        List<PsProductVO> productVOList = client.findByFields(params,SearchType.ANDLIKE);

        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign()) {
            matchProductsCampaigns(productVOList, matchCampaignCond, true);
            calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
        }
        return productVOList;
    }

    @Override
    public List<PsProductVO> findByChnCodeCateCodeCreateTime(
            String chnCode,Map<String,Date> dateRange, final PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        if (pagenum < 1) {
            return Collections.emptyList();
        }

        Map<String, Object> params = new HashMap<>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);

        params.put("channelProdInfo.channelCode", chnCode);
        params.put("pagenum", pagenum);
        params.put("currpage", currpage);

        Map seqMap = new LinkedHashMap();
        Map sMap = new HashMap();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");

        Map sNestedMap = new HashMap();
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);

        /*Map map = new HashMap();
        Map paramsMap = new HashMap();
        seqMap.put("_script", map);
        map.put("script", "frontCategorySort");
        map.put("params", paramsMap);
        map.put("order", "asc");
        map.put("mode", "min");*/
        //seqMap.put("saleStartDate", "desc");
        seqMap.put("channelProdInfo.createTime", "desc");
        seqMap.put("code", "asc");
        params.put("sort",seqMap);

        Map chanelProdTime = new HashMap();
        chanelProdTime.put("createTimeStart", dateRange.get("createTimeStart"));
        chanelProdTime.put("createTimeEnd", dateRange.get("createTimeEnd"));
        params.put("chanelProdTime", chanelProdTime);
        List<PsProductVO> productVOList = client.findByFields(params,SearchType.ANDLIKE);

        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign()) {
            matchProductsCampaigns(productVOList, matchCampaignCond, true);
            calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
        }
        return productVOList;
    }

    @Override
    public List<PsProductVO> findByChnCodeCateCodeRightLike(String chnCode, String cateCode) {
        List<PsProductVO> allProds = new ArrayList<>();
        Map<String, Object> params = new HashMap<>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("categoryCode", cateCode);
        List<PsProductVO> productVOs = client.findByFields(params, SearchType.AND);
        if (CollectionUtils.isNotEmpty(productVOs)) {
            allProds.addAll(productVOs);
        }
        params.remove("categoryCode");
        params.put("categoryCodePRE", cateCode+"_");
        List<PsProductVO> productVOList =  client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isNotEmpty(productVOList)) {
            allProds.addAll(productVOList);
        }
        return allProds;
    }

	@Override
	public Map<String, PsProductVO> mapByProdCodes(List<String> codes) {
		if (CollectionUtils.isNotEmpty(codes)) {
			Map<String, PsProductVO> rt = Maps.newHashMapWithExpectedSize(codes.size());
			PsProductCond cond = new PsProductCond();
			cond.setCodes(codes);
            cond.setPagenum(200);
			List<PsProductVO> prods = findByCond(cond);
			for (PsProductVO prod : prods) {
				rt.put(prod.getCode(), prod);
			}
			return rt;
		}
		return null;
	}

}
