package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.alibaba.fastjson.JSONArray;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCombinationCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuCombinationMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpAttributeDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpAttributeValueDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCombinationDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuDomain;
import com.thebeastshop.pegasus.merchandise.model.OpAttributeValue;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCombination;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCombinationExample;
import com.thebeastshop.pegasus.merchandise.vo.OpAttributeValueVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCombinationVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.FieldCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.LinkedHashMap;
import java.util.List;

/**
 * @author gongjun
 * @since 2016-10-19
 */
@Component("pcsSkuCombinationDomain")
public class PcsSkuCombinationDomainImpl extends AbstractBaseDomain<PcsSkuCombinationVO, PcsSkuCombination>
        implements PcsSkuCombinationDomain {

    @Autowired
    private PcsSkuCombinationMapper pcsSkuCombinationMapper;
    @Autowired
    private OpAttributeDomain opAttributeDomain;
    @Autowired
    private OpAttributeValueDomain opAttributeValueDomain;
    @Autowired
    private PcsSkuDomain pcsSkuDomain;

    @Override
    public boolean create(PcsSkuCombination skuCombination) {
        skuCombination.setActive(true);
        return pcsSkuCombinationMapper.insert(skuCombination) != 0;
    }

    @Override
    public boolean update(PcsSkuCombination skuCombination) {
        return pcsSkuCombinationMapper.updateByPrimaryKeySelective(skuCombination) != 0;
    }

    @Override
    public List<PcsSkuCombinationVO> findSkuCombinationBySpvId(PcsSkuCombinationCond cond){
        PcsSkuCombinationExample example = new PcsSkuCombinationExample();
        PcsSkuCombinationExample.Criteria criteria = example.createCriteria();
        criteria.andSpvIdEqualTo(cond.getSpvId());
        criteria.andActiveEqualTo(cond.getActive());
        List<PcsSkuCombination> skuCombinationList = pcsSkuCombinationMapper.selectByExample(example);
        List<PcsSkuCombinationVO> skuCombinationVOList = BeanUtil.buildListFrom(skuCombinationList, PcsSkuCombinationVO.class);
        for (PcsSkuCombinationVO pcsSkuCombinationVO : skuCombinationVOList){
            if(cond.getWithSku() && StringUtils.isNotEmpty(pcsSkuCombinationVO.getSubSkuCode())){
                pcsSkuCombinationVO.setSubSkuVO(pcsSkuDomain.findByCode(pcsSkuCombinationVO.getSubSkuCode()));
            }
            LinkedHashMap<Long, Long> attrValueIdMap = getAttributeMap(pcsSkuCombinationVO.getAttrs());
            pcsSkuCombinationVO.setAttrValueIds(attrValueIdMap);
/*
            if(cond.getWithAttribute() && !NumberUtil.isNullOrZero(pcsSkuCombinationVO.getAttributeId())){
                OpAttributeCond opAttributeCond = new OpAttributeCond();
                opAttributeCond.setId(pcsSkuCombinationVO.getAttributeId());
                pcsSkuCombinationVO.setOpAttributeVO(BeanUtil.buildFrom(opAttributeDomain.findByCondition(opAttributeCond),OpAttributeVO.class));
            }
*/
/*
            if(cond.getWithAttributeValue() && !NumberUtil.isNullOrZero(pcsSkuCombinationVO.getAttributeValueId())){
                OpAttributeCond opAttributeCond = new OpAttributeCond();
                opAttributeCond.setId(pcsSkuCombinationVO.getAttributeId());
                pcsSkuCombinationVO.setOpAttributeValueVO(BeanUtil.buildFrom(opAttributeValueDomain.findOpAttributeValueById(pcsSkuCombinationVO.getAttributeValueId()), OpAttributeValueVO.class));
            }
*/
        }
        return skuCombinationVOList;
    }


    private LinkedHashMap<Long, Long> getAttributeMap(String jsonText) {
        LinkedHashMap<Long, Long> map = new LinkedHashMap<>();
        JSONArray jsonArray = JSONArray.parseArray(jsonText);
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONArray attrJson = jsonArray.getJSONArray(i);
            Long attrId = attrJson.getLong(0);
            Long attrValueId = attrJson.getLongValue(1);
            map.put(attrId, attrValueId);
        }
        return map;
    }

    @Override
    public List<PcsSkuCombination> findBySpvId(Long spvId) {
        PcsSkuCombinationExample example = new PcsSkuCombinationExample();
        example.createCriteria().andSpvIdEqualTo(spvId).andActiveEqualTo(true);
        return pcsSkuCombinationMapper.selectByExample(example);
    }

    @Override
    public List<PcsSkuCombination> findBySpvIdAndCode(Long spvId,String code) {
        PcsSkuCombinationExample example = new PcsSkuCombinationExample();
        example.createCriteria().andSpvIdEqualTo(spvId).andSubSkuCodeEqualTo(code).andActiveEqualTo(true);
        return pcsSkuCombinationMapper.selectByExample(example);
    }

    @Override
    public List<PcsSkuCombinationVO> findSkuCombinationBySpvId(Long spvId){
        List<PcsSkuCombinationVO> result = pcsSkuCombinationMapper.selectBySpvId(spvId);
        for (PcsSkuCombinationVO combination:result) {
            JSONArray arr = JSONArray.parseArray(combination.getAttrs());
            StringBuffer attrValue = new StringBuffer();
            for(Object o :arr){
                JSONArray a = (JSONArray)o;
                OpAttributeValueVO opAttributeValue =  opAttributeValueDomain.findOpAttributeValueById(Long.parseLong(a.get(1).toString()));
                attrValue.append(opAttributeValue.getValueText()).append(" ");
            }
            combination.setAttrValue(attrValue.toString());
        }
       return result;
    }
}
