package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsBuyerCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsBusinessCategoryPermissionMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsBuyerInfoMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsPurchaseCategoryPermissionMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsBuyerDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.PcsBusinessCategoryPermission;
import com.thebeastshop.pegasus.merchandise.model.PcsBuyerInfo;
import com.thebeastshop.pegasus.merchandise.model.PcsBuyerInfoExample;
import com.thebeastshop.pegasus.merchandise.model.PcsPurchaseCategoryPermission;
import com.thebeastshop.pegasus.merchandise.vo.PcsBuyerInfoVO;
import com.thebeastshop.pegasus.merchandise.vo.UserInfo;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @author gongjun
 * @since 2016-08-30
 */
@Component("pcsBuyerDomain")
public class PcsBuyerDomainImpl extends AbstractBaseDomain<PcsBuyerInfoVO, PcsBuyerInfo> implements PcsBuyerDomain {

    @Autowired
    private PcsBuyerInfoMapper pcsBuyerInfoMapper;
    
    @Autowired
    private PcsBusinessCategoryPermissionMapper businessCategoryPermissionMapper;
    
    @Autowired
    private PcsPurchaseCategoryPermissionMapper purchaseCategoryPermissionMapper;


    @Override
    public PcsBuyerInfoVO getBuyerInfoById(Long id) {
        PcsBuyerInfo buyerInfo = pcsBuyerInfoMapper.selectByPrimaryKey(id);
        return BeanUtil.buildFrom(buyerInfo,PcsBuyerInfoVO.class);
    }

    @Override
    public List<PcsBuyerInfoVO> getAllBuyers() {
        PcsBuyerInfoExample example = new PcsBuyerInfoExample();
        example.createCriteria().getAllCriteria();
        List<PcsBuyerInfo> buyerInfoVOs = pcsBuyerInfoMapper.selectByExample(example);
        return BeanUtil.buildListFrom(buyerInfoVOs, PcsBuyerInfoVO.class);
    }

    @Override
    public List<Map<String, String>> getAllBuyerInfos() {
        List<PcsBuyerInfoVO> buyers = getAllBuyers();
        List<Map<String,String>> buyerInfos = new ArrayList<>();
        for(PcsBuyerInfoVO buyer : buyers){
            Map<String,String> buyerInfoMap = new HashMap<>();
            buyerInfoMap.put("value",buyer.getId().toString());
            buyerInfoMap.put("text",buyer.getRealName());
            buyerInfoMap.put("loginUserId",String.valueOf(buyer.getLoginUserId()));
            buyerInfos.add(buyerInfoMap);
        }
        if (CollectionUtils.isEmpty(buyerInfos)) return Collections.EMPTY_LIST;
        return buyerInfos;
    }

    @Override
    public List<PcsBuyerInfo> getBuyerByCond(PcsBuyerCond cond) {
        return pcsBuyerInfoMapper.getBuyerInfoByCond(cond);
    }

    @Override
    public Boolean newBuyer(PcsBuyerInfo buyerInfo) {
        if (pcsBuyerInfoMapper.insertSelective(buyerInfo)>0)
            return true;
        else{
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_DELETE_DB,"保存失败");
        }
    }

    @Override
    public Boolean updateBuyerInfo(PcsBuyerInfo buyer) {
        if (pcsBuyerInfoMapper.updateByPrimaryKeySelective(buyer) > 0)
            return true;
        else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_DELETE_DB, "更新失败");
        }
    }

    @Override
    public UserInfo findCategoryManagerByBuyer(Integer buyerId) {
        return pcsBuyerInfoMapper.selectCategoryManagerByBuyer(buyerId);
    }

	@Override
	public Integer addPurchaseCategoryPermission(PcsPurchaseCategoryPermission purchaseCategoryPermission) {
		return purchaseCategoryPermissionMapper.insertSelective(purchaseCategoryPermission);
	}

	@Override
	public Integer addBusinessCategoryPermission(PcsBusinessCategoryPermission businessCategoryPermission) {
		return businessCategoryPermissionMapper.insertSelective(businessCategoryPermission);
	}

	@Override
	public int deletePurchaseCategoryPermByUserId(Integer userId) {
		return purchaseCategoryPermissionMapper.deleteByUserId(userId);
	}

	@Override
	public int deleteBusinessCategoryPermByUserId(Integer userId) {
		return businessCategoryPermissionMapper.deleteByUserId(userId);
	}

}
