/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.OpProdDynmContMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpProdDynmContDomain;
import com.thebeastshop.pegasus.merchandise.exception.OperationException;
import com.thebeastshop.pegasus.merchandise.exception.OperationExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.OpProdDynmCont;
import com.thebeastshop.pegasus.merchandise.model.OpProdDynmContExample;
import com.thebeastshop.pegasus.merchandise.vo.OpProdDynmContVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:27
 */
@Component("opProdDynmContDomain")
public class OpProdDynmContDomainImpl extends AbstractBaseDomain<OpProdDynmContVO, OpProdDynmCont> implements OpProdDynmContDomain {

    @Autowired
    private OpProdDynmContMapper opProdDynmContMapper;

    @Override
    public boolean create(OpProdDynmContVO vo) {
        OpProdDynmCont cont = buildFromVO(vo);
        opProdDynmContMapper.insert(cont);
        vo.setId(cont.getId());
        return  cont.getId() > 0;
    }

    @Override
    public boolean update(OpProdDynmContVO vo) {
        return opProdDynmContMapper.updateByPrimaryKeySelective(buildFromVO(vo)) != 0;
    }

    @Override
    public boolean deleteById(Long id) {
        return opProdDynmContMapper.deleteByPrimaryKey(id) != 0;
    }

    @Override
    public List<OpProdDynmContVO> findByProdId(Long prodId) {
        OpProdDynmContExample example = new OpProdDynmContExample();
        OpProdDynmContExample.Criteria criteria = example.createCriteria();
        criteria.andProductIdEqualTo(prodId);
        example.setOrderByClause("SORT");
        List<OpProdDynmCont> contents = opProdDynmContMapper.selectByExampleWithBLOBs(example);

        if (CollectionUtils.isEmpty(contents)) {
            return Collections.emptyList();
        }

        List<OpProdDynmContVO> vos = new ArrayList<OpProdDynmContVO>(contents.size());
        for (OpProdDynmCont content : contents) {
            vos.add(buildFromModel(content));
        }

        return vos;
    }

    @Override
    public boolean createOrUpdate(List<OpProdDynmContVO> vos) {
        try {
            for (OpProdDynmContVO vo : vos) {

                if (NumberUtil.isNullOrZero(vo.getId())) {
                    create(vo);
                }else {
                    update(vo);
                }
            }
            return true;
        }catch (RuntimeException e) {
            throw new OperationException(OperationExceptionErrorCode.BT_TRANS_CREATE_ERROR, "保存动态内容失败！");
        }
    }

    @Override
    public boolean deleteByProdId(Long prodId) {
        OpProdDynmContExample example = new OpProdDynmContExample();
        OpProdDynmContExample.Criteria criteria = example.createCriteria();
        criteria.andProductIdEqualTo(prodId);
        return opProdDynmContMapper.deleteByExample(example) != 0;
    }

    @Override
    public int updateContentByProdIdAndType(String content, String prodId, String type) {
        return opProdDynmContMapper.updateContentByProdIdAndType(content, prodId, type);
    }

}
