/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.OpClPsProdMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpClPsProdDomain;
import com.thebeastshop.pegasus.merchandise.model.OpClPsProd;
import com.thebeastshop.pegasus.merchandise.model.OpClPsProdExample;
import com.thebeastshop.pegasus.merchandise.vo.OpClPsProdVO;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:27
 */
@Component("opClPsProdDomain")
public class OpClPsProdDomainImpl extends AbstractBaseDomain<OpClPsProdVO, OpClPsProd> implements OpClPsProdDomain {

    @Autowired
    private OpClPsProdMapper opClPsSkuMapper;

    @Override
    public Long findMaxId() {
        return (Long) NumberUtil.avoidNull(opClPsSkuMapper.findMaxId(), 0L);
    }

    @Override
    public Integer add(OpClPsProd opClPsProd) {
        return opClPsSkuMapper.insert(opClPsProd);
    }

    @Override
    public List<OpClPsProd> findByMaxId(Long maxId) {
        return opClPsSkuMapper.findByMaxId(maxId);
    }

    @Override
    public boolean deleteByMaxId(Long maxId) {
        OpClPsProdExample example = new OpClPsProdExample();
        OpClPsProdExample.Criteria criteria = example.createCriteria();
        criteria.andIdLessThanOrEqualTo(maxId);
        return opClPsSkuMapper.deleteByExample(example) != 0;
    }
}
